/*
 * Entrees:sorties directes sur les cartes MCC et MCX par IOCTL
 *
 * ATTENTION DRIVER UNIX :
 * ^^^^^^^^^^^^^^^^^^^^^
 *		Dans le driver, il n'y a qu'un seul buffer de commandes
 *		manuelles par voie. Aussi, IL NE FAUT PAS envoyer simultanement
 *		les ioctl() suivants dans PLUSIEURS processes sur le MEME
 *		device (/dev/mccXX). Risque de crash systeme.
 *
 *		Par contre,
 *		- dans le MEME process, sur le meme device, on peut envoyer
 *		  des commandes qui s'appliquent a plusieurs voies DIFFERENTES
 *		  (elles sont alors designees par le parametre par[1] ou par
 *		  le nom du device)
 *		- PLUSIEURS processes peuvent ouvrir chacun un device DIFFERENT
 *		  et envoyer independamment leurs commandes.
 *
 * @(#)mcc_mcx.h	3.3 96/06/21 -- JPT
 * Copyright(C) ACKSYS, 1993, 1994, 1995, 1996.
 */
#ifndef MCC_MCX_H
#define MCC_MCX_H

typedef unsigned char unchar;
#define McxUnshort	unsigned short

/* macros and structs for manual commands requests */

#define TIOC_MCC_CMD		(TIOC|99)	/* lancement d'une commde MCX */
#define TIOC_MCC_CMD_AUTO	(TIOC|98)	/* init automatique de par[1] */
#define TIOC_MCC_RUN01		(TIOC|(RUN01))	/* ecriture RUN01 sur mailbox */
#define TIOC_MCC_HUNT		(TIOC|96)	/* non implemente */
#define TIOC_MCX_GET_SYNC_STATE	(TIOC|95)	/* non implemente */
#define TIOC_MCX_SET_SYNC_STATE	(TIOC|94)	/* non implemente */
#define TIOC_MCC_RUN02		(TIOC|(RUN02))	/* ecriture RUN02 sur mailbox */
#define TIOC_MCC_RUN00		(TIOC|(RUN00))	/* ecriture RUN00 sur mailbox */
#define TIOC_MCC_DO_CLR_ON_OVF	(TIOC|(CLOVF))	/* effacer bufs si OVF soft */
#define TIOC_MCC_DONT_CLR_ON_OVF (TIOC|(KPOVF))	/* conserver bufs si OVF soft */
#define TIOC_MCX_WRITE_DELAY	(TIOC|87)	/* retard a l'emission */
#define mcc_op(fd,str,op,p1,p2,p3,p4,p5,p6,p7)				\
		(str.opcode=(op), str.par[0]=(p1), str.par[1]=(p2),	\
		str.par[2]=(p3), str.par[3]=(p4), str.par[4]=(p5),	\
		str.par[5]=(p6), str.par[6]=(p7),			\
		(ioctl(fd,TIOC_MCC_CMD,&(str))==-1?-1:str.status))
#define mcx_op	mcc_op

typedef struct mcc_cmd {
	unchar opcode;
	unchar status;
	unchar par[76];
	unchar ichan;
	unchar icond;
	unchar ipar1;
	unchar ipar2;
	unchar ipar3;
	unchar padding1;
	unchar *data;
	unchar *kdata;
	McxUnshort length;
	McxUnshort padding2;
}mcc_cmd;

typedef struct _MCC_CMD {			/* tampon pour ces ioctls */
	mcc_cmd Cb;				/* l'usage de cette struct */
	unchar Data[1];				/* est facultatif sous UNIX */
} MCC_CMD, *PMCC_CMD;

/* taille a allouer pour contenir la struct _MCC_CMD */
#define MCX_DIRECT_IO_BUFFER_SIZE(datalen)	((datalen)+sizeof(mcc_cmd))

#ifndef MCC_NO_CMD		/* permet a l'usager d'inhiber ces defines */
/*
 * Les commandes reperees par *C/X* sont incompatibles entre MCC et MCX
 * Les commandes reperees par *MCC* n'existent pas sur la carte MCX
 * Les commandes reperees par *MCX* n'existent pas sur la carte MCC
 */
#define	VINIT	(char)0	/*C/X*/	/* init. canal de communication asynchrone */	
#define ALLOC	(char)1	/*C/X*/	/* initialisation de la taille des tampons */
#define	ILOAD	(char)2
#define	VMODE	(char)3		/* init. du mode de 'hand-shake' et echo */
#define	RXENB	(char)4		/* activation ou desactivation d'un canal */
#define	MBOOT	(char)5
#define	BDELE	(char)6		/* effacement d'un tampon de trans. et arret */
#define	ISEND	(char)7
#define	BTRAN	(char)8		/* chargement d'un tampon de trans. et envoi */
#define	RDBUF	(char)9		/* lecture d'un tampon de reception */ 
#define	CHDEF	(char)10	/* definition des parametres de chaine */
#define	STCNT	(char)11	/* definition de la taille des blocs */
#define	MINTR	(char)12	/* initialisation du mode d'interruption */
#define	RSTAT	(char)13	/* lecture de l'etat des canaux de com. */
#define	LTEST	(char)14	/* test des canaux de communication */
#define	BTEST	(char)15	/* test automatique de la memoire tampon */
#define	STIME	(char)16	/* mise a l'heure de la carte MCC, MCX */
#define RMEMO	(char)17	/* lecture d'un bloc memoire */	 
#define	GOADR	(char)18	/* execution d'un programme en memoire */
#define	RELRP	(char)19/*C/X*/	/* lecture du No de version,identificateurs */
#define	ENDIT	(char)20	/* commande de fin d'interruption */ 
#define	DALOC	(char)21	/* desallocation des tampons en memoire */
#define	HNGUP	(char)22	/* raccrochage modem */
#define	MTURN	(char)23/*MCC*/	/* retournement de modem */
#define	BPARM	(char)24/*C/X*/	/* lecture des parametres tampons */
#define	RINIT	(char)25	/* reinitialisation de la carte MCC, MCX */
#define	TFREE	(char)26	/* calcul de la place disponible dans TX */
#define	RXCNT	(char)27	/* lecture du nombre de car. dans RX */
#define TMRRP	(char)28	/* lecture de l'heure des communications */
#define	CLRRX	(char)29	/* remise a zero d'un tampon de reception */
#define	IMDWR	(char)30	/* envoi immediat d'une chaine de caracteres */ 
#define	STTMO	(char)31	/* def. des valeurs de Time out en reception */ 
#define ASYSP	(char)32/*MCC*/	/* initialisation vitesses asymetriques */
#define ASYMD	(char)33/*MCC*/	/* passage d'un canal en mode asymetrique */
#define LDIAL	(char)34/*MCC*/	/* numerotation automatique sur ligne modem */
#define BREAK	(char)35	/* envoie d'un break */
#define STSIG	(char)36	/* positionnement manuel de DTR et RTS */
#define MSETP	(char)38/*MCC*/	/* initialisation de la carte OCTOPUCE */
#define TANNU	(char)39/*MCC*/	/* gestion de l'annuaire telephonique integre */
#define ADDCM	(char)40	/* addition d'une commande au jeu standard */
#define ADDTX	(char)41	/* addition d'une fonction en transmission */
#define ADDRX	(char)42	/* addition d'une fonction en reception */
#define NOPER	(char)43	/* pas d'operation */
#define MSIZE	(char)44/*C/X*/	/* lecture configuration memoire */
#define RSMDE	(char)45/*MCX*/	/* initialisation du mode RS232/RS422 */
#define FLASH	(char)46/*MCX*/	/* programmation de la memoire FLASH 256Ko */
#define PROTO	(char)47/*MCX*/	/* init. d'un canal en mode synchrone */
#define PRCTL	(char)48/*MCX*/	/* parametrage des protocoles (MCX-MP) */
#define XBOOT	(char)50/*MCX*/	/* passage en mode MCXDOS */

#define GETMB	(char)84	/* get Mailbox area(s) */
#define SETMB	(char)85	/* set Mailbox area(s) */
#define WINTR	(char)86	/* wait for any interrupt, return area */
#define WCHAN	(char)87	/* wait for channel interrupt, return area */
#define KPOVF	(char)88	/* commande virtuelle, pour mccioctl(1) */
#define CLOVF	(char)89	/* commande virtuelle, pour mccioctl(1) */
#define RUN00	(char)92	/* commande virtuelle, pour mccioctl(1) */
#define RUN02	(char)93	/* commande virtuelle, pour mccioctl(1) */
#define RUN01	(char)97	/* commande virtuelle, pour mccioctl(1) */
#define MANUAL	(char)99	/* commande formee par l'usager lui-meme */

#endif /* MCC_NO_CMD */

typedef struct _MCC_INTERRUPT_STATUS_AREA{
	 unchar chan;			/* 0x50 = 80 */
	 unchar cond;			/* 0x51 = 81 */
	 unchar par1;			/* 0x52 = 82 */
	 unchar par2;			/* 0x53 = 83 */
	 unchar par3;			/* 0x54 = 84 */
	 unchar par4;			/* 0x55 = 85 */
	 unchar par5;			/* 0x56 = 86 */
	 unchar par6;			/* 0x57 = 87 */
	 unchar par7;			/* 0x58 = 88 */
	 unchar par8;			/* 0x59 = 89 */
	 unchar par9;			/* 0x5A = 90 */
} MCC_INTERRUPT_STATUS_AREA, *PMCC_INTERRUPT_STATUS_AREA;
typedef struct mcc_mb {			/* Offset */
	unchar valid;			/* 0x0000 */
#	define busy valid		/* 0x0000 */
	unchar endit;			/* 0x0001 */
	unchar opcode;			/* 0x0002 */
	unchar param[77];
#	define mcxstatus param[0]	/* 0x0003 */
#	define mcxparam param		/* 0x0004 -- utiliser mcxparam[1..76] */
	MCC_INTERRUPT_STATUS_AREA i;	/* 0x0050 */
	unchar reserve[9-1];		/* -1 pour que data[] commence a 1 */
	unchar data[0x7f00 - 100 + 1];	/* -100 pour les octets precedents */
	McxUnshort McxRxCount[64];	/* 0x7F00 */
	McxUnshort McxTxFree[32];	/* 0x7F80 */
	McxUnshort MccRxCount[16];	/* 0x7FC0 */
	McxUnshort MccTxFree[12];	/* 0x7FE0 */
	unchar McxdosString[8];		/* 0x7FF8 */
}mcc_mb, MCC_MAILBOX, *PMCC_MAILBOX;

#define MCX_VALID_BUSY		1
#define MCX_ENDIT_STATRDY	0x80
#define MCX_ENDIT_ENDIT		1
#define MCX_STATUS_ERRCMD	0x80
#define MCX_STATUS_INT_EVENT	0x40	/* interruption evenement */

#define MCX_MINTR_IT0		1	/* interruption sur chaque car. recu */
#define MCX_MINTR_IT1		2	/* interruption sur tampon%STCNT == 0 */
#define MCX_MINTR_IT2		4	/* interruption sur tampon plein */
#define   MCX_IT2_NOEMPTY	0x80	/*   "      "   IT2 si RX non vide */
#define MCX_MINTR_IT3		8	/*   "      "   sur chaine programmee */
#define MCX_MINTR_IT4		16	/*   "      "   sur time-out */
#define MCX_MINTR_IT5		32	/*   "      "   sur erreur reception */
#define   MCX_IT5_PARITY	0x10
#define   MCX_IT5_OVERRUN	0x20
#define   MCX_IT5_FRAMING	0x40
#define   MCX_IT5_OVERFLOW	0x80
#define   MCX_IT5_FRMLOST	0x08
#define   MCX_IT5_FRMABORT	0x10
#define   MCX_IT5_FRMOVR	0x20
#define   MCX_IT5_FRMCRC	0x40
#define   MCX_IT5_FRMTRUNC	0x80
#define MCX_MINTR_IT6		64	/* interruption sur delta CTS, etc */
#define   MCX_IT6_BREAK	0x80		/* event bits CTS,CD,RI,BREAK in IT6 */
#define   MCX_IT6_DSR	0x40
#define   MCX_IT6_CTS	0x20
#define   MCX_IT6_RING	0x10
#define   MCX_IT6_RLSD	0x08
#define   MCX_IT6_ISLINK 0x80		/* LAPLINK state changed */
#define MCX_MINTR_IT7		128	/* interruption TX EMPTY */

#define	MCX_VMODE_NONE		0	/* VMODE : pas de hand-shake */
#define	MCX_VMODE_XON_XOFF	1	/* VMODE : mode XON-XOFF */
#define	MCX_VMODE_ACK_NACK	2	/* VMODE : mode ACK-NACK */
#define MCX_VMODE_STX_ETX	3	/* VMODE : mode STX-ETX */
#define	MCX_VMODE_CTS_DTR	4	/* VMODE : hand-shake hardware */
#define MCX_VMODE_USER		5	/* VMODE : mode caracteres speciaux */
#define MCX_VMODE_IXANY		6	/* VMODE : stop=XOFF, start=any */
#define MCX_VMODE_RTS_CTS	7	/* VMODE : nouveau handshake hardware */

#define MCX_ALLOC_MASK		0xc0	/* masque type de tampon */
#define MCX_ALLOC_TX		0x00	/* allocation tampon d'emission */
#define MCX_ALLOC_RX		0x40	/* allocation tampon de reception */
#define MCX_ALLOC_IMAGE		0x80	/* allocation tampon d'image ecran */

#define MCX_RXENB_ON		1	/* autoriser la reception de car. */
#define MCX_RXENB_OFF		0	/* interdire la reception de car. */

#define MCX_RDBUF_ALL		2	/* RDBUF : lecture totale du tampon */
#define MCX_RDBUF_NCHAR		4	/* RDBUF : lecture de n caracteres */
#define MCX_BTRAN_MAXLEN	31744	/* BTRAN : longueur max bloc donnees */

#define MCX_RINIT_SOFT		0	/* RINIT realloc tampons par defaut */
#define MCX_RINIT_HARD		1	/* RINIT reset total de la carte */

#define MCX_BREAK_SHORT		0	/* BREAK : break court */
#define MCX_BREAK_LONG		1	/* BREAK : break long */

#define MCX_STSIG_RTS_ON	1	/* placer le RTS a l'etat ACTIF */
#define MCX_STSIG_DTR_ON	2	/* placer le DTR a l'etat ACTIF */

#define MCX_RSTAT_DCD		0x20	/* DCD actif */
#define MCX_RSTAT_CTS		0x10	/* CTS actif */
#define MCX_RSTAT_RI		0x08	/* RING actif */

/* types de carte MCX, renvoyes par RELRP v2.0 */
#define MCX_TYPE_XX		0
#define MCX_TYPE_S		1
#define MCX_TYPE_U		2
#define MCX_TYPE_104		3
#define MCX_TYPE_570		4
#define MCX_TYPE_485		5
#define MCX_TYPE_128		6
#define MCX_TYPE_WANH		7
#define MCX_TYPE_MCC		0x7f
#define MCX_TYPE_PCI		0x80	/* flag ajoute au type */
#define MCX_TYPE_UNKNOWN	0x100	/* > tout modele */

#define MCX_LNKUP		0	/* PRCTL param. 7 */
#define MCX_LNKDN		1	/* PRCTL param. 7 */
#define MCX_LNKUP_ABM_AB	0	/* PRCTL param. 8 */
#define MCX_LNKUP_NRMBLA_AB	1
#define MCX_LNKUP_ABM		2
#define MCX_LNKUP_ACTIVE	0	/* PRCTL param. 9 */
#define MCX_LNKUP_PASSIVE	1	/* PRCTL param. 9 */

#define MCX_ITREC1		1	/* interrupt causes in i.cond */
#define MCX_ITRECCNT		2
#define MCX_ITRECNOEMPTY	3
#define MCX_ITRECFULL		4
#define MCX_ITCHDEF		8
#define MCX_ITTMOUT		0x10
#define MCX_ITRECERR		0x20
#define MCX_ITDELTA		0x40
#define MCX_ITTXVIDE		0x80
#define MCX_ITLDIAL		0xC0
#define MCX_ITQUEUE_OVF		0xFF	/* interrupt cause in i.chan */

/* Extended serial IOCTL codes for Windows NT */

#if defined(CTL_CODE) && defined(FILE_DEVICE_SERIAL_PORT)

#define MCX_NT	1
#define MCX_IOCTL(code)			CTL_CODE(FILE_DEVICE_SERIAL_PORT,code,\
						METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_GET_SYNC_STATE		MCX_IOCTL(0x901)
#define IOCTL_SERIAL_SET_SYNC_STATE		MCX_IOCTL(0x902)
#define IOCTL_SERIAL_CMD			MCX_IOCTL(0x903)
#define IOCTL_SERIAL_CMD_AUTO			MCX_IOCTL(0x904)
#define IOCTL_SERIAL_RUN01			MCX_IOCTL(0x905)
#define IOCTL_SERIAL_RUN02			MCX_IOCTL(0x906)
#define IOCTL_SERIAL_RUN00			MCX_IOCTL(0x907)
#define IOCTL_SERIAL_WAIT_CHANNEL_INTERRUPT	MCX_IOCTL(0x908)
#define IOCTL_SERIAL_WAIT_ANY_INTERRUPT		MCX_IOCTL(0x909)
#define IOCTL_SERIAL_ACCESS_AREA		MCX_IOCTL(0x90A)
#define IOCTL_SERIAL_MCX_OPTIONS		MCX_IOCTL(0x90B)

/* Extended AUTOMCX IOCTL codes for Windows NT */

#define FILE_DEVICE_AUTOMCX		0x00008000

#define MCX_IOCTL_AUTO(code,acces)	CTL_CODE(FILE_DEVICE_AUTOMCX, code,\
					METHOD_BUFFERED, FILE_##acces##_ACCESS)
#define IOCTL_AUTOMCX_MAP_MAILBOX		MCX_IOCTL_AUTO(0x800,ANY)
#define IOCTL_AUTOMCX_UNMAP_MAILBOX		MCX_IOCTL_AUTO(0x801,ANY)
#define IOCTL_AUTOMCX_READ_PORT			MCX_IOCTL_AUTO(0x802,ANY)
#define IOCTL_AUTOMCX_WRITE_PORT		MCX_IOCTL_AUTO(0x803,WRITE)

#endif	/* Windows NT */

typedef struct _MCX_SYNCHRONIZATION_PARAMETERS {
    unchar SynchronousMode;
#define MCX_SYNC_CHAR		0	/* also means FALSE (NOT synchronous) */
#define MCX_SYNC_MONOSYNC	1	/* not implemented */
#define MCX_SYNC_BISYNC		2	/* HDX, trames delimitees par CD/RTS */
#define MCX_SYNC_EXTERNAL	3	/* not implemented */
#define MCX_SYNC_HDLC		4
#define MCX_SYNC_LAPB		5	/* LAPB/HDLC FDX */
#define MCX_SYNC_X25		6	/* X25/LAPB/HDLC FDX */
#define MCX_PROTOCOL_MASK	0x0f	/* bits selecting the major protocol */
#define MCX_SYNC_STATE_BM	0x60	/* bitmap des protocoles avec etat */
#define MCX_SYNC_OLD_BM		0x15	/* protocoles permis sans version */
    unchar Duplex;			/* flag version + 2 bits duplex */
#define MCX_WAY_VERSION		0x80	/* bit validant le champ Version */
#define MCX_WAY_FULLDUPLEX	0x80	/* full duplex + version */
#define MCX_WAY_HALFDUPLEX	0x81	/* RTS descend apres chaque trame */
#define MCX_FULL_DUPLEX		0	/* obsolete form */
#define MCX_HALF_DUPLEX		1	/* obsolete form */
#define MCX_SIMPLEX		2	/* not implemented */
					/* --------- horloges --------- */
					/*    ETTD      ETCD NULL-MODEM */
					/* ---------------------------- */
    unchar TransmitClockSource;		/*    TXCI	BRG	BRG	*/
    unchar ReceiveClockSource;		/*    RXC	BRG	RXC	*/
    unchar TxClockPinSource;		/* TRXC_HIGH	BRG	BRG	*/
					/* ---------------------------- */
#define MCX_CLOCK_RXC		0	/* modes Transmit/ReceiveClockSource */
#define MCX_CLOCK_TXCI		1
#define MCX_CLOCK_TRXC_HIGH	0	/* modes TxClockPinSource uniquement */
#define MCX_CLOCK_TXCLOCK	1
#define MCX_CLOCK_BRG		2	/* modes communs */
#define MCX_CLOCK_DPLL		3
    unchar MonosyncChar;
    unchar BisyncChar;
    unchar Version;			/* valide si Duplex & MCX_WAY_VERSION */
    McxUnshort Options;			/* default: 0 */
#define MCX_HDLC_USERDTR	1	/* slows HDLC but allows driving DTR */
#define MCX_HDLC_SPECS		2	/* use Hdlc parms struct (below) */
#define MCX_BISYNC_SPECS	2	/* use Bisync parms struct (below) */
#define MCX_LAPB_MOD128		4	/* unimplemented */
#define MCX_BISYNC_MKIDL	4	/* Bisync mark-on-idle, unimplemented */
#define MCX_BISYNC_PARMS	8	/* use Bisync spare parms, unimplemented */
    McxUnshort DataLength;		/* max frame size (N1 in LAPB) */
					/* defaults vary on the protocol used */
#define MCX_FRAMELEN_DEFAULT	0	/* default for above field */
    union{
	struct{
		unchar RxFrames;	/* default: 14 */
		unchar TxFrames;	/* default: 4 */
		McxUnshort Spare1;	/* Spare, must be set to ZERO */
		McxUnshort Spare2;	/* Spare, must be set to ZERO */
		McxUnshort Spare3;	/* Spare, must be set to ZERO */
		McxUnshort Spare4;	/* Spare, must be set to ZERO */
		McxUnshort Spare5;	/* Spare, must be set to ZERO */
#define SpBisyncP10	Spare1
#define SpBisyncP11	Spare2
#define SpBisyncP12	Spare3
#define SpBisyncP13	Spare4
#define SpBisyncP14	Spare5
	}Hdlc, Bisync;
#define MCX_HDLC_DEFAULT	0	/* valable pour ts les champs susdits */
	struct{
		unchar Role;		/* default: CLIENT */
#define MCXLAPB_ROLE_CLIENT	1
#define MCXLAPB_ROLE_NETWORK	3
		unchar K;		/* default: 7 */
		McxUnshort N2;		/* default: 10 retrans */
		McxUnshort T1;		/* default: 2550 ms */
		McxUnshort T2;		/* default: 0 */
		McxUnshort T3;		/* default: infinite */
		McxUnshort Spare;	/* Spare, must be set to ZERO */
#define MCX_LAPB_DEFAULT	0	/* valable pour ts les champs susdits */
	}Lapb;
    }Protocol;
} MCX_SYNCHRONIZATION_PARAMETERS, *PMCX_SYNCHRONIZATION_PARAMETERS;

#define MCX_SYNC_MAX_PACKET	1024	/* taille max d'une trame synchrone */

typedef struct _MCX_AREA_DESCRIPTOR {	/* pour IOCTL_SERIAL_ACCESS_AREA */
					/* et IOCTL_DOWNLOAD_ACCESS_AREA */
    long Operation;			/* combinaison des flags suivants */
#define MCX_AREA_GET	0		/* carte vers process */
#define MCX_AREA_SET	1		/* process vers carte */
#define MCX_AREA_MEMORY	0		/* acces a la boite aux lettres */
#define MCX_AREA_IOPORT 2		/* acces aux ports d'E/S */
#define MCX_AREA_VALID	4		/* ecrire 1 dans valid apres l'acces */
#define MCX_AREA_ENDIT	8		/* ecrire 1 dans endit apres l'acces */
    long StartAddress;			/* adresse depart de l'acces */
					/* relative au port de base ou au */
					/* debut de la boite aux lettres */
    long Length;			/* longueur a transferer */
    unchar Buffer[sizeof(long)];	/* valeurs a ecrire si MCX_AREA_SET */
} MCX_AREA_DESCRIPTOR, *PMCX_AREA_DESCRIPTOR;
#define MCX_AREA_DESCRIPTOR_HEADER_SIZE	(3*sizeof(long))
#define MCX_AREA_DESCRIPTOR_SIZE(dlen)	((dlen)+sizeof(MCX_AREA_DESCRIPTOR)-1)
					/* -1 conserve pour compatibilite... */
					/* ...devrait etre -sizeof(long) ! */

typedef struct _MCX_OPTION {		/* pour IOCTL_SERIAL_SET_OPTIONS */
    long Option;			/* type d'option i: 16 bits de code, */
					/* 8 bits input len 8 bits output len */
    union{
	long Long[1];
	short Short[1];
	unchar Char[1];			/* char value or TRUE/FALSE */
    }Value;				/* valeur de l'option */
} MCX_OPTION, *PMCX_OPTION;
#define MCX_OPTION_SIZE(dlen)		\
			((dlen)+sizeof(MCX_OPTION)-sizeof(long))

// structure des parametres physiques, utilisee pour :
//	MCX_OPTION_GET_PHYSICAL_PARMS
//	MCX_OPTION_SET_ETU1080_PARMS
typedef struct _MCX_OPTION_PHYSICAL_PARMS {
	USHORT StructVersion;
	USHORT BusType;
	ULONG BusNumber;
	ULONG SlotNumber;
	ULONG MemoryAddressLow;
	ULONG MemoryAddressHigh;
	ULONG MemorySize;
	ULONG IoAddressLow;
	ULONG IoAddressHigh;
	ULONG IoSize;
	LONG InterruptVector;
	LONG DmaChannel;		// -1 means not used
	ULONG SpecificInformation;
} MCX_OPTION_PHYSICAL_PARMS, *PMCX_OPTION_PHYSICAL_PARMS;

/*** Constants for Option field ***/
#define MCX_OPTION_CMD_TIME		0x10200	/* memoriser heure commande */
#define MCX_OPTION_CMD_OFFSET	0x7808		/* offset date pour la voie 1 */
#define MCX_OPTION_GET_CHANNEL		0x20002	/* obtenir num. canal(base 1) */
#define MCX_OPTION_SET_DSR_RI_INVERSION	0x30100	/* T/F exchange DSR with RING */
#define MCX_OPTION_GET_DSR_RI_INVERSION	0x40001	/* get DSR/RING xchange state */
#define MCX_OPTION_GET_COMPATIBILITY	0x50004 /* get current Compatibility */
#define MCX_OPTION_GET_PHYSICAL_PARMS	0x60030 /* get card physical parms */
#define MCX_OPTION_SET_ETU1080_PARMS	0x73000 /* set ETU1080 parms */

/*** Constants for Values field ***/
					/* This for CMD_TIME option */
#define MCX_OPTION_CMD_OFF	(-1)	/* -- inhibe la fonction CMD_TIME */
					/* These for GET_COMPATIBILITY option */
					/* behavior is undefined if both 164
					 * and LOWSIGS flags are set */
#define MCX_COMPAT_DTRFLOW	0x001	/* -- handshake compat. 1.6.2       */
#define MCX_COMPAT_LOWSIGS	0x002	/* -- clear RTS/DTR on first open   */
#define MCX_COMPAT_V164		0x004	/* -- assert RTS/DTR on each open   */
#define MCX_COMPAT_DSR_RI	0x008	/* -- invert DSR & RING roles       */
#define MCX_COMPAT_V171		0x010	/* -- sync rx errors+single txempty */
#define MCX_COMPAT_V181		0x020	/* -- CbIn/OutQue = frames * 1024   */
#define MCX_COMPAT_QSIZE	0x040	/* -- SetupComm error if size>init  */
#define MCX_COMPAT_HIDDENMB	0x080	/* -- Mailbox is hidden / shareable */
#define MCX_COMPAT_NORXERRS	0x100	/* -- driver-issued MINTR clears IT5*/
#define MCX_COMPAT_NO_SPD31	0x200	/* -- always use speed 17, never 31 */

#undef McxUnshort

#endif /* MCC_MCX_H */
