/***************************************************************************
 *
 * Complements mcc_mcx.h - MCX-MP specific protocols for MCX, MCX-Lite/S
 * and MCX-Lite/570
 *
 * Copyright(C) 1997-2010 by ACKSYS -- JPT
 *
 ***************************************************************************
 */

#ifndef MCXPROTO_H
#define MCXPROTO_H

#ifndef MCC_MCX_H // Linux driver does not have this file
#include "mcc_mcx.h"
#endif

/*
 ***************************************************************************
 *
 * Mise en mode de la carte MCX
 *
 * definitions non supportees - unsupported defines
 */
#define McxToWord(lval)	(*(unshort*)&(lval))
#define MCXBASE_READY	"MCX IS READY"
#define MCXBASE_2_MP	"RUN 02"
#define MCXDOS_READY	"READY"
#define MCXDOS_2_BASE	"RUN 98"
#define MCXDOS_RUN_ADDR	data[0x7ff8-100+1]
/* bits in the MCX status I/O port */
#define MCX_STATUS_PCINT 0x1	/* bit D0: MCX request */
#define MCX_STATUS_INT	0x04	/* bit D2: MCX busy */
#define MCX_ITCOMMANDE	0		/* pseudo-evenement 'fin de commande' */

/************* NT demo services *************/
#if defined(MCX_NT) && !defined(_DDK_DRIVER_)

/*** NT LAPB demo services ***/
HANDLE McxLapbSetup(char *name, BOOLEAN isHost, BOOLEAN isNullModem,
		unsigned long datalen, DWORD openFlags);
BOOLEAN McxLapbConnect(HANDLE, BOOLEAN, BOOLEAN);
BOOLEAN McxLapbDisconnect(HANDLE, BOOLEAN);

char *McxLapbStateToString(int state);
int McxLapbState(HANDLE);
DWORD McxLapbWait(HANDLE port);
HANDLE McxInitAsyncLapbWaitComm();
void McxFreeAsyncLapbWaitComm();
#define EV_MCXLAPB	EV_EVENT1

/*** NT IoControl demo services ***/
BOOL AcksysIoControl(HANDLE, DWORD, LPVOID, DWORD, LPVOID, DWORD, DWORD *);
extern BOOL AcksysCmdRetCount_;		// library internal use only !
#define AcksysCmdAuto(hnd,pcmd)	\
			AcksysIoControl(hnd, IOCTL_SERIAL_CMD_AUTO,	\
			pcmd, MCX_DIRECT_IO_BUFFER_SIZE(pcmd->Cb.length),\
			pcmd, MCX_DIRECT_IO_BUFFER_SIZE(pcmd->Cb.length),\
			&AcksysCmdRetCount_)
#define AcksysCmd(hnd,pcmd)	\
			AcksysIoControl(hnd, IOCTL_SERIAL_CMD,		\
			pcmd, MCX_DIRECT_IO_BUFFER_SIZE(pcmd->Cb.length),\
			pcmd, MCX_DIRECT_IO_BUFFER_SIZE(pcmd->Cb.length),\
			&AcksysCmdRetCount_)

#endif /*MCX_NT && !_DDK_DRIVER_*/

/*
 * fin des definitions non supportees - end of unsupported defines
 *
 ***************************************************************************
 */

/*
 ***************************************************************************
 *
 * Various firmware modes
 *
 */
#define MCX_FIRMWARE_BASE		01
#define MCX_FIRMWARE_MPROTOCOL	02
#define MCX_FIRMWARE_COMPATIBLE	02	/* maxvalue for base-compatible modes */
#define MCX_FIRMWARE_BIOS		96
#define MCX_FIRMWARE_AUTOMCX	99
#define MCX_FIRMWARE_UNKNOWN	100

/*
 ***************************************************************************
 *
 * LAPB/X25 specific services, commands and statuses
 *
 */

#define ABMLINKUP	0		/* operations dans PRCTL */
#define ABMLINKDN	1
#define X25LISTN	2
#define X25CALL		3
#define X25LIB		4
#define X25RESET	5
#define X25CFCALL	6
#define X25CFLIB	7
#define X25CFINT	8
#define X25GETPKT	9
#define ABMSTATE	10

/* parametres des commandes PROTO et PRCTL */
#define MCX_PROTO_LAPB_DCE	8	/* adresse ETCD */
#define MCX_PROTO_LAPB_DTE	0	/* adresse ETTD */
#define MCX_X25CALL_AUTO	1	/* appel entrant automatique */
#define MCX_X25LISTN_CREATE	2	/* creation d'un wildcard */
#define MCX_X25LISTN_DELETE	0	/* suppression d'un wildcard */
#define MCX_X25LIB_AUTO		1	/* lib. recue automatique */
#define MCX_X25LIB_CF_IT	4	/* conf lib recu => IT6 */ 
#define MCX_X25CALL_GAVL_IO	128	/* CV bidirectionnels */
#define MCX_X25_Q			0x80	/* bit Q */
#define MCX_X25_D			0x40	/* bit D */
#define MCX_X25_M			0x20	/* bit M */
#define MCX_X25_INTR		0x1	/* paquet INTERRUPT. */
#define MCX_X25_DATA		0x0	/* paquet DATA */

/* code cause (ipar4) des interruptions evenement IT6 */
#define MCX_IT6_ICALL	1
#define MCX_IT6_ICALLTO	2
#define MCX_IT6_OCALLCF	3
#define MCX_IT6_OCALLTO	4
#define MCX_IT6_ILIB	9
#define MCX_IT6_OLIBCF	5
#define MCX_IT6_OLIBTO	6
#define MCX_IT6_IDIAG	7
#define MCX_IT6_EPL	8
#define MCX_IT6_IRST	10
#define MCX_IT6_ORSTCF	11
#define MCX_IT6_ORSTTO	12
#define MCX_IT6_IINIT	13
#define MCX_IT6_OINITCF	14
#define MCX_IT6_OINITTO	15
#define MCX_IT6_IINTR	16
#define MCX_IT6_OINTRCF	17
#define MCX_IT6_LINKOFF	MCX_LINK_OFF	/* deconnecte; voir aussi mcc_mcx.h */
#define MCX_IT6_LINKON	MCX_LINK_ON	/* LAPB connecte */
#define MCX_IT6_LINKRST	MCX_LINK_GO_UP	/* reinitialisation de la couche */

/* etats de la couche liaison (LAPSTATE et IT6/i.par4) et flags associes */
	/* flags */
#define MCX_ISLNKSTATE	MCX_IT6_ISLINK	/* flag LAPB, voir mcc_mcx.h */
#define MCX_ISLNKON	0x01		/* LAPB: flag connecte */
#define MCX_ISLNKTRANS	0x04		/* LAPB: flag etat transitoire */
#define MCX_ISLNKGODN	0x02		/* LAPB: flag en cours de deconnexion */
	/* etats */
#define MCX_LINK_OFF	(MCX_ISLNKSTATE)		/* LAPB deconnecte */
#define MCX_LINK_ON	(MCX_ISLNKSTATE|MCX_ISLNKON)	/* LAPB connecte */
#define MCX_LINK_GO_UP	(MCX_ISLNKSTATE|MCX_ISLNKTRANS)	/* connexion en cours */
#define MCX_LINK_GO_DN	(MCX_ISLNKSTATE|MCX_ISLNKTRANS|MCX_ISLNKGODN) /*decon*/

#define MCX_X25_WINDOW	2
#define X25_X25_MAXPKT	4095		/* limite due a la structure de X25 */
#define MCX_X25_MAXPKT	2048		/* limite ACTUELLE de MCX-X25 */

/*
 ***************************************************************************
 *
 * PROTO specific commands and statuses
 *
 */
#define MCX_PROTO_USERDTR	0x08	/* slows HDLC but allows use of DTR */

/*
 ***************************************************************************
 *
 * VMODE specific commands and statuses
 *
 */
/*** defines pour VMODE version 1 ***/

/* extended VMODE flag (param.1) */
#define MCX_VMODE_EXTENDED	((unchar)0x80)
#define MCX_VMODE_VERSION0	0

/* misc control functions (param.3) */
#define MCXMP_ERROR_REPLACE	0x01
#define MCXMP_NULL_STRIPPING	0x02
#define MCXMP_DSR_SENSITIVITY	0x04	/* non supporte sauf Lite-570 */
#define MCXMP_RI_SENSITIVITY	0x08
#define MCXMP_DCD_SENSITIVITY	0x10
#define MCXMP_CTS_SENSITIVITY	0x20

/* input flow control (param.5) */
#define MCXMP_IXON_IXANY	0x10
#define MCXMP_IXON_XONXOFF	0x20
#define MCXMP_IXON_MASK		0x30
#define MCXMP_DTR_STSIG		0x00
#define MCXMP_DTR_FLOW		0x04
#define MCXMP_DTR_MASK		0x0c
#define MCXMP_RTS_STSIG		0x00
#define MCXMP_RTS_FLOW		0x01
#define MCXMP_RTS_TOGGLE	0x02
#define MCXMP_RTS_MASK		0x03

/* output flow control (param.6) */
#define MCXMP_CTS_FLOW		0x01
#define MCXMP_DSR_FLOW		0x02	/* non supporte sauf Lite-570 */
#define MCXMP_DCD_FLOW		0x04
#define MCXMP_RI_FLOW		0x08	/* non supporte sur Lite-570 */
#define MCXMP_OXON_XONXOFF	0x10
#define MCXMP_OXON_IXANY	0x20

/*
 ***************************************************************************
 *
 * VINIT specific commands and statuses
 *
 */
#define MCX_PARITY_NONE	(0<<6)
#define MCX_PARITY_ODD	(1<<6)
#define MCX_PARITY_EVEN	(3<<6)

#define MCX_STOPBITS_1	(1<<4)
#define MCX_STOPBITS_15	(2<<4)
#define MCX_STOPBITS_2	(3<<4)

#endif /* MCXPROTO_H */
