#include <windows.h>
#include "ack_w32.h"

void
AcksysPrintCommError(HANDLE hfd)
{
	COMSTAT comStat;
	DWORD errcode;

	printf("ClearCommError:");
	if( !ClearCommError(hfd,&errcode,&comStat) ){
		printf("ClearCommError '%s' failed, code %d\n",
			AcksysFile,GetLastError());
	}
	else{
		printf("OK, cbInQue=%d, cbOutQue=%d, errcode=",
			comStat.cbInQue,comStat.cbOutQue);
		if(errcode&CE_BREAK)	printf("BREAK ");
		if(errcode&CE_FRAME)	printf("FRAME ");
		if(errcode&CE_MODE)	printf("MODE ");
		if(errcode&CE_IOE)	printf("IOE ");
		if(errcode&CE_OOP)	printf("OOP ");
		if(errcode&CE_OVERRUN)	printf("OVERRUN ");
		if(errcode&CE_RXOVER)	printf("RXOVER ");
		if(errcode&CE_RXPARITY)	printf("RXPARITY ");
		if(errcode&CE_TXFULL)	printf("TXFULL ");
		if(errcode&CE_DNS)	printf("DNS ");
		if(errcode&CE_PTO)	printf("PTO ");
		printf("(%x)\n",errcode);
	}
}
