#include <windows.h>
#include <stdio.h>

//
// AcksysStringError converts the Last Error code returned by GetLastError(),
// into a localized string.
//
// Arguments: none.
//
// Returns:
//	char * to the statically-allocated string.
//
// Note:
//	Warning, the string is contained in heap memory that will be
//	freed at the next call.
//
// (c)ACKSYS 1998 -- JPT
//

char *
AcksysStringError()
{
	int len;
	static char *lpMsgBuf = NULL;
	DWORD errcode = GetLastError();	// A faire en tout premier

	if(lpMsgBuf) {
		// Free the buffer.
		LocalFree(lpMsgBuf);
	}

	FormatMessage( 
		FORMAT_MESSAGE_ALLOCATE_BUFFER | FORMAT_MESSAGE_FROM_SYSTEM,
		NULL,
		errcode,
		MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
		(LPTSTR) &lpMsgBuf,
		0,
		NULL 
		);
	len = strlen(lpMsgBuf);
	while(len > 0 && (lpMsgBuf[len-1] == '\n' || lpMsgBuf[len-1] == '\r'))
		lpMsgBuf[--len] = '\0';

	return lpMsgBuf;
}

//
// AcksysOemError converts the Last Error code returned by GetLastError(),
// into a OEM charset localized string.
//
// Arguments: none.
//
// Returns:
//	char * to the statically-allocated string.
//
// Note:
//	Warning, the string is contained in heap memory that will be
//	freed at the next call.
//
// (c)ACKSYS 1999 -- JPT
//
char *
AcksysOemError()
{
	char *errtext = AcksysStringError();
	CharToOemBuff(errtext, errtext, strlen(errtext));
	return errtext;
}
