/*
**	@(#)getopt.c	2.5 (smail) 9/15/87
**	+ modifs mineures JPT 17/9/97
**	+ conversion des options **argv en minuscules (mais pas *opts)
**
** chaines acceptees:
**	-abcd[:valeur] -efgh[:valeur]... val_indep1 val_indep2...
**
**	l'argument 'opts' est la chaine des options acceptables
**	Si l'argument est accepte il est renvoye en minuscule
**	si une valeur l'accompagne elle est disponible dans 'optarg'
**	Apres la derniere option on renvoie EOF. 'optind' permet
**	alors d'acceder aux valeurs independantes.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#ifdef size_t
#undef size_t
#endif
#define size_t int

size_t	   opterr = 1;
size_t	   optind = 1;
size_t	   optopt = 0;
char	*optarg = 0;

size_t
GetOpt(argc, argv, opts)
int	argc;
char	**argv, *opts;
{
	static size_t sp = 1;
	register size_t c;
	register char *cp;

	if(sp == 1)
		if(optind >= argc ||
		   argv[optind][0] != '-' || argv[optind][1] == '\0')
			return(EOF);
	optopt = c = argv[optind][sp];

	/* tous les arguments options sont convertis en minuscules */
	if(isupper(c))
		c = tolower(c);
	if(c == ':' || (cp=strchr(opts, c)) == NULL) {
		if(argv[optind][++sp] == '\0') {
			optind++;
			sp = 1;
		}
		return('?');
	}
	if(*++cp == ':') {
		if(argv[optind][sp+1] != '\0')
			optarg = &argv[optind++][sp+1];
		else if(++optind >= argc) {
			sp = 1;
			return('?');
		} else
			optarg = argv[optind++];
		sp = 1;
	} else {
		if(argv[optind][++sp] == '\0') {
			sp = 1;
			optind++;
		}
		optarg = NULL;
	}
	return(c);
}
