#include <windows.h>
#include <winioctl.h>
#include <mcc_mcx.h>

main(int argc, char **argv)
{
	HANDLE h;

	if((h=CreateFile(argv[1],GENERIC_WRITE|GENERIC_READ,
				0,
				NULL,
				OPEN_EXISTING,
				FILE_ATTRIBUTE_NORMAL,
				NULL)) == INVALID_HANDLE_VALUE){
		printf("Open '%s' failed, code %d\n",argv[1],GetLastError());
		exit(1);
	}
	DemoPhysical(h);
}

DemoPhysical(HANDLE hDevice)
{
	DWORD retLen;			/* longueur renvoye dans les appels */
	PMCX_OPTION pOptionDesc;
	PMCX_OPTION_PHYSICAL_PARMS pOptionResult;
	int optionLen;

	optionLen = MCX_OPTION_SIZE(sizeof(MCX_OPTION_PHYSICAL_PARMS));
	printf("OL=%d\n",optionLen);
	pOptionDesc = malloc(optionLen);

	pOptionDesc->Option = MCX_OPTION_GET_PHYSICAL_PARMS;
	if(!DeviceIoControl(hDevice,IOCTL_SERIAL_MCX_OPTIONS,
				pOptionDesc, optionLen,		// paramtres fournis
				pOptionDesc, optionLen,		// informations renvoyes
				&retLen, NULL)) {
			printf("DIOC:%d\n",GetLastError());
	}

	pOptionResult = (PMCX_OPTION_PHYSICAL_PARMS)pOptionDesc->Value.Long;
	printf("Adresse physique de la carte : %x%x / %x%x / %d\n",
		pOptionResult->MemoryAddressHigh,
		pOptionResult->MemoryAddressLow,
		pOptionResult->IoAddressHigh,
		pOptionResult->IoAddressLow,
		pOptionResult->InterruptVector);

	free(pOptionDesc);
}

