		/************************************************/
		/* Driver OS/2 pour cartes UNX,UNX/II,ADRS,4RS	*/
		/* Commande permettant l'envoi d'un IOCTL	*/
		/* Version 1.00 du 17/05/95			*/
		/* (C) Copyright ACKSYS 1995 -- JPT		*/
		/************************************************/
#if 0/******/
#define DBG_LABEL
#endif/*****/

/*
 * Syntaxe :
 * srlmode [dev=dev...] < inputdata
 *
 * "inputdata" est un fichier contenant la categorie, la commande et les
 * donnees, par exemple :
 *
 * dev[ice]=COM4 ioctl=1,73
 * writeTimeout=1000
 * DTR_HANDSHAKE=1
 * ioctl=1,53
 *
 * Le mot-cle "ioctl" declenche l'operation.
 * Tout est converti en minuscule avant traitement.
/*

Version	Commentaire
1.00
*/

#define INCL_DOS
#define INCL_DOSERRORS
#define INCL_DOSDEVICES
#define INCL_DOSFILEMGR
#include <stdio.h>
#include <stdlib.h>		/* pour atol() */
#include <string.h>
#include <ctype.h>
#include <os2def.h>
typedef char near *NPUCHAR;
/*
#define INCL_SUB
#include <bsesub.h>
#define INCL_DOS
*/
#include <bsedos.h>
#include "os2comm.h"

/***************************************************************
 *
 *			OS/2 INTERFACE
 *
 ***************************************************************/

#define SZ_BUF	80
unsigned short env[SZ_BUF], rec[SZ_BUF];

#ifdef __32BIT__
#define write	_write
#define read	_read
#define open	_open
#define close	_close
#endif

OS_interface(
	int cat, int code, int handle,
	void *parm, UINT plen,
	void *data, UINT dlen)
{
#ifdef __32BIT__
	/* 32 bits interface */
	ULONG envlen, reclen;

	return DosDevIOCtl(
			handle,cat,code,
			parm,plen,&envlen,
			data,pdata,&reclen);
#else
	/* 16 bits interface */
	//return DosDevIOCtl2(data, dlen, parm, plen, code, cat, handle);
	return DosDevIOCtl(data,parm,code,cat,handle);
#endif
}

/***************************************************************
 *
 *			SRLMODE
 *
 ***************************************************************/

NPUCHAR getmot();
NPUCHAR coupe(NPUCHAR);
void tomin(NPUCHAR);
void dispatch(NPUCHAR, NPUCHAR);

NPUCHAR *Argv;
UCHAR Options = 0;
#define OPT_COMMENT	1
ULONG StartTimer, EndTimer, DeltaTimer;

NPUCHAR
getmot()
{
	static UCHAR mot[50];

	if( Argv[0] ){
		if( Argv[0][0] == ';' )
			return 0;
		return *Argv++;
	}
	else{
retry:
		if( scanf("%s",mot) != 1 )
			return 0;
		if(mot[0] == '#'){
			/* marque de commentaire */
			int c;

			while((c=getchar()) != '\n' && c != EOF){
				if(Options & OPT_COMMENT)
					putchar(c);
			}
			if(Options & OPT_COMMENT)
				putchar('\n');
			goto retry;
		}
		return mot;
	}
}

NPUCHAR
coupe(NPUCHAR mot)
{
	NPUCHAR egal;

	egal = strchr(mot,'=');
	if(!egal){
		printf("Syntax error: %s: no value given\n",mot);
		exit(1);
	}
	*egal = '\0';	/* marquer la fin du mot-cle */
	return ++egal;	/* renvoyer le debut de la zone valeur */
}

void
tomin(NPUCHAR mot)
{
	while(*mot){
		if(isupper(*mot))
			*mot = tolower(*mot);
		mot++;
	}
}

void
dump(void *ptr, int len)
{
	NPUCHAR p = ptr;
	int i;

	for( i = 0; i < len; i++ ){
		if( i%16 == 0 ){
			if( i != 0 )
				printf("\n");
			printf("0x%04x: ",i);
		}
		printf("%02x ",(*p++) & 0xff);
	}
	printf("\n");
}

typedef struct{
	char label[32];
	long pos;
}LABEL;
LABEL Labels[50];
int LastLabel = -1;
int Flags = 0;
NPUCHAR pReturnedBytes = NULL;
int IoctlError = 0;
#define F_ZERO		1
#define F_LESS		2
#define F_SOMEBITS	4
#define F_ALLBITS	8

long
SearchLabel(char *label)
{
	LABEL *p;

	for(p = &Labels[LastLabel]; p >= Labels; p--){
		if( strcmp(p->label,label) == 0 ){
			return p->pos;
		}
	}
	return -1L;
}

void
Jump(char *label)
{
	char localLabel[32];
	LABEL *p;
	long pos;

#ifdef DBG_LABEL
	printf("Jumping to <%s>\n",label);
#endif
	pos = SearchLabel(label);
	if( pos == -1 ){
		NPUCHAR mot;
		NPUCHAR val;

		strcpy(localLabel,label);	/* getmot utilise un static */
		while( mot=getmot() ){
			tomin(mot);
			val = coupe(mot);
			if( strcmp(mot,"label") == 0 ){
				/* mettre les nouveaux labels en table */
				dispatch(mot,val);
				/* est-ce celui qu'on cherche ? */
				if( strcmp(val,localLabel) == 0 )
					return;
			}
		}
		/* pas trouve */
		printf("Error: label %s does not exist\n",localLabel);
		exit(3);
	}else{
		fseek(stdin,pos,0);
	}
}

void
CreateLabel(char *label)
{
	LABEL *p;
	long pos;

	pos = SearchLabel(label);
	if( pos == -1 ){
		if( LastLabel == 50 ){
			printf("Error: too many labels\n");
			exit(2);
		}
		p = &Labels[++LastLabel];
		strcpy(p->label, label);
		p->pos = ftell(stdin);
#ifdef DBG_LABEL
		printf("Creating label %s at %ld\n",label,p->pos);
#endif
	}else{
		if( pos != ftell(stdin) ){
			printf("Error: label already defined: %s\n",label);
			exit(2);
		}
	}
}

int HCom;
UCHAR IsComOpen = 0;

void
main(int argc, char **argv)
{
	NPUCHAR mot;
	NPUCHAR val;

	/* par commodite traiter le cas ou l'usager a
	 * colle le ';' au dernier mot
	 */
 	{
		NPUCHAR mot = argv[argc-1];
		unsigned len = strlen(mot);

		if(len > 1 && mot[len-1] == ';'){
			argv[argc] = ";";
			mot[len-1] = '\0';
			argc++;
		}
	}

	Argv = argv+1;
	while( mot=getmot() ){
		tomin(mot);
		val = coupe(mot);
		fflush(stdout);
		printf("> %s=%s\n",mot,val);
		dispatch(mot,val);
		fflush(stdout);
	}
	if(IsComOpen)
		close(HCom);
}

/*
 * Parametres statiques passes a DosDevIoctl
 */
USHORT	Baud;
struct{ ASYNCLINE LC; UCHAR TxBreak;}QueryLine;
EQBR	EBaud;
UCHAR	Immediate;
ASYNCDCB Dcb;
USHORT	COMEvent;
USHORT	COMERR;
UCHAR	ComStatus;		// !!! different de celui du driver
UCHAR	TransmitStatus;
UCHAR	ModemOutputs;
UCHAR	ModemInputs;
UCHAR	FlushInParm = 0, FlushInData;
UCHAR	FlushOutParm = 0, FlushOutData;
struct{ USHORT Qcount, Qsize;}ibuf, obuf;
struct{ UCHAR On,Off;}ModemMasks;
struct{ UCHAR Flags1; ULONG reserved;}Enhanced;

#define VL(x)	&x, sizeof(x)
struct{
	int active;
	void *pparm;
	int lparm;
	void *pdata;
	int ldata;
}Datatype[] = {
	{ 1, VL(Baud),		0, 0, },		/* 41 */
	{ 1, VL(QueryLine.LC),	0, 0, },		/* 42 */
	{ 1, VL(EBaud),		0, 0, },		/* 43 */
	{ 1, VL(Immediate),	0, 0, },		/* 44 */
	{ 1, 0, 0,		VL(COMERR), },		/* 45 */
	{ 1, VL(ModemMasks),	VL(COMERR), },		/* 46 */
	{ 1, 0, 0,		0, 0, },		/* 47 */
	{ 1, 0, 0,		0, 0, },		/* 48 */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 1, 0, 0,		VL(COMERR), },		/* 4B */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 1, VL(Dcb),		0, 0, },		/* 53 */
	{ 1, VL(Enhanced),	0, 0, },		/* 54 */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 1, 0, 0,		VL(Baud), },		/* 61 */
	{ 1, 0, 0,		VL(QueryLine), },	/* 62 */
	{ 1, 0, 0,		VL(EBaud), },		/* 63 */
	{ 1, 0, 0,		VL(ComStatus), },	/* 64 */
	{ 1, 0, 0,		VL(TransmitStatus), },	/* 65 */
	{ 1, 0, 0,		VL(ModemOutputs), },	/* 66 */
	{ 1, 0, 0,		VL(ModemInputs), },	/* 67 */
	{ 1, 0, 0,		VL(ibuf), },		/* 68 */
	{ 1, 0, 0,		VL(obuf), },		/* 69 */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 1, 0, 0,		VL(COMERR), },		/* 6D */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 0, 0, 0,		0, 0, },		/* -- */
	{ 1, 0, 0,		VL(COMEvent), },	/* 72 */
	{ 1, 0, 0,		VL(Dcb), },		/* 73 */
	{ 1, 0, 0,		VL(Enhanced), },	/* 74 */
	{ 1, VL(FlushInParm),	VL(FlushInData), },	/* cat 11, 01 */
	{ 1, VL(FlushOutParm),	VL(FlushOutData), },	/* cat 11, 02 */
};

#define SWITCH		if(0){
#define CASE(val)	}else if( strcmp(mot,#val) == 0 ){
#define VCASE(code)	}else if( strcmp(val,#code) == 0 ){
#define DEFAULT		}else{
#define ENDSWITCH	}

void
cflag(NPUCHAR FlagStorage,UCHAR FlagBit, NPUCHAR val)
{
	SWITCH
	VCASE(1)	goto setbit;
	VCASE(yes)	goto setbit;
	VCASE(oui)	goto setbit;
	VCASE(on)	goto setbit;
	VCASE(vrai)	goto setbit;
	VCASE(true)
	setbit:
		*FlagStorage |= FlagBit;

	VCASE(0)	goto clearbit;
	VCASE(no)	goto clearbit;
	VCASE(non)	goto clearbit;
	VCASE(off)	goto clearbit;
	VCASE(faux)	goto clearbit;
	VCASE(false)
	clearbit:
		*FlagStorage &= ~FlagBit;

	DEFAULT
		printf("Syntax error: unrecognized bit value\n");
		exit(1);

	ENDSWITCH
}

void
dispatch(NPUCHAR mot, NPUCHAR val)
{
SWITCH
	/*
	 * meta-actions
	 */
 CASE(comment)
 	cflag(&Options,OPT_COMMENT,val);
 CASE(starttimer)
 	time(&StartTimer);
	printf("start at %ld\n",StartTimer);
 CASE(endtimer)
 	time(&EndTimer);
	DeltaTimer = EndTimer - StartTimer;
	printf("end at %ld, delta=%ld\n",EndTimer, DeltaTimer);
 CASE(label)
 	CreateLabel(val);
 CASE(cmp)
	int byteOffset;
	unsigned int byteValue;
	unsigned int returnedByte;

	Flags = 0;
	if( strncmp(val,"error",5) == 0 ){
		if(sscanf(val,"error,%d",&byteValue) != 1 )
			goto stxerr_cmp;
		printf("IoctlError=%d, compareValue=%d\n",IoctlError,byteValue);
		if( IoctlError == byteValue )
			Flags |= F_ZERO;
		if( IoctlError < byteValue )
			Flags |= F_LESS;
	}else if( strncmp(val,"rbyte",5) == 0 ){
		if( sscanf(val,"rbyte%d,%x",&byteOffset,&byteValue) != 2 )
			goto stxerr_cmp;
		/* se mefier des conversions: uchar->int->uint etend le signe */
		returnedByte = (USHORT)pReturnedBytes[byteOffset] & 0xff;
		printf("byte%d=%x, compareValue=%x\n",
			byteOffset, returnedByte, byteValue);
		if( returnedByte == byteValue )
			Flags |= F_ZERO;
		if( returnedByte < byteValue )
			Flags |= F_LESS;
		if( returnedByte & byteValue )
			Flags |= F_SOMEBITS;
		if( (returnedByte & byteValue) == byteValue )
			Flags |= F_ALLBITS;
	}else if( strncmp(val,"timer",5) == 0 ){
		if(sscanf(val,"timer,%d",&byteValue) != 1 )
			goto stxerr_cmp;
		printf("DeltaTimer=%ld, compareValue=%d\n",
			DeltaTimer,byteValue);
		if( DeltaTimer == byteValue )
			Flags |= F_ZERO;
		if( DeltaTimer < byteValue )
			Flags |= F_LESS;
	}else{
	stxerr_cmp:
		printf("Syntax error: cmp=rbyteX,HexValue	(DATA BLK)\n");
		printf("          or: cmp=error,HexValue	(IOCTL RC)\n");
		printf("Exemple.....: cmp=rbyte0,41\n");
		exit(1);
	}
 CASE(jmp)
	Jump(val);
 CASE(je)
 	if(Flags & F_ZERO)
		Jump(val);
 CASE(jne)
 	if(!(Flags & F_ZERO))
		Jump(val);
 CASE(jl)
 	if(Flags & F_LESS)
		Jump(val);
 CASE(jg)
 	if(!(Flags & F_LESS) && !(Flags & F_ZERO))
		Jump(val);
 CASE(jnl)
 	if(!(Flags & F_LESS))
		Jump(val);
 CASE(jallclear)
 	if(!(Flags & F_SOMEBITS))
		Jump(val);
 CASE(jnallclear)
 	if(Flags & F_SOMEBITS)
		Jump(val);
 CASE(jallset)
 	if(Flags & F_ALLBITS)
		Jump(val);
 CASE(jnallset)
 	if(!(Flags & F_ALLBITS))
		Jump(val);
 CASE(exit)
 	exit(atoi(val));

	/*
	 * actions
	 */
CASE(ioctl)
	int Category;
	int Function;
	int cmd;
	int rc;

	if( sscanf(val,"%d,%x",&Category,&Function) != 2 ){
		printf("Syntax error: ioctl Dcategory,Hfunction\n");
		printf("Exemple.....: ioctl 1,73	Get DCB\n");
		exit(1);
	}
	if( Category == 1 ){
		cmd = Function - 0x41;

		if( Function < 0x41 || Function > 0x74
		  || Datatype[cmd].active == 0 ){
			printf("%02x : unknown function\n",Function);
			exit(2);
		}
	}else if( Category == 11 ){
		cmd = (Function - 0x01) + (0x74+1 - 0x41);

		if( Function < 0x1 || Function > 0x2
		  || Datatype[cmd].active == 0 ){
			printf("%02x : unsupported function\n",Function);
			exit(2);
		}
	}else{
		printf("%d: Unsupported category\n", Category);
		exit(2);
	}
	if( Datatype[cmd].lparm != 0 ){
		printf("Sending params:\n");
		dump(Datatype[cmd].pparm,Datatype[cmd].lparm);
	}
	if( (rc=OS_interface(
		Category, Function, HCom,
		Datatype[cmd].pparm, Datatype[cmd].lparm,
		Datatype[cmd].pdata, Datatype[cmd].ldata)) != 0 ){
			printf("Cat=%d Func=%02x : DosDevIOCtl error %d\n",
				Category, Function, rc);
	}
	IoctlError = rc;
	if( Datatype[cmd].ldata != 0 ){
		printf("Returned data:\n");
		dump(Datatype[cmd].pdata,Datatype[cmd].ldata);
		pReturnedBytes = (NPUCHAR)(Datatype[cmd].pdata);
	}

CASE(dev)
	goto device;
CASE(device)
device:
	if(IsComOpen)
		close(HCom);
	if( (HCom = open(val,2)) != -1 )
		IsComOpen = 1;
	else{
		printf("%s: cannot open\n",val);
		perror(val);
		exit(2);
	}
CASE(sleep)
	DosSleep(atoi(val));
CASE(write)
	NPUCHAR p = val;
	for( p = val; *p; p++ )
		if(*p == '\\')
			switch(*(p+1)){
			case 'n': *p = '\r'; *++p = '\n'; break;
			case 'a': *p = '\a'; goto tasser;
			case 'r': *p = '\r'; goto tasser;
			case '\\':
			tasser:
				strcpy(p,p+1);
				break;
			}
	if( write(HCom,val,strlen(val)) != strlen(val) ){
		perror("write");
	}
CASE(read)
	int len;
	int rcvlen;
	static char buf[500];

	len = atoi(val);
	if(len > 500){
		printf("Error: receive buffer is 500 char length\n");
		exit(1);
	}
	if( (rcvlen=read(HCom,buf,len)) == -1 ){
		perror("read");
	}
	printf("receive data:<%*.*s>\n",rcvlen,rcvlen,buf);
	pReturnedBytes = buf;

	/*
	 * Parametres du DCB
	 */
CASE(writetimeout)		Dcb.WriteTimeout = atoi(val);
CASE(readtimeout)		Dcb.ReadTimeout = atoi(val);
CASE(errorreplacementchar)	sscanf(val,"%x",&Dcb.ErrorReplacementChar);
CASE(breakreplacementchar)	sscanf(val,"%x",&Dcb.BreakReplacementChar);
CASE(xonchar)			sscanf(val,"%x",&Dcb.XonChar);
CASE(xoffchar)			sscanf(val,"%x",&Dcb.XoffChar);

/* Flags1 modes */
CASE(dtr)
	Dcb.Flags1 &= ~ADCB_DTR_MASK;
	SWITCH
	VCASE(enable)	Dcb.Flags1 |= ADCB_DTR_ENABLE;
	VCASE(disable)	Dcb.Flags1 |= ADCB_DTR_DISABLE;
	VCASE(handshake)Dcb.Flags1 |= ADCB_DTR_HANDSHAKE;
	DEFAULT		Dcb.Flags1 |= ADCB_DTR_INVALID;
	ENDSWITCH
CASE(cts_handshake)	cflag(&Dcb.Flags1,ADCB_CTS_HANDSHAKE,val);
CASE(dsr_handshake)	cflag(&Dcb.Flags1,ADCB_DSR_HANDSHAKE,val);
CASE(dcd_handshake)	cflag(&Dcb.Flags1,ADCB_DCD_HANDSHAKE,val);
CASE(dsr_sensitivity)	cflag(&Dcb.Flags1,ADCB_DSR_SENSITIVITY,val);

/* Flags2 modes */
CASE(auto_tx_xon)	cflag(&Dcb.Flags2,ADCB_AUTO_TX_XON,val);
CASE(auto_rx_xon)	cflag(&Dcb.Flags2,ADCB_AUTO_RX_XON,val);
CASE(error_replace)	cflag(&Dcb.Flags2,ADCB_ERROR_REPLACE,val);
CASE(null_strip)	cflag(&Dcb.Flags2,ADCB_NULL_STRIP,val);
CASE(break_replace)	cflag(&Dcb.Flags2,ADCB_BREAK_REPLACE,val);
CASE(fdx_rx_flow)	cflag(&Dcb.Flags2,ADCB_FDX_RX_FLOW,val);
CASE(rts)
	Dcb.Flags2 &= ~ADCB_RTS_MASK;
	SWITCH
	VCASE(enable)	Dcb.Flags2 |= ADCB_RTS_ENABLE;
	VCASE(disable)	Dcb.Flags2 |= ADCB_RTS_DISABLE;
	VCASE(handshake)Dcb.Flags2 |= ADCB_RTS_HANDSHAKE;
	VCASE(toggle)	Dcb.Flags2 |= ADCB_RTS_TOGGLE;
	DEFAULT		printf("Syntax error: rts control mode\n"); exit(1);
	ENDSWITCH

/* Flags3 modes */
CASE(infinite_txtout)	cflag(&Dcb.Flags3,ADCB_INFINITE_TXTOUT,val);
CASE(rxtout)
	Dcb.Flags3 &= ~ADCB_RXTOUT_MASK;
	SWITCH
	VCASE(normal)	Dcb.Flags3 |= ADCB_RXTOUT_NORMAL;
	VCASE(wait)	Dcb.Flags3 |= ADCB_RXTOUT_WAIT;
	VCASE(nowait)	Dcb.Flags3 |= ADCB_RXTOUT_NOWAIT;
	DEFAULT		Dcb.Flags3 |= ADCB_RXTOUT_INVALID;
	ENDSWITCH
CASE(hardbuf)
	Dcb.Flags3 &= ~ADCB_HARDBUF_MASK;
	SWITCH
	VCASE(enable)	Dcb.Flags3 |= ADCB_HARDBUF_ENABLE;
	VCASE(disable)	Dcb.Flags3 |= ADCB_HARDBUF_DISABLE;
	VCASE(protovr)	Dcb.Flags3 |= ADCB_HARDBUF_PROTOVR;
	VCASE(ignored)	Dcb.Flags3 |= ADCB_HARDBUF_IGNORED;
	DEFAULT		printf("Syntax error: HARDBUF type\n"); exit(1);
	ENDSWITCH
CASE(hardbuf_rx)
	Dcb.Flags3 &= ~ADCB_HARDBUF_RX14;
	SWITCH
	VCASE(1)	Dcb.Flags3 |= ADCB_HARDBUF_RX1;
	VCASE(4)	Dcb.Flags3 |= ADCB_HARDBUF_RX4;
	VCASE(8)	Dcb.Flags3 |= ADCB_HARDBUF_RX8;
	VCASE(14)	Dcb.Flags3 |= ADCB_HARDBUF_RX14;
	DEFAULT		printf("Syntax error: Hard Rx buffer len\n"); exit(1);
	ENDSWITCH
CASE(hardbuf_tx)
	Dcb.Flags3 &= ~ADCB_HARDBUF_TX16;
	SWITCH
	VCASE(1)	Dcb.Flags3 |= ADCB_HARDBUF_TX1;
	VCASE(16)	Dcb.Flags3 |= ADCB_HARDBUF_TX16;
	DEFAULT		printf("Syntax error: Hard Tx buffer len\n"); exit(1);
	ENDSWITCH

	/*
	 * Line Control
	 */
CASE(databits)
	QueryLine.LC.DataBits = atoi(val);
CASE(parity)
	char code;
	SWITCH
	VCASE(none)	code = ALINE_PARITY_NONE;
	VCASE(odd)	code = ALINE_PARITY_ODD;
	VCASE(even)	code = ALINE_PARITY_EVEN;
	VCASE(mark)	code = ALINE_PARITY_MARK;
	VCASE(space)	code = ALINE_PARITY_SPACE;
	ENDSWITCH
	QueryLine.LC.Parity = code;
CASE(stopbits)
	char code;
	SWITCH
	VCASE(1)	code = ALINE_STOP_1;
	VCASE(1.5)	code = ALINE_STOP_1_5;
	VCASE(2)	code = ALINE_STOP_2;
	ENDSWITCH
	QueryLine.LC.StopBits = code;

CASE(bitrate)
	Baud = atoi(val);
CASE(currentbitrate)
	EBaud.CurrentBitRate = atol(val);
CASE(currentfrac)
	EBaud.CurrentFrac = atoi(val);
CASE(immediate)
	USHORT usImmediate;
	if(sscanf(val,"%x",&usImmediate) != 1){
		printf("Syntax error: hex value required\n"); exit(1);
	}
	Immediate = usImmediate;

/* Async Set/Get Modem Control Signals */
CASE(onmask)
	SWITCH
	VCASE(dtr)	ModemMasks.On = AMCS_DTR;
	VCASE(rts)	ModemMasks.On = AMCS_RTS;
	VCASE(dtr+rts)	ModemMasks.On = AMCS_DTR | AMCS_RTS;
	VCASE(0)	ModemMasks.On = 0;
	DEFAULT		printf("Syntax error: ModemMask.On\n"); exit(1);
	ENDSWITCH
CASE(offmask)
	SWITCH
	VCASE(dtr)	ModemMasks.Off = ~(AMCS_DTR);
	VCASE(rts)	ModemMasks.Off = ~(AMCS_RTS);
	VCASE(dtr+rts)	ModemMasks.Off = ~(AMCS_DTR | AMCS_RTS);
	VCASE(0)	ModemMasks.Off = ~(0);
	DEFAULT		printf("Syntax error: ModemMask.Off\n"); exit(1);
	ENDSWITCH

DEFAULT
	printf("Syntax error: %s: unknown keyword\n",mot);
	exit(1);
ENDSWITCH
}
