
		/************************************************/
		/* Driver OS/2 pour cartes UNX,UNX/II,ADRS,4RS	*/
		/* Test sommaire des voies sous OS/2		*/
		/* Peut etre utilise par un client		*/
		/* Version : voir ci-dessous			*/
		/* (C) Copyright ACKSYS 1995 -- JPT		*/
		/************************************************/

#if 0/******/
#define DBG_STACK		/* afficher taille restante dans les stacks */
#endif/*****/

/*
 * Syntaxe :
 * srltest param1 param2
 *
 * param1 peut etre /H ou /?, dans ce cas param2 est ignore
 * param1 peut etre de la forme :
 *  {nomdevice}{numero}		par ex. COM3	On testera cette voie-la
 *  {nomdev}{numero}-{numero2}	par ex. COM3-6	On testera toutes ces voies
 *
 * param2 peut etre /1 ou /N
 *  /1	teste une seule fois chaque voie
 *  /N	teste N fois (s'arrete sur ctrl-C)
/*

Version	Date	Commentaire
1.00	10/7/95
*/

#define INCL_DOS
#define INCL_DOSERRORS
#include <stdio.h>
#include <stdlib.h>		/* pour atol() */
#include <string.h>
#include <ctype.h>
#include <os2def.h>
typedef char near *NPUCHAR;
#include <bsedos.h>
#include <bsedev.h>
#include "os2comm.h"
#define STKSZ 300		/* Au moins 112 sous OS/2 2.0 */
#define MSGSIZE 40
char msg[MSGSIZE+1] = "The quick brown fox jumps over lazy dogs";

/***************************************************************
 *
 *			OS/2 INTERFACE
 *
 ***************************************************************/

#define SZ_BUF	80
unsigned short env[SZ_BUF], rec[SZ_BUF];

#ifdef __32BIT__
#define write	_write
#define read	_read
#define open	_open
#define close	_close
#endif

OS_interface(
	int cat, int code, int handle,
	void *parm, UINT plen,
	void *data, UINT dlen)
{
#ifdef __32BIT__
	/* 32 bits interface */
	ULONG envlen, reclen;

	return DosDevIOCtl(
			handle,cat,code,
			parm,plen,&envlen,
			data,pdata,&reclen);
#else
	/* 16 bits interface */
	//return DosDevIOCtl2(data, dlen, parm, plen, code, cat, handle);
	return DosDevIOCtl(data,parm,code,cat,handle);
#endif
}

/***************************************************************
 *
 *			SRLMODE
 *
 ***************************************************************/

typedef struct{
	/*		variables internes au thread */
	int Hcom;
	char *stack;
	char rcvbuf[MSGSIZE];
	DCBINFO Dcb;
	/*		compteurs a afficher */
	int NbTests;
	int ErrEmis;
	int ErrRecu;
	int ErrCts;
	int ErrDcd;
	int ErrDsr;
	int ErrRi;
	int ErrAutres;
}COUNTERS;
COUNTERS voie[8];
UCHAR Mode;
int AllDone, YourChan, YourChanAck, TotalErreurs;

void far FoncTest(void);
char * getpnum1(char *pname);

void
main(int argc, char **argv)
{
	COUNTERS *pvoie;
	int num1, i, rc;
	int nbVoies;
	char stacks[8][STKSZ];

#ifdef DBG_STACK
	setbuf(stdout,NULL);
#endif
	if(argc < 2 || argc > 3) goto stxerror;
	if(strcmp(argv[1],"/H") == 0 || strcmp(argv[1],"/?") == 0 ){
	syntax:
		printf("usage: %s nameInterval [/1] [/N]\n",argv[0]);
		printf("	nameInterval	: i.e. COM3-6 or COM3\n");
		printf("	/1		: test once each channel\n");
		printf("	/n		: test until CTRL-C\n");
		exit(1);
	}
	/* arg 1 */
	{
		UCHAR *pname = argv[1];
		UCHAR *pnum1, *pnum2;
		int num, num2;

		pnum2 = strchr(pname,'-');
		if(pnum2){
			*pnum2++ = '\0';
			num2 = atoi(pnum2);
			if( (pnum1=getpnum1(pname)) == NULL ) goto stxerror;
			num1 = atoi(pnum1);
			*pnum1 = '\0';	/* pour isoler la racine du nom */
			if(num1 > num2 || num1 < 0 || num2 < 0) goto stxerror;
			for(num = num1,nbVoies=0; num <= num2; num++,nbVoies++){
				char buf[20];

				sprintf(buf,"%s%d", pname, num);
				if( (voie[nbVoies].Hcom=open(buf,2)) < 0 ){
					perror(buf);
					exit(1);
				}
			}
		}else{
			if( (pnum1=getpnum1(pname)) == NULL ) goto stxerror;
			num1 = atoi(pnum1);
			nbVoies = 1;
			if( (voie[0].Hcom=open(pname,2)) < 0 ){
				perror(pname);
				exit(1);
			}
		}
	}
	/* arg 2 */
	{
		if(argc == 3){
			Mode = argv[2][1];
			if(argv[2][0] != '/' && argv[2][0] != '-')goto stxerror;
		}else{
			Mode = 'N';
		}
		switch(Mode){
		case 'n':
			Mode = 'N';
		case 'N':
		case '1':
			break;
		default:
		stxerror:
			printf("\nCommand line syntax error.\n\n");
			goto syntax;
		}
	}

	/* initialiser les voies */

	for(YourChan=0,pvoie=voie; YourChan<nbVoies; YourChan++,pvoie++){
		rc = OS_interface(1, ASYNC_GETDCBINFO, pvoie->Hcom,
				0, 0, &pvoie->Dcb, sizeof(pvoie->Dcb));
		if(rc != 0){
			printf("GetDcb: error %d\n",rc);
			exit(1);
		}
		pvoie->Dcb.usWriteTimeout = 400;
		pvoie->Dcb.usReadTimeout = 400;
		pvoie->Dcb.fbCtlHndShake &= ~(0
					| MODE_CTS_HANDSHAKE
					| MODE_DSR_HANDSHAKE
					| MODE_DCD_HANDSHAKE
					| MODE_DSR_SENSITIVITY );

		rc = OS_interface(1, ASYNC_SETDCBINFO, pvoie->Hcom,
				&pvoie->Dcb, sizeof(pvoie->Dcb), 0, 0);
		if(rc != 0){
			printf("SetDcb: error %d\n",rc);
			exit(1);
		}
		testdtrrts(pvoie,0,0);	/* RAZ modes de handshake Rx */
	}

	/* maintenant creer les threads */

	TotalErreurs = 0;
	AllDone = 0;		/* flag de synchro */
	for(YourChan=0,pvoie=voie; YourChan<nbVoies; YourChan++,pvoie++){
		TID	tid;
		USHORT	rc;		/* Return code */

 		pvoie->NbTests = 0;
		pvoie->ErrEmis = 0;
		pvoie->ErrRecu = 0;
		pvoie->ErrCts = 0;
		pvoie->ErrDcd = 0;
		pvoie->ErrDsr = 0;
		pvoie->ErrRi = 0;
		pvoie->ErrAutres = 0;
		YourChanAck = 0;
		pvoie->stack = stacks[YourChan];
		for(i=0;i<STKSZ;i++)
			pvoie->stack[i] = 0x34;
		rc = DosCreateThread(FoncTest, &tid, pvoie->stack+STKSZ-2);
		if(rc != 0){
			printf("DosCreateThread no %d error %d\n",YourChan,rc);
			exit(1);
		}
		while(!YourChanAck)
			DosSleep(100);	/* laisser le thread demarrer */
 	}

	/* boucle d'affichage */
	cls();
	gotoxy(1,1);
printf("  Bouchon de test DB25:		|  Bouchon de test DB9:\n");
printf("-----------------------------------------------------------------\n");
printf("	Relier 2 --- 3		|	Relier 2 --- 3\n");
printf("	Relier 4 --- 5 --- 8	|	Relier 1 --- 7 --- 8\n");
printf("	Relier 20 --- 6 --- 22	|	Relier 4 --- 6 --- 9\n");
printf("-----------------------------------------------------------------\n");
	gotoxy(1,8);
	printf("    |           |===============Erreurs===================\n");
	printf("voie| Nb. tests |=Emis===Recu====CTS====DCD====DSR====RI==\n");
	printf("====|===========|=========================================\n");
	do{
		DosSleep(400);
		for(i=0,pvoie=voie; i<nbVoies; i++,pvoie++){
			gotoxy(1,i+11);
			printf("%3d |%9u  |%6u%7u%7u%7u%7u%7u",
				num1+i,
				pvoie->NbTests,
				pvoie->ErrEmis,
				pvoie->ErrRecu,
				pvoie->ErrCts,
				pvoie->ErrDcd,
				pvoie->ErrDsr,
				pvoie->ErrRi);
			if(pvoie->ErrAutres)
				printf("%7u", pvoie->ErrAutres);
		}
		gotoxy(1,20);
		printf("Voies stoppees=%d\nNombre total d'erreurs=%d",
			AllDone,TotalErreurs);
		fflush(stdout);
	}while(AllDone != nbVoies);
}

gotoxy(int x,int y){
	printf("\033[%d;%dH",y,x);
}
cls()
{
	printf("\033[2J");
}

char *
getpnum1(char *pname)
{
	char *pnum1;

	pnum1 = pname+strlen(pname);
	while( --pnum1 >= pname && isdigit(*pnum1) )
		;
	if(pnum1 < pname) return NULL;
	pnum1++;
	if( *pnum1 == '\0' ) return NULL;
	return pnum1;
}

/***************************************************************
 *
 *		FONCTION DE TEST D'UNE VOIE
 *
 ***************************************************************/

void far FoncTest()
{
	int MyChan = YourChan;
	COUNTERS *pvoie = &voie[MyChan];
	int cr;

	YourChanAck = 1;	/* signaler qu'on a lu le numero de voie */
	do{
		pvoie->NbTests++;
		cr = write(pvoie->Hcom,msg,MSGSIZE);
#ifdef DBG_STACK
		probe(MyChan);
#endif
		if( cr != MSGSIZE ){
			pvoie->ErrEmis++;
			TotalErreurs++;
		}
		cr = read(pvoie->Hcom,pvoie->rcvbuf,MSGSIZE);
		if( cr != MSGSIZE || strncmp(msg,pvoie->rcvbuf,MSGSIZE) != 0 ){
			pvoie->ErrRecu++;
			TotalErreurs++;
		}
		/* ecrire DTR=0 RTS=0 relire CTS DCD DSR RI */
		testdtrrts(pvoie,0,0);
		/* ecrire DTR=0 RTS=1 relire CTS DCD DSR RI */
		testdtrrts(pvoie,0,1);
		/* ecrire DTR=1 RTS=0 relire CTS DCD DSR RI */
		testdtrrts(pvoie,1,0);
		/* ecrire DTR=1 RTS=1 relire CTS DCD DSR RI */
		testdtrrts(pvoie,1,1);
	}while(Mode == 'N');
	AllDone++;
}

testdtrrts(COUNTERS *pvoie,int dtr,int rts)
{
	int rc;
	UCHAR	ModemInputs;

	pvoie->Dcb.fbCtlHndShake &= ~(MODE_DTR_CONTROL|MODE_DTR_HANDSHAKE);
	pvoie->Dcb.fbFlowReplace &= ~(MODE_RTS_CONTROL|MODE_RTS_HANDSHAKE);
	if(dtr) pvoie->Dcb.fbCtlHndShake |= MODE_DTR_CONTROL;
	if(rts) pvoie->Dcb.fbFlowReplace |= MODE_RTS_CONTROL;

	rc = OS_interface(1, ASYNC_SETDCBINFO, pvoie->Hcom,
			&pvoie->Dcb, sizeof(pvoie->Dcb), 0, 0);
	if(rc != 0){
		printf("SetDcbForRtsDtr: error %d\n",rc);
		exit(1);
	}

	DosSleep(50);		/* attendre la propagation des signaux */
	rc = OS_interface(1, ASYNC_GETMODEMINPUT, pvoie->Hcom,
			0, 0, &ModemInputs, sizeof(ModemInputs));
	if(rc != 0){
		printf("GetModemInput: error %d\n",rc);
		exit(1);
	}
	if(dtr){
		if( !(ModemInputs & DSR_ON) ){
			pvoie->ErrDsr++;
			TotalErreurs++;
		}
		if( !(ModemInputs & RI_ON) ){
			pvoie->ErrRi++;
			TotalErreurs++;
		}
	}else{
		if( ModemInputs & DSR_ON ){
			pvoie->ErrDsr++;
			TotalErreurs++;
		}
		if( ModemInputs & RI_ON ){
			pvoie->ErrRi++;
			TotalErreurs++;
		}
	}
	if(rts){
		if( !(ModemInputs & DCD_ON) ){
			pvoie->ErrDcd++;
			TotalErreurs++;
		}
		if( !(ModemInputs & CTS_ON) ){
			pvoie->ErrCts++;
			TotalErreurs++;
		}
	}else{
		if( ModemInputs & DCD_ON ){
			pvoie->ErrDcd++;
			TotalErreurs++;
		}
		if( ModemInputs & CTS_ON ){
			pvoie->ErrCts++;
			TotalErreurs++;
		}
	}
}

probe(num)
int num;
{
	int i;
	for(i=0;i<STKSZ;i++)
		if(voie[num].stack[i] != 0x34){
			printf("free(%d)=%d\n",num,i);
			fflush(stdout);
			break;
		}
}
