/*
 * structures OS/2 pour driver serie asynchrone
 *
 * (C)Copyright ACKSYS, 1995 -- JPT
 */

typedef struct _ASYNCDCB {
	unsigned short WriteTimeout;
	unsigned short ReadTimeout;
	unsigned char Flags1;
	unsigned char Flags2;
	unsigned char Flags3;
	unsigned char ErrorReplacementChar;
	unsigned char BreakReplacementChar;
	unsigned char XonChar;
	unsigned char XoffChar;
} ASYNCDCB, *PASYNCDCB, far *FPASYNCDCB;

/* flags1 modes */
#define ADCB_DTR_DISABLE	0
#define ADCB_DTR_ENABLE		1
#define ADCB_DTR_HANDSHAKE	2
#define ADCB_DTR_INVALID	3
#define ADCB_DTR_MASK		3
#define ADCB_CTS_HANDSHAKE	8
#define ADCB_DSR_HANDSHAKE	16
#define ADCB_DCD_HANDSHAKE	32
#define ADCB_DSR_SENSITIVITY	64

/* Flags2 modes */
#define ADCB_AUTO_TX_XON	1
#define ADCB_AUTO_RX_XON	2
#define ADCB_ERROR_REPLACE	4
#define ADCB_NULL_STRIP		8
#define ADCB_BREAK_REPLACE	16
#define ADCB_FDX_RX_FLOW	32
#define ADCB_RTS_DISABLE	0
#define ADCB_RTS_ENABLE		64
#define ADCB_RTS_HANDSHAKE	128
#define ADCB_RTS_TOGGLE		192
#define ADCB_RTS_MASK		192

/* Flags3 modes */
#define ADCB_NORMAL_TXTOUT	0
#define ADCB_INFINITE_TXTOUT	1
#define ADCB_RXTOUT_INVALID	0
#define ADCB_RXTOUT_NORMAL	2
#define ADCB_RXTOUT_WAIT	4
#define ADCB_RXTOUT_NOWAIT	6
#define ADCB_RXTOUT_MASK	6
#define ADCB_HARDBUF_IGNORED	0
#define ADCB_HARDBUF_DISABLE	8
#define ADCB_HARDBUF_ENABLE	16
#define ADCB_HARDBUF_PROTOVR	24
#define ADCB_HARDBUF_MASK	24
#define ADCB_HARDBUF_RX1	0
#define ADCB_HARDBUF_RX4	32
#define ADCB_HARDBUF_RX8	64
#define ADCB_HARDBUF_RX14	96
#define ADCB_HARDBUF_TX1	0
#define ADCB_HARDBUF_TX16	128

typedef struct _ASYNCLINE {
	char DataBits;
	char Parity;
	char StopBits;
}ASYNCLINE, *PASYNCLINE, far*FPASYNCLINE;
#define ALINE_5BITS		5
#define ALINE_6BITS		6
#define ALINE_7BITS		7
#define ALINE_8BITS		8
#define ALINE_ISLEGALDATA(databit)	((databit)>=5 && (databit)<=8)
#define ALINE_PARITY_NONE	0
#define ALINE_PARITY_ODD	1
#define ALINE_PARITY_EVEN	2
#define ALINE_PARITY_MARK	3
#define ALINE_PARITY_SPACE	4
#define ALINE_ISLEGALPARITY(parity)	((parity)<=4)
#define ALINE_STOP_1		0
#define ALINE_STOP_1_5		1
#define ALINE_STOP_2		2
#define ALINE_ISLEGALSTOP(stop,databit)	( (stop)==0			\
					|| ((stop)==1&&(databit)==5)	\
					|| ((stop)==2&&(databit)!=5) )

typedef struct _EQBR{
	unsigned long CurrentBitRate;
	unsigned char CurrentFrac;
	unsigned long MinimumBitRate;
	unsigned char MinimumFrac;
	unsigned long MaximumBitRate;
	unsigned char MaximumFrac;
}EQBR, *PEQBR, far *FPEQBR;

/* Async Set/Get Modem Control Signals */
#define AMCS_DTR	'\1'
#define AMCS_RTS	'\2'

/* Async Get COM Error word bits */
#define COMERR_RXQ_OVR	1

/* Async Get COM Event word bits */
#define COMEVT_RX	0x001
#define COMEVT_RXTO	0x002
#define COMEVT_TXLAST	0x004
#define COMEVT_CTS	0x008
#define COMEVT_DSR	0x010
#define COMEVT_DCD	0x020
#define COMEVT_BREAK	0x040
#define COMEVT_RXERR	0x080
#define COMEVT_RI	0x100

/* Async Get COM Status byte bits */
#define COMSTAT_TXCTS	0x01	/* cant transmit, because CTS off */
#define COMSTAT_TXDSR	0x02	/* cant transmit, because DSR off */
#define COMSTAT_TXDCD	0x04	/* cant transmit, because DCD off */
#define COMSTAT_TXRXOFF	0x08	/* cant transmit, because XOFF received */
#define COMSTAT_TXTXOFF	0x10	/* cant transmit, because XOFF sent */
#define COMSTAT_TXBREAK	0x20	/* cant transmit, because BREAK being sent */
#define COMSTAT_TXIMMED	0x40	/* ImmediateChar waiting for transmit */
#define COMSTAT_RXDSR	0x80	/* Receive waiting for DSR */
#define COMSTAT_TX_NODT	0x3f	/* cannot transmit ordinary data */
#define COMSTAT_TX_NONE	0x27	/* cannot transmit ImmediateChar, XON or XOFF */

/* Async Get Transmit Status (func. 65H) byte bits */
#define TXSTAT_PACKET	0x01	/* data waiting in request packet */
#define TXSTAT_QUEUE	0x02	/* data waiting in the driver buffer */
#define TXSTAT_HARDWARE	0x04	/* data waiting in hardware registers */
				/* set in ioctl 65 from LSR */
#define TXSTAT_IMMEDIAT	0x08	/* data waiting in immediate buffer (1 char) */
				/* set in ioctl 65 from ComStatus */
#define TXSTAT_AUTOXON	0x10	/* XON waiting to be transmitted */
				/* set in ioctl 65 from COMSTATI_XON */
#define TXSTAT_AUTOXOFF	0x20	/* XOFF waiting to be transmitted */
				/* set in ioctl 65 from COMSTATI_XOFF */

/********** General driver structures & defs **********/

#define RP_ERR		0x8000
#define RP_DEVERR	0x4000
#define RP_BUSY		0x0200
#define RP_DONE		0x0100
#define RPERR_WRTPROT	(RP_ERR|RP_DONE|0x00)
#define RPERR_DEVBUSY	(RP_ERR|RP_DONE|0x02)
#define RPERR_UNKNOWN	(RP_ERR|RP_DONE|0x03)
#define RPERR_GENFAIL	(RP_ERR|RP_DONE|0x0C)
#define RPERR_RWFAULT	RPERR_GENFAIL		/* general protection trap */
#define RPERR_INTERPT	(RP_ERR|RP_DONE|0x11)
#define RPERR_MONITOR	(RP_ERR|RP_DONE|0x12)
#define RPERR_INVPARM	(RP_ERR|RP_DONE|0x13)
#define RP_OK		RP_DONE

typedef struct _DRVHEAD {
	struct _DRVHEAD far *Next;
	int	Attribute;
	void	(near *StrategyOffset)();
	void	(near *IDCEntryPoint)();
	char	DeviceName[8];
	char	ReservedChars[8];
	long	Capabilities;
}DRVHEAD, *PDRVHEAD, far *FPDRVHEAD;

/********** DevHelp structures & definitions **********/

enum KDH {			/* OS/2 Kernel functions */
	DEVDONE		= 0x01,
	DH_YIELD	= 0x02,
	DH_BLOCK	= 0x04,
	DH_RUN		= 0x05,
	ALLOCRP		= 0x0d,
	FREERP		= 0x0e,
	DH_QUEUEINIT	= 0x0f,
	DH_QUEUEFLUSH	= 0x10,
	DH_QUEUEWRITE	= 0x11,
	DH_QUEUEREAD	= 0x12,
	PHYSTOV		= 0x15,
	VTOPHYS		= 0x16,
	PHYSTOUV	= 0x17,
	DH_SETIRQ	= 0x1b,
	DH_UNSETIRQ	= 0x1c,
	DH_SETTIMER	= 0x1d,
	DH_RESETTIMER	= 0x1e,
	DH_GETDOSVAR	= 0x24,
	DH_VERRW	= 0x27,
	GDTALLOC	= 0x2d,
	PHYSTOGDT	= 0x2e,
	DH_EOI		= 0x31,
	UNPHYSTOV	= 0x32,
	DH_TICKCOUNT	= 0x33,
	DH_REGSTACKUSE	= 0x3a,
	DH_SAVEMESSAGE	= 0x3d,
	DH_BEEP		= 0x52,
};

typedef struct _MSG_TABLE {
	USHORT Message_ID;
	USHORT ItemCount;
	UCHAR far *Item[3];
}MSG_TABLE, *PMSG_TABLE, far *FPMSG_TABLE;

typedef struct _QUEUE {
	USHORT Qsize;
	USHORT Qchrout;
	USHORT Qcount;
	UCHAR Qbase[1];
}QUEUE, *PQUEUE, far *FPQUEUE;

typedef struct _GLOBALINFO{
	ULONG Time;
	ULONG Millisecs;
	UCHAR Hours;
	UCHAR Minute;
	UCHAR Seconds;
	UCHAR HundredSec;
	USHORT TimeZone;
	USHORT Interval;
	/* ... */
}GLOBALINFO, *PGLOBALINFO, far *FPGLOBALINFO;
