/*
 * Entrees/sorties directes sur les cartes ADRS et UNX par IOCTL
 *
 * ATTENTION :	Certaines operations sur les ports d'E/S sont conflictuelles
 * ^^^^^^^^^	avec le fonctionnement normal du driver, en particulier la
 *		gestion des interruptions et les IOCTL standard.
 *
 * @(#)unx232.h	4.4 94/10/06 -- JPT
 * Copyright(C) ACKSYS, 1993, 1994.
 */

/***********************************************
**
** Rappels sur les denominations des signaux
**
**  Noms      Circuit	      Broche
** fr/ang    CCITT V24     RS232/EIA530
**
** TP  PG	-		1
** TD  TD	103		2
** RD  RD	104		3
** DPE RTS	105		4
** PAE CTS	106		5
** PDP DSR	107		6
** TS  SG	102		7
** DS  DCD	109		8	(ou RLSD)
** TDP DTR	108/2		20
** -   RI	125		22
**
************************************************/

#ifndef UNX232_H
#define UNX232_H

#define TIOC_UNX_ECM		(TIOC|80)	/* ecriture Controle MODEM */
#define TIOC_UNX_LEM		(TIOC|81)	/* lecture etat MODEM */
#define TIOC_UNX_ECL		(TIOC|82)	/* ecriture Controle Ligne */
#define TIOC_UNX_IES		(TIOC|83)	/* init extensions signaux */
#define TIOC_UNX_LES		(TIOC|84)	/* lecture etat signaux */
#define TIOC_UNX_ABS		(TIOC|85)	/* attente bloquante signaux */
#define TIOC_UNX_TXE		(TIOC|86)	/* attente vidage en emission */

/***********************************************
**
**	Definitions pour le controleur intel
**	8250 et ses compatibles (16550, etc)
**	Voir aussi les ioctls TIOC_UNX_ECM,
**	TIOC_UNX_LEM, TIOC_UNX_ECL.
**
************************************************/
#define	UART8250_DTR		1		/* Modem control register */
#define UART8250_RTS		2
#define UART8250_OUT1		4
#define UART8250_OUT2		010
#define	UART8250_LOOP		020

#define UART8250_DCTS		1		/* Modem status register */
#define UART8250_DDSR		2
#define UART8250_TERI		4
#define UART8250_DRLSD		010
#define UART8250_CTS		020
#define UART8250_DSR		040
#define UART8250_RI		0100
#define UART8250_RLSD		0200

#define UART8250_DR		1		/* Line Status Register */
#define UART8250_OE		2
#define UART8250_PE		4
#define UART8250_FE		8
#define UART8250_BI		16
#define UART8250_THRE		32
#define UART8250_TEMT		64
#define UART8250_RXFE		128

#define UART8250_IE_RX		1		/* Interrupt Enable Register */
#define UART8250_IE_TX		2
#define UART8250_IE_ERR		4
#define UART8250_IE_MDM		8

#define UART8250_WLS0		1		/* LCR bits */
#define UART8250_WLS1		2
#define UART8250_STB		4
#define UART8250_PEN		010
#define UART8250_EPS		020
#define UART8250_STICKP		040
#define UART8250_SBRK		0100
#define UART8250_DLAB		0200		/* mis a 0 dans TIOC_UNX_ECL */

#define UART8250_L5BIT		(0		| 0)
#define UART8250_L6BIT		(0		| UART8250_WLS0)
#define UART8250_L7BIT		(UART8250_WLS1	| 0)
#define UART8250_L8BIT		(UART8250_WLS1	| UART8250_WLS0)
#define UART8250_TWOSB		UART8250_STB

/***********************************************
**
**	Definitions pour l'ioctl TIOC_UNX_IES
**
************************************************/
#define UNX_CTS_X		0		/* index en table sig[] */
#define UNX_DSR_X		1
#define UNX_DCD_X		2
#define UNX_RI_X		3
#define UNX_IES_NB_SIGS		4
#define UNX_SIG_CTS		sig[UNX_CTS_X]	/* table sig[] */
#define UNX_SIG_DSR		sig[UNX_DSR_X]
#define UNX_SIG_DCD		sig[UNX_DCD_X]
#define UNX_SIG_RI		sig[UNX_RI_X]

#define UNX_IES_CHAR_ON		1
#define UNX_IES_CHAR_OFF	2		/* champ char_off valide */

typedef struct {
	unsigned short mc_msec;			/* micro-coupure (en msec) */
	unsigned short mf_msec;			/* micro-fermeture (millisec) */
	unsigned char char_on;			/* reserve */
	unsigned char char_off;			/* car. indiquant perte sig. */
	unsigned char flags;
	unsigned char reserved;
}UnxSigDesc_t;

typedef struct {
	unsigned char version;			/* version de la structure */
	unsigned char etat;			/* etat sig. (interne driver) */
	UnxSigDesc_t sig[UNX_IES_NB_SIGS];	/* DSR/DCD/RI/CTS + retards */
}UnxIesParameters_t;

/***********************************************
**
**	Definitions pour l'ioctl TIOC_UNX_ABS
**	et le retour de TIOC_UNX_LES
**
************************************************/
#define UNX_BIT_CTS		(1<<UNX_CTS_X)	/* bits du parametre no 3 */
#define UNX_BIT_DSR		(1<<UNX_DSR_X)
#define UNX_BIT_DCD		(1<<UNX_DCD_X)
#define UNX_BIT_RI		(1<<UNX_RI_X)
#define UNX_BIT_ALL		0xf		/* masque validite parametre */

/***********************************************
**
**	Definitions pour l'ioctl TIOC_UNX_ABS
**	Faire un OR avec les bits ci-dessus
**
************************************************/
#define UNX_ABS_TOUS_ON		(0<<8)
#define UNX_ABS_TOUS_OFF	(1<<8)
#define UNX_ABS_UN_ON		(2<<8)
#define UNX_ABS_UN_OFF		(3<<8)
#define UNX_ABS_MODE		(3<<8)		/* masque validite parametre */

/***********************************************
**
**	Definitions pour l'ioctl TIOC_UNX_TXE
**
************************************************/
/* sans objet */

#endif /* UNX232_H */
