//
// Programme de test des ports COM
//
// Limite  12 ports (fichier ressources)
// Limite  32 ports (1 par bits dans un long)
// Ne se compile q'en 32 bits (Make/FreeProcInstance, CreateFile...)
//
// (c)Copyright Acksys SARL, 1995 -- JPT
//

#define  STRICT
#include <windows.h>
#pragma hdrstop
#include <stdio.h>
#include <BWCC.H>	// pour les styles Borland

#include "main.h"
#include "tstcomrc.h"

////////////////////////////////////////////////////////////
// Dfinitions des variables initialises ici
////////////////////////////////////////////////////////////

// Les callbacks

HWND HMainDialog = NULL;
LRESULT CALLBACK _export MainDialogFunc( HWND hWnd, UINT iMessage,
											WPARAM wParam, LPARAM lParam );
LRESULT AnalyseControle(int notificationCode, int controlId, HWND control);

// Les debugs

#define WPrintf(a,b,c)	WinPrintf(a,(long)b, (long)c)
void WinPrintf(char *format, long param1, long param2);
char *StringError(void);	// Conversion de GetLastError() en texte

// L'application (fichier et ports)

typedef struct {
	HANDLE		hCom;
	char			friendlyName[20];
	char			systemName[20];
	BOOL			first;	// TRUE si aucun write antrieur sur ce handle
	int			lastWriteLen;
	OVERLAPPED	overlap;
}PORT;

int LireFichier(HANDLE hFile,char *enreg,int len);
void SendFileOnManyPorts(char *nomFichier, long selectedComs);
void InitSelectedComs32(long *selectedComs,PORT *com);
void SendSelectedComs32(long selectedComs,PORT *com,char *rec,int reclen);
void CloseSelectedComs32(long selectedComs,PORT *com);
void AttenteFinEcriturePrecedente(PORT *pCom);

// Les paramtres des ports

#define COMMON_BUF_SIZE	30		// buffers lecture fichier/criture ports

long Vitesses[] = {
	300, 1200, 9600, 14400, 19200, 28800, 38400, 57600, 115200, 0};
#define B9600	2
long *PVitesse = &Vitesses[B9600];

// Les ressources messages
#define MAXMSGNUM	50
#define MAXMSGLEN	50
char message[MAXMSGNUM][MAXMSGLEN];

////////////////////////////////////////////////////////////
// Fonctions
////////////////////////////////////////////////////////////

#pragma argsused
int
InitAnyInstance(HINSTANCE hInst, HINSTANCE prev)
{
	// Forcer le link avec les classes Borland.
	BWCCRegister(hInst);
	// Charger la table des messages. A faire en tout premier lieu.
	int i = 1;
	while( LoadString(hInst, i, (LPSTR)message[i], MAXMSGLEN) )
		i++;

	HMainDialog = CreateDialog(hInst,
							MAKEINTRESOURCE(FENETRE_PRINCIPALE),
							NULL,
							(DLGPROC)MainDialogFunc
						);
	if(HMainDialog == NULL){
		MessageBox(NULL, message[MSG_DLG_CREAT], message[MSG_INTERNE],
				MB_APPLMODAL | MB_ICONSTOP | MB_OK);
		return 0;
	}

	return 1;	// OK, continuer
}

int MustProcessMainLoop(MSG *pMsg)
{
	if(HMainDialog)
		return !IsDialogMessage(HMainDialog,pMsg);
	else
		return TRUE;
}

#pragma argsused			// Turn off warning: Parameter is never used
LRESULT CALLBACK _export
MainDialogFunc(HWND hWnd, UINT iMessage, WPARAM wParam, LPARAM lParam)
{
	switch (iMessage)
	{
		case WM_INITDIALOG:
			//
			// ATTENTION: CreateDialog() n'est pas encore termin,
			// HMainDialog n'est donc pas initialis
			//
			// Afficher une chaine initiale :
			SetDlgItemText(hWnd,SAIS_FICHIER,message[MSG_FILE_DFLT]);
			// Slectionner toute la chaine :
			SendDlgItemMessage(hWnd,SAIS_FICHIER,
							(WORD)EM_SETSEL,
							NULL,
							MAKELONG(0,0x7fff));
			return TRUE;	// focus donn au 1er controle

		case WM_COMMAND:
			// The WM_COMMAND message is sent when a control sends a
			// notification message.
			// If an application processes this message, it should return zero.
			//
			// HIWORD(wParam):	notification code
			// LOWORD(wParam);	control identifier
			// (HWND)lParam;		handle of control
			return AnalyseControle(HIWORD(wParam), LOWORD(wParam), (HWND)lParam);

		case WM_CLOSE:					// Bouton systeme CLOSE
			DestroyWindow(hWnd);		// provoque appel WM_DESTROY
			break;

		case WM_DESTROY:
			PostQuitMessage( 0 );	// Provoque sortie boucle principale
			break;
	}
	return 0;
}

#pragma argsused
LRESULT
AnalyseControle(int notificationCode, int controlId, HWND hControl)
{
	switch(controlId)
	{
		case BTN_EMETTRE:{
			char nomFichier[100];
			long selectedComs;

			// Demander au controle SAIS_FICHIER de renvoyer le texte saisi
			GetDlgItemText(HMainDialog,SAIS_FICHIER,
							(LPSTR)nomFichier,
							sizeof(nomFichier));

			// Faire la liste des ports  traiter
			selectedComs = 0L;
			for( int i=CHK_COM1; i<=CHK_COMLAST; i++ ){
				// interroger le checkBox correspondant
				if( IsDlgButtonChecked(HMainDialog,i) )
					// bit N = 1 si comN est choisi
					selectedComs |= 1 << (i-CHK_COM1+1);
			}
			// Envoyer le fichier sur les ports choisis
			SendFileOnManyPorts(nomFichier, selectedComs);
			break;
		}

		case BTN_EFFACER:{
			HWND hList = GetDlgItem(HMainDialog,LST_INFO);
			SendMessage(hList, LB_RESETCONTENT, 0L, 0L);
			break;
		}

		case BTN_COMPARAMS:{
			// Cycler dans la liste des vitesses
			PVitesse++;
			if( *PVitesse == 0 )
				PVitesse = Vitesses;

			// Afficher la vitesse dans le bouton (espace rduit)
			char buf[12];
			if(*PVitesse < 10000)
				sprintf(buf,"%ld bds",*PVitesse);
			else if(*PVitesse < 100000)
				sprintf(buf,"%ld b.",*PVitesse);
			else
				sprintf(buf,"%ld b",*PVitesse);
			SetDlgItemText(HMainDialog,BTN_COMPARAMS,buf);
			break;
		}

		default:
			return 1;	// message non trait
	}
	return 0;			// pour les messages traits
}

void
WinPrintf(char *format, long param1, long param2)
{
	char buf[100];

	sprintf(buf,format,param1,param2);
	int rc = SendDlgItemMessage(HMainDialog, LST_INFO,
							LB_ADDSTRING, NULL, (LPARAM)(LPSTR)buf);
	if (rc == LB_ERR || rc == LB_ERRSPACE){
		MessageBox(HMainDialog, message[MSG_LB_ERR], message[MSG_INTERNE],
				  MB_APPLMODAL | MB_ICONEXCLAMATION | MB_OK);
	}
}

char *
StringError()
{
	static char buf[10];
	DWORD err;

	switch(err = GetLastError()){
	case 2:
		return message[MSG_ERRSYS2]; // Fichier non trouv
	case 5:
		return message[MSG_ERRSYS5];	// Accs refus
	case 31:
		return message[MSG_ERRSYS31];	// General Failure
	default:
		sprintf(buf,"%ld",err);
		return buf;
	}
}

void
SendFileOnManyPorts(char *nomFichier, long selectedComs)
{
	PORT com[(CHK_COMLAST+1)-CHK_COM1+1];
	HANDLE hFile;

	hFile = CreateFile(	nomFichier,
								GENERIC_READ,
								FILE_SHARE_READ|FILE_SHARE_WRITE,
								NULL,
								OPEN_EXISTING,
								FILE_ATTRIBUTE_NORMAL|FILE_FLAG_SEQUENTIAL_SCAN,
								NULL);
	if( hFile == INVALID_HANDLE_VALUE ){
		WPrintf(message[MSG_FILE_OPEN],nomFichier,StringError());
		return;
	}
	InitSelectedComs32(&selectedComs,com);
	char enreg1[COMMON_BUF_SIZE];
	char enreg2[COMMON_BUF_SIZE];

	int len;
	WPrintf(message[MSG_DEB_EMIS],0,0);
	// On utilise deux tampons  cause des critures en mode OVERLAP
	while( (len=LireFichier(hFile,enreg1,sizeof(enreg1))) > 0 ){
		SendSelectedComs32(selectedComs,com,enreg1,len);
		if( (len=LireFichier(hFile,enreg2,sizeof(enreg2))) <= 0 )
			break;
		SendSelectedComs32(selectedComs,com,enreg2,len);
	}
	WPrintf(message[MSG_FIN_EMIS],0,0);

	CloseHandle(hFile);
	CloseSelectedComs32(selectedComs,com);
	WPrintf(message[MSG_FIN_CLS],0,0);
}

int LireFichier(HANDLE hFile,char *enreg,int len)
{
	BOOL rc;
	DWORD readLen;

	rc = ReadFile(hFile, enreg, len, &readLen, NULL);
	if( !rc ){
		WPrintf(message[MSG_FILE_READ], StringError(), 0);
		return -1;
	}
	return readLen;
}

//
// Initialise les ports choisis et inhibe les ports en erreur
//
void InitSelectedComs32(long *pSelectedComs,PORT *pComTab)
{
	int numCom;
	long selectedComs = *pSelectedComs;
	long clearBit = 1;		// bit glissant pour effacer les ports en erreur

	numCom = 0;
	while(selectedComs){
		if( selectedComs & 1 ){
			sprintf(pComTab->friendlyName,message[MSG_UCOM_FMT],numCom);
			sprintf(pComTab->systemName,message[MSG_SCOM_FMT],numCom);
			// Sous Windows 95 on peut ouvrir indiffremment COMx ou \\.\COMx
         // Sous Windows NT 3.1 on doit ouvrir \\.\COMx
			pComTab->hCom = CreateFile(pComTab->systemName,
									GENERIC_READ|GENERIC_WRITE,
									0,					// requis par  la doc Win32
									NULL,
									OPEN_EXISTING,	// requis par  la doc Win32
									FILE_ATTRIBUTE_NORMAL|FILE_FLAG_OVERLAPPED,
									NULL);			// requis par  la doc Win32
			if( pComTab->hCom == INVALID_HANDLE_VALUE ){
				WPrintf(message[MSG_COM_OPEN],
							pComTab->systemName,StringError());
				*pSelectedComs &= ~clearBit;
				goto nextPort;
			}
			// Initialiser les paramtres du port
			DCB dcb;
			COMMPROP commProp;

			if( !GetCommState(pComTab->hCom,&dcb) ){
				WPrintf(message[MSG_COM_GETS], pComTab->friendlyName, StringError());
				*pSelectedComs &= ~clearBit;
				goto nextPort;
			}
			dcb.BaudRate = *PVitesse;
			if( !SetCommState(pComTab->hCom,&dcb) ){
				WPrintf(message[MSG_COM_SETS], pComTab->friendlyName, StringError());
				*pSelectedComs &= ~clearBit;
				goto nextPort;
			}

			if( !SetupComm(pComTab->hCom,10,COMMON_BUF_SIZE) ){
				WPrintf(message[MSG_COM_SETB], pComTab->friendlyName, StringError());
				*pSelectedComs &= ~clearBit;
				goto nextPort;
			}

			// Initialiser l'criture parallle sur les ports
			pComTab->overlap.hEvent =
								CreateEvent(NULL,		/* security attributes */
												FALSE,	/* NOT manualReset */
												TRUE,		/* create signaled */
												NULL);	/* unnamed */
			if( !pComTab->overlap.hEvent){
				WPrintf(message[MSG_EVT_CREAT], pComTab->friendlyName, StringError());
				*pSelectedComs &= ~clearBit;
				goto nextPort;
			}
			pComTab->first = TRUE;
		}
nextPort:
		pComTab++;
		selectedComs >>= 1;
		clearBit <<= 1;
		numCom++;
	}
}

void CloseSelectedComs32(long selectedComs,PORT *pComTab)
{
	while(selectedComs){
		if( selectedComs & 1 ){
			AttenteFinEcriturePrecedente(pComTab);
			CloseHandle(pComTab->hCom);
			CloseHandle(pComTab->overlap.hEvent);
		}
		pComTab++;
		selectedComs >>= 1;
	}
}

void SendSelectedComs32(long selectedComs,PORT *pComTab,char *rec,int reclen)
{
	while(selectedComs){
		if( selectedComs & 1 ){
			DWORD writtenLen;
			BOOL rc;

			// ATTENTE DE FIN DE LA DERNIERE ECRITURE
			AttenteFinEcriturePrecedente(pComTab);
			// NOUVELLE ECRITURE
			pComTab->lastWriteLen = reclen;
			rc = WriteFile(pComTab->hCom,rec,reclen,&writtenLen,&pComTab->overlap);
			if( !rc && GetLastError() != ERROR_IO_PENDING ){
				WPrintf(message[MSG_COM_WRIT], pComTab->friendlyName, StringError());
			}
		}
		// PORT SUIVANT
		pComTab++;
		selectedComs >>= 1;
	}
}

void AttenteFinEcriturePrecedente(PORT *pPort)
{
	DWORD writtenLen;
	BOOL rc;

	if(pPort->first)
		pPort->first = FALSE;
	else{
		rc = GetOverlappedResult(
							pPort->hCom,
							&pPort->overlap,
							&writtenLen,
							TRUE);	// attente fin du write
		if( !rc ){
			WPrintf(message[MSG_ERR_OVER], pPort->friendlyName, StringError());
		}else if(writtenLen != pPort->lastWriteLen){
			WPrintf(message[MSG_COM_PART], pPort->friendlyName, 0);
		}
	}
}
