/*****************************************************************************/
/*fichier contenant la declaration des constantes permettant la manipulation */
/*de l'UART. Ce fichier ne contient que les constantes qui ne sont pas       */
/*de le fichier /linux/serial_reg.h											 */
/*****************************************************************************/
#define UART_SPR					7
#define UART_ICR					5

#define UART_XON1					4
#define UART_XON2					5
#define UART_XOFF1					6
#define UART_XOFF2					7
//offset des registres specifiques au mode 950 
#define UART_ASR					1
#define UART_RFL					3
#define UART_TFL					4
#define UART_ICR					5

//offset du registre ICR
#define UART_ICR_ACR				0
#define UART_ICR_CPR				1
#define UART_ICR_TCR				2
#define UART_ICR_CKS				3
#define UART_ICR_TTL				4
#define UART_ICR_RTL				5
#define UART_ICR_FCL				6
#define UART_ICR_FCH				7
#define UART_ICR_ID1				8
#define UART_ICR_ID2				9
#define UART_ICR_ID3				10
#define UART_ICR_REV				11
#define UART_ICR_CSR				12
#define UART_ICR_NMR				13
#define UART_ICR_MDM				14
#define UART_ICR_RFC				15
#define UART_ICR_GDS				16

// advanced status register
#define ASR_TX_DISABLED				0x01
#define ASR_RTX_DISABLED			0x02
#define ASR_RTS						0x04
#define ASR_DTR						0x08
#define ASR_SPECIAL_CHR				0x10
#define ASR_FIFOSEL					0x20
#define ASR_FIFO_SIZE				0x40
#define ASR_TX_IDLE					0x80

// advanced control register
#define ACR_DISABLE_RX				0x01
#define ACR_DISABLE_TX				0x02
#define ACR_DTR_FC					0x08
#define ACR_DSR_FC					0x04
#define ACR_DTRDFN_MSK				0x18
#define ACR_DTR_RS485_EN			0x10
#define ACR_DTR_RS485_SENSE			0x08
#define ACR_950TRIG_LEV_EN			0x20
#define ACR_ICR_READ_EN				0x40
#define ACR_ASR_EN					0x80

//line control register
#define LCR_ACCESS_650				0xBF

//enhance feature register
#define EFR_USE_XON1XOFF1			0x0A
#define EFR_USE_XON2XOFF2			0x05
