/*
 * Entrees:sorties directes sur le pilote ACKSRLNT par IOCTL
 */
#ifndef ACKSRLNT_H
#define ACKSRLNT_H

typedef unsigned char unchar;

/* Extended serial IOCTL codes for Windows NT */
#if defined(CTL_CODE) && defined(FILE_DEVICE_SERIAL_PORT)
#define ACKNT_IOCTL(code)			CTL_CODE(FILE_DEVICE_SERIAL_PORT,code,\
										METHOD_BUFFERED,FILE_ANY_ACCESS)
#define IOCTL_SERIAL_ACK_OPTIONS	ACKNT_IOCTL(0x90B)	// same as MCC-MCX
#endif	/* Windows NT */

/*
 * The following defines stuff for the IOCTL code IOCTL_SERIAL_ACK_OPTIONS.
 * Please stay in sync with mcc_mcx.h if you change this.
 */
typedef struct _ACK_OPTION {		/* pour IOCTL_SERIAL_SET_OPTIONS */
    long Option;					/* type d'option i: 16 bits de code, */
									/* 8 bits input len 8 bits output len */
    union{
		long Long[1];
		short Short[1];
		unchar Char[1];				/* char value or TRUE/FALSE */
    }Value;							/* valeur de l'option */
} ACK_OPTION, *PACK_OPTION;
#define ACK_OPTION_SIZE(dlen)		((dlen)+sizeof(ACK_OPTION)-sizeof(long))

/*** Constants for Option field ***/
#define ACK_OPTION_SET_DUALPORT_XMIT	0x60100 /* set/clear dualport tx	*/
#define ACK_OPTION_GET_DUALPORT_XMIT	0x60001 /* get dualport tx flag		*/
/* non implemente */
#define ACK_OPTION_SET_HARD_RTS_TOGGLE	0x70100 /* set/clear RS485 toggle	*/
#define ACK_OPTION_GET_HARD_RTS_TOGGLE	0x70001 /* get hard toggle flag		*/

#define ACK_OPTION_SET_LOOPBACK			0x80100 /* set/clear internal loopb	*/
#define ACK_OPTION_GET_LOOPBACK			0x80001 /* get internal loopback flg*/

/*** Constants for Values field ***/
/* none for now */

/*** Constants for Registry ***/
/* used only by driver and setup */
#ifdef ACK_UNXPCI_REGISTRY
#define UNXPCI_OPTION_DUALPORT_XMIT	01	// -- UNXPCI Mod AP --
#define UNXPCI_OPTION_HARD_TOGGLE	02	// -- UNXPCI Mod AP --
#define UNXPCI_OPTION_LOOPBACK		04	// -- UNXPCI Mod AU --
#endif

#endif /* ACKSRLNT_H */
