/* misc defines which should be included in linux standard headers */

#define _ACKSYS_8250_PATCH_

/* in asm-i386/ioctls.h */
#ifndef TIOCSERSETRS485
#define TIOCSERSETRS485 0x5461  /* enable rs-485 */
#define TIOCSERWRRS485  0x5462  /* write rs-485 */
#endif

/* in linux/serial_core.h */
#ifndef UPF_950_ACR_SENSE
#define UPF_950_ACR_SENSE	(1 << 8)
#endif

/* in linux/serial_reg.h */
#ifndef UART_ACR_SENSE
#define UART_ACR_SENSE	0x08	/* DTR toggling polarity (1=>active high) */
#define UART_ACR_485_EN	0x10	/* DTR toggling with emission */
#endif

/* cohabitation module linux/module acksys */
#define serial8250_register_port acksys8250_register_port
#define serial8250_unregister_port acksys8250_unregister_port
#define serial8250_suspend_port acksys8250_suspend_port
#define serial8250_resume_port acksys8250_resume_port
#define register_serial register_acksys
#define unregister_serial unregister_acksys
#define serial8250_pci_init acksys8250_pci_init
#define serial8250_pci_exit acksys8250_pci_exit
extern int __init serial8250_pci_init(void);
extern void __exit serial8250_pci_exit(void);
