#!/bin/sh
#
# test_version.sh
#
# Check the version of the Linux driver
#
# Copyright 1999, 2000 by Theodore Ts'o
#
# Version 1.01, last modified on March 19, 2000
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License as
# published by the Free Software Foundation; either version 2 of the
# License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

if test "$LINUX_SRC"x = x 
then
	LINUX_SRC=/usr/src/linux
fi
if test "$NAME"x = x
then
	NAME=device
fi

#
# Determine whether SMP is enabled in both the includes file and in
# the currently running Kernel
#
# If the .config file exists, then the user has compiled a kernel, even 
# if they're using a RedHat configuration.  So believe the .config file or 
# the Makefile authoratiatively.  
#
ISMP=''; KSMP=''; 
if test -r $LINUX_SRC/.config ; then
    if grep -q CONFIG_SMP=y $LINUX_SRC/.config ||
       grep -q "^SMP[:space:]*=[:space:]1" $LINUX_SRC/Makefile
    then
	ISMP='-SMP';
    fi
elif grep -q smp_ $LINUX_SRC/include/linux/modules/ksyms.ver ; then 
	ISMP='-SMP';
elif test -f /boot/kernel.h && 
     grep -q "BOOT_KERNEL_SMP 1" /boot/kernel.h ; then
	ISMP='-SMP';
fi 
if grep -q smp_ /proc/ksyms
then 
	KSMP='-SMP'
fi 

#
# Determine whether MODVERSIONS is enabled in both the includes file 
# and in the currently running Kernel
#
IMOD=''; KMOD='';
if /lib/cpp <<EOF | grep -q "THE REDHAT KERNEL BUILD SYSTEM IS A PITA"
#include "$LINUX_SRC/include/linux/autoconf.h"
#ifdef CONFIG_MODVERSIONS
THE REDHAT KERNEL BUILD SYSTEM IS A PITA
#endif
EOF
then 
	IMOD='-MOD'; 
fi 
if grep -q "kfree" /proc/ksyms &&  ! grep -q "kfree$" /proc/ksyms ; then 
	KMOD='-MOD'
fi

#
# Set the .smpflag and .modflag files
#

cp /dev/null .smpflag; 
if test -n "$ISMP" ; then
	echo "-D__SMP__" > .smpflag 
fi
cp /dev/null .modflag;
if test -n "$IMOD" ; then
	echo "-DMODVERSIONS" > .modflag
fi

#
# Determine the kernel version for both the includes file and in the
# currently running kernel
#
IVER=`echo UTS_RELEASE | cat $LINUX_SRC/include/linux/version.h - | \
	/lib/cpp | tail -1 | tr -d \"\ `$IMOD$ISMP
KVER=`uname -r`$KMOD$KSMP

if [ -f .kver ]; then 
    OVER=`cat .kver`; 
    if [ $OVER != $IVER ]; then 
	echo "Removing previously built driver for Linux $OVER"; 
	make clean > /dev/null
	echo " "
    fi 
else 
	make clean > /dev/null
fi

#
# Check whether any of the built modules has unresolved symbols; if so force
# a make clean regardless of kernel version numbers
#
if which depmod >& /dev/null ; then
    for i in $CHK_OBJS
    do
    	if test -f $i && depmod $i | grep -q "unresolved symbol"; then
		echo "Previously built $i has unresolved symbols; forcing rebuild"
		make clean >& /dev/null
	        echo " "
        fi
    done
fi

echo $IVER > .kver
echo Building $NAME driver for Linux $IVER
echo " " ; 
if [ $IVER != $KVER ]; then 
    echo "WARNING: The current kernel is actually version $KVER." 
    echo " " 
fi
