/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.custom;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = 7814834515086803444L;
    private static final String JRE_INFO = "<html>Version:&nbsp;&nbsp;Java (TM) Platform V" + System.getProperties().getProperty("java.version") + "</html>";

    public AboutDialog(Frame owner) {
        this.setModal(true);
        IgUtils.SetIconImage(this);
        this.setTitle(String.valueOf(TranslateEnum.MENU_ABOUT.get()) + " " + "ACKSYS Networking Devices Manager");
        JLabel version = new JLabel("ACKSYS Networking Devices Manager V2.20.2");
        JLabel copyright = new JLabel(String.format("Copyright \u00a9 %s by ACKSYS", "2008-2017"));
        JLabel logoLabel = new JLabel(ImageManager.ABOUT.getImageIcon());
        JPanel address = new JPanel();
        address.setBorder(new TitledBorder(TranslateEnum.ADDRESS.get()));
        address.add(new JLabel("<html>ACKSYS Communication & Systems<br><br>ZA Val Joyeux<br>10 rue des entrepreneurs<br>F-78450 Villepreux - France</html>"));
        JPanel phone = new JPanel();
        phone.setBorder(new TitledBorder(TranslateEnum.PHONE_NUMBERS.get()));
        phone.add(new JLabel("<html>Sales             : +33 (0)1 30 56 46 46<br>Technical Support : +33 (0)1 30 56 46 46<br>Fax number        : +33 (0)1 30 56 12 95</html>"));
        JPanel weblink = new JPanel();
        weblink.setBorder(new TitledBorder(TranslateEnum.WEB_LINK.get()));
        weblink.add(new JLabel("<html>Sales             : sales@acksys.fr<br>Technical Support : support@acksys.fr<br>Web site          : www.acksys.fr</html>"));
        JPanel javainfo = new JPanel();
        javainfo.setBorder(new TitledBorder(TranslateEnum.ENVIRONNEMENT.get()));
        javainfo.add(new JLabel(JRE_INFO));
        this.add(logoLabel);
        this.add(version);
        this.add(copyright);
        this.add(address);
        this.add(phone);
        this.add(weblink);
        this.add(javainfo);
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("North", (Component)logoLabel, 5, "North", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)logoLabel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)logoLabel, -5, "East", (Component)this.getContentPane());
        this.positionneComposantCentreH(layout, version, logoLabel, 10, copyright, 5);
        this.positionneComposantCentreH(layout, copyright, version, 0, address, 5);
        layout.putConstraint("West", (Component)address, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)address, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)phone, 5, "South", (Component)address);
        layout.putConstraint("West", (Component)phone, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)phone, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)weblink, 5, "South", (Component)phone);
        layout.putConstraint("West", (Component)weblink, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)weblink, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)javainfo, 5, "South", (Component)weblink);
        layout.putConstraint("West", (Component)javainfo, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)javainfo, -5, "East", (Component)this.getContentPane());
        address.setOpaque(false);
        phone.setOpaque(false);
        weblink.setOpaque(false);
        javainfo.setOpaque(false);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        if (Main.os_name.equals("Linux")) {
            this.setSize(350, 300);
            this.setMinimumSize(new Dimension(330, 300));
        } else {
            this.setSize(350, 490);
            this.setMinimumSize(new Dimension(330, 490));
        }
        this.setMinimumSize(new Dimension(330, 480));
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    private void positionneComposantCentreH(SpringLayout layout, Component composantACadrer, Component composantDuDessus, int combienDessus, Component composantDuDessous, int combienDessous) {
        layout.putConstraint("North", composantACadrer, combienDessus, "South", composantDuDessus);
        layout.putConstraint("HorizontalCenter", composantACadrer, 0, "HorizontalCenter", (Component)this.getContentPane());
        layout.putConstraint("North", composantDuDessous, combienDessous, "South", composantACadrer);
    }

    public static void main(String[] args) {
        ImageManager.initMapImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new AboutDialog(null).setVisible(true);
            }
        });
    }
}

