/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.snmp.SnmpManager;
import fr.acksys.translation.AvailableLanguages;
import fr.acksys.translation.LocaleState;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.udap.UdapSocket;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class Main {
    public static final int VERSION_MAJOR = 2;
    public static final int VERSION_MINOR = 20;
    public static final int VERSION_DEBUG = 2;
    public static final String DATE_COPYRIGHT = "2008-2017";
    public static String language = "en";
    public static String os_name = System.getProperties().getProperty("os.name");
    private static FileLock lock;
    private static FileChannel channel;
    public static List<String> gatewayList;
    public static SnmpManager snmpmanager;

    static {
        gatewayList = new ArrayList<String>();
    }

    public static void main(String[] args) {
        if (!Main.lock()) {
            return;
        }
        System.setProperty("file.encoding", "UTF-8");
        ImageManager.initMapImage();
        UserParameters userParam = UserParameters.getInstance();
        if (userParam.getParam("LANGUAGE_VALUE").equals("00")) {
            language = System.getProperties().getProperty("user.language");
            if (language.equals("fr")) {
                LocaleState.getInstance().setLocale(AvailableLanguages.FR.getLocale());
            } else {
                LocaleState.getInstance().setLocale(AvailableLanguages.EN.getLocale());
            }
        } else if (userParam.getParam("LANGUAGE_VALUE").equals("FR")) {
            language = "fr";
            LocaleState.getInstance().setLocale(AvailableLanguages.FR.getLocale());
        } else {
            language = "en";
            LocaleState.getInstance().setLocale(AvailableLanguages.EN.getLocale());
        }
        if (!UdapSocket.checkFirewall()) {
            JOptionPane.showMessageDialog(null, TranslateEnum.FIREWALL.get(), TranslateEnum.ERROR.get(), 2);
            return;
        }
        NdmDb sgbd = NdmDb.getInstance();
        if (sgbd == null) {
            return;
        }
        String errStr = sgbd.createSchema();
        if (errStr != null) {
            JOptionPane.showMessageDialog(null, errStr, TranslateEnum.DB_SCHEMA_ERROR.get(), 2);
            return;
        }
        String[] version = System.getProperty("java.version").split("\\.");
        try {
            int majorJvm = Integer.parseInt(version[0]);
            int minorJvm = Integer.parseInt(version[1]);
            if (majorJvm * 1000 + minorJvm < 1006) {
                JOptionPane.showMessageDialog(null, TranslateEnum.WRONG_VERSION.get(), TranslateEnum.ERROR.get(), 2);
                return;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        snmpmanager = new SnmpManager();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame mainFrame = new MainFrame();
                mainFrame.setVisible(true);
            }
        });
    }

    private static boolean lock() {
        File file = new File(System.getProperty("user.home"), ".AcksysNDMLock");
        file.deleteOnExit();
        try {
            channel = new RandomAccessFile(file, "rw").getChannel();
            lock = channel.tryLock();
            if (lock == null) {
                JOptionPane.showMessageDialog(null, TranslateEnum.SINGLE_INSTANCE.get(), TranslateEnum.ERROR.get(), 0);
                return false;
            }
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void unlock() {
        try {
            channel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int exec(String cmd, String[] args) {
        int cr = 1;
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                cmd = String.valueOf(cmd) + " " + arg;
                ++n2;
            }
        }
        System.out.println("Do " + cmd);
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            cr = p.waitFor();
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("Done:" + cr);
        return cr;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }
}

