/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.Parameter;
import fr.acksys.translation.TranslateEnum;

public class MibParser {
    public static final int MIB_WLAN_STATE_CONNECTED = 9;
    public static final int MIB_WLG_BRIDGE_CONNECTED_YES = 1;
    public static final int MIB_WLG_BRIDGE_CONNECTED_NO = 2;

    public static String getValue(Parameter param, int index) {
        int value = (Integer)param.getOneValue(index);
        if (value == Parameter.MULTIPLE) {
            return TranslateEnum.COLVAL_MULTIPLE.get();
        }
        if (value == Parameter.UNAVAILABLE) {
            return TranslateEnum.UNAVAILABLE.get();
        }
        switch (param.getId()) {
            case WIFI_SECURITY: 
            case WLAN_TABLE_SECURITY: {
                switch (value) {
                    case 1: {
                        return TranslateEnum.NONE.get();
                    }
                    case 2: {
                        return TranslateEnum.WEP.get();
                    }
                    case 3: {
                        return TranslateEnum.WPAPSK.get();
                    }
                    case 4: {
                        return TranslateEnum.WPA.get();
                    }
                }
                return TranslateEnum.UNAVAILABLE.get();
            }
            case WPA_VERSION: 
            case WLAN_TABLE_WPA: {
                switch (value) {
                    case 1: {
                        return TranslateEnum.WPA1.get();
                    }
                    case 2: {
                        return TranslateEnum.WPA2.get();
                    }
                }
                return TranslateEnum.UNAVAILABLE.get();
            }
            case WIFI_802: 
            case WLAN_TABLE_BAND: {
                switch (value) {
                    case 1: {
                        return TranslateEnum.COLVAL_MODULATION_B_ONLY.get();
                    }
                    case 2: {
                        return TranslateEnum.COLVAL_MODULATION_G_ONLY.get();
                    }
                    case 3: {
                        return TranslateEnum.COLVAL_MODULATION_BG.get();
                    }
                    case 4: {
                        return TranslateEnum.COLVAL_MODULATION_A_ONLY.get();
                    }
                    case 5: {
                        return TranslateEnum.COLVAL_MODULATION_900_DSS.get();
                    }
                    case 6: {
                        return TranslateEnum.COLVAL_MODULATION_900_OFDM.get();
                    }
                    case 7: {
                        return TranslateEnum.COLVAL_MODULATION_900_DSS_OFDM.get();
                    }
                    case 10: {
                        return TranslateEnum.COLVAL_MODULATION_NG.get();
                    }
                    case 11: {
                        return TranslateEnum.COLVAL_MODULATION_NBG.get();
                    }
                    case 12: {
                        return TranslateEnum.COLVAL_MODULATION_NA.get();
                    }
                    case 16: {
                        return TranslateEnum.COLVAL_MODULATION_AC.get();
                    }
                }
                return TranslateEnum.UNAVAILABLE.get();
            }
            case WLAN_TABLE_ROLE: {
                switch (value) {
                    case 1: {
                        return TranslateEnum.COLVAL_WROLE_CLIENT.get();
                    }
                    case 2: {
                        return TranslateEnum.COLVAL_WROLE_AP.get();
                    }
                    case 3: {
                        return TranslateEnum.COLVAL_WROLE_ADHOC.get();
                    }
                    case 4: {
                        return TranslateEnum.COLVAL_WROLE_VLAN_AP.get();
                    }
                    case 5: {
                        return TranslateEnum.COLVAL_WROLE_WDS.get();
                    }
                    case 6: {
                        return TranslateEnum.COLVAL_WROLE_MESH.get();
                    }
                    case 7: {
                        return TranslateEnum.COLVAL_WROLE_REPEATER.get();
                    }
                }
                return TranslateEnum.UNAVAILABLE.get();
            }
        }
        return TranslateEnum.UNAVAILABLE.get();
    }

    public static int getIntValue(Parameter param, int index) {
        int value = (Integer)param.getOneValue(index);
        if (value < 0) {
            return value;
        }
        switch (param.getId()) {
            case WIFI_SECURITY: 
            case WLAN_TABLE_SECURITY: {
                switch (value) {
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 3;
                    }
                }
                return 4;
            }
            case WPA_VERSION: 
            case WLAN_TABLE_WPA: {
                return value;
            }
            case WLAN_TABLE_ROLE: {
                switch (value) {
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 3;
                    }
                    case 4: {
                        return 4;
                    }
                    case 5: {
                        return 5;
                    }
                    case 6: {
                        return 6;
                    }
                    case 7: {
                        return 7;
                    }
                }
                return 0;
            }
            case WLAN_TABLE_STATE: {
                return value;
            }
        }
        return Parameter.UNKNOWN;
    }

    public static String getEnable12String(Parameter param, int index) {
        int value;
        switch (param.rowCount()) {
            case -1: {
                value = (Integer)param.getValue();
                break;
            }
            case 0: {
                value = -1;
                break;
            }
            case 1: {
                if (index > 0) {
                    value = -1;
                }
                value = (Integer)param.getValue(0);
                break;
            }
            default: {
                if (index < 0) {
                    return TranslateEnum.COLVAL_MULTIPLE.get();
                }
                value = (Integer)param.getValue(index);
            }
        }
        switch (value) {
            case 1: {
                return TranslateEnum.COLVAL_DISABLE.get();
            }
            case 2: {
                return TranslateEnum.COLVAL_ENABLE.get();
            }
        }
        return TranslateEnum.UNAVAILABLE.get();
    }
}

