/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.Sgbd;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class NdmDb
extends Sgbd {
    private static final int versionSchema = 3;
    private static final boolean debugDbCreation = false;
    private static NdmDb singleton = null;
    private static boolean inited = false;
    private static boolean connected = false;
    public Statement st;

    private NdmDb() {
    }

    public static NdmDb getInstance() {
        if (singleton == null) {
            singleton = new NdmDb();
        }
        if (!inited) {
            if (!singleton.init()) {
                JOptionPane.showMessageDialog(null, TranslateEnum.NO_JDBC.get(), TranslateEnum.ERROR.get(), 2);
                return null;
            }
            inited = true;
        }
        if (!connected) {
            String errStr = singleton.connect("ndm");
            if (errStr != null) {
                JOptionPane.showMessageDialog(null, errStr, TranslateEnum.DB_CONNECT_ERROR.get(), 2);
                return null;
            }
            NdmDb.singleton.st = NdmDb.singleton.stmt;
            connected = true;
        }
        return singleton;
    }

    public PreparedStatement prepare(String s) {
        try {
            return this.conn.prepareStatement(s);
        }
        catch (SQLException e) {
            return null;
        }
    }

    public void begin() {
        try {
            this.conn.setAutoCommit(false);
            this.st.execute("begin transaction;");
        }
        catch (SQLException e) {
            return;
        }
    }

    public void commit() {
        try {
            this.st.execute("commit;");
            this.conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            return;
        }
    }

    public void rollback() {
        try {
            this.st.execute("rollback;");
            this.conn.setAutoCommit(true);
        }
        catch (SQLException e) {
            return;
        }
    }

    public synchronized boolean executeSynchronizedSqlChange(String s) {
        try {
            this.st.execute(s);
            return true;
        }
        catch (SQLException e) {
            return false;
        }
    }

    private void createProfilesElements() throws SQLException {
        this.st.execute("create table if not exists profiles (pf_code integer primary key, pf_name text unique, pf_reset integer);");
        this.st.execute("insert into profiles (pf_code,pf_name,pf_reset) values (null,'<new>',1);");
        this.st.execute("create table if not exists pf_crits (pfc_profile integer references profiles(pf_code),pfc_group integer,pfc_oid integer references oids(oid_code),pfc_comp integer,pfc_val text,primary key(pfc_profile,pfc_oid,pfc_comp));");
        this.st.execute("create table if not exists pf_vals (pfv_profile integer references profiles(pf_code),pfv_index integer,pfv_oid integer references oids(oid_code),pfv_val text,primary key(pfv_profile,pfv_index,pfv_oid));");
    }

    public synchronized String createSchema() {
        NdmDb db = NdmDb.getInstance();
        if (db == null) {
            return "cannot connect to database";
        }
        try {
            int versionDb = 0;
            if (this.st.executeQuery("select name from sqlite_master where name='ndmconfig';").next()) {
                ResultSet query = this.st.executeQuery(String.format("select cfg_value from ndmconfig where cfg_code=%d;", CfgType.SCHEMA_VERSION.ordinal()));
                if (query.next()) {
                    versionDb = Integer.parseInt(query.getString(1));
                }
                query.close();
            }
            if (versionDb <= 0) {
                this.st.execute("create table if not exists oids (oid_code integer primary key, oid_str text unique);");
                this.createProfilesElements();
                this.st.execute("create table if not exists products (p_mac text primary key,p_code integer,p_sysdescr text,p_ip text,p_type text,p_snmp_r text,p_snmp_w text,p_password text);");
                db.begin();
                db.st.execute("delete from oids;");
                final PreparedStatement prep = db.prepare("insert into oids (oid_code,oid_str) values (null,?);");
                Oid.iterateKnownOids(new NdmCallback(){

                    @Override
                    public void callback(Object ob) {
                        Oid oid = (Oid)((Object)ob);
                        try {
                            prep.setString(1, oid.getOid());
                            prep.addBatch();
                        }
                        catch (SQLException e) {
                            e.printStackTrace();
                        }
                    }
                });
                prep.executeBatch();
                db.commit();
                this.st.execute("create table if not exists ndmconfig (cfg_code integer,cfg_value text);");
                this.st.execute(String.format("insert into ndmconfig (cfg_code,cfg_value) values (%d,'%d');", CfgType.SCHEMA_VERSION.ordinal(), 3));
            } else {
                if (versionDb <= 1) {
                    final ArrayList<String> existingOidsList = NdmDb.getStringsList("select oid_str from oids;");
                    db.begin();
                    final PreparedStatement prep = db.prepare("insert into oids (oid_code,oid_str) values (null,?);");
                    Oid.iterateKnownOids(new NdmCallback(){

                        @Override
                        public void callback(Object ob) {
                            Oid oid = (Oid)((Object)ob);
                            try {
                                if (!existingOidsList.contains(oid.getOid())) {
                                    prep.setString(1, oid.getOid());
                                    prep.addBatch();
                                }
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    prep.executeBatch();
                    db.commit();
                }
                if (versionDb <= 2) {
                    this.st.execute("drop table if exists pf_crits;");
                    this.st.execute("drop table if exists pf_vals;");
                    this.st.execute("drop table if exists profiles;");
                    this.createProfilesElements();
                }
                this.st.execute(String.format("update ndmconfig set cfg_value='%d' where cfg_code=%d", 3, CfgType.SCHEMA_VERSION.ordinal()));
            }
        }
        catch (SQLException e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> getStringsList(String selectStr) {
        NdmDb db;
        ArrayList<String> list = new ArrayList<String>();
        NdmDb ndmDb = db = NdmDb.getInstance();
        synchronized (ndmDb) {
            try {
                ResultSet query = db.st.executeQuery(selectStr);
                while (query.next()) {
                    String s = query.getString(1);
                    list.add(s);
                }
                query.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    public static List<String> getProfilesList() {
        return NdmDb.getStringsList("select pf_name from profiles;");
    }

    public static List<String> getProductsMacList(String p_type) {
        return NdmDb.getStringsList("select p_mac from products where p_type='" + p_type + "';");
    }

    public static void Fatal(TranslateEnum msg) {
        JOptionPane.showConfirmDialog(null, msg.get(), TranslateEnum.DB_FATAL.get(), 0, 0);
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Vacuum() {
        NdmDb db;
        NdmDb ndmDb = db = NdmDb.getInstance();
        synchronized (ndmDb) {
            try {
                db.st.execute("vacuum;");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private static enum CfgType {
        SCHEMA_VERSION;

    }
}

