/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.snmp.Oid;
import java.util.List;

public class Parameter {
    public static final Integer UNAVAILABLE = -1;
    public static final Integer MULTIPLE = -2;
    public static final Integer UNKNOWN = -3;
    private static int serialorg = 0;
    private int serial = ++serialorg;
    private Oid id;
    private Object value = null;
    private boolean isSequence = false;
    private int columnSize = 0;
    private int columnCount = -1;
    private boolean changed = false;
    private Object newValue = null;

    public Parameter(Oid id) {
        switch (id.getType()) {
            case INTEGER: 
            case GAUGE32: {
                this.value = new Integer(0);
                break;
            }
            case TIMETICKS: {
                this.value = new Long(0L);
                break;
            }
            case SEQUENCE: {
                this.isSequence = true;
                List<Oid> l = id.getSequence();
                this.columnCount = l.size();
                this.value = new Parameter[this.columnCount];
                int i = 0;
                for (Oid oid : l) {
                    Parameter param = new Parameter(oid);
                    param.setArrayValue(new Object[0]);
                    ((Object[])this.value)[i++] = param;
                }
                break;
            }
            default: {
                this.value = "";
            }
        }
        this.id = id;
    }

    public Parameter(Oid id, String value) {
        switch (id.getType()) {
            case INTEGER: 
            case GAUGE32: {
                this.value = new Integer(value);
                break;
            }
            case TIMETICKS: {
                this.value = new Long(value);
                break;
            }
            default: {
                this.value = value;
            }
        }
        this.id = id;
    }

    public Parameter(Oid id, int value) {
        switch (id.getType()) {
            case INTEGER: 
            case GAUGE32: {
                this.value = new Integer(value);
                break;
            }
            case TIMETICKS: {
                this.value = new Long(value);
                break;
            }
            default: {
                this.value = Integer.toString(value);
            }
        }
        this.id = id;
    }

    public void print(String where) {
        if (this.columnCount == -1) {
            System.out.println(String.valueOf(where) + ": SCALAR oid(" + (Object)((Object)this.id) + ") value=" + this.value);
        } else if (this.columnCount == 0) {
            System.out.println(String.valueOf(where) + ": ARRAY oid(" + (Object)((Object)this.id) + ") EMPTY");
        } else {
            System.out.println(String.valueOf(where) + ": ARRAY oid(" + (Object)((Object)this.id) + ") size=" + this.columnCount + " value0=" + this.getValue(0));
        }
        Thread.yield();
    }

    public Oid getId() {
        return this.id;
    }

    public void setId(Oid id) {
        this.id = id;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getValue(int index) {
        return ((Object[])this.value)[index];
    }

    public Parameter getParameterValue(int index) {
        return ((Parameter[])this.value)[index];
    }

    public Object getOneValue(int index) {
        switch (this.rowCount()) {
            case -1: {
                return this.getValue();
            }
            case 0: {
                return UNAVAILABLE;
            }
            case 1: {
                if (index > 0) {
                    return UNAVAILABLE;
                }
                return this.getValue(0);
            }
        }
        if (index < 0) {
            return MULTIPLE;
        }
        return this.getValue(index);
    }

    public void setValue(Object value) {
        this.columnCount = -1;
        this.value = value;
    }

    public void setArrayValue(Object[] array) {
        this.columnCount = 0;
        this.value = array;
    }

    public void setValue(int index, String item) {
        if (this.columnCount <= index) {
            this.columnCount = index + 1;
        }
        switch (this.id.getType()) {
            case INTEGER: 
            case GAUGE32: {
                ((Object[])this.value)[index] = new Integer(item);
                break;
            }
            case TIMETICKS: {
                ((Object[])this.value)[index] = new Long(item);
                break;
            }
            default: {
                ((Object[])this.value)[index] = item;
            }
        }
    }

    public void setValue(int index, Parameter item) {
        if (this.columnCount <= index) {
            this.columnCount = index + 1;
        }
        if (this.isSequence && item != null) {
            this.columnSize = item.rowCount();
        }
        ((Object[])this.value)[index] = item;
    }

    public boolean testAndSetValue(int index, Object item) {
        Object[] table = (Object[])this.value;
        if (this.columnCount < index) {
            this.columnCount = index + 1;
        }
        try {
            if (!Parameter.areValuesEqual(table[index], item, this.id.getType())) {
                table[index] = item;
                if (this.isSequence && item != null) {
                    this.columnSize = ((Object[])item).length;
                }
                return true;
            }
        }
        catch (ClassCastException e) {
            System.out.println((Object)((Object)this.id.getType()) + " change(" + this + ")[" + index + "](" + table[index].getClass().getSimpleName() + ")=" + item + "(" + item.getClass().getSimpleName() + ")");
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getId().toString()) + " " + this.serial + " " + this.hashCode();
    }

    public static void dumpSerial(String s) {
        System.out.println(String.valueOf(s) + ": param last serial=" + serialorg);
    }

    public int columnCount() {
        return this.columnCount;
    }

    public int rowCount() {
        return this.isSequence ? this.columnSize : this.columnCount;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void setChanged(boolean changed) {
        this.changed = changed;
    }

    public Object getNewValue() {
        return this.newValue;
    }

    public void setNewValue(Object newValue) {
        this.newValue = newValue;
        this.setChanged(true);
    }

    public void applyNewValue() {
        this.setValue(this.getNewValue());
        this.setNewValue(null);
        this.setChanged(false);
    }

    private static boolean areValuesEqual(Object one, Object two, Oid.Type type) {
        if (one == null) {
            return two == null;
        }
        if (two == null) {
            return false;
        }
        switch (type) {
            default: {
                return one.equals(two);
            }
            case INTEGER: 
            case GAUGE32: 
        }
        return ((Integer)one).intValue() == ((Integer)two).intValue();
    }

    public boolean equals(Parameter given) {
        if (this.value == given.value) {
            return true;
        }
        if (this.getId().getType() != given.getId().getType()) {
            return this.value.toString().equals(given.getValue().toString());
        }
        return this.value.equals(given.getValue());
    }
}

