/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.discover.DiscoverManager;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import sun.awt.Mutex;

public class ProductManager {
    public static final int MAX_TTL = 4;
    private static ProductManager productManager = null;
    private static List<Product> productList = new ArrayList<Product>();
    public List<Product> hiddenproductList = new ArrayList<Product>();
    private static Mutex productListLock = new Mutex();
    private static DiscoverManager discover;
    private static List<RefreshableInterface> generalDisplayList;
    public static List<RefreshableInterface> dynamicStatusList;
    public static boolean showDead;
    private JEditorPane productDetailsPane;
    private Product detailedProduct;

    static {
        generalDisplayList = new ArrayList<RefreshableInterface>();
        dynamicStatusList = new ArrayList<RefreshableInterface>();
    }

    private ProductManager() {
    }

    public static ProductManager getInstance() {
        if (productManager == null) {
            productManager = new ProductManager();
            discover = DiscoverManager.getInstance();
        }
        return productManager;
    }

    public String pollAndDiscoverProducts() {
        this.decrementTTL();
        String msg_poll = discover.poll();
        for (Product product : productList) {
            if (product.getTTL() != 2) continue;
            product.unicastRetry();
        }
        return msg_poll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rediscoverProductListInGUIThread() {
        for (Product prod : productList) {
            if (prod.isHiddenByUser() && !this.hiddenproductList.contains(prod)) {
                this.hiddenproductList.add(prod);
            }
            prod.cleanup();
        }
        productList.clear();
        List<RefreshableInterface> list = generalDisplayList;
        synchronized (list) {
            for (RefreshableInterface refreshItem : generalDisplayList) {
                refreshItem.refreshClearList();
            }
        }
        discover.discover();
    }

    public boolean containsProduct(Product product) {
        return productList.contains(product);
    }

    public void addProduct(final Product product) {
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                productListLock.lock();
                if (productList.contains(product)) {
                    productListLock.unlock();
                    return;
                }
                productList.add(product);
                productListLock.unlock();
                product.initDisplayableFlag();
                List list = generalDisplayList;
                synchronized (list) {
                    for (RefreshableInterface refreshItem : generalDisplayList) {
                        product.registerRefreshIg(refreshItem);
                    }
                }
            }
        });
    }

    public void removeProduct(final Product product) {
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                productListLock.lock();
                productList.remove(product);
                productListLock.unlock();
                product.cleanup();
            }
        });
    }

    public int sizeProduct() {
        return productList.size();
    }

    public Product getProductByMacInGUIThread(String mac) {
        for (Product prod : productList) {
            if (prod.getUniqueIdString().equalsIgnoreCase(mac)) {
                return prod;
            }
            if (!prod.canMultifunction || !prod.getProductByRadioMac(mac)) continue;
            return prod;
        }
        return null;
    }

    public Product getProductByMacInOtherThreads(String mac) {
        productListLock.lock();
        Product prod = this.getProductByMacInGUIThread(mac);
        productListLock.unlock();
        return prod;
    }

    public void unsetUserHidden() {
        for (Product prod : productList) {
            prod.setUserHideState(false);
        }
        this.hiddenproductList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRefreshIg(RefreshableInterface refreshItem) {
        List<RefreshableInterface> list = generalDisplayList;
        synchronized (list) {
            if (!generalDisplayList.contains(refreshItem)) {
                for (Product p : productList) {
                    p.registerRefreshIg(refreshItem);
                }
                generalDisplayList.add(refreshItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unRegisterRefreshIg(RefreshableInterface refreshItem) {
        List<RefreshableInterface> list = generalDisplayList;
        synchronized (list) {
            for (Product p : productList) {
                p.unRegisterRefreshIg(refreshItem);
            }
            generalDisplayList.remove(refreshItem);
        }
    }

    public void registerStatusIg(final RefreshableInterface refreshItem) {
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (!dynamicStatusList.contains(refreshItem)) {
                    dynamicStatusList.add(refreshItem);
                }
            }
        });
    }

    private void decrementTTL() {
        for (Product product : productList) {
            product.decrementTTL();
        }
    }

    public boolean hasConflictingIp(Product product) {
        String ip = (String)product.getParam(Oid.IP_ADDRESS).getValue();
        for (Product prod : productList) {
            String productIp = (String)prod.getParam(Oid.IP_ADDRESS).getValue();
            if (prod.getTTL() <= 0 || !productIp.equals(ip) || product.equals(prod)) continue;
            return true;
        }
        return false;
    }

    public static void checkIpConflictsForIg(Product product, boolean mustLock) {
        String ip = (String)product.getParam(Oid.IP_ADDRESS).getValue();
        if (mustLock) {
            productListLock.lock();
        }
        for (Product prod : productList) {
            String productIp = (String)prod.getParam(Oid.IP_ADDRESS).getValue();
            if (prod.getTTL() <= 0 || !productIp.equals(ip) || product.equals(prod) || !prod.requiresDisplay()) continue;
            prod.updateIg();
        }
        if (mustLock) {
            productListLock.unlock();
        }
    }

    public void setShowDeads(boolean b) {
        showDead = b;
        for (Product prod : productList) {
            prod.toggleDisplayRemoveIfConditionsAreMet();
        }
    }

    public void dump() {
        for (Product prod : productList) {
            prod.dump();
        }
    }

    public void iterateManagedProductsInGUIThread(NdmCallback code) {
        for (Product p : productList) {
            code.callback(p);
        }
    }

    public void registerProductDetailsPane(JEditorPane productDetailsPane) {
        this.productDetailsPane = productDetailsPane;
    }

    public static void setProductInDetailsPane(Product prod) {
        ProductManager.productManager.detailedProduct = prod;
        ProductManager.updateProductDetails(prod);
    }

    public static void resetProductInDetailsPane(Product prod) {
        if (prod == null || prod == ProductManager.productManager.detailedProduct) {
            ProductManager.productManager.productDetailsPane.setText(TranslateEnum.DETAILS_NO_SELECTION.get());
            ProductManager.productManager.detailedProduct = prod;
        }
    }

    public static void updateProductDetails(Product prod) {
        if (ProductManager.productManager.detailedProduct == prod) {
            ProductManager.productManager.productDetailsPane.setText(prod.getHtmlDetails());
        }
    }
}

