/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import sun.awt.Mutex;

public class SystrayMenu
extends PopupMenu
implements RefreshableInterface {
    private final Mutex refreshLock = new Mutex();
    private static final long serialVersionUID = -4079803941071985691L;
    List<Product> productList = new ArrayList<Product>();

    public SystrayMenu(MainFrame frame, JTable table) {
        MenuItem exit = new MenuItem(TranslateEnum.MENU_QUIT.get());
        exit.addActionListener(frame.getQuitListener());
        this.add(exit);
    }

    @Override
    public void refreshAdd(Product product) {
        this.refreshLock.lock();
        if (this.productList.size() == 0) {
            this.insertSeparator(0);
        }
        this.productList.add(0, product);
        MenuItem menu = new MenuItem(String.valueOf((String)product.getParam(Oid.SYSLOCATION).getValue()) + " (" + (String)product.getParam(Oid.IP_ADDRESS).getValue() + ")");
        menu.addActionListener(ListenerFactory.getTrayItemListener(product));
        this.insert(menu, 0);
        this.refreshLock.unlock();
    }

    @Override
    public void refreshClearList() {
        this.refreshLock.lock();
        this.productList.clear();
        int count = this.getItemCount();
        int i = 0;
        while (i < count - 1) {
            this.remove(0);
            ++i;
        }
        this.refreshLock.unlock();
    }

    @Override
    public void refreshProduct(Product product) {
        if (this.productList.indexOf(product) != -1) {
            this.getItem(this.productList.indexOf(product)).setLabel(product.getParam(Oid.SYSLOCATION).getValue() + " (" + (String)product.getParam(Oid.IP_ADDRESS).getValue() + ")");
        }
    }

    @Override
    public void refreshRemove(Product product) {
        this.refreshLock.lock();
        int index = this.productList.indexOf(product);
        if (index != -1) {
            this.productList.remove(product);
            this.remove(index);
            if (this.productList.size() == 0) {
                this.remove(0);
            }
        } else {
            System.out.println("Systray: removed product not found in list");
        }
        this.refreshLock.unlock();
    }
}

