/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.TrayIcon;

public class TrayIconInfo
extends TrayIcon
implements RefreshableInterface {
    private int ap = 0;
    private int bridge = 0;
    private int mesh = 0;
    private int adhoc = 0;
    private int unknown = 0;
    private static final boolean debugCount = false;

    public TrayIconInfo(Image image, String tooltip, PopupMenu popup) {
        super(image, tooltip, popup);
    }

    @Override
    public void refreshAdd(Product product) {
        int newClass = product.getCurrentWirelessRole();
        this.incrementCounter(newClass);
        product.setParam(new Parameter(Oid.TRAY_PANEL, newClass));
        this.updateToolTips();
    }

    @Override
    public void refreshClearList() {
        this.ap = 0;
        this.bridge = 0;
        this.mesh = 0;
        this.adhoc = 0;
        this.unknown = 0;
        this.updateToolTips();
    }

    @Override
    public void refreshProduct(Product product) {
        int newClass;
        int oldClass = product.parameters.getPositiveValue(Oid.TRAY_PANEL);
        if (oldClass != (newClass = product.getCurrentWirelessRole())) {
            this.decrementCounter(oldClass);
            this.incrementCounter(newClass);
            product.setParam(new Parameter(Oid.TRAY_PANEL, newClass));
            this.updateToolTips();
        }
    }

    @Override
    public void refreshRemove(Product product) {
        int oldClass = product.parameters.getPositiveValue(Oid.TRAY_PANEL);
        this.decrementCounter(oldClass);
        this.updateToolTips();
    }

    private void incrementCounter(int productClass) {
        switch (productClass) {
            case 6: {
                ++this.mesh;
                break;
            }
            case 3: {
                ++this.adhoc;
                break;
            }
            case 2: 
            case 7: {
                ++this.bridge;
                break;
            }
            case 1: {
                ++this.ap;
                break;
            }
            default: {
                ++this.unknown;
            }
        }
    }

    private void decrementCounter(int productClass) {
        switch (productClass) {
            case 2: 
            case 7: {
                --this.bridge;
                break;
            }
            case 3: {
                --this.adhoc;
                break;
            }
            case 1: {
                --this.ap;
                break;
            }
            case 6: {
                --this.mesh;
                break;
            }
            default: {
                --this.unknown;
            }
        }
    }

    private void updateToolTips() {
        String message = "";
        if (this.ap != 0) {
            message = String.valueOf(message) + "\r\n" + this.ap + " " + TranslateEnum.COLVAL_ROLE_AP.get();
        }
        if (this.bridge != 0) {
            message = String.valueOf(message) + "\r\n" + this.bridge + " " + TranslateEnum.BRIDGE.get();
        }
        if (this.adhoc != 0) {
            message = String.valueOf(message) + "\r\n" + this.adhoc + " " + TranslateEnum.ADHOC_STATION.get();
        }
        if (this.mesh != 0) {
            message = String.valueOf(message) + "\r\n" + this.mesh + " " + TranslateEnum.Mesh_STATION.get();
        }
        if (this.unknown != 0) {
            message = String.valueOf(message) + "\r\n" + this.unknown + " " + TranslateEnum.CAT_OTHERS.get();
        }
        this.setToolTip(message == "" ? "" : message.substring(2));
    }
}

