/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.discover;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.discover.DiscoverManager;
import fr.acksys.ndm.discover.DiscoverMethod;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.udap.DiscoverResponse;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class DatabaseDiscoverMethod
extends DiscoverMethod {
    private static final String TypeUdap = "U";
    private static final String TypeSaisie = "S";
    private final int defaultDistance = 10;
    private int distance = 10;
    private LinkedList<Product> dbProductsList = new LinkedList();
    public static boolean ctr_message;
    private static final DatabaseDiscoverMethod thisSingleton;
    private NdmCallback setParamCallback = new NdmCallback(){

        @Override
        public void callback(Object ob) {
            List list = (List)ob;
            Product product = (Product)list.get(0);
            Parameter parameter = (Parameter)list.get(1);
            Oid id = parameter.getId();
            if (id == Oid.PRODUCT_CODE) {
                NdmDb.getInstance().executeSynchronizedSqlChange(String.format("update products set p_code='%s' where p_mac='%s';", parameter.getValue().toString(), product.getUniqueIdString()));
            } else if (id == Oid.SYSDESCR) {
                NdmDb.getInstance().executeSynchronizedSqlChange(String.format("update products set p_sysdescr='%s' where p_mac='%s';", parameter.getValue(), product.getUniqueIdString()));
            } else if (id == Oid.IP_ADDRESS) {
                NdmDb.getInstance().executeSynchronizedSqlChange(String.format("update products set p_ip='%s' where p_mac='%s';", parameter.getValue(), product.getUniqueIdString()));
            }
        }
    };

    static {
        thisSingleton = new DatabaseDiscoverMethod();
    }

    private DatabaseDiscoverMethod() {
    }

    public static DatabaseDiscoverMethod getInstance() {
        return thisSingleton;
    }

    @Override
    public void init() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String discover() {
        ctr_message = false;
        NdmDb db = NdmDb.getInstance();
        try {
            NdmDb ndmDb = db;
            synchronized (ndmDb) {
                LinkedList<Product> linkedList = this.dbProductsList;
                synchronized (linkedList) {
                    this.dbProductsList.clear();
                }
                ResultSet query = db.st.executeQuery("select p_mac,p_code,p_sysdescr,p_ip,p_snmp_r,p_snmp_w,p_type from products;");
                while (query.next()) {
                    this.giveDbProductToManager(query.getString(1), query.getInt(2), query.getString(3), query.getString(4), query.getString(5), query.getString(6), query.getString(7).equals(TypeUdap) ? DiscoverManager.QuerySystem.UDAP : DiscoverManager.QuerySystem.SNMP, false, 10);
                }
                query.close();
            }
            return null;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return ex.getLocalizedMessage();
        }
    }

    public void dump() {
        for (Product p : this.dbProductsList) {
            System.out.println("dbdump: " + p.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String poll() {
        LinkedList<Product> linkedList = this.dbProductsList;
        synchronized (linkedList) {
            this.setDistance(10);
            for (final Product prod : this.dbProductsList) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        this.setName("POLL " + prod.getIpString());
                        prod.setDistance(DatabaseDiscoverMethod.this.getDistanceAndIncr());
                        prod.updateConfig();
                    }
                };
                thread.start();
            }
        }
        return null;
    }

    public synchronized void setDistance(int distance) {
        this.distance = distance;
    }

    public synchronized int getDistanceAndIncr() {
        int d = this.distance++;
        return d;
    }

    public void createProduct(String mac, int productCode, String sysdescr, String ip, String snmpRead, String snmpWrite, boolean isAlive) {
        this.insertProduct(mac, productCode, sysdescr, ip, snmpRead, snmpWrite, DiscoverManager.QuerySystem.SNMP);
        this.giveDbProductToManager(mac, productCode, sysdescr, ip, snmpRead, snmpWrite, DiscoverManager.QuerySystem.SNMP, isAlive, 10);
    }

    void insertProduct(Product p, DiscoverManager.QuerySystem querySystem) {
        if (p.parameters.getStringValue(Oid.SYSDESCR).contains("_E2131.")) {
            return;
        }
        this.insertProduct(p.getUniqueIdString(), p.parameters.getPositiveValue(Oid.PRODUCT_CODE), p.parameters.getStringValue(Oid.SYSDESCR), p.parameters.getStringValue(Oid.IP_ADDRESS), p.isDefaultCommunityRead() ? "" : p.getCommunityRead(), p.isDefaultCommunityWrite() ? "" : p.getCommunityWrite(), querySystem);
    }

    private void insertProduct(String mac, int productCode, String sysdescr, String ip, String snmpRead, String snmpWrite, DiscoverManager.QuerySystem querySystem) {
        if (UserParameters.getBooleanUserParam("DB_SAVE_DETECTED")) {
            NdmDb.getInstance().executeSynchronizedSqlChange(String.format("insert into products (p_mac,p_code,p_sysdescr,p_ip,p_type,p_snmp_r,p_snmp_w) values('%s','%d','%s','%s','%s','%s','%s');", mac, productCode, sysdescr, ip, querySystem == DiscoverManager.QuerySystem.SNMP ? TypeSaisie : TypeUdap, snmpRead, snmpWrite));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProduct(String mac) {
        NdmDb.getInstance().executeSynchronizedSqlChange(String.format("delete from products where p_mac='%s';", mac));
        ProductManager pm = ProductManager.getInstance();
        Product prod = pm.getProductByMacInGUIThread(mac);
        pm.removeProduct(prod);
        LinkedList<Product> linkedList = this.dbProductsList;
        synchronized (linkedList) {
            this.dbProductsList.remove(prod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void giveDbProductToManager(String mac, int productCode, String sysdescr, String ip, String snmpRead, String snmpWrite, DiscoverManager.QuerySystem querySystem, boolean isAlive, int distance) {
        String[] splitDescr = sysdescr.split("_", 2);
        if (splitDescr.length < 2) {
            splitDescr = (String.valueOf(sysdescr) + "_").split("_", 2);
        }
        DiscoverResponse discovered = new DiscoverResponse(mac, ip, sysdescr, splitDescr[0], splitDescr[1], productCode, true);
        discovered.setDistance(distance);
        Product prod = DiscoverManager.getInstance().giveToProductManager(discovered, isAlive);
        if (prod != null) {
            prod.setSetParamCallback(this.setParamCallback);
            if (!snmpRead.equals("")) {
                prod.setCommunityRead(snmpRead);
            }
            if (!snmpWrite.equals("")) {
                prod.setCommunityWrite(snmpWrite);
            }
            if (querySystem == DiscoverManager.QuerySystem.SNMP) {
                LinkedList<Product> linkedList = this.dbProductsList;
                synchronized (linkedList) {
                    System.out.println("[add] " + ip + "  dbProductsList size = " + this.dbProductsList.size());
                    this.dbProductsList.add(prod);
                }
            }
            prod.updateConfig();
        }
    }
}

