/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.discover;

import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.discover.DatabaseDiscoverMethod;
import fr.acksys.ndm.discover.UdapDiscoverMethod;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.ProductFactory;
import fr.acksys.udap.DiscoverResponse;

public class DiscoverManager {
    private static DiscoverManager singleton = null;
    private static UdapDiscoverMethod udapDiscover;
    private static DatabaseDiscoverMethod databaseDiscover;

    private DiscoverManager() {
    }

    public static DiscoverManager getInstance() {
        if (singleton == null) {
            singleton = new DiscoverManager();
            udapDiscover = new UdapDiscoverMethod();
            databaseDiscover = DatabaseDiscoverMethod.getInstance();
            udapDiscover.init();
            databaseDiscover.init();
            singleton.discover();
        }
        return singleton;
    }

    public String discover() {
        String cr1 = null;
        cr1 = databaseDiscover.discover();
        String cr2 = udapDiscover.discover();
        return cr1 == null ? cr2 : cr1;
    }

    public String poll() {
        String cr1 = null;
        cr1 = udapDiscover.poll();
        String cr2 = databaseDiscover.poll();
        return cr1 == null ? cr2 : cr1;
    }

    Product processDiscoveredProduct(DiscoverResponse discover, QuerySystem querySystem, boolean alive) {
        Product product = this.giveToProductManager(discover, alive);
        if (product != null) {
            databaseDiscover.insertProduct(product, querySystem);
        }
        return product;
    }

    Product giveToProductManager(DiscoverResponse discover, boolean alive) {
        String mac = discover.getMacAddress();
        ProductManager pm = ProductManager.getInstance();
        Product existingProduct = pm.getProductByMacInOtherThreads(mac);
        boolean ishide = false;
        for (Product prod : pm.hiddenproductList) {
            if (!prod.getUniqueIdString().equalsIgnoreCase(mac)) continue;
            ishide = true;
            break;
        }
        if (existingProduct == null) {
            Product newProduct = ProductFactory.createProduct(discover);
            if (newProduct != null) {
                if (alive) {
                    newProduct.resetTTL();
                }
                pm.addProduct(newProduct);
                if (ishide) {
                    newProduct.setUserHideState(true);
                }
            }
            return newProduct;
        }
        existingProduct.resetTTL();
        discover.setProductDiscoverParams(existingProduct);
        if (ishide) {
            existingProduct.setUserHideState(true);
        }
        return null;
    }

    static enum QuerySystem {
        SNMP,
        UDAP;

    }
}

