/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ig.ConfigProgressThread;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.product.CATWlgProduct;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.BaseConfigThread;
import fr.acksys.ndm.product.config.IdentifyThread;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.TitledBorder;

public class ConfigBaseDialog
extends JDialog {
    private static final long serialVersionUID = -5937820141676939099L;
    private boolean isClosed = false;
    public static int dhcpValue;
    private JTextField ipAddress = new JTextField(10);
    private JComboBox subnetMask = new JComboBox();
    private JComboBox gateway = new JComboBox();
    private JPasswordField passwordField = new JPasswordField(10);
    private JCheckBox dhcpCheck = new JCheckBox(TranslateEnum.OBTAIN_AUTO_IP.get());
    private JButton closeButton = new JButton(TranslateEnum.CANCEL.get());
    private JButton applyButton = new JButton(TranslateEnum.APPLY_CHANGE.get());
    private JProgressBar progress = new JProgressBar();
    private JTextField txlocation = new JTextField(10);
    private JComboBox txrole = new JComboBox();
    SpinnerNumberModel model_Timeout = new SpinnerNumberModel((Number)10, Integer.valueOf(0), null, (Number)1);
    public JSpinner TimeoutSpin = new JSpinner(this.model_Timeout);
    public JButton Apply_identify = new JButton(TranslateEnum.COMMENCE.get());
    public JLabel InfoLabel = new JLabel(ImageManager.LOAD.getImageIcon());
    IdentifyThread confThread;

    public ConfigBaseDialog(Frame owner, final CATWlgProduct selectedPro) {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle(TranslateEnum.CONFIGURE_BASIC.get());
        IgUtils.SetIconImage(this);
        this.addWindowListener(this.onClose());
        final String oldrole = selectedPro.getFirmwareFunctionString();
        JLabel descr = new JLabel("<html><center>" + TranslateEnum.CONFIG_DESC1.get() + "<br><br>" + TranslateEnum.CONFIG_DESC2.get() + "</center></html>");
        this.add(descr);
        this.txrole.addItem(TranslateEnum.COLVAL_ROLE_AP_CA.get());
        this.txrole.addItem(TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH_CA.get());
        this.updateIG(selectedPro);
        this.dhcpCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigBaseDialog.this.dhcpCheck.isSelected()) {
                    ConfigBaseDialog.this.ipAddress.setEnabled(false);
                    ConfigBaseDialog.this.subnetMask.setEnabled(false);
                    ConfigBaseDialog.this.gateway.setEnabled(false);
                } else {
                    ConfigBaseDialog.this.ipAddress.setEnabled(true);
                    ConfigBaseDialog.this.subnetMask.setEnabled(true);
                    ConfigBaseDialog.this.gateway.setEnabled(true);
                }
            }
        });
        this.txrole.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newrole = (String)ConfigBaseDialog.this.txrole.getSelectedItem();
                String oldloc = (String)selectedPro.getParam(Oid.SYSLOCATION).getValue();
                String txloc = "";
                String mac = selectedPro.getUniqueIdString();
                String[] currentmac = mac.split("\\:");
                if (oldrole != newrole) {
                    ConfigBaseDialog.this.txlocation.setText(oldloc);
                    if (newrole == TranslateEnum.COLVAL_ROLE_AP_CA.get()) {
                        int i = 0;
                        while (i < currentmac.length) {
                            int ch = Integer.parseInt(currentmac[i], 16);
                            txloc = String.valueOf(txloc) + Integer.toHexString(ch);
                            ++i;
                        }
                        ConfigBaseDialog.this.txlocation.setText("LARN-" + txloc);
                    } else if (newrole == TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH_CA.get()) {
                        int j = 0;
                        while (j < currentmac.length) {
                            int ch = Integer.parseInt(currentmac[j], 16);
                            txloc = String.valueOf(txloc) + Integer.toHexString(ch);
                            ++j;
                        }
                        ConfigBaseDialog.this.txlocation.setText("OR-" + txloc);
                    }
                } else {
                    ConfigBaseDialog.this.txlocation.setText(oldloc);
                }
            }
        });
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newIp = null;
                String newGw = null;
                String newMask = null;
                String newrole = (String)ConfigBaseDialog.this.txrole.getSelectedItem();
                String newloc = ConfigBaseDialog.this.txlocation.getText();
                String oldloc = (String)selectedPro.getParam(Oid.SYSLOCATION).getValue();
                String oldIp = (String)selectedPro.getParam(Oid.IP_ADDRESS).getValue();
                String oldmask = (String)selectedPro.getParam(Oid.SUBNET_MASK).getValue();
                String oldgw = (String)selectedPro.getParam(Oid.GATEWAY).getValue();
                int maxConfigTime = 0;
                boolean dataOk = true;
                if (ConfigBaseDialog.this.dhcpCheck.isSelected()) {
                    dhcpValue = 2;
                } else {
                    dhcpValue = 1;
                    newIp = ConfigBaseDialog.this.ipAddress.getText();
                    newGw = (String)ConfigBaseDialog.this.gateway.getSelectedItem();
                    newMask = (String)ConfigBaseDialog.this.subnetMask.getSelectedItem();
                    dataOk = ListenerFactory.isInvalidIp(ConfigBaseDialog.this.ipAddress) & ListenerFactory.isInvalidComboIp(ConfigBaseDialog.this.gateway) & ListenerFactory.isInvalidComboIp(ConfigBaseDialog.this.subnetMask);
                    if (!dataOk) {
                        return;
                    }
                    if (!ConfigBaseDialog.checkCompatibility(selectedPro, newIp, newMask, newGw)) {
                        return;
                    }
                    if (!oldIp.equals(newIp)) {
                        selectedPro.updateParam(Oid.IP_ADDRESS, newIp);
                    }
                    if (!oldmask.equals(newMask)) {
                        selectedPro.updateParam(Oid.SUBNET_MASK, newMask);
                    }
                    if (!oldgw.equals(newGw)) {
                        selectedPro.updateParam(Oid.GATEWAY, newGw);
                    }
                }
                selectedPro.updateParam(Oid.DHCP_STATE, dhcpValue);
                if (!oldrole.equals(newrole)) {
                    selectedPro.rolechange = true;
                    selectedPro.locationchange = true;
                    if (newrole == TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH_CA.get()) {
                        selectedPro.updateParam(Oid.WIFI_MODE, 1);
                        selectedPro.updateParam(Oid.WIFI_BRIDGE_MODE, 1);
                    } else if (newrole == TranslateEnum.COLVAL_ROLE_AP_CA.get()) {
                        selectedPro.updateParam(Oid.WIFI_MODE, 2);
                        selectedPro.updateParam(Oid.WIFI_BRIDGE_MODE, 0);
                    }
                } else {
                    selectedPro.rolechange = false;
                    selectedPro.locationchange = !oldloc.equals(newloc);
                }
                selectedPro.setParam(new Parameter(Oid.RESET, 0));
                selectedPro.updateParam(Oid.RESET, 1);
                ConfigBaseDialog.this.ipAddress.setBackground(Color.WHITE);
                ConfigBaseDialog.this.ipAddress.setForeground(Color.BLACK);
                ConfigBaseDialog.this.applyButton.setEnabled(false);
                if (maxConfigTime < selectedPro.getConfigurationTime()) {
                    maxConfigTime = selectedPro.getConfigurationTime();
                }
                ConfigProgressThread configProgress = new ConfigProgressThread(ConfigBaseDialog.this.progress, maxConfigTime, ConfigBaseDialog.this.applyButton, 1);
                BaseConfigThread confThread = new BaseConfigThread(selectedPro, ConfigBaseDialog.this.passwordField, configProgress, newloc, newrole);
                confThread.setName("ConfigThread");
                confThread.start();
                configProgress.setName("ConfigProgressThread");
                configProgress.start();
                ConfigBaseDialog.this.closeButton.setText(TranslateEnum.CLOSE.get());
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!selectedPro.thread_isstoped) {
                    JOptionPane.showMessageDialog(null, TranslateEnum.SINGLE_IDENT.get(), TranslateEnum.WARNING.get(), 2);
                    return;
                }
                ConfigBaseDialog.this.dispose();
            }
        });
        this.Apply_identify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int my_intval = (Integer)ConfigBaseDialog.this.TimeoutSpin.getValue();
                ConfigBaseDialog.this.confThread = new IdentifyThread(selectedPro, my_intval, ConfigBaseDialog.this.Apply_identify, ConfigBaseDialog.this.TimeoutSpin, ConfigBaseDialog.this.InfoLabel, null);
                ConfigBaseDialog.this.InfoLabel.setVisible(true);
                if (ConfigBaseDialog.this.Apply_identify.getText() == TranslateEnum.COMMENCE.get()) {
                    ConfigBaseDialog.this.TimeoutSpin.setEnabled(false);
                    ConfigBaseDialog.this.Apply_identify.setEnabled(false);
                    ConfigBaseDialog.this.confThread.start();
                } else {
                    ConfigBaseDialog.this.confThread.interrupt();
                    selectedPro.identify_Product(0);
                    ConfigBaseDialog.this.TimeoutSpin.setEnabled(true);
                    ConfigBaseDialog.this.Apply_identify.setText(TranslateEnum.COMMENCE.get());
                    ConfigBaseDialog.this.InfoLabel.setVisible(false);
                    selectedPro.thread_isstoped = true;
                }
                ConfigBaseDialog.this.updateIG(selectedPro);
            }
        });
        SpringLayout cfgLayout = new SpringLayout();
        SpringLayout idenLayout = new SpringLayout();
        JPanel buttonPanel = new JPanel();
        JPanel configPanel = new JPanel(cfgLayout);
        TitledBorder configBorder = new TitledBorder("Configuration");
        configPanel.setBorder(configBorder);
        JPanel idenPanel = new JPanel(idenLayout);
        TitledBorder idenBorder = new TitledBorder(TranslateEnum.IDENT_PRODUCT.get());
        idenPanel.setBorder(idenBorder);
        JLabel ipAddressLabel = new JLabel(TranslateEnum.COLUMN_IP_ADDRESS.get());
        JLabel passwordLabel = new JLabel(TranslateEnum.PASSWORD.get());
        JLabel subnetMaskLabel = new JLabel(TranslateEnum.SUBNET_MASK.get());
        JLabel gatewayLabel = new JLabel(TranslateEnum.DEFAULT_GATEWAY.get());
        JLabel location = new JLabel(TranslateEnum.COLUMN_SYSLOCATION.get());
        JLabel status = new JLabel(TranslateEnum.STATUS.get());
        JLabel role = new JLabel(TranslateEnum.COLUMN_FUNCTION.get());
        JLabel TimeoutLabel = new JLabel("Time out (min)");
        configPanel.add(this.dhcpCheck);
        configPanel.add(ipAddressLabel);
        configPanel.add(this.ipAddress);
        configPanel.add(subnetMaskLabel);
        configPanel.add(this.subnetMask);
        configPanel.add(gatewayLabel);
        configPanel.add(this.gateway);
        configPanel.add(role);
        configPanel.add(this.txrole);
        configPanel.add(location);
        configPanel.add(this.txlocation);
        configPanel.add(passwordLabel);
        configPanel.add(this.passwordField);
        configPanel.add(this.applyButton);
        configPanel.add(status);
        configPanel.add(this.progress);
        idenPanel.add(TimeoutLabel);
        idenPanel.add(this.TimeoutSpin);
        idenPanel.add(this.Apply_identify);
        idenPanel.add(this.InfoLabel);
        this.ipAddress.setPreferredSize(new Dimension(150, 20));
        this.subnetMask.setPreferredSize(new Dimension(125, 20));
        this.gateway.setPreferredSize(new Dimension(125, 20));
        this.txlocation.setPreferredSize(new Dimension(150, 20));
        this.txrole.setPreferredSize(new Dimension(125, 20));
        this.passwordField.setPreferredSize(new Dimension(150, 20));
        this.progress.setPreferredSize(new Dimension(190, 20));
        this.TimeoutSpin.setPreferredSize(new Dimension(100, 20));
        this.InfoLabel.setVisible(false);
        idenLayout.putConstraint("East", (Component)this.Apply_identify, 0, "East", (Component)this.TimeoutSpin);
        if (Main.language.equals("fr")) {
            idenLayout.putConstraint("West", (Component)this.TimeoutSpin, 160, "West", (Component)this.getContentPane());
        } else {
            idenLayout.putConstraint("West", (Component)this.TimeoutSpin, 130, "West", (Component)this.getContentPane());
        }
        idenLayout.putConstraint("West", (Component)TimeoutLabel, 10, "West", (Component)idenPanel);
        idenLayout.putConstraint("West", (Component)this.InfoLabel, 8, "West", (Component)idenPanel);
        idenLayout.putConstraint("North", (Component)TimeoutLabel, 5, "North", (Component)idenPanel);
        idenLayout.putConstraint("North", (Component)this.TimeoutSpin, 0, "North", (Component)TimeoutLabel);
        idenLayout.putConstraint("North", (Component)this.Apply_identify, 5, "South", (Component)this.TimeoutSpin);
        idenLayout.putConstraint("South", (Component)this.InfoLabel, -15, "South", (Component)idenPanel);
        cfgLayout.putConstraint("North", (Component)this.ipAddress, 0, "North", (Component)ipAddressLabel);
        cfgLayout.putConstraint("North", (Component)this.subnetMask, 0, "North", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)this.gateway, 0, "North", (Component)gatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.txrole, 0, "North", (Component)role);
        cfgLayout.putConstraint("North", (Component)this.txlocation, 0, "North", (Component)location);
        cfgLayout.putConstraint("North", (Component)this.passwordField, 0, "North", (Component)passwordLabel);
        cfgLayout.putConstraint("North", (Component)this.progress, 0, "North", (Component)status);
        cfgLayout.putConstraint("West", (Component)ipAddressLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)subnetMaskLabel, 0, "West", (Component)ipAddressLabel);
        cfgLayout.putConstraint("West", (Component)gatewayLabel, 0, "West", (Component)ipAddressLabel);
        cfgLayout.putConstraint("West", (Component)location, 0, "West", (Component)ipAddressLabel);
        cfgLayout.putConstraint("West", (Component)role, 0, "West", (Component)ipAddressLabel);
        cfgLayout.putConstraint("West", (Component)passwordLabel, 0, "West", (Component)ipAddressLabel);
        cfgLayout.putConstraint("West", (Component)status, 0, "West", (Component)ipAddressLabel);
        if (Main.language.equals("fr")) {
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 160, "West", (Component)this.getContentPane());
        } else {
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 130, "West", (Component)this.getContentPane());
        }
        cfgLayout.putConstraint("West", (Component)this.subnetMask, 0, "West", (Component)this.ipAddress);
        cfgLayout.putConstraint("West", (Component)this.gateway, 0, "West", (Component)this.ipAddress);
        cfgLayout.putConstraint("West", (Component)this.txlocation, 0, "West", (Component)this.ipAddress);
        cfgLayout.putConstraint("West", (Component)this.txrole, 0, "West", (Component)this.ipAddress);
        cfgLayout.putConstraint("West", (Component)this.passwordField, 0, "West", (Component)this.ipAddress);
        cfgLayout.putConstraint("East", (Component)this.progress, 0, "East", (Component)this.passwordField);
        cfgLayout.putConstraint("East", (Component)this.applyButton, 0, "East", (Component)this.passwordField);
        cfgLayout.putConstraint("HorizontalCenter", (Component)this.dhcpCheck, 0, "HorizontalCenter", (Component)configPanel);
        cfgLayout.putConstraint("North", (Component)ipAddressLabel, 10, "South", (Component)this.dhcpCheck);
        cfgLayout.putConstraint("North", (Component)subnetMaskLabel, 10, "South", (Component)ipAddressLabel);
        cfgLayout.putConstraint("North", (Component)gatewayLabel, 10, "South", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)role, 20, "South", (Component)gatewayLabel);
        cfgLayout.putConstraint("North", (Component)location, 10, "South", (Component)role);
        cfgLayout.putConstraint("North", (Component)passwordLabel, 40, "South", (Component)location);
        cfgLayout.putConstraint("North", (Component)this.applyButton, 10, "South", (Component)passwordLabel);
        cfgLayout.putConstraint("North", (Component)status, 10, "South", (Component)this.applyButton);
        buttonPanel.add(configPanel);
        buttonPanel.add(idenPanel);
        buttonPanel.add(this.closeButton);
        this.add(buttonPanel);
        if (Main.language.equals("fr")) {
            buttonPanel.setPreferredSize(new Dimension(310, 460));
            configPanel.setPreferredSize(new Dimension(300, 320));
            idenPanel.setPreferredSize(new Dimension(290, 90));
        } else {
            buttonPanel.setPreferredSize(new Dimension(290, 460));
            configPanel.setPreferredSize(new Dimension(280, 320));
            idenPanel.setPreferredSize(new Dimension(270, 90));
        }
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("HorizontalCenter", (Component)buttonPanel, 0, "HorizontalCenter", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)buttonPanel, 0, "North", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)descr, -5, "South", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)descr, 5, "South", (Component)buttonPanel);
        layout.putConstraint("HorizontalCenter", (Component)descr, 0, "HorizontalCenter", (Component)buttonPanel);
        layout.putConstraint("East", (Component)descr, 5, "East", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)descr, 5, "West", (Component)this.getContentPane());
        this.dhcpCheck.setOpaque(false);
        configPanel.setOpaque(false);
        idenPanel.setOpaque(false);
        buttonPanel.setOpaque(false);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        if (Main.language.equals("fr")) {
            this.setSize(310, 620);
            this.setMinimumSize(new Dimension(320, 620));
        } else {
            this.setSize(280, 550);
            this.setMinimumSize(new Dimension(290, 610));
        }
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    public WindowListener onClose() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (ConfigBaseDialog.this.InfoLabel.isVisible()) {
                    JOptionPane.showMessageDialog(null, TranslateEnum.SINGLE_IDENT.get(), TranslateEnum.WARNING.get(), 2);
                    return;
                }
                ConfigBaseDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!ConfigBaseDialog.this.isClosed) {
                    ConfigBaseDialog.this.isClosed = true;
                }
            }
        };
    }

    public void updateIG(Product product) {
        ArrayList<String> gatewayList = new ArrayList<String>();
        ArrayList<String> subnetList = new ArrayList<String>();
        this.gateway.removeAllItems();
        this.subnetMask.removeAllItems();
        if (product == null) {
            this.ipAddress.setText("");
            this.applyButton.setEnabled(false);
            return;
        }
        this.gateway.setEditable(true);
        this.subnetMask.setEditable(true);
        String ip = (String)product.getParam(Oid.IP_ADDRESS).getValue();
        String gatewayStr = (String)product.getParam(Oid.GATEWAY).getValue();
        String subnetStr = (String)product.getParam(Oid.SUBNET_MASK).getValue();
        String role = product.getFirmwareFunctionString();
        String location = (String)product.getParam(Oid.SYSLOCATION).getValue();
        if (IpComparator.isValidIp(gatewayStr) && !gatewayList.contains(gatewayStr)) {
            gatewayList.add(gatewayStr);
        }
        if (IpComparator.isValidIp(subnetStr) && !subnetList.contains(subnetStr)) {
            subnetList.add(subnetStr);
        }
        this.ipAddress.setText(ip);
        this.txrole.setSelectedItem(role);
        this.txlocation.setText(location);
        if (product.parameters.getPositiveValue(Oid.DHCP_STATE) == 1) {
            this.dhcpCheck.setSelected(false);
            this.ipAddress.setEnabled(true);
            this.subnetMask.setEnabled(true);
            this.gateway.setEnabled(true);
        } else {
            this.dhcpCheck.setSelected(true);
            this.ipAddress.setEnabled(false);
            this.subnetMask.setEnabled(false);
            this.gateway.setEnabled(false);
        }
        IpComparator ipCmp = new IpComparator();
        Collections.sort(gatewayList, ipCmp);
        for (String string : gatewayList) {
            this.gateway.addItem(string);
        }
        Collections.sort(subnetList, ipCmp);
        for (String string : subnetList) {
            this.subnetMask.addItem(string);
        }
        if (this.gateway.getItemCount() == 1) {
            this.gateway.setSelectedIndex(0);
        } else {
            this.gateway.setSelectedIndex(-1);
        }
        if (this.gateway.getItemCount() == 1) {
            this.gateway.setSelectedIndex(0);
        } else {
            this.gateway.setSelectedItem((String)product.getParam(Oid.GATEWAY).getValue());
        }
        if (this.subnetMask.getItemCount() == 1) {
            this.subnetMask.setSelectedIndex(0);
        } else {
            this.subnetMask.setSelectedItem((String)product.getParam(Oid.SUBNET_MASK).getValue());
        }
        if (!product.iden_sign) {
            this.Apply_identify.setEnabled(false);
            this.TimeoutSpin.setEnabled(false);
        }
    }

    public static boolean checkCompatibility(Product product, String ipAddress, String subnetMask, String gateway) {
        int result;
        String currentNm;
        String currentGw;
        Parameter param;
        String currentIp = null;
        int sameNetwork = -1;
        boolean warning = false;
        currentIp = ipAddress == null ? (String)product.getParam(Oid.IP_ADDRESS).getValue() : ipAddress;
        int ip = IpComparator.toInteger(currentIp);
        if (gateway == null) {
            param = product.getParam(Oid.GATEWAY);
            String string = currentGw = param == null ? null : (String)param.getValue();
            if (currentGw == null) {
                currentGw = "0.0.0.0";
            }
        } else {
            currentGw = gateway;
        }
        if (subnetMask == null) {
            param = product.getParam(Oid.SUBNET_MASK);
            String string = currentNm = param == null ? null : (String)param.getValue();
            if (currentNm == null) {
                currentNm = (ip & Integer.MIN_VALUE) == 0 ? "255.0.0.0" : ((ip & 0x40000000) == 0 ? "255.255.0.0" : "255.255.255.0");
            }
        } else {
            currentNm = subnetMask;
        }
        int gw = IpComparator.toInteger(currentGw);
        int nm = IpComparator.toInteger(currentNm);
        if ((ip | nm) == -1) {
            JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
            return false;
        }
        if ((ip & ~nm) == 0) {
            JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
            return false;
        }
        if (gw != 0) {
            if ((ip & nm) != (gw & nm)) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.IP_GW_DIFFERENT_NETWORK.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.DEFAULT_GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if ((gw & ~nm) == 0) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if ((gw | nm) == -1) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
        }
        int isSameNetwork = ip & nm;
        if (sameNetwork == -1) {
            sameNetwork = isSameNetwork;
        } else if (sameNetwork != isSameNetwork) {
            warning = true;
        }
        return !warning || (result = JOptionPane.showConfirmDialog(null, TranslateEnum.DIFFERENT_NETWORK.get(), TranslateEnum.WARNING.get(), 2)) == 0;
    }
}

