/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.CenterRenderer;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.ig.ParamTableModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ConfigDialog
extends JDialog {
    private static final long serialVersionUID = -5937820141676939099L;
    private boolean isClosed = false;
    private int max_gwcount = 5;
    private JTextField ipAddress = new JTextField(10);
    private JTextField increment = new JTextField(10);
    private JCheckBox changeIp = new JCheckBox();
    private JCheckBox changeGateway = new JCheckBox();
    private JCheckBox changeSubnetMask = new JCheckBox();
    private JComboBox subnetMask = new JComboBox();
    private JComboBox gateway = new JComboBox();
    private JPasswordField passwordField = new JPasswordField(10);
    private JLabel nextIpLab = new JLabel();
    private JRadioButton dhcpRadio = new JRadioButton(TranslateEnum.OBTAIN_AUTO_IP.get());
    private JRadioButton staticRadio = new JRadioButton(TranslateEnum.USE_FOLLOWING_IP.get());
    private JButton closeButton = new JButton(TranslateEnum.CLOSE.get());
    private JButton applyButton = new JButton(TranslateEnum.APPLY.get());
    private JTextArea logArea = new JTextArea();
    private ParamTableModel paramModel;
    private JTable table;
    private JProgressBar progress = new JProgressBar();

    public ConfigDialog(Frame owner, List<Product> selectedList) {
        this.setModal(true);
        this.setTitle(TranslateEnum.CONFIGURE_BASIC.get());
        IgUtils.SetIconImage(this);
        this.paramModel = new ParamTableModel(selectedList);
        for (Product p : selectedList) {
            p.registerRefreshIg(this.paramModel);
        }
        this.addWindowListener(this.onClose());
        this.table = new JTable(this.paramModel);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        sorter.setComparator(2, new IpComparator());
        this.table.setRowSorter(sorter);
        this.table.setDefaultRenderer(Object.class, new CenterRenderer());
        this.table.addRowSelectionInterval(0, selectedList.size() - 1);
        this.ipAddress.addKeyListener(ListenerFactory.getConfigIcrementListener(this.ipAddress, this.increment, this.nextIpLab));
        this.increment.addKeyListener(ListenerFactory.getConfigIcrementListener(this.ipAddress, this.increment, this.nextIpLab));
        JScrollPane tableScrollPanel = new JScrollPane(this.table);
        BevelBorder borderTable = new BevelBorder(1);
        tableScrollPanel.setBorder(borderTable);
        this.add(tableScrollPanel);
        JLabel descr = new JLabel("<html>" + TranslateEnum.CONFIG_DESC1.get() + "<br><br>" + TranslateEnum.CONFIG_DESC2.get() + "</html>");
        this.add(descr);
        this.dhcpRadio.addActionListener(ListenerFactory.getConfigDhcpRadioListener(this.changeIp, this.ipAddress, this.increment, this.nextIpLab, this.changeSubnetMask, this.subnetMask, this.changeGateway, this.gateway));
        this.staticRadio.addActionListener(ListenerFactory.getConfigStaticRadioListener(this.table, this.changeIp, this.changeSubnetMask, this.changeGateway, this.ipAddress, this.increment, this.nextIpLab, this.subnetMask, this.gateway));
        ButtonGroup group = new ButtonGroup();
        group.add(this.dhcpRadio);
        group.add(this.staticRadio);
        JPanel radPanel = new JPanel(new GridLayout(2, 1));
        radPanel.add(this.dhcpRadio);
        radPanel.add(this.staticRadio);
        SpringLayout cfgLayout = new SpringLayout();
        SpringLayout applyLayout = new SpringLayout();
        JPanel buttonPanel = new JPanel();
        JPanel configPanel = new JPanel(cfgLayout);
        JPanel applyPanel = new JPanel(applyLayout);
        TitledBorder applyBorder = new TitledBorder(TranslateEnum.APPLY.get());
        applyPanel.setBorder(applyBorder);
        this.ipAddress.setEnabled(false);
        this.increment.setEnabled(false);
        this.nextIpLab.setEnabled(false);
        this.gateway.setEnabled(false);
        this.subnetMask.setEnabled(false);
        this.increment.setText(UserParameters.getInstance().getParam("INCREMENT_VALUE"));
        this.updateIG(selectedList);
        TitledBorder border = new TitledBorder("");
        configPanel.setBorder(border);
        JLabel ipAddressLabel = new JLabel(TranslateEnum.COLUMN_IP_ADDRESS.get());
        JLabel incrementLabel = new JLabel("       " + TranslateEnum.INCREMENT.get());
        JLabel nextIpLabel = new JLabel("       " + TranslateEnum.NEXT_IP.get());
        JLabel passwordLabel = new JLabel(TranslateEnum.PASSWORD.get());
        JLabel changeIpLabel = new JLabel(TranslateEnum.CHANGE_IP.get());
        JLabel changeSubnetMaskLabel = new JLabel(TranslateEnum.CHANGE_SUBNETMASK.get());
        JLabel subnetMaskLabel = new JLabel(TranslateEnum.SUBNET_MASK.get());
        JLabel gatewayLabel = new JLabel(TranslateEnum.DEFAULT_GATEWAY.get());
        JLabel changeGatewayLabel = new JLabel(TranslateEnum.CHANGE_GATEWAY.get());
        this.changeIp.addActionListener(ListenerFactory.getConfigChangeIpListener(this.changeIp, this.ipAddress, this.increment, this.table, this.nextIpLab));
        this.changeSubnetMask.addActionListener(ListenerFactory.getConfigChangeSubnetMaskListener(this.changeSubnetMask, this.subnetMask));
        this.changeGateway.addActionListener(ListenerFactory.getConfigChangeGatewayListener(this.changeGateway, this.gateway));
        configPanel.add(changeIpLabel);
        configPanel.add(this.changeIp);
        configPanel.add(ipAddressLabel);
        configPanel.add(this.ipAddress);
        configPanel.add(incrementLabel);
        configPanel.add(this.increment);
        configPanel.add(nextIpLabel);
        configPanel.add(this.nextIpLab);
        configPanel.add(changeSubnetMaskLabel);
        configPanel.add(this.changeSubnetMask);
        configPanel.add(subnetMaskLabel);
        configPanel.add(this.subnetMask);
        configPanel.add(changeGatewayLabel);
        configPanel.add(this.changeGateway);
        configPanel.add(gatewayLabel);
        configPanel.add(this.gateway);
        applyPanel.add(passwordLabel);
        applyPanel.add(this.passwordField);
        applyPanel.add(this.applyButton);
        this.ipAddress.setPreferredSize(new Dimension(120, 20));
        this.subnetMask.setPreferredSize(new Dimension(120, 20));
        this.gateway.setPreferredSize(new Dimension(120, 20));
        this.nextIpLab.setPreferredSize(new Dimension(120, 20));
        this.increment.setPreferredSize(new Dimension(120, 20));
        this.passwordField.setPreferredSize(new Dimension(120, 20));
        if (Main.language.equals("fr")) {
            applyLayout.putConstraint("East", (Component)this.applyButton, 0, "East", (Component)this.passwordField);
            applyLayout.putConstraint("West", (Component)this.passwordField, 160, "West", (Component)this.getContentPane());
        } else {
            applyLayout.putConstraint("West", (Component)this.applyButton, 120, "West", (Component)this.getContentPane());
            applyLayout.putConstraint("West", (Component)this.passwordField, 120, "West", (Component)this.getContentPane());
        }
        applyLayout.putConstraint("West", (Component)passwordLabel, 10, "West", (Component)this.getContentPane());
        applyLayout.putConstraint("North", (Component)passwordLabel, 5, "North", (Component)this.getContentPane());
        applyLayout.putConstraint("North", (Component)this.passwordField, 5, "North", (Component)this.getContentPane());
        applyLayout.putConstraint("North", (Component)this.applyButton, 5, "South", (Component)this.passwordField);
        cfgLayout.putConstraint("North", (Component)this.changeIp, 0, "North", (Component)changeIpLabel);
        cfgLayout.putConstraint("North", (Component)this.ipAddress, 0, "North", (Component)ipAddressLabel);
        cfgLayout.putConstraint("North", (Component)this.increment, 0, "North", (Component)incrementLabel);
        cfgLayout.putConstraint("North", (Component)this.nextIpLab, 0, "North", (Component)nextIpLabel);
        cfgLayout.putConstraint("North", (Component)this.changeSubnetMask, 0, "North", (Component)changeSubnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)this.subnetMask, 0, "North", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)this.changeGateway, 0, "North", (Component)changeGatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.gateway, 0, "North", (Component)gatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.passwordField, 0, "North", (Component)passwordLabel);
        cfgLayout.putConstraint("West", (Component)changeIpLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)ipAddressLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)incrementLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)nextIpLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)changeSubnetMaskLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)subnetMaskLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)changeGatewayLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)gatewayLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)passwordLabel, 10, "West", (Component)this.getContentPane());
        if (Main.language.equals("fr")) {
            cfgLayout.putConstraint("West", (Component)this.changeIp, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.increment, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.nextIpLab, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeSubnetMask, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.subnetMask, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeGateway, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.gateway, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.passwordField, 160, "West", (Component)this.getContentPane());
        } else {
            cfgLayout.putConstraint("West", (Component)this.changeIp, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.increment, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.nextIpLab, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeSubnetMask, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.subnetMask, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeGateway, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.gateway, 120, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.passwordField, 120, "West", (Component)this.getContentPane());
        }
        cfgLayout.putConstraint("South", (Component)ipAddressLabel, 40, "North", (Component)changeIpLabel);
        cfgLayout.putConstraint("South", (Component)incrementLabel, 40, "North", (Component)ipAddressLabel);
        cfgLayout.putConstraint("South", (Component)nextIpLabel, 40, "North", (Component)incrementLabel);
        cfgLayout.putConstraint("South", (Component)changeSubnetMaskLabel, 40, "North", (Component)nextIpLabel);
        cfgLayout.putConstraint("South", (Component)subnetMaskLabel, 40, "North", (Component)changeSubnetMaskLabel);
        cfgLayout.putConstraint("South", (Component)changeGatewayLabel, 40, "North", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("South", (Component)gatewayLabel, 40, "North", (Component)changeGatewayLabel);
        cfgLayout.putConstraint("South", (Component)passwordLabel, 40, "North", (Component)gatewayLabel);
        buttonPanel.add(radPanel);
        buttonPanel.add(configPanel);
        buttonPanel.add(applyPanel);
        buttonPanel.add(this.closeButton);
        this.add(buttonPanel);
        this.closeButton.addActionListener(ListenerFactory.getCancelDialoglListener(this));
        this.logArea.setEditable(false);
        JScrollPane scrollLog = new JScrollPane(this.logArea);
        this.add(scrollLog);
        this.add(this.progress);
        this.progress.setPreferredSize(new Dimension(300, 20));
        scrollLog.setPreferredSize(new Dimension(340, 100));
        descr.setPreferredSize(new Dimension(300, 120));
        if (Main.language.equals("fr")) {
            buttonPanel.setPreferredSize(new Dimension(310, 385));
            configPanel.setPreferredSize(new Dimension(295, 200));
            applyPanel.setPreferredSize(new Dimension(295, 85));
        } else {
            buttonPanel.setPreferredSize(new Dimension(270, 385));
            configPanel.setPreferredSize(new Dimension(250, 200));
            applyPanel.setPreferredSize(new Dimension(250, 85));
        }
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("North", (Component)tableScrollPanel, 5, "North", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)tableScrollPanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("VerticalCenter", (Component)buttonPanel, 0, "VerticalCenter", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)descr, 5, "South", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)tableScrollPanel, -10, "North", (Component)this.progress);
        layout.putConstraint("South", (Component)this.progress, -10, "North", (Component)scrollLog);
        layout.putConstraint("West", (Component)scrollLog, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)this.progress, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)scrollLog, 0, "North", (Component)descr);
        layout.putConstraint("West", (Component)descr, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)buttonPanel, 5, "East", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)tableScrollPanel, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)this.progress, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)scrollLog, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)descr, 5, "West", (Component)buttonPanel);
        radPanel.setOpaque(false);
        this.dhcpRadio.setOpaque(false);
        this.staticRadio.setOpaque(false);
        this.changeIp.setOpaque(false);
        this.changeGateway.setOpaque(false);
        this.changeSubnetMask.setOpaque(false);
        configPanel.setOpaque(false);
        applyPanel.setOpaque(false);
        buttonPanel.setOpaque(false);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        if (Main.language.equals("fr")) {
            this.setSize(670, 440);
            this.setMinimumSize(new Dimension(670, 440));
        } else {
            this.setSize(630, 440);
            this.setMinimumSize(new Dimension(630, 440));
        }
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    public WindowListener onClose() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConfigDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!ConfigDialog.this.isClosed) {
                    ConfigDialog.this.isClosed = true;
                    ProductManager.getInstance().unRegisterRefreshIg(ConfigDialog.this.paramModel);
                    UserParameters userParam = UserParameters.getInstance();
                    userParam.setParam("INCREMENT_VALUE", ConfigDialog.this.increment.getText());
                }
            }
        };
    }

    public void updateIG(List<Product> productList) {
        ArrayList<String> subnetList = new ArrayList<String>();
        boolean dhcpState = true;
        this.gateway.removeAllItems();
        this.subnetMask.removeAllItems();
        if (productList.size() == 0) {
            this.ipAddress.setText("");
            this.nextIpLab.setText("");
            this.applyButton.setEnabled(false);
            return;
        }
        this.gateway.setEditable(true);
        this.subnetMask.setEditable(true);
        IpComparator ipCmp = new IpComparator();
        String lowIp = (String)productList.get(0).getParam(Oid.IP_ADDRESS).getValue();
        int i = 0;
        while (i < productList.size()) {
            String gatewayStr;
            String subnetStr;
            String ip1 = (String)productList.get(i).getParam(Oid.IP_ADDRESS).getValue();
            if (ipCmp.compare(ip1, lowIp) < 0) {
                lowIp = ip1;
            }
            if (IpComparator.isValidIp(subnetStr = (String)productList.get(i).getParam(Oid.SUBNET_MASK).getValue()) && !subnetList.contains(subnetStr)) {
                subnetList.add(subnetStr);
            }
            if (IpComparator.isValidIp(gatewayStr = (String)productList.get(i).getParam(Oid.GATEWAY).getValue()) && !Main.gatewayList.contains(gatewayStr)) {
                Main.gatewayList.add(0, gatewayStr);
            }
            if (dhcpState && productList.get((int)i).parameters.getPositiveValue(Oid.DHCP_STATE) == 1) {
                dhcpState = false;
            }
            ++i;
        }
        int gw_size = Main.gatewayList.size();
        if (gw_size < this.max_gwcount) {
            String autoGw = ConfigDialog.calculAutoGw(lowIp, (String)subnetList.get(0), "0.0.0.1");
            if (!Main.gatewayList.contains(autoGw)) {
                Main.gatewayList.add(autoGw);
            }
            if (gw_size < this.max_gwcount - 1 && !Main.gatewayList.contains(autoGw = ConfigDialog.calculAutoGw(lowIp, (String)subnetList.get(0), "0.0.0.254"))) {
                Main.gatewayList.add(autoGw);
            }
        } else if (gw_size > this.max_gwcount) {
            int j = gw_size - 1;
            while (j > this.max_gwcount - 1) {
                Main.gatewayList.remove(j);
                --j;
            }
        }
        if (dhcpState) {
            this.dhcpRadio.setSelected(true);
            this.changeIp.setEnabled(false);
            this.ipAddress.setEnabled(false);
            this.increment.setEnabled(false);
            this.nextIpLab.setEnabled(false);
            this.changeSubnetMask.setEnabled(false);
            this.subnetMask.setEnabled(false);
            this.changeGateway.setEnabled(false);
            this.gateway.setEnabled(false);
        } else {
            this.staticRadio.setSelected(true);
            int[] selection = this.table.getSelectedRows();
            this.changeIp.setEnabled(true);
            this.changeSubnetMask.setEnabled(true);
            this.changeGateway.setEnabled(true);
            if (selection.length == 1) {
                this.changeIp.setSelected(true);
                this.changeGateway.setSelected(true);
                this.changeSubnetMask.setSelected(true);
            }
            if (this.changeIp.isSelected()) {
                this.ipAddress.setEnabled(true);
            } else {
                this.ipAddress.setEnabled(false);
            }
            if (this.changeSubnetMask.isSelected()) {
                this.subnetMask.setEnabled(true);
            } else {
                this.subnetMask.setEnabled(false);
            }
            if (this.changeGateway.isSelected()) {
                this.gateway.setEnabled(true);
            } else {
                this.gateway.setEnabled(false);
            }
            switch (selection.length) {
                case 0: {
                    this.applyButton.setEnabled(false);
                    this.applyButton.setText(TranslateEnum.APPLY.get());
                    this.increment.setEnabled(false);
                    this.nextIpLab.setEnabled(false);
                    break;
                }
                case 1: {
                    this.applyButton.setEnabled(true);
                    this.applyButton.setText(TranslateEnum.APPLY.get());
                    this.increment.setEnabled(false);
                    this.nextIpLab.setEnabled(false);
                    break;
                }
                default: {
                    this.applyButton.setEnabled(true);
                    this.applyButton.setText(TranslateEnum.APPLY_ALL.get());
                    if (!this.changeIp.isSelected() || !this.staticRadio.isSelected()) break;
                    this.increment.setEnabled(true);
                    this.nextIpLab.setEnabled(true);
                }
            }
        }
        Collections.sort(Main.gatewayList, ipCmp);
        for (String string : Main.gatewayList) {
            this.gateway.addItem(string);
        }
        Collections.sort(subnetList, ipCmp);
        for (String string : subnetList) {
            this.subnetMask.addItem(string);
        }
        if (this.gateway.getItemCount() == 1) {
            this.gateway.setSelectedIndex(0);
        } else if (productList.size() == 1) {
            this.gateway.setSelectedItem((String)productList.get(0).getParam(Oid.GATEWAY).getValue());
        } else {
            this.gateway.setSelectedIndex(-1);
        }
        if (this.subnetMask.getItemCount() == 1) {
            this.subnetMask.setSelectedIndex(0);
        } else {
            this.subnetMask.setSelectedIndex(-1);
        }
        this.ipAddress.setText(lowIp);
        this.nextIpLab.setText(ConfigDialog.calculNextIp(lowIp, this.increment.getText()));
    }

    public static String calculNextIp(String ip, String increment) {
        String[] currentIp;
        String[] incr;
        block5: {
            if (ip == null || increment == null) {
                return null;
            }
            incr = increment.split("\\.");
            currentIp = ip.split("\\.");
            if (incr.length == 4 && currentIp.length == 4) break block5;
            return null;
        }
        try {
            int[] value = new int[4];
            int i = 0;
            while (i < 4) {
                value[i] = Integer.parseInt(incr[i]) + Integer.parseInt(currentIp[i]);
                value[i] = value[i] % 256;
                ++i;
            }
            return String.valueOf(value[0]) + "." + value[1] + "." + value[2] + "." + value[3];
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String calculAutoGw(String ip, String netmask, String increment) {
        String[] currentIp;
        String[] currentNm;
        String[] incr;
        block5: {
            if (ip == null || increment == null) {
                return null;
            }
            incr = increment.split("\\.");
            currentNm = netmask.split("\\.");
            currentIp = ip.split("\\.");
            if (incr.length == 4 && currentIp.length == 4 && currentNm.length == 4) break block5;
            return null;
        }
        try {
            int[] value = new int[4];
            int i = 0;
            while (i < 4) {
                value[i] = (Integer.parseInt(currentIp[i]) & Integer.parseInt(currentNm[i])) + Integer.parseInt(incr[i]);
                value[i] = value[i] % 256;
                ++i;
            }
            return String.valueOf(value[0]) + "." + value[1] + "." + value[2] + "." + value[3];
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean checkCompatibility(List<Product> productList, String ipAddress, String increment, String subnetMask, String gateway) {
        int result;
        String currentIp = null;
        int sameNetwork = -1;
        boolean warning = false;
        int j = 0;
        while (j < productList.size()) {
            String currentNm;
            String currentGw;
            Parameter param;
            currentIp = ipAddress == null ? (String)productList.get(j).getParam(Oid.IP_ADDRESS).getValue() : (j == 0 ? ipAddress : ConfigDialog.calculNextIp(currentIp, increment));
            int ip = IpComparator.toInteger(currentIp);
            if (gateway == null) {
                param = productList.get(j).getParam(Oid.GATEWAY);
                String string = currentGw = param == null ? null : (String)param.getValue();
                if (currentGw == null) {
                    currentGw = "0.0.0.0";
                }
            } else {
                currentGw = gateway;
            }
            if (subnetMask == null) {
                param = productList.get(j).getParam(Oid.SUBNET_MASK);
                String string = currentNm = param == null ? null : (String)param.getValue();
                if (currentNm == null) {
                    currentNm = (ip & Integer.MIN_VALUE) == 0 ? "255.0.0.0" : ((ip & 0x40000000) == 0 ? "255.255.0.0" : "255.255.255.0");
                }
            } else {
                currentNm = subnetMask;
            }
            int gw = IpComparator.toInteger(currentGw);
            int nm = IpComparator.toInteger(currentNm);
            if ((ip | nm) == -1) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if ((ip & ~nm) == 0) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if (gw != 0) {
                if ((ip & nm) != (gw & nm)) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.IP_GW_DIFFERENT_NETWORK.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.DEFAULT_GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
                if ((gw & ~nm) == 0) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
                if ((gw | nm) == -1) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
            }
            int isSameNetwork = ip & nm;
            if (sameNetwork == -1) {
                sameNetwork = isSameNetwork;
            } else if (sameNetwork != isSameNetwork) {
                warning = true;
            }
            ++j;
        }
        return !warning || (result = JOptionPane.showConfirmDialog(null, TranslateEnum.DIFFERENT_NETWORK.get(), TranslateEnum.WARNING.get(), 2)) == 0;
    }
}

