/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.CenterRenderer;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.ig.ParamTableModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.IdentifyThread;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class ConfigDialog2
extends JDialog {
    private static final long serialVersionUID = -5937820141676939099L;
    private boolean isClosed = false;
    private int max_gwcount = 5;
    private JCheckBox dhcpCheck = new JCheckBox(TranslateEnum.OBTAIN_AUTO_IP.get());
    private JTextField ipAddress = new JTextField(10);
    private JTextField increment = new JTextField(10);
    private JLabel nextIpLab = new JLabel();
    private JCheckBox changeIp = new JCheckBox();
    private JCheckBox changeGateway = new JCheckBox();
    private JCheckBox changeSubnetMask = new JCheckBox();
    private JComboBox subnetMask = new JComboBox();
    private JComboBox gateway = new JComboBox();
    private JPasswordField passwordField = new JPasswordField(10);
    private JButton applyButton = new JButton(TranslateEnum.APPLY.get());
    private JButton closeButton = new JButton(TranslateEnum.CLOSE.get());
    private JTextArea logArea = new JTextArea();
    private ParamTableModel paramModel;
    public JTable table;
    private JProgressBar progress = new JProgressBar();
    SpinnerNumberModel model_Timeout = new SpinnerNumberModel((Number)10, Integer.valueOf(0), null, (Number)1);
    public JSpinner TimeoutSpin = new JSpinner(this.model_Timeout);
    public JButton Apply_identify = new JButton(TranslateEnum.COMMENCE.get());
    public JLabel InfoLabel = new JLabel(ImageManager.LOAD.getImageIcon());
    IdentifyThread confThread;
    public static List<String> autogwList = new ArrayList<String>();

    public ConfigDialog2(Frame owner, final List<Product> selectedList) {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle(TranslateEnum.CONFIGURE_BASIC.get());
        IgUtils.SetIconImage(this);
        this.paramModel = new ParamTableModel(selectedList);
        for (Product p : selectedList) {
            p.registerRefreshIg(this.paramModel);
        }
        this.addWindowListener(this.onClose());
        this.table = new JTable(this.paramModel);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        sorter.setComparator(2, new IpComparator());
        this.table.setRowSorter(sorter);
        this.table.setDefaultRenderer(Object.class, new CenterRenderer());
        this.table.addRowSelectionInterval(0, selectedList.size() - 1);
        this.table.getSelectionModel().addListSelectionListener(ListenerFactory.getConfigTableListener(selectedList, this.table, this));
        this.ipAddress.addKeyListener(ListenerFactory.getConfigIPListener(this.ipAddress, this.increment, this.nextIpLab, this.subnetMask, this.gateway));
        this.increment.addKeyListener(ListenerFactory.getConfigIcrementListener(this.ipAddress, this.increment, this.nextIpLab));
        JScrollPane tableScrollPanel = new JScrollPane(this.table);
        BevelBorder borderTable = new BevelBorder(1);
        tableScrollPanel.setBorder(borderTable);
        this.add(tableScrollPanel);
        JLabel descr = new JLabel("<html>" + TranslateEnum.CONFIG_DESC1.get() + "<br><br>" + TranslateEnum.CONFIG_DESC2.get() + "</html>");
        this.add(descr);
        this.dhcpCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConfigDialog2.this.dhcpCheck.isSelected()) {
                    ConfigDialog2.this.changeIp.setEnabled(false);
                    ConfigDialog2.this.ipAddress.setEnabled(false);
                    ConfigDialog2.this.increment.setEnabled(false);
                    ConfigDialog2.this.nextIpLab.setEnabled(false);
                    ConfigDialog2.this.changeSubnetMask.setEnabled(false);
                    ConfigDialog2.this.subnetMask.setEnabled(false);
                    ConfigDialog2.this.changeGateway.setEnabled(false);
                    ConfigDialog2.this.gateway.setEnabled(false);
                } else {
                    int[] selection = ConfigDialog2.this.table.getSelectedRows();
                    ConfigDialog2.this.changeIp.setEnabled(true);
                    ConfigDialog2.this.changeSubnetMask.setEnabled(true);
                    ConfigDialog2.this.changeGateway.setEnabled(true);
                    ConfigDialog2.this.changeIp.setSelected(true);
                    if (ConfigDialog2.this.changeIp.isSelected()) {
                        ConfigDialog2.this.ipAddress.setEnabled(true);
                    } else {
                        ConfigDialog2.this.ipAddress.setEnabled(false);
                    }
                    if (ConfigDialog2.this.changeSubnetMask.isSelected()) {
                        ConfigDialog2.this.subnetMask.setEnabled(true);
                    } else {
                        ConfigDialog2.this.subnetMask.setEnabled(false);
                    }
                    if (ConfigDialog2.this.changeGateway.isSelected()) {
                        ConfigDialog2.this.gateway.setEnabled(true);
                    } else {
                        ConfigDialog2.this.gateway.setEnabled(false);
                    }
                    switch (selection.length) {
                        case 0: {
                            ConfigDialog2.this.increment.setEnabled(false);
                            ConfigDialog2.this.nextIpLab.setEnabled(false);
                            break;
                        }
                        case 1: {
                            ConfigDialog2.this.increment.setEnabled(false);
                            ConfigDialog2.this.nextIpLab.setEnabled(false);
                            break;
                        }
                        default: {
                            if (!ConfigDialog2.this.changeIp.isSelected()) break;
                            ConfigDialog2.this.increment.setEnabled(true);
                            ConfigDialog2.this.nextIpLab.setEnabled(true);
                        }
                    }
                }
            }
        });
        this.Apply_identify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int my_intval = (Integer)ConfigDialog2.this.TimeoutSpin.getValue();
                int[] selection = ConfigDialog2.this.table.getSelectedRows();
                int i = 0;
                while (i < selection.length) {
                    Product product = (Product)selectedList.get(ConfigDialog2.this.table.convertRowIndexToModel(selection[i]));
                    ConfigDialog2.this.confThread = new IdentifyThread(product, my_intval, ConfigDialog2.this.Apply_identify, ConfigDialog2.this.TimeoutSpin, ConfigDialog2.this.InfoLabel, ConfigDialog2.this.table);
                    ConfigDialog2.this.InfoLabel.setVisible(true);
                    if (ConfigDialog2.this.Apply_identify.getText() == TranslateEnum.COMMENCE.get()) {
                        ConfigDialog2.this.TimeoutSpin.setEnabled(false);
                        ConfigDialog2.this.Apply_identify.setEnabled(false);
                        ConfigDialog2.this.confThread.start();
                    } else {
                        product.iden_status = 1;
                        product.thread_isstoped = true;
                        ConfigDialog2.this.confThread.interrupt();
                        product.identify_Product(0);
                        ConfigDialog2.this.TimeoutSpin.setEnabled(true);
                        ConfigDialog2.this.Apply_identify.setText(TranslateEnum.COMMENCE.get());
                        ConfigDialog2.this.InfoLabel.setVisible(false);
                    }
                    ++i;
                }
                ConfigDialog2.this.table.updateUI();
            }
        });
        SpringLayout cfgLayout = new SpringLayout();
        SpringLayout idenLayout = new SpringLayout();
        JPanel buttonPanel = new JPanel();
        JPanel configPanel = new JPanel(cfgLayout);
        JPanel idenPanel = new JPanel(idenLayout);
        TitledBorder idenBorder = new TitledBorder(TranslateEnum.IDENT_PRODUCT.get());
        idenPanel.setBorder(idenBorder);
        this.InfoLabel.setVisible(false);
        this.increment.setText(UserParameters.getInstance().getParam("INCREMENT_VALUE"));
        this.updateIG(selectedList);
        JLabel TimeoutLabel = new JLabel("Time out (min)");
        idenPanel.add(TimeoutLabel);
        idenPanel.add(this.TimeoutSpin);
        idenPanel.add(this.Apply_identify);
        idenPanel.add(this.InfoLabel);
        idenLayout.putConstraint("East", (Component)this.Apply_identify, 0, "East", (Component)this.TimeoutSpin);
        idenLayout.putConstraint("East", (Component)this.TimeoutSpin, -10, "East", (Component)idenPanel);
        idenLayout.putConstraint("West", (Component)TimeoutLabel, 10, "West", (Component)idenPanel);
        idenLayout.putConstraint("West", (Component)this.InfoLabel, 8, "West", (Component)idenPanel);
        idenLayout.putConstraint("North", (Component)TimeoutLabel, 5, "North", (Component)idenPanel);
        idenLayout.putConstraint("North", (Component)this.TimeoutSpin, 0, "North", (Component)TimeoutLabel);
        idenLayout.putConstraint("North", (Component)this.Apply_identify, 5, "South", (Component)this.TimeoutSpin);
        idenLayout.putConstraint("South", (Component)this.InfoLabel, -15, "South", (Component)idenPanel);
        TitledBorder border = new TitledBorder(TranslateEnum.CONFIGURE_IP.get());
        configPanel.setBorder(border);
        JLabel ipAddressLabel = new JLabel(TranslateEnum.COLUMN_IP_ADDRESS.get());
        JLabel incrementLabel = new JLabel("       " + TranslateEnum.INCREMENT.get());
        JLabel nextIpLabel = new JLabel("       " + TranslateEnum.NEXT_IP.get());
        JLabel subnetMaskLabel = new JLabel(TranslateEnum.SUBNET_MASK.get());
        JLabel gatewayLabel = new JLabel(TranslateEnum.DEFAULT_GATEWAY.get());
        JLabel changeGatewayLabel = new JLabel(TranslateEnum.CHANGE_GATEWAY.get());
        JLabel passwordLabel = new JLabel(TranslateEnum.PASSWORD.get());
        JLabel changeIpLabel = new JLabel(TranslateEnum.CHANGE_IP.get());
        JLabel changeSubnetMaskLabel = new JLabel(TranslateEnum.CHANGE_SUBNETMASK.get());
        this.changeIp.addActionListener(ListenerFactory.getConfigChangeIpListener(this.changeIp, this.ipAddress, this.increment, this.table, this.nextIpLab));
        this.changeSubnetMask.addActionListener(ListenerFactory.getConfigChangeSubnetMaskListener(this.changeSubnetMask, this.subnetMask));
        this.changeGateway.addActionListener(ListenerFactory.getConfigChangeGatewayListener(this.changeGateway, this.gateway));
        configPanel.add(this.dhcpCheck);
        configPanel.add(changeIpLabel);
        configPanel.add(this.changeIp);
        configPanel.add(ipAddressLabel);
        configPanel.add(this.ipAddress);
        configPanel.add(incrementLabel);
        configPanel.add(this.increment);
        configPanel.add(nextIpLabel);
        configPanel.add(this.nextIpLab);
        configPanel.add(changeSubnetMaskLabel);
        configPanel.add(this.changeSubnetMask);
        configPanel.add(subnetMaskLabel);
        configPanel.add(this.subnetMask);
        configPanel.add(changeGatewayLabel);
        configPanel.add(this.changeGateway);
        configPanel.add(gatewayLabel);
        configPanel.add(this.gateway);
        configPanel.add(passwordLabel);
        configPanel.add(this.passwordField);
        configPanel.add(this.applyButton);
        this.ipAddress.setPreferredSize(new Dimension(120, 20));
        this.subnetMask.setPreferredSize(new Dimension(120, 20));
        this.gateway.setPreferredSize(new Dimension(120, 20));
        this.nextIpLab.setPreferredSize(new Dimension(120, 20));
        this.increment.setPreferredSize(new Dimension(120, 20));
        this.passwordField.setPreferredSize(new Dimension(120, 20));
        this.TimeoutSpin.setPreferredSize(new Dimension(100, 20));
        cfgLayout.putConstraint("North", (Component)this.changeIp, 0, "North", (Component)changeIpLabel);
        cfgLayout.putConstraint("North", (Component)this.ipAddress, 0, "North", (Component)ipAddressLabel);
        cfgLayout.putConstraint("North", (Component)this.increment, 0, "North", (Component)incrementLabel);
        cfgLayout.putConstraint("North", (Component)this.nextIpLab, 0, "North", (Component)nextIpLabel);
        cfgLayout.putConstraint("North", (Component)this.changeSubnetMask, 0, "North", (Component)changeSubnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)this.subnetMask, 0, "North", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)this.changeGateway, 0, "North", (Component)changeGatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.gateway, 0, "North", (Component)gatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.passwordField, 0, "North", (Component)passwordLabel);
        cfgLayout.putConstraint("North", (Component)changeIpLabel, 10, "South", (Component)this.dhcpCheck);
        cfgLayout.putConstraint("North", (Component)ipAddressLabel, 10, "South", (Component)changeIpLabel);
        cfgLayout.putConstraint("North", (Component)incrementLabel, 10, "South", (Component)ipAddressLabel);
        cfgLayout.putConstraint("North", (Component)nextIpLabel, 10, "South", (Component)incrementLabel);
        cfgLayout.putConstraint("North", (Component)changeSubnetMaskLabel, 10, "South", (Component)nextIpLabel);
        cfgLayout.putConstraint("North", (Component)subnetMaskLabel, 10, "South", (Component)changeSubnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)changeGatewayLabel, 10, "South", (Component)subnetMaskLabel);
        cfgLayout.putConstraint("North", (Component)gatewayLabel, 10, "South", (Component)changeGatewayLabel);
        cfgLayout.putConstraint("North", (Component)passwordLabel, 15, "South", (Component)gatewayLabel);
        cfgLayout.putConstraint("North", (Component)this.applyButton, 10, "South", (Component)passwordLabel);
        cfgLayout.putConstraint("North", (Component)this.getContentPane(), 10, "South", (Component)this.applyButton);
        cfgLayout.putConstraint("West", (Component)this.dhcpCheck, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)changeIpLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)ipAddressLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)incrementLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)nextIpLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)changeSubnetMaskLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)subnetMaskLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)changeGatewayLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)gatewayLabel, 10, "West", (Component)this.getContentPane());
        cfgLayout.putConstraint("West", (Component)passwordLabel, 10, "West", (Component)this.getContentPane());
        if (Main.language.equals("fr")) {
            cfgLayout.putConstraint("West", (Component)this.changeIp, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.increment, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.nextIpLab, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeSubnetMask, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.subnetMask, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeGateway, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.gateway, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.passwordField, 160, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.applyButton, 160, "West", (Component)this.getContentPane());
        } else {
            cfgLayout.putConstraint("West", (Component)this.changeIp, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.ipAddress, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.increment, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.nextIpLab, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeSubnetMask, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.subnetMask, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.changeGateway, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.gateway, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.passwordField, 130, "West", (Component)this.getContentPane());
            cfgLayout.putConstraint("West", (Component)this.applyButton, 130, "West", (Component)this.getContentPane());
        }
        buttonPanel.add(idenPanel);
        buttonPanel.add(configPanel);
        buttonPanel.add(this.closeButton);
        this.add(buttonPanel);
        this.applyButton.addActionListener(ListenerFactory.getConfigApplyAllListener(this.table, this.ipAddress, this.subnetMask, this.gateway, this.dhcpCheck, this.increment, this.closeButton, this.changeIp, this.changeSubnetMask, this.changeGateway, selectedList, this.logArea, this.progress, this.applyButton, this.passwordField, this));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int i = 0;
                while (i < ConfigDialog2.this.table.getRowCount()) {
                    if (ConfigDialog2.this.table.getValueAt(i, 3) == TranslateEnum.IDENTIFY.get()) {
                        JOptionPane.showMessageDialog(null, TranslateEnum.SINGLE_IDENT.get(), TranslateEnum.WARNING.get(), 2);
                        return;
                    }
                    ++i;
                }
                ConfigDialog2.this.dispose();
            }
        });
        this.logArea.setEditable(false);
        JScrollPane scrollLog = new JScrollPane(this.logArea);
        this.add(scrollLog);
        this.add(this.progress);
        this.progress.setPreferredSize(new Dimension(405, 20));
        scrollLog.setPreferredSize(new Dimension(445, 100));
        descr.setPreferredSize(new Dimension(405, 120));
        if (Main.language.equals("fr")) {
            buttonPanel.setPreferredSize(new Dimension(315, 475));
            configPanel.setPreferredSize(new Dimension(300, 325));
            idenPanel.setPreferredSize(new Dimension(300, 90));
        } else {
            buttonPanel.setPreferredSize(new Dimension(285, 475));
            configPanel.setPreferredSize(new Dimension(265, 325));
            idenPanel.setPreferredSize(new Dimension(265, 90));
        }
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("North", (Component)tableScrollPanel, 5, "North", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)tableScrollPanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("VerticalCenter", (Component)buttonPanel, 0, "VerticalCenter", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)descr, 5, "South", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)tableScrollPanel, -10, "North", (Component)this.progress);
        layout.putConstraint("South", (Component)this.progress, -10, "North", (Component)scrollLog);
        layout.putConstraint("West", (Component)scrollLog, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)this.progress, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)scrollLog, 0, "North", (Component)descr);
        layout.putConstraint("West", (Component)descr, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)buttonPanel, 5, "East", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)tableScrollPanel, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)this.progress, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)scrollLog, 0, "West", (Component)buttonPanel);
        layout.putConstraint("East", (Component)descr, 5, "West", (Component)buttonPanel);
        idenPanel.setOpaque(false);
        this.dhcpCheck.setOpaque(false);
        this.changeIp.setOpaque(false);
        this.changeGateway.setOpaque(false);
        this.changeSubnetMask.setOpaque(false);
        configPanel.setOpaque(false);
        buttonPanel.setOpaque(false);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        if (Main.language.equals("fr")) {
            this.setSize(775, 520);
            this.setMinimumSize(new Dimension(775, 500));
        } else {
            this.setSize(745, 520);
            this.setMinimumSize(new Dimension(740, 500));
        }
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    public WindowListener onClose() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                int i = 0;
                while (i < ConfigDialog2.this.table.getRowCount()) {
                    if (ConfigDialog2.this.table.getValueAt(i, 3) == TranslateEnum.IDENTIFY.get()) {
                        JOptionPane.showMessageDialog(null, TranslateEnum.SINGLE_IDENT.get(), TranslateEnum.WARNING.get(), 2);
                        return;
                    }
                    ++i;
                }
                ConfigDialog2.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!ConfigDialog2.this.isClosed) {
                    ConfigDialog2.this.isClosed = true;
                    ProductManager.getInstance().unRegisterRefreshIg(ConfigDialog2.this.paramModel);
                    UserParameters userParam = UserParameters.getInstance();
                    userParam.setParam("INCREMENT_VALUE", ConfigDialog2.this.increment.getText());
                }
            }
        };
    }

    public void updateIG(List<Product> productList) {
        IpComparator ipCmp;
        int[] selection;
        boolean dhcpState;
        ArrayList<String> subnetList;
        block41: {
            int gw_size;
            block40: {
                autogwList.clear();
                subnetList = new ArrayList<String>();
                dhcpState = true;
                boolean idenState = true;
                selection = this.table.getSelectedRows();
                this.gateway.removeAllItems();
                this.subnetMask.removeAllItems();
                if (productList.size() == 0) {
                    this.ipAddress.setText("");
                    this.nextIpLab.setText("");
                    this.applyButton.setEnabled(false);
                    return;
                }
                this.gateway.setEditable(true);
                this.subnetMask.setEditable(true);
                subnetList.add("255.255.255.0");
                subnetList.add("255.255.0.0");
                subnetList.add("255.0.0.0");
                ipCmp = new IpComparator();
                String lowIp = (String)productList.get(0).getParam(Oid.IP_ADDRESS).getValue();
                int i = 0;
                while (i < productList.size()) {
                    String subnetStr;
                    String gatewayStr;
                    String ip1 = (String)productList.get(i).getParam(Oid.IP_ADDRESS).getValue();
                    if (ipCmp.compare(ip1, lowIp) < 0) {
                        lowIp = ip1;
                    }
                    if (IpComparator.isValidIp(gatewayStr = (String)productList.get(i).getParam(Oid.GATEWAY).getValue()) && !Main.gatewayList.contains(gatewayStr)) {
                        Main.gatewayList.add(gatewayStr);
                    }
                    if (IpComparator.isValidIp(subnetStr = (String)productList.get(i).getParam(Oid.SUBNET_MASK).getValue()) && !subnetList.contains(subnetStr)) {
                        subnetList.add(subnetStr);
                    }
                    if (dhcpState && productList.get((int)i).parameters.getPositiveValue(Oid.DHCP_STATE) == 1) {
                        dhcpState = false;
                    }
                    if (idenState && !productList.get((int)i).iden_sign) {
                        idenState = false;
                    }
                    ++i;
                }
                UserParameters userParam = UserParameters.getInstance();
                String gateway_default = userParam.getParam("GATEWAY_DEFAULT");
                if (!Main.gatewayList.contains(gateway_default) && !gateway_default.equals(null)) {
                    Main.gatewayList.add(gateway_default);
                }
                if ((gw_size = Main.gatewayList.size()) >= this.max_gwcount + 1) break block40;
                if (subnetList.size() <= 0) break block41;
                String autoGw = ConfigDialog2.calculAutoGw(lowIp, (String)subnetList.get(0), "0.0.0.1");
                if (!Main.gatewayList.contains(autoGw) && !autogwList.contains(autoGw)) {
                    autogwList.add(autoGw);
                }
                if (gw_size >= this.max_gwcount || Main.gatewayList.contains(autoGw = ConfigDialog2.calculAutoGw(lowIp, (String)subnetList.get(0), "0.0.0.254")) || autogwList.contains(autoGw)) break block41;
                autogwList.add(autoGw);
                break block41;
            }
            if (gw_size > this.max_gwcount) {
                int j = gw_size - 1;
                while (j > this.max_gwcount - 1) {
                    Main.gatewayList.remove(j);
                    --j;
                }
            }
        }
        Collections.sort(Main.gatewayList, ipCmp);
        for (String string : Main.gatewayList) {
            this.gateway.addItem(string);
        }
        Collections.sort(autogwList, ipCmp);
        for (String string_auto : autogwList) {
            this.gateway.addItem(string_auto);
        }
        Collections.sort(subnetList, ipCmp);
        for (String string : subnetList) {
            this.subnetMask.addItem(string);
        }
        this.applyButton.setText(TranslateEnum.APPLY.get());
        this.InfoLabel.setVisible(false);
        block0 : switch (selection.length) {
            case 0: {
                this.dhcpCheck.setSelected(false);
                this.changeIp.setEnabled(false);
                this.ipAddress.setEnabled(false);
                this.increment.setEnabled(false);
                this.nextIpLab.setEnabled(false);
                this.changeSubnetMask.setEnabled(false);
                this.subnetMask.setEnabled(false);
                this.changeGateway.setEnabled(false);
                this.gateway.setEnabled(false);
                this.Apply_identify.setEnabled(false);
                this.TimeoutSpin.setEnabled(false);
                this.InfoLabel.setVisible(false);
                this.applyButton.setEnabled(false);
                break;
            }
            case 1: {
                String IP = (String)productList.get(0).getParam(Oid.IP_ADDRESS).getValue();
                this.ipAddress.setText(IP);
                this.nextIpLab.setText(ConfigDialog2.calculNextIp(IP, this.increment.getText()));
                this.gateway.setSelectedItem((String)productList.get(0).getParam(Oid.GATEWAY).getValue());
                this.subnetMask.setSelectedItem((String)productList.get(0).getParam(Oid.SUBNET_MASK).getValue());
                if (productList.get((int)0).parameters.getPositiveValue(Oid.DHCP_STATE) == 2) {
                    this.dhcpCheck.setSelected(true);
                    this.changeIp.setEnabled(false);
                    this.ipAddress.setEnabled(false);
                    this.increment.setEnabled(false);
                    this.nextIpLab.setEnabled(false);
                    this.changeSubnetMask.setEnabled(false);
                    this.subnetMask.setEnabled(false);
                    this.changeGateway.setEnabled(false);
                    this.gateway.setEnabled(false);
                } else {
                    this.dhcpCheck.setSelected(false);
                    this.changeIp.setEnabled(true);
                    this.changeSubnetMask.setEnabled(true);
                    this.changeGateway.setEnabled(true);
                    this.changeIp.setSelected(true);
                    this.changeGateway.setSelected(true);
                    this.changeSubnetMask.setSelected(true);
                }
                switch (productList.get((int)0).iden_status) {
                    case 0: {
                        this.Apply_identify.setEnabled(false);
                        this.TimeoutSpin.setEnabled(false);
                        this.Apply_identify.setText(TranslateEnum.COMMENCE.get());
                        break;
                    }
                    case 1: {
                        this.Apply_identify.setEnabled(true);
                        this.TimeoutSpin.setEnabled(true);
                        this.Apply_identify.setText(TranslateEnum.COMMENCE.get());
                        break;
                    }
                    case 2: {
                        this.Apply_identify.setEnabled(true);
                        this.TimeoutSpin.setEnabled(false);
                        this.InfoLabel.setVisible(true);
                        this.Apply_identify.setText(TranslateEnum.STOP_TRACE.get());
                    }
                }
                this.applyButton.setEnabled(true);
                break;
            }
            default: {
                String IP0 = (String)productList.get(0).getParam(Oid.IP_ADDRESS).getValue();
                this.ipAddress.setText(IP0);
                this.nextIpLab.setText(ConfigDialog2.calculNextIp(IP0, this.increment.getText()));
                if (this.gateway.getItemCount() == 1) {
                    this.gateway.setSelectedIndex(0);
                } else {
                    this.gateway.setSelectedIndex(-1);
                }
                if (this.subnetMask.getItemCount() == 1) {
                    this.subnetMask.setSelectedIndex(0);
                } else {
                    this.subnetMask.setSelectedIndex(-1);
                }
                if (dhcpState) {
                    this.dhcpCheck.setSelected(true);
                    this.changeIp.setEnabled(false);
                    this.changeSubnetMask.setEnabled(false);
                    this.changeGateway.setEnabled(false);
                    this.ipAddress.setEnabled(false);
                    this.increment.setEnabled(false);
                    this.nextIpLab.setEnabled(false);
                    this.gateway.setEnabled(false);
                    this.subnetMask.setEnabled(false);
                } else {
                    this.dhcpCheck.setSelected(false);
                    this.changeIp.setEnabled(true);
                    this.changeSubnetMask.setEnabled(true);
                    this.changeGateway.setEnabled(true);
                    this.changeIp.setSelected(true);
                    this.changeGateway.setSelected(true);
                    this.changeSubnetMask.setSelected(true);
                }
                this.applyButton.setEnabled(true);
                this.applyButton.setText(TranslateEnum.APPLY_ALL.get());
                this.Apply_identify.setEnabled(false);
                this.TimeoutSpin.setEnabled(false);
                int n = 0;
                while (n < selection.length) {
                    if (productList.get((int)n).iden_status == 2) {
                        this.InfoLabel.setVisible(true);
                        break block0;
                    }
                    ++n;
                }
                break block0;
            }
        }
        if (!this.dhcpCheck.isSelected()) {
            if (this.changeIp.isSelected()) {
                this.ipAddress.setEnabled(true);
                this.increment.setEnabled(true);
                this.nextIpLab.setEnabled(true);
            } else {
                this.ipAddress.setEnabled(false);
                this.increment.setEnabled(false);
                this.nextIpLab.setEnabled(false);
            }
            if (this.changeSubnetMask.isSelected()) {
                this.subnetMask.setEnabled(true);
            } else {
                this.subnetMask.setEnabled(false);
            }
            if (this.changeGateway.isSelected()) {
                this.gateway.setEnabled(true);
            } else {
                this.gateway.setEnabled(false);
            }
        }
    }

    public static String calculNextIp(String ip, String increment) {
        String[] currentIp;
        String[] incr;
        block5: {
            if (ip == null || increment == null) {
                return null;
            }
            incr = increment.split("\\.");
            currentIp = ip.split("\\.");
            if (incr.length == 4 && currentIp.length == 4) break block5;
            return null;
        }
        try {
            int[] value = new int[4];
            int i = 0;
            while (i < 4) {
                value[i] = Integer.parseInt(incr[i]) + Integer.parseInt(currentIp[i]);
                value[i] = value[i] % 256;
                ++i;
            }
            return String.valueOf(value[0]) + "." + value[1] + "." + value[2] + "." + value[3];
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String calculAutoGw(String ip, String netmask, String increment) {
        String[] currentIp;
        String[] currentNm;
        String[] incr;
        block5: {
            if (ip == null || increment == null) {
                return null;
            }
            incr = increment.split("\\.");
            currentNm = netmask.split("\\.");
            currentIp = ip.split("\\.");
            if (incr.length == 4 && currentIp.length == 4 && currentNm.length == 4) break block5;
            return null;
        }
        try {
            int[] value = new int[4];
            int i = 0;
            while (i < 4) {
                value[i] = (Integer.parseInt(currentIp[i]) & Integer.parseInt(currentNm[i])) + (~Integer.parseInt(currentNm[i]) & Integer.parseInt(incr[i]));
                value[i] = value[i] % 256;
                ++i;
            }
            return String.valueOf(value[0]) + "." + value[1] + "." + value[2] + "." + value[3];
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean checkCompatibility(List<Product> productList, String ipAddress, String increment, String subnetMask, String gateway) {
        int result;
        String currentIp = null;
        int sameNetwork = -1;
        boolean warning = false;
        int j = 0;
        while (j < productList.size()) {
            String currentNm;
            String currentGw;
            Parameter param;
            currentIp = ipAddress == null ? (String)productList.get(j).getParam(Oid.IP_ADDRESS).getValue() : (j == 0 ? ipAddress : ConfigDialog2.calculNextIp(currentIp, increment));
            int ip = IpComparator.toInteger(currentIp);
            if (gateway == null) {
                param = productList.get(j).getParam(Oid.GATEWAY);
                String string = currentGw = param == null ? null : (String)param.getValue();
                if (currentGw == null) {
                    currentGw = "0.0.0.0";
                }
            } else {
                currentGw = gateway;
            }
            if (subnetMask == null) {
                param = productList.get(j).getParam(Oid.SUBNET_MASK);
                String string = currentNm = param == null ? null : (String)param.getValue();
                if (currentNm == null) {
                    currentNm = (ip & Integer.MIN_VALUE) == 0 ? "255.0.0.0" : ((ip & 0x40000000) == 0 ? "255.255.0.0" : "255.255.255.0");
                }
            } else {
                currentNm = subnetMask;
            }
            int gw = IpComparator.toInteger(currentGw);
            int nm = IpComparator.toInteger(currentNm);
            if ((ip | nm) == -1) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if ((ip & ~nm) == 0) {
                JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_IP.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                return false;
            }
            if (gw != 0) {
                if ((ip & nm) != (gw & nm)) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.IP_GW_DIFFERENT_NETWORK.get()) + "\r\n" + TranslateEnum.COLUMN_IP_ADDRESS.get() + " : " + currentIp + "\r\n" + TranslateEnum.DEFAULT_GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
                if ((gw & ~nm) == 0) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.NETWORK_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
                if ((gw | nm) == -1) {
                    JOptionPane.showMessageDialog(null, String.valueOf(TranslateEnum.BROADCAST_GATEWAY.get()) + "\r\n" + TranslateEnum.GATEWAY.get() + " : " + currentGw + "\r\n" + TranslateEnum.SUBNET_MASK.get() + " : " + currentNm, TranslateEnum.ERROR.get(), 0);
                    return false;
                }
            }
            int isSameNetwork = ip & nm;
            if (sameNetwork == -1) {
                sameNetwork = isSameNetwork;
            } else if (sameNetwork != isSameNetwork) {
                warning = true;
            }
            ++j;
        }
        return !warning || (result = JOptionPane.showConfirmDialog(null, TranslateEnum.DIFFERENT_NETWORK.get(), TranslateEnum.WARNING.get(), 2)) == 0;
    }
}

