/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.MibParser;
import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.ig.ProductTreeCellRenderer;
import fr.acksys.ndm.ig.ProductTreeNode;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.ig.TableProductModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ConnectionPanel
extends JPanel
implements RefreshableInterface {
    private static final long serialVersionUID = -5937820141676939099L;
    private TableProductModel productModel;
    private DefaultTreeModel treeModel;
    public JTree tree;
    public ProductTreeNode root = new ProductTreeNode(TranslateEnum.ALL_PRODUCTS.get());
    private static ProductManager pm_conePanel = ProductManager.getInstance();
    private static String macBSSID;
    private static String name_AP;
    private ProductTreeNode allAp = new ProductTreeNode(TranslateEnum.ACCESS_POINTS.get()){
        private static final long serialVersionUID = 4743151978645623214L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private ProductTreeNode bridge = new ProductTreeNode(TranslateEnum.INFRASTRUCTURE_STATION.get()){
        private static final long serialVersionUID = 8501926817459543369L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private ProductTreeNode adHoc = new ProductTreeNode(TranslateEnum.ADHOC_STATION.get()){
        private static final long serialVersionUID = -1476413942177815724L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private ProductTreeNode Mesh = new ProductTreeNode(TranslateEnum.Mesh_STATION.get()){
        private static final long serialVersionUID = 6766952461308738713L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private ProductTreeNode multifunction = new ProductTreeNode(TranslateEnum.CAT_MULTIFUNCTION.get()){
        private static final long serialVersionUID = 8552264200983622946L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };
    private ProductTreeNode others = new ProductTreeNode(TranslateEnum.CAT_OTHERS.get()){
        private static final long serialVersionUID = 8552264200983622946L;

        @Override
        public boolean isLeaf() {
            return false;
        }
    };

    static {
        name_AP = "";
    }

    public ConnectionPanel(TableProductModel productModel) {
        this.productModel = productModel;
        this.setLayout(new BorderLayout());
        this.treeModel = new DefaultTreeModel(this.root);
        this.treeModel.insertNodeInto(this.allAp, this.root, 0);
        this.treeModel.insertNodeInto(this.bridge, this.root, 1);
        this.treeModel.insertNodeInto(this.adHoc, this.root, 2);
        this.treeModel.insertNodeInto(this.Mesh, this.root, 3);
        this.treeModel.insertNodeInto(this.multifunction, this.root, 4);
        this.treeModel.insertNodeInto(this.others, this.root, 5);
        this.tree = new JTree(this.treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setSelectionPath(new TreePath(this.root));
        this.tree.setCellRenderer(new ProductTreeCellRenderer());
        this.tree.setOpaque(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ConnectionPanel.this.updateTreeView();
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setOpaque(false);
        scrollPane.getViewport().setOpaque(false);
        this.add((Component)scrollPane, "Center");
    }

    public void updateTreeView() {
        TreePath treePath = this.tree.getSelectionPath();
        if (treePath == null) {
            treePath = new TreePath(this.root);
        }
        ProductManager.getInstance().iterateManagedProductsInGUIThread(new NdmCallback(){

            @Override
            public void callback(Object ob) {
                ((Product)ob).setSelectedInTreeState(false);
            }
        });
        this.productModel.refreshClearList();
        ProductTreeNode node = (ProductTreeNode)treePath.getLastPathComponent();
        this.addAllLeaf(node);
    }

    private void addAllLeaf(ProductTreeNode node) {
        Product product = node.getProduct();
        if (node.isLeaf()) {
            if (product != null) {
                product.setSelectedInTreeState(true);
                this.productModel.refreshAdd(product);
                return;
            }
        } else {
            if (product != null && node.getParent() == this.bridge) {
                product.setSelectedInTreeState(true);
                this.productModel.refreshAdd(product);
                return;
            }
            Enumeration<TreeNode> enu = node.children();
            while (enu.hasMoreElements()) {
                this.addAllLeaf((ProductTreeNode)enu.nextElement());
            }
        }
    }

    private void addNode(ProductTreeNode productNode, ProductTreeNode node, int index, boolean insertInTable) {
        this.treeModel.insertNodeInto(productNode, node, index);
        Product product = productNode.getProduct();
        if (product == null) {
            return;
        }
        if (this.tree.getSelectionPath() != null) {
            String selectedSubtree = this.tree.getSelectionPath().getLastPathComponent().toString();
            ProductTreeNode tmpNode = node;
            while (!selectedSubtree.equals(tmpNode.toString())) {
                if ((tmpNode = (ProductTreeNode)tmpNode.getParent()) != null) continue;
                return;
            }
        }
        product.setSelectedInTreeState(true);
        if (insertInTable) {
            this.productModel.refreshAdd(product);
        }
        this.tree.repaint();
    }

    @Override
    public void refreshAdd(Product product) {
        this.insertInTree(product, true);
    }

    private void insertInTree(Product product, boolean insertInTable) {
        ProductTreeNode productNode = new ProductTreeNode(product);
        if (!product.canMultifunction || product.getmaxWlans() == 1) {
            switch (product.getCurrentWirelessRole()) {
                default: {
                    this.addNode(productNode, this.allAp, 0, insertInTable);
                    this.updateAssocName(productNode);
                    return;
                }
                case 6: {
                    this.addNode(productNode, this.Mesh, 0, insertInTable);
                    return;
                }
                case 0: {
                    this.updateAssocName(productNode);
                    this.addNode(productNode, this.others, 0, insertInTable);
                    return;
                }
                case 3: {
                    String val_IBSSID = !product.canMultifunction ? (String)product.getParam(Oid.WIFI_SSID).getValue() : (String)product.parameters.get(Oid.ASSOC_TABLE).getParameterValue(Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BSSID)).getValue(0);
                    int i = 0;
                    while (i < this.adHoc.getChildCount()) {
                        ProductTreeNode child = (ProductTreeNode)this.adHoc.getChildAt(i);
                        int assoIndex = child.toString().indexOf(TranslateEnum.ASSOCIATED_TO.get());
                        if (assoIndex != -1) {
                            int textLength = child.toString().length();
                            String ibssidChild = child.toString().substring(textLength - 18, textLength - 1);
                            if (ibssidChild.equalsIgnoreCase(val_IBSSID)) {
                                this.addNode(productNode, child, 0, insertInTable);
                                return;
                            }
                        }
                        ++i;
                    }
                    String newNodeName = String.valueOf(TranslateEnum.ASSOCIATED_TO.get()) + "(" + val_IBSSID + ")";
                    ProductTreeNode newIBSSID = new ProductTreeNode(newNodeName);
                    this.addNode(newIBSSID, this.adHoc, 0, false);
                    this.addNode(productNode, newIBSSID, 0, insertInTable);
                    return;
                }
                case 2: 
                case 7: 
            }
            int bridgeStatus = product.parameters.getPositiveValue(Oid.WIFI_BRIDGE_STATUS);
            if (bridgeStatus == 2) {
                int i = 0;
                while (i < this.bridge.getChildCount()) {
                    ProductTreeNode child = (ProductTreeNode)this.bridge.getChildAt(i);
                    int unassoIndex = child.toString().indexOf(TranslateEnum.UNASSOCIATED.get());
                    if (unassoIndex != -1) {
                        this.addNode(productNode, child, 0, insertInTable);
                        return;
                    }
                    ++i;
                }
                ProductTreeNode unassociated = new ProductTreeNode(TranslateEnum.UNASSOCIATED.get());
                this.addNode(unassociated, this.bridge, 0, false);
                this.addNode(productNode, unassociated, 0, insertInTable);
                return;
            }
            if (bridgeStatus == 1) {
                macBSSID = (String)product.getParam(Oid.WIFI_BRIDGE_MAC_AP).getValue();
                int childCount = this.bridge.getChildCount();
                int i = 0;
                while (i < childCount) {
                    ProductTreeNode child = (ProductTreeNode)this.bridge.getChildAt(i);
                    int macIndex = child.toString().indexOf(TranslateEnum.ASSOCIATED_TO.get());
                    if (macIndex != -1) {
                        int textLength = child.toString().length();
                        String macChild = child.toString().substring(textLength - 18, textLength - 1);
                        if (macChild.equalsIgnoreCase(macBSSID)) {
                            this.addNode(productNode, child, 0, insertInTable);
                            return;
                        }
                    }
                    ++i;
                }
                pm_conePanel.iterateManagedProductsInGUIThread(new NdmCallback(){

                    @Override
                    public void callback(Object ob) {
                        Product prod = (Product)ob;
                        if (!prod.canMultifunction) {
                            String macAddress = prod.getUniqueIdString();
                            if (macAddress.equalsIgnoreCase(macBSSID)) {
                                name_AP = prod.toDisplayMac();
                            }
                        } else {
                            Parameter assoc = prod.parameters.get(Oid.ASSOC_TABLE);
                            int assocRoleIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_ROLE);
                            Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
                            int maxRole = assoc.getParameterValue(assocRoleIndex).rowCount();
                            int k = 0;
                            while (k < maxRole) {
                                String macAddress;
                                if (MibParser.getIntValue(assocrole, k) == 1 && (macAddress = (String)assoc.getParameterValue(Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BSSID)).getValue(k)).equalsIgnoreCase(macBSSID)) {
                                    name_AP = prod.toDisplayMac();
                                }
                                ++k;
                            }
                        }
                    }
                });
                String newNodeName = String.valueOf(TranslateEnum.ASSOCIATED_TO.get()) + name_AP + " (" + macBSSID + ")";
                ProductTreeNode newAp = new ProductTreeNode(newNodeName);
                this.addNode(newAp, this.bridge, 0, false);
                this.addNode(productNode, newAp, 0, insertInTable);
                return;
            }
            this.addNode(productNode, this.others, 0, insertInTable);
            this.updateAssocName(productNode);
            return;
        }
        this.addNode(productNode, this.multifunction, 0, insertInTable);
    }

    private void updateAssocName(ProductTreeNode productNode) {
        Product product = productNode.getProduct();
        String mac = product.getUniqueIdString();
        int i = 0;
        while (i < this.bridge.getChildCount()) {
            int textLength;
            String macChild;
            ProductTreeNode child = (ProductTreeNode)this.bridge.getChildAt(i);
            String currentChildName = child.toString();
            int macIndex = currentChildName.indexOf(TranslateEnum.ASSOCIATED_TO.get());
            if (macIndex != -1 && (macChild = currentChildName.substring((textLength = currentChildName.length()) - 18, textLength - 1)).equalsIgnoreCase(mac)) {
                String name = product.toDisplayMac();
                child.changeName(String.valueOf(TranslateEnum.ASSOCIATED_TO.get()) + name + " (" + mac.toUpperCase() + ")");
                break;
            }
            ++i;
        }
    }

    @Override
    public void refreshClearList() {
        this.allAp.removeAllChildren();
        this.adHoc.removeAllChildren();
        this.bridge.removeAllChildren();
        this.Mesh.removeAllChildren();
        this.multifunction.removeAllChildren();
        this.others.removeAllChildren();
        this.treeModel.reload();
        this.tree.setSelectionPath(new TreePath(this.root));
    }

    @Override
    public void refreshProduct(Product product) {
        this.removeFromTree(product, false);
        this.insertInTree(product, false);
        this.productModel.refreshProduct(product);
    }

    @Override
    public void refreshRemove(Product product) {
        this.removeFromTree(product, true);
    }

    private void removeFromTree(Product product, boolean removeFromTable) {
        MutableTreeNode child;
        String mac = product.getUniqueIdString();
        product.setSelectedInTreeState(false);
        this.removeFromNode(mac, this.allAp, removeFromTable);
        this.removeFromNode(mac, this.Mesh, removeFromTable);
        this.removeFromNode(mac, this.multifunction, removeFromTable);
        this.removeFromNode(mac, this.others, removeFromTable);
        int childCount = this.bridge.getChildCount();
        int i = 0;
        while (i < childCount) {
            child = (MutableTreeNode)this.bridge.getChildAt(i);
            this.removeFromNode(mac, child, removeFromTable);
            if (child.getChildCount() == 0 && !child.toString().equals(TranslateEnum.UNASSOCIATED.get())) {
                this.bridge.remove(child);
                this.treeModel.reload(this.bridge);
                --i;
                --childCount;
            }
            ++i;
        }
        int adHocCount = this.adHoc.getChildCount();
        int j = 0;
        while (j < adHocCount) {
            child = (MutableTreeNode)this.adHoc.getChildAt(j);
            this.removeFromNode(mac, child, removeFromTable);
            if (child.getChildCount() == 0) {
                this.adHoc.remove(child);
                this.treeModel.reload(this.adHoc);
                --j;
                --adHocCount;
            }
            ++j;
        }
        this.tree.repaint();
        if (this.tree.getSelectionPath() == null) {
            this.tree.setSelectionPath(new TreePath(this.root));
        }
    }

    private void removeFromNode(String mac, MutableTreeNode node, boolean removeFromTable) {
        int childCount = node.getChildCount();
        int i = 0;
        while (i < childCount) {
            int length = node.getChildAt(i).toString().length();
            if (length < 18) {
                return;
            }
            if (mac.equalsIgnoreCase(node.getChildAt(i).toString().substring(length - 18, length - 1))) {
                Product product = ((ProductTreeNode)node.getChildAt(i)).getProduct();
                node.remove(i);
                if (product != null && removeFromTable) {
                    this.productModel.refreshRemove(product);
                }
                this.treeModel.reload(node);
                return;
            }
            ++i;
        }
    }

    public void updateNodeLocation() {
        ArrayList<Product> productList = new ArrayList<Product>();
        int childCount = this.bridge.getChildCount();
        int i = 0;
        while (i < childCount) {
            MutableTreeNode child = (MutableTreeNode)this.bridge.getChildAt(i);
            int childCount2 = child.getChildCount();
            int j = 0;
            while (j < childCount2) {
                ProductTreeNode productNode = (ProductTreeNode)child.getChildAt(j);
                Product product = productNode.getProduct();
                if (product.peerHasChangedAutoReset()) {
                    productList.add(product);
                }
                ++j;
            }
            ++i;
        }
        for (Product product : productList) {
            this.refreshRemove(product);
            this.refreshAdd(product);
        }
    }

    public void updateNodeLocation_CAT() {
        ArrayList<Product> productList = new ArrayList<Product>();
        int childCount = this.bridge.getChildCount();
        int i = 0;
        while (i < childCount) {
            ProductTreeNode child = (ProductTreeNode)this.bridge.getChildAt(i);
            Product product = child.getProduct();
            if (product.peerHasChangedAutoReset()) {
                productList.add(product);
            }
            ++i;
        }
        for (Product product : productList) {
            this.refreshRemove(product);
            this.refreshAdd(product);
        }
    }
}

