/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.ig.ImageNdm;
import fr.acksys.ndm.product.ProductModel;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.ImageIcon;

public class ImageManager {
    public static ImageNdm LOGO;
    public static ImageNdm ICON;
    public static ImageNdm ABOUT;
    public static ImageNdm IPCONFIG;
    public static ImageNdm UPGRADE;
    public static ImageNdm WEB;
    public static ImageNdm REFRESH;
    public static ImageNdm TREE_LEAF;
    public static ImageNdm TREE_NODE;
    public static ImageNdm TREE_NODE2;
    public static ImageNdm TRACE;
    public static ImageNdm EDIT;
    public static ImageNdm APPLY;
    public static ImageNdm LOAD;
    public static ImageNdm LOADREFRESH;
    public static ImageNdm INFO;
    private static Map<String, ImageNdm> mapImage;
    private static int maxHeight;
    private static ImageNdm[] rssiIcons;

    static {
        mapImage = null;
        maxHeight = 0;
        rssiIcons = new ImageNdm[11];
    }

    private ImageManager() {
    }

    public static void initMapImage() {
        if (mapImage == null) {
            mapImage = new HashMap<String, ImageNdm>();
            ProductModel[] productModelArray = ProductModel.values();
            int n = productModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProductModel brand = productModelArray[n2];
                int height = new ImageNdm(brand.id, brand.iconFileName).getImageIcon().getIconHeight();
                if (height > maxHeight) {
                    maxHeight = height;
                }
                ++n2;
            }
            Set<String> keySet = mapImage.keySet();
            Iterator<String> it = keySet.iterator();
            while (it.hasNext()) {
                int height = mapImage.get(it.next()).getImageIcon().getIconHeight();
                if (height <= maxHeight) continue;
                maxHeight = height;
            }
            LOGO = new ImageNdm(0, "fr/acksys/custom/logo.png");
            ICON = new ImageNdm(0, "fr/acksys/img/icon.png");
            ABOUT = new ImageNdm(0, "fr/acksys/custom/about.png");
            IPCONFIG = new ImageNdm(1, "ipconfig.png");
            UPGRADE = new ImageNdm(1, "upgrade.png");
            WEB = new ImageNdm(1, "explorer.png");
            REFRESH = new ImageNdm(1, "refresh.png");
            TREE_LEAF = new ImageNdm(1, "leaf.png");
            TREE_NODE = new ImageNdm(1, "node.png");
            TREE_NODE2 = new ImageNdm(1, "node2.png");
            TRACE = new ImageNdm(1, "trace.png");
            APPLY = new ImageNdm(1, "apply.png");
            EDIT = new ImageNdm(1, "edit.png");
            LOAD = new ImageNdm(1, "load.gif");
            LOADREFRESH = new ImageNdm(1, "load-refresh.gif");
            INFO = new ImageNdm(1, "info.png");
            ImageManager.rssiIcons[0] = new ImageNdm(2, "0.png");
            ImageManager.rssiIcons[1] = new ImageNdm(2, "1.png");
            ImageManager.rssiIcons[2] = new ImageNdm(2, "2.png");
            ImageManager.rssiIcons[3] = new ImageNdm(2, "3.png");
            ImageManager.rssiIcons[4] = new ImageNdm(2, "4.png");
            ImageManager.rssiIcons[5] = new ImageNdm(2, "5.png");
            ImageManager.rssiIcons[6] = new ImageNdm(2, "6.png");
            ImageManager.rssiIcons[7] = new ImageNdm(2, "7.png");
            ImageManager.rssiIcons[8] = new ImageNdm(2, "8.png");
            ImageManager.rssiIcons[9] = new ImageNdm(2, "9.png");
            ImageManager.rssiIcons[10] = new ImageNdm(2, "10.png");
        }
    }

    public static void addImage(String key, ImageNdm img) {
        mapImage.put(key, img);
    }

    public static Map<String, ImageNdm> getInstance() {
        return mapImage;
    }

    public static int getMaxHeight() {
        return maxHeight;
    }

    public static ImageIcon getImageIcon(String imageCode) {
        ImageNdm a = mapImage.get(imageCode);
        if (a == null) {
            System.out.println("get code=" + imageCode + " imageNdm=" + a);
        }
        return mapImage.get(imageCode).getImageIcon();
    }

    public static String getImageUrlString(String imageCode) {
        return mapImage.get(imageCode).getImageUrlString();
    }

    public static String getRssiUrlString(int rssi) {
        int percent = rssi;
        if (rssi < 0) {
            int signal = rssi;
            int sig_upper_limit = -40;
            int sig_lower_limit = -110;
            if (rssi > sig_upper_limit) {
                signal = sig_upper_limit;
            } else if (rssi < sig_lower_limit) {
                signal = sig_lower_limit;
            }
            percent = (signal - sig_lower_limit) * 100 / (sig_upper_limit - sig_lower_limit);
        }
        return rssiIcons[(percent + 9) / 10].getImageUrlString();
    }

    public static ImageIcon getRssiImageIcon(int percent) {
        return rssiIcons[(percent + 9) / 10].getImageIcon();
    }
}

