/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import java.util.Comparator;

public class IpComparator
implements Comparator<String> {
    @Override
    public int compare(String o1, String o2) {
        int int2;
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String[] strings1 = o1.split("\\.");
        String[] strings2 = o2.split("\\.");
        int int1 = Integer.parseInt(strings1[0]);
        if (int1 != (int2 = Integer.parseInt(strings2[0]))) {
            return int1 - int2;
        }
        int1 = Integer.parseInt(strings1[1]);
        if (int1 != (int2 = Integer.parseInt(strings2[1]))) {
            return int1 - int2;
        }
        int1 = Integer.parseInt(strings1[2]);
        if (int1 != (int2 = Integer.parseInt(strings2[2]))) {
            return int1 - int2;
        }
        int1 = Integer.parseInt(strings1[3]);
        int2 = Integer.parseInt(strings2[3]);
        return int1 - int2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidIp(String ipAddress) {
        if (ipAddress == null) {
            return false;
        }
        String[] text = ipAddress.split("\\.");
        if (text.length != 4) {
            return false;
        }
        try {
            String[] stringArray = text;
            int n = text.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                String s = stringArray[n2];
                int val = Integer.parseInt(s);
                if (val < 0) return false;
                if (val > 255) {
                    return false;
                }
                ++n2;
            }
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static Integer toInteger(String legalIpV4Address) {
        String[] ipStr;
        if (legalIpV4Address == null) {
            legalIpV4Address = "0.0.0.0";
        }
        if ((ipStr = legalIpV4Address.split("\\.")).length != 4) {
            ipStr = (String.valueOf(legalIpV4Address) + ".0.0.0.0").split("\\.");
        }
        return Integer.parseInt(ipStr[0]) << 24 | Integer.parseInt(ipStr[1]) << 16 | Integer.parseInt(ipStr[2]) << 8 | Integer.parseInt(ipStr[3]) << 0;
    }
}

