/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.AboutDialog;
import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.ColumnMenu;
import fr.acksys.ndm.ig.ConfigDialog2;
import fr.acksys.ndm.ig.ConfigProgressThread;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.PreferencesDialog;
import fr.acksys.ndm.ig.RememberExitDialog;
import fr.acksys.ndm.ig.TableHeaderRenderer;
import fr.acksys.ndm.ig.TableProductModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.config.ConfigThread;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.udap.UdapSocket;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableColumn;

public class ListenerFactory {
    static int compt_error;

    public static ActionListener getListener(TranslateEnum btnCode, JFrame frame, JTable table) {
        switch (btnCode) {
            default: {
                return ListenerFactory.getPreferencesListener(frame);
            }
            case MENU_SELECT_ALL: {
                return ListenerFactory.getSelectAllListener(table);
            }
            case MENU_UNSELECT_ALL: {
                return ListenerFactory.getUnselectAllListener(table);
            }
            case MENU_REVERSE_SELECTION: {
                return ListenerFactory.getReverseSelectionListener(table);
            }
            case MENU_ALL_AP: {
                return ListenerFactory.getSelectAllApListener(table);
            }
            case MENU_ALL_BRIDGE: {
                return ListenerFactory.getSelectAllBridgeListener(table);
            }
            case MENU_ABOUT: 
        }
        return ListenerFactory.getAboutListener(frame);
    }

    private static ActionListener getSelectAllListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.selectAll();
            }
        };
    }

    private static ActionListener getUnselectAllListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.clearSelection();
            }
        };
    }

    private static ActionListener getReverseSelectionListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selectedlines = table.getSelectedRows();
                table.selectAll();
                int[] nArray = selectedlines;
                int n = selectedlines.length;
                int n2 = 0;
                while (n2 < n) {
                    int line = nArray[n2];
                    table.removeRowSelectionInterval(line, line);
                    ++n2;
                }
            }
        };
    }

    private static ActionListener getSelectAllApListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.clearSelection();
                int fonctionIndex = 2;
                int i = 0;
                while (i < table.getColumnCount()) {
                    if (TranslateEnum.COLUMN_FUNCTION.get().equals(table.getColumnName(i))) {
                        fonctionIndex = i;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < table.getRowCount()) {
                    if (table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_AP.get()) || table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_WDS_REPEATER.get()) || table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_AP_CA.get())) {
                        table.addRowSelectionInterval(i, i);
                    }
                    ++i;
                }
            }
        };
    }

    private static ActionListener getSelectAllBridgeListener(final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                table.clearSelection();
                int fonctionIndex = 2;
                int i = 0;
                while (i < table.getColumnCount()) {
                    if (TranslateEnum.COLUMN_FUNCTION.get().equals(table.getColumnName(i))) {
                        fonctionIndex = i;
                        break;
                    }
                    ++i;
                }
                i = 0;
                while (i < table.getRowCount()) {
                    if (table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_BRIDGE_ADHOC.get()) || table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH.get()) || table.getValueAt(i, fonctionIndex).equals(TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH_CA.get())) {
                        table.addRowSelectionInterval(i, i);
                    }
                    ++i;
                }
            }
        };
    }

    private static ActionListener getPreferencesListener(final JFrame frame) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog preferencesDialog = new PreferencesDialog(frame);
                preferencesDialog.setVisible(true);
            }
        };
    }

    private static ActionListener getAboutListener(final JFrame frame) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog aboutFrame = new AboutDialog(frame);
                aboutFrame.setVisible(true);
            }
        };
    }

    public static ActionListener getCancelDialoglListener(final JDialog dialog) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.dispose();
            }
        };
    }

    public static ActionListener getConfigApplyAllListener(final JTable table, final JTextField ipAddress, final JComboBox subnetMask, final JComboBox gateway, final JCheckBox dhcpRadio, final JTextField increment, JButton closeButton, final JCheckBox changeIp, final JCheckBox changeSubnetMask, final JCheckBox changeGateway, final List<Product> selectedProduct, final JTextArea logArea, final JProgressBar progress, final JButton applyButton, final JPasswordField password, final ConfigDialog2 config) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Product> prodList = new ArrayList<Product>();
                String checkIp = null;
                String checkIncrement = null;
                String checkGw = null;
                String checkMask = null;
                int maxConfigTime = 0;
                int[] selectedIndex = table.getSelectedRows();
                boolean dataOk = true;
                if (!dhcpRadio.isSelected()) {
                    if (changeIp.isSelected()) {
                        dataOk = ListenerFactory.isInvalidIp(ipAddress) && dataOk;
                        checkIp = ipAddress.getText();
                        if (selectedIndex.length > 1) {
                            dataOk = ListenerFactory.isInvalidIp(increment) && dataOk;
                            checkIncrement = increment.getText();
                        }
                    }
                    if (changeGateway.isSelected()) {
                        dataOk = ListenerFactory.isInvalidComboIp(gateway) && dataOk;
                        checkGw = (String)gateway.getSelectedItem();
                    }
                    if (changeSubnetMask.isSelected()) {
                        dataOk = ListenerFactory.isInvalidComboIp(subnetMask) && dataOk;
                        checkMask = (String)subnetMask.getSelectedItem();
                    }
                    if (!dataOk) {
                        return;
                    }
                    int i = 0;
                    while (i < selectedIndex.length) {
                        prodList.add((Product)selectedProduct.get(table.convertRowIndexToModel(selectedIndex[i])));
                        ++i;
                    }
                    if (!ConfigDialog2.checkCompatibility(prodList, checkIp, checkIncrement, checkMask, checkGw)) {
                        return;
                    }
                }
                logArea.setText("");
                ipAddress.setBackground(Color.WHITE);
                ipAddress.setForeground(Color.BLACK);
                increment.setBackground(Color.WHITE);
                increment.setForeground(Color.BLACK);
                applyButton.setEnabled(false);
                String nextIp = ipAddress.getText();
                int i = 0;
                while (i < selectedIndex.length) {
                    Product product = (Product)selectedProduct.get(table.convertRowIndexToModel(selectedIndex[i]));
                    if (maxConfigTime < product.getConfigurationTime()) {
                        maxConfigTime = product.getConfigurationTime();
                    }
                    ++i;
                }
                ConfigProgressThread configProgress = new ConfigProgressThread(progress, maxConfigTime, applyButton, selectedIndex.length);
                int i2 = 0;
                while (i2 < selectedIndex.length) {
                    int dhcpValue;
                    Product product = (Product)selectedProduct.get(table.convertRowIndexToModel(selectedIndex[i2]));
                    if (dhcpRadio.isSelected()) {
                        dhcpValue = 2;
                    } else {
                        dhcpValue = 1;
                        if (changeIp.isSelected()) {
                            product.updateParam(Oid.IP_ADDRESS, nextIp);
                        }
                        if (changeSubnetMask.isSelected()) {
                            product.updateParam(Oid.SUBNET_MASK, subnetMask.getSelectedItem());
                        }
                        if (changeGateway.isSelected()) {
                            product.updateParam(Oid.GATEWAY, checkGw);
                            UserParameters userParam = UserParameters.getInstance();
                            if (!Main.gatewayList.contains(checkGw)) {
                                userParam.setParam("GATEWAY_DEFAULT", checkGw);
                            }
                        }
                    }
                    product.updateParam(Oid.DHCP_STATE, dhcpValue);
                    product.setParam(new Parameter(Oid.RESET, 0));
                    product.updateParam(Oid.RESET, 1);
                    if (maxConfigTime < product.getConfigurationTime()) {
                        maxConfigTime = product.getConfigurationTime();
                    }
                    ConfigThread confThread = new ConfigThread(product, logArea, password, configProgress, config);
                    confThread.setName("ConfigThread");
                    confThread.start();
                    if (selectedIndex.length != 1) {
                        nextIp = ConfigDialog2.calculNextIp(nextIp, increment.getText());
                    }
                    ++i2;
                }
                configProgress.setName("ConfigProgressThread");
                configProgress.start();
            }
        };
    }

    protected static boolean isInvalidIp(JTextField ipAddress) {
        if (ipAddress == null) {
            return true;
        }
        if (IpComparator.isValidIp(ipAddress.getText())) {
            ipAddress.setBackground(Color.WHITE);
            ipAddress.setForeground(Color.BLACK);
            return true;
        }
        ipAddress.setBackground(Color.RED);
        ipAddress.setForeground(Color.WHITE);
        return false;
    }

    protected static boolean isInvalidComboIp(JComboBox ipAddress) {
        if (ipAddress == null) {
            return true;
        }
        if (IpComparator.isValidIp((String)ipAddress.getSelectedItem())) {
            ipAddress.setBackground(Color.WHITE);
            ipAddress.setForeground(Color.BLACK);
            return true;
        }
        ipAddress.setBackground(Color.RED);
        ipAddress.setForeground(Color.WHITE);
        return false;
    }

    public static KeyListener getConfigIPListener(final JTextField ipAddress, final JTextField increment, final JLabel incrementLab, final JComboBox subnet, final JComboBox gateway) {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                String ip = ipAddress.getText();
                String subnetMask = (String)subnet.getSelectedItem();
                String[] currentIp = ip.split("\\.");
                incrementLab.setText(ConfigDialog2.calculNextIp(ip, increment.getText()));
                if (currentIp.length != 4) {
                    return;
                }
                int j = 0;
                while (j < 4) {
                    if (currentIp[j].equals("")) {
                        return;
                    }
                    ++j;
                }
                int val_currentIp = Integer.parseInt(currentIp[0]);
                if (val_currentIp < 128) {
                    subnet.setSelectedItem("255.0.0.0");
                } else if (val_currentIp < 192) {
                    subnet.setSelectedItem("255.255.0.0");
                } else if (val_currentIp < 224) {
                    subnet.setSelectedItem("255.255.255.0");
                }
                subnetMask = (String)subnet.getSelectedItem();
                ArrayList<String> gw_buf = new ArrayList<String>();
                for (String gw : ConfigDialog2.autogwList) {
                    if (!UdapSocket.isValideIp(ip, gw, subnetMask)) {
                        gateway.removeItem(gw);
                        String autoGw = ConfigDialog2.calculAutoGw(ip, subnetMask, gw);
                        if (autoGw == null || Main.gatewayList.contains(autoGw) || ConfigDialog2.autogwList.contains(autoGw)) continue;
                        gw_buf.add(autoGw);
                        gateway.addItem(autoGw);
                        continue;
                    }
                    gw_buf.add(gw);
                }
                ConfigDialog2.autogwList.clear();
                for (String gw_b : gw_buf) {
                    ConfigDialog2.autogwList.add(gw_b);
                }
            }
        };
    }

    public static KeyListener getConfigIcrementListener(final JTextField ipAddress, final JTextField increment, final JLabel incrementLab) {
        return new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                incrementLab.setText(ConfigDialog2.calculNextIp(ipAddress.getText(), increment.getText()));
            }
        };
    }

    public static ActionListener getUpgradeBrowseListener(final JTextField fileName, final JDialog parent, final String path) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser firmwareChooser = new JFileChooser(path);
                firmwareChooser.setMultiSelectionEnabled(false);
                FileNameExtensionFilter filter = new FileNameExtensionFilter("Firmware BIN", "bin");
                firmwareChooser.setFileFilter(filter);
                int returnVal = firmwareChooser.showOpenDialog(parent);
                if (returnVal == 0) {
                    String fullPath = firmwareChooser.getCurrentDirectory() + System.getProperty("file.separator") + firmwareChooser.getSelectedFile().getName();
                    fileName.setText(fullPath);
                    UserParameters.getInstance().setParam("FIRMWARE_PATH_VALUE", fullPath);
                }
            }
        };
    }

    public static ActionListener getUpgradeApplyAllListener(final JTable table, final JTextField fileName, final JPasswordField passwordField, final JProgressBar progress, final JButton upgradeButton, final JButton closeButton, final JTextField fileArea, final JButton browse, final JTextArea logArea, final List<Product> selectedList) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread upgradeAll = new Thread(){

                    @Override
                    public void run() {
                        upgradeButton.setEnabled(false);
                        int[] selectedIndex = table.getSelectedRows();
                        ArrayList<Product> prodList = new ArrayList<Product>();
                        compt_error = 0;
                        int i = 0;
                        while (i < selectedIndex.length) {
                            prodList.add((Product)selectedList.get(table.convertRowIndexToModel(selectedIndex[i])));
                            ++i;
                        }
                        for (Product product : prodList) {
                            product.upgrade(fileName.getText(), passwordField.getPassword(), progress, logArea);
                            if (logArea.getText().indexOf(TranslateEnum.UPGRADE_OK.get()) != -1) continue;
                            ++compt_error;
                        }
                        if (compt_error == 0) {
                            JOptionPane.showMessageDialog(null, TranslateEnum.UPGRADE_ALLOK.get(), TranslateEnum.INFORMATION.get(), 1);
                        } else if (compt_error == prodList.size()) {
                            JOptionPane.showMessageDialog(null, TranslateEnum.UPGRADE_ALLFAIL.get(), TranslateEnum.ERROR.get(), 1);
                        } else {
                            JOptionPane.showMessageDialog(null, TranslateEnum.UPGRADE_FAIL.get(), TranslateEnum.ERROR.get(), 1);
                        }
                        upgradeButton.setEnabled(true);
                    }
                };
                upgradeAll.setName("upgradeAll");
                upgradeAll.start();
            }
        };
    }

    public static ChangeListener getPreferencesSpinnerListener(final JSpinner spinner) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)spinner.getValue() < 0) {
                    spinner.setValue(0);
                }
            }
        };
    }

    public static ChangeListener getMAXTraceListener(final JSpinner spinner) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)spinner.getValue() < 0) {
                    spinner.setValue(1);
                }
            }
        };
    }

    public static ChangeListener getIntervalleSpinnerPeriodListener(final JSpinner spinner, final JLabel warningLab) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if ((Integer)spinner.getValue() < 0) {
                    spinner.setValue(0);
                }
                if ((Integer)spinner.getValue() == 0) {
                    warningLab.setForeground(Color.RED);
                } else {
                    warningLab.setForeground(Company.BACK_COLOR);
                }
            }
        };
    }

    public static ChangeListener getPreferencesSpinnerPeriodListener(final JSpinner spinner, final JSpinner spinner2, final JLabel warningLab) {
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int val_spinner = (Integer)spinner.getValue();
                int val_spinner2 = (Integer)spinner2.getValue();
                if (val_spinner < 0) {
                    spinner.setValue(0);
                }
                if (val_spinner == 0 || val_spinner2 == 0) {
                    warningLab.setForeground(Color.RED);
                } else {
                    warningLab.setForeground(Color.BLACK);
                }
            }
        };
    }

    public static ActionListener getConfigChangeIpListener(final JCheckBox changeIp, final JTextField ipAddress, final JTextField increment, final JTable table, final JLabel nextIp) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changeIp.isSelected()) {
                    ipAddress.setEnabled(true);
                    if (table.getSelectedRows().length > 1) {
                        increment.setEnabled(true);
                        nextIp.setEnabled(true);
                    } else {
                        increment.setEnabled(false);
                        nextIp.setEnabled(false);
                    }
                } else {
                    ipAddress.setEnabled(false);
                    increment.setEnabled(false);
                    nextIp.setEnabled(false);
                }
            }
        };
    }

    public static ActionListener getConfigChangeSubnetMaskListener(final JCheckBox changeSubnetMask, final JComboBox subnetMask) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changeSubnetMask.isSelected()) {
                    subnetMask.setEnabled(true);
                } else {
                    subnetMask.setEnabled(false);
                }
            }
        };
    }

    public static ActionListener getConfigChangeGatewayListener(final JCheckBox changeGateway, final JComboBox gateway) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (changeGateway.isSelected()) {
                    gateway.setEnabled(true);
                } else {
                    gateway.setEnabled(false);
                }
            }
        };
    }

    public static ListSelectionListener getConfigTableListener(final List<Product> productList, final JTable table, final ConfigDialog2 config) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selection = table.getSelectedRows();
                ArrayList<Product> selectList = new ArrayList<Product>();
                int i = 0;
                while (i < selection.length) {
                    selectList.add((Product)productList.get(table.convertRowIndexToModel(selection[i])));
                    ++i;
                }
                config.updateIG(selectList);
            }
        };
    }

    public static ListSelectionListener getUpgradeTableListener(List<Product> selectedList, final JTable table, final JButton upgradeButton, final JButton upgradeAllButton) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int[] selection = table.getSelectedRows();
                switch (selection.length) {
                    case 0: {
                        upgradeButton.setEnabled(false);
                        upgradeAllButton.setEnabled(false);
                        break;
                    }
                    case 1: {
                        upgradeButton.setEnabled(true);
                        upgradeAllButton.setEnabled(false);
                        break;
                    }
                    default: {
                        upgradeButton.setEnabled(false);
                        upgradeAllButton.setEnabled(true);
                    }
                }
            }
        };
    }

    public static ActionListener getConfigDhcpRadioListener(final JCheckBox changeIp, final JTextField ipAddress, final JTextField increment, final JLabel nextIpLab, final JCheckBox changeSubnetMask, final JComboBox subnetMask, final JCheckBox changeGateway, final JComboBox gateway) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                changeIp.setEnabled(false);
                ipAddress.setEnabled(false);
                increment.setEnabled(false);
                nextIpLab.setEnabled(false);
                changeSubnetMask.setEnabled(false);
                subnetMask.setEnabled(false);
                changeGateway.setEnabled(false);
                gateway.setEnabled(false);
            }
        };
    }

    public static ActionListener getConfigStaticRadioListener(final JTable table, final JCheckBox changeIp, final JCheckBox changeSubnetMask, final JCheckBox changeGateway, final JTextField ipAddress, final JTextField increment, final JLabel nextIpLab, final JComboBox subnetMask, final JComboBox gateway) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selection = table.getSelectedRows();
                changeIp.setEnabled(true);
                changeSubnetMask.setEnabled(true);
                changeGateway.setEnabled(true);
                if (changeIp.isSelected()) {
                    ipAddress.setEnabled(true);
                } else {
                    ipAddress.setEnabled(false);
                }
                if (changeSubnetMask.isSelected()) {
                    subnetMask.setEnabled(true);
                } else {
                    subnetMask.setEnabled(false);
                }
                if (changeGateway.isSelected()) {
                    gateway.setEnabled(true);
                } else {
                    gateway.setEnabled(false);
                }
                switch (selection.length) {
                    case 0: {
                        increment.setEnabled(false);
                        nextIpLab.setEnabled(false);
                        break;
                    }
                    case 1: {
                        increment.setEnabled(false);
                        nextIpLab.setEnabled(false);
                        break;
                    }
                    default: {
                        if (!changeIp.isSelected()) break;
                        increment.setEnabled(true);
                        nextIpLab.setEnabled(true);
                    }
                }
            }
        };
    }

    public static MouseListener getTableSortListener(final JTable table, final TableProductModel productModel) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 1) {
                    TableHeaderRenderer.setSortIndex(table.getColumnModel().getColumnIndexAtX(e.getX()));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 3) {
                    ColumnMenu popMenu = new ColumnMenu(productModel, table);
                    popMenu.getMenu().show(table, e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    public static RowSorterListener getRowSorterListener() {
        return new RowSorterListener(){

            @Override
            public void sorterChanged(RowSorterEvent e) {
                if (e.getType().equals((Object)RowSorterEvent.Type.SORT_ORDER_CHANGED)) {
                    TableHeaderRenderer.switchSortOrder();
                }
            }
        };
    }

    public static ActionListener getColumnMenuListener(final JCheckBoxMenuItem menu, final int i, final JTable table, TableProductModel productModel) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (menu.isSelected()) {
                    TableColumn col = new TableColumn();
                    col.setModelIndex(i);
                    table.addColumn(col);
                } else {
                    table.removeColumn(table.getColumnModel().getColumn(table.convertColumnIndexToView(i)));
                }
            }
        };
    }

    public static ActionListener getRememberOkListener(final JDialog rememberDialog, final JCheckBox rememberBox, final String parameter) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (rememberBox.isSelected()) {
                    UserParameters.getInstance().setParam(parameter, "1");
                }
                rememberDialog.dispose();
            }
        };
    }

    public static MouseListener getTrayListener(final JFrame frame) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    frame.setVisible(true);
                    frame.setExtendedState(0);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    public static ActionListener getTrayItemListener(final Product product) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!Desktop.isDesktopSupported()) {
                    JOptionPane.showMessageDialog(null, TranslateEnum.MAINFRAME_NO_BROWSER.get(), TranslateEnum.ERROR.get(), 0);
                }
                try {
                    Desktop desktop = Desktop.getDesktop();
                    desktop.browse(new URI("http://" + (String)product.getParam(Oid.IP_ADDRESS).getValue()));
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                catch (URISyntaxException e1) {
                    e1.printStackTrace();
                }
            }
        };
    }

    public static ActionListener getRememberIconListener(final RememberExitDialog rememberExitDialog, final JCheckBox rememberBox) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserParameters.getInstance().setParam("TRAY_ICON_PROG", "1");
                if (rememberBox.isSelected()) {
                    UserParameters.getInstance().setParam("TRAY_CHOICE", "1");
                }
                rememberExitDialog.dispose();
            }
        };
    }

    public static ActionListener getRememberQuitListener(final RememberExitDialog rememberExitDialog, final JCheckBox rememberBox) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserParameters.getInstance().setParam("TRAY_ICON_PROG", "0");
                if (rememberBox.isSelected()) {
                    UserParameters.getInstance().setParam("TRAY_CHOICE", "1");
                }
                rememberExitDialog.dispose();
            }
        };
    }
}

