/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.RefreshAssociationThread;
import fr.acksys.ndm.RefreshProductThread;
import fr.acksys.ndm.SystrayMenu;
import fr.acksys.ndm.TrayIconInfo;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.AssocLabelComparator;
import fr.acksys.ndm.ig.CenterRenderer;
import fr.acksys.ndm.ig.ConnectionPanel;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.LabelRenderer;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MenuNewProductDialog;
import fr.acksys.ndm.ig.NetList;
import fr.acksys.ndm.ig.RememberExitDialog;
import fr.acksys.ndm.ig.StatusBar;
import fr.acksys.ndm.ig.TableCellIpRenderer;
import fr.acksys.ndm.ig.TableCellMacRenderer;
import fr.acksys.ndm.ig.TableHeaderRenderer;
import fr.acksys.ndm.ig.TableProductModel;
import fr.acksys.ndm.ig.UpgradeDialog;
import fr.acksys.ndm.ig.VersionComparator;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.profiles.ProfileDialog;
import fr.acksys.rssi.TraceDialog;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.help.JHelp;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.AbstractBorder;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.tree.TreePath;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = -7312491169391661152L;
    public static final Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    private TableProductModel productModel = new TableProductModel();
    private JTable table;
    private JEditorPane productDetails;
    private JSplitPane splitRightSize;
    private TrayIconInfo systrayTooltip;
    private static RefreshProductThread refreshProductThread;
    private static RefreshAssociationThread refreshRssiThread;
    JMenuItem showdeads;
    private String beta = "";
    public static ConnectionPanel connectPanel;
    public static boolean traceopend;
    private static long timestemp;

    static {
        traceopend = false;
        timestemp = 0L;
    }

    public static RefreshAssociationThread getRefreshRssiThread() {
        return refreshRssiThread;
    }

    public static RefreshProductThread getRefreshProductThread() {
        return refreshProductThread;
    }

    public MainFrame() {
        if (!Company.apropos) {
            this.setTitle("ACKSYS Networking Devices Manager V2.20.2" + this.beta);
        } else {
            this.setTitle("ACKSYS Networking Devices Manager" + this.beta);
        }
        JCheckBox hideSelectionBox = new JCheckBox(TranslateEnum.HIDE_SELECTION.get());
        connectPanel = new ConnectionPanel(this.productModel);
        this.setIconImage(ImageManager.ICON.getImage());
        this.table = new JTable(this.productModel);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        sorter.setComparator(5, new IpComparator());
        sorter.setComparator(7, new VersionComparator());
        sorter.setComparator(6, new AssocLabelComparator());
        this.table.setRowSorter(sorter);
        this.table.setDefaultRenderer(Object.class, new CenterRenderer());
        this.table.setRowHeight(ImageManager.getMaxHeight());
        this.table.setDefaultRenderer(JLabel.class, new LabelRenderer());
        this.table.getTableHeader().addMouseListener(ListenerFactory.getTableSortListener(this.table, this.productModel));
        this.table.getRowSorter().addRowSorterListener(ListenerFactory.getRowSorterListener());
        RowSorter.SortKey[] sortIp = new RowSorter.SortKey[]{new RowSorter.SortKey(4, SortOrder.ASCENDING)};
        sorter.setSortKeys(Arrays.asList(sortIp));
        this.initTableColumn(this.table.getColumnModel());
        JTableHeader tableHeader = this.table.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(0, 25));
        tableHeader.setDefaultRenderer(new TableHeaderRenderer(this.table));
        JScrollPane scrollPane = new JScrollPane(this.table);
        BevelBorder borderTable = new BevelBorder(1);
        scrollPane.setBorder(borderTable);
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu(TranslateEnum.MENU_FILE.get());
        JMenu edit = new JMenu(TranslateEnum.MENU_EDIT.get());
        JMenu help = new JMenu(TranslateEnum.MENU_HELP.get());
        JMenuItem dbNewProduct = new JMenuItem(TranslateEnum.MENU_NEWPROD.get());
        JMenuItem dbUdapProduct = new JMenuItem(TranslateEnum.MENU_UDAPPROD.get());
        JMenuItem dbVacuum = new JMenuItem(TranslateEnum.NEWP_VACUUM.get());
        JMenuItem dbAffiche = new JMenuItem(TranslateEnum.NEWP_NETLIST.get());
        JMenuItem arpVacuum = new JMenuItem(TranslateEnum.MENU_ARPVACUUM.get());
        JMenuItem quit = new JMenuItem(TranslateEnum.MENU_QUIT.get());
        JMenuItem selectAll = new JMenuItem(TranslateEnum.MENU_SELECT_ALL.get());
        JMenuItem unselectAll = new JMenuItem(TranslateEnum.MENU_UNSELECT_ALL.get());
        JMenuItem reverseSelection = new JMenuItem(TranslateEnum.MENU_REVERSE_SELECTION.get());
        JMenuItem allAP = new JMenuItem(TranslateEnum.MENU_ALL_AP.get());
        JMenuItem allBridge = new JMenuItem(TranslateEnum.MENU_ALL_BRIDGE.get());
        JMenuItem multiedit = new JMenuItem(TranslateEnum.MENU_MULTIEDIT.get());
        this.showdeads = new JMenuItem(TranslateEnum.MENU_SHOWDEADS.get());
        JMenuItem preferences = new JMenuItem(TranslateEnum.MENU_PREFERENCES.get());
        JMenuItem about = new JMenuItem(TranslateEnum.MENU_ABOUT.get());
        JLabel logo = new JLabel(ImageManager.LOGO.getImageIcon());
        JButton config = new JButton(TranslateEnum.CONFIGURE_BASIC.get(), ImageManager.IPCONFIG.getImageIcon());
        JButton upgrade = new JButton(TranslateEnum.UPGRADE.get(), ImageManager.UPGRADE.getImageIcon());
        JButton web = new JButton(TranslateEnum.WEB.get(), ImageManager.WEB.getImageIcon());
        JButton refresh = new JButton(TranslateEnum.REFRESH.get(), ImageManager.REFRESH.getImageIcon());
        JButton trace = new JButton(TranslateEnum.RSSI_TRACE.get(), ImageManager.TRACE.getImageIcon());
        JLabel LoadLabel = new JLabel(ImageManager.LOADREFRESH.getImageIcon());
        SystrayMenu systrayMenu = new SystrayMenu(this, this.table);
        URL trayUrl = ClassLoader.getSystemResource("fr/acksys/img/tray.gif");
        Image img = Toolkit.getDefaultToolkit().getImage(trayUrl);
        file.add(dbNewProduct);
        file.add(dbUdapProduct);
        file.add(dbVacuum);
        file.add(dbAffiche);
        file.add(quit);
        edit.add(multiedit);
        edit.add(new JSeparator());
        edit.add(selectAll);
        edit.add(unselectAll);
        edit.add(reverseSelection);
        edit.add(allAP);
        edit.add(allBridge);
        edit.add(new JSeparator());
        edit.add(this.showdeads);
        edit.add(preferences);
        help.add(MainFrame.getJavaHelp());
        help.add(about);
        menuBar.add(file);
        menuBar.add(edit);
        menuBar.add(help);
        about.setVisible(Company.apropos);
        dbNewProduct.addActionListener(this.onNewProduct(1));
        dbUdapProduct.addActionListener(this.onNewProduct(2));
        dbVacuum.addActionListener(this.onVacuum());
        dbAffiche.addActionListener(this.onAffiche(this));
        arpVacuum.addActionListener(this.onArpVacuum());
        quit.addActionListener(this.getQuitListener());
        selectAll.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_SELECT_ALL, this, this.table));
        unselectAll.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_UNSELECT_ALL, this, this.table));
        reverseSelection.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_REVERSE_SELECTION, this, this.table));
        allAP.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_ALL_AP, this, this.table));
        allBridge.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_ALL_BRIDGE, this, this.table));
        this.showdeads.addActionListener(this.onShowDeads());
        preferences.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_PREFERENCES, this, this.table));
        multiedit.addActionListener(this.onMultiEdit());
        about.addActionListener(ListenerFactory.getListener(TranslateEnum.MENU_ABOUT, this, this.table));
        trace.addActionListener(MainFrame.onTraceJButton(this, this.table));
        upgrade.addActionListener(MainFrame.onUpgradeButton(this, this.table));
        config.addActionListener(MainFrame.onConfigButton(this, this.table));
        web.addActionListener(MainFrame.onWebButton(this, this.table));
        this.table.addMouseListener(this.onClickButton(this, this.table));
        this.table.getSelectionModel().addListSelectionListener(this.onReselect(this, this.table));
        refresh.addActionListener(MainFrame.onRefreshButton(this, refresh, LoadLabel));
        hideSelectionBox.addActionListener(MainFrame.onHideBoxButton(this, this.table, hideSelectionBox, this.productModel, connectPanel));
        SpringLayout buttonLayout = new SpringLayout();
        SpringLayout logoLayout = new SpringLayout();
        JPanel buttonPanel = new JPanel(buttonLayout);
        buttonPanel.add(LoadLabel);
        buttonPanel.add(refresh);
        buttonPanel.add(config);
        buttonPanel.add(upgrade);
        buttonPanel.add(web);
        buttonPanel.add(trace);
        buttonPanel.add(hideSelectionBox);
        if (Main.os_name.equals("Linux")) {
            if (Main.language.equals("fr")) {
                buttonPanel.setPreferredSize(new Dimension(825, 79));
            } else {
                buttonPanel.setPreferredSize(new Dimension(780, 79));
            }
        } else if (Main.language.equals("fr")) {
            buttonPanel.setPreferredSize(new Dimension(765, 79));
        } else {
            buttonPanel.setPreferredSize(new Dimension(700, 79));
        }
        buttonLayout.putConstraint("West", (Component)hideSelectionBox, 5, "East", (Component)trace);
        buttonLayout.putConstraint("West", (Component)trace, 5, "East", (Component)web);
        buttonLayout.putConstraint("West", (Component)web, 5, "East", (Component)upgrade);
        buttonLayout.putConstraint("West", (Component)upgrade, 5, "East", (Component)config);
        buttonLayout.putConstraint("West", (Component)config, 5, "East", (Component)refresh);
        buttonLayout.putConstraint("West", (Component)refresh, 5, "East", (Component)LoadLabel);
        buttonLayout.putConstraint("North", (Component)hideSelectionBox, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)trace, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)web, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)upgrade, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)config, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)refresh, 30, "North", (Component)this.getContentPane());
        buttonLayout.putConstraint("North", (Component)LoadLabel, 33, "North", (Component)this.getContentPane());
        JPanel buttonCenterPanel = new JPanel();
        buttonCenterPanel.add(buttonPanel);
        logo.setBackground(Company.BACK_COLOR);
        logo.setOpaque(true);
        JPanel logoPanel = new JPanel(logoLayout);
        logoPanel.setOpaque(false);
        int decalage = 2;
        int logoWidth = ImageManager.LOGO.getImageIcon().getIconWidth();
        int logoHeight = ImageManager.LOGO.getImageIcon().getIconHeight();
        logoPanel.setPreferredSize(new Dimension(logoWidth + decalage, logoHeight));
        logoPanel.setMinimumSize(new Dimension(logoWidth, logoHeight));
        logoPanel.add(logo);
        logoLayout.putConstraint("West", (Component)logo, decalage, "West", (Component)this.getContentPane());
        logoLayout.putConstraint("South", (Component)logo, -25, "South", (Component)this.getContentPane());
        hideSelectionBox.setOpaque(false);
        buttonPanel.setOpaque(false);
        buttonCenterPanel.setOpaque(false);
        buttonCenterPanel.setBackground(Company.BACK_COLOR);
        scrollPane.getViewport().setOpaque(false);
        scrollPane.setOpaque(true);
        LoadLabel.setVisible(false);
        this.productDetails = new JEditorPane();
        this.productDetails.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        this.productDetails.setFont(new Font("normal", 0, 12));
        this.productDetails.setEditable(false);
        this.productDetails.setContentType("text/html");
        this.productDetails.setBackground(Color.WHITE);
        this.productDetails.setOpaque(true);
        this.productDetails.setText(TranslateEnum.DETAILS_NO_SELECTION.get());
        JScrollPane productDetailsScroller = new JScrollPane(this.productDetails);
        this.splitRightSize = new JSplitPane(0, true, scrollPane, productDetailsScroller);
        this.splitRightSize.setOpaque(false);
        MainFrame.setDividerColor(this.splitRightSize, Company.BACK_COLOR);
        ProductManager pm = ProductManager.getInstance();
        pm.registerRefreshIg(connectPanel);
        pm.registerRefreshIg(systrayMenu);
        pm.registerStatusIg(this.productModel);
        pm.registerProductDetailsPane(this.productDetails);
        JSplitPane splitPane = new JSplitPane(1, true, connectPanel, this.splitRightSize);
        splitPane.setOpaque(false);
        MainFrame.setDividerColor(splitPane, Company.BACK_COLOR);
        SpringLayout tableLayout = new SpringLayout();
        JPanel tablePanel = new JPanel(tableLayout);
        tablePanel.setOpaque(false);
        tablePanel.add(splitPane);
        tableLayout.putConstraint("West", (Component)splitPane, 10, "West", (Component)tablePanel);
        tableLayout.putConstraint("East", (Component)splitPane, -10, "East", (Component)tablePanel);
        tableLayout.putConstraint("North", (Component)splitPane, 0, "North", (Component)tablePanel);
        tableLayout.putConstraint("South", (Component)splitPane, -5, "South", (Component)tablePanel);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.setBackground(Company.BACK_COLOR);
        JPanel border = new JPanel();
        border.setOpaque(false);
        border.setLayout(new BorderLayout());
        border.add((Component)logoPanel, "West");
        border.add((Component)buttonCenterPanel, "Center");
        StatusBar statusBar = new StatusBar();
        statusBar.setLayout(new BorderLayout());
        statusBar.setPreferredSize(new Dimension(100, 20));
        statusBar.setBorder(new BevelBorder(1));
        pm.registerRefreshIg(statusBar);
        if (SystemTray.isSupported()) {
            SystemTray sys = SystemTray.getSystemTray();
            this.systrayTooltip = new TrayIconInfo(img, "NDM", systrayMenu);
            pm.registerRefreshIg(this.systrayTooltip);
            this.systrayTooltip.addMouseListener(ListenerFactory.getTrayListener(this));
            try {
                sys.add(this.systrayTooltip);
            }
            catch (AWTException aWTException) {
                // empty catch block
            }
        }
        this.addWindowListener(this.onMainWindow());
        this.setDefaultCloseOperation(0);
        this.setLayout(new BorderLayout());
        this.setJMenuBar(menuBar);
        this.add((Component)tablePanel, "Center");
        this.add((Component)border, "North");
        this.add((Component)statusBar, "South");
        UserParameters userParam = UserParameters.getInstance();
        int screenWidth = Integer.parseInt(userParam.getParam("FRAME_WIDTH_VALUE"));
        int screenHeight = Integer.parseInt(userParam.getParam("FRAME_HEIGHT_VALUE"));
        int xPosition = Integer.parseInt(userParam.getParam("FRAME_X_VALUE"));
        int yPosition = Integer.parseInt(userParam.getParam("FRAME_Y_VALUE"));
        this.setSize(screenWidth, screenHeight);
        this.setMinimumSize(new Dimension(700, 500));
        this.setLocation(xPosition, yPosition);
        int listPeriod = Integer.parseInt(userParam.getParam("LIST_REFRESH_PERIOD"));
        int rssiPeriod = Integer.parseInt(userParam.getParam("RSSI_REFRESH_PERIOD"));
        this.splitRightSize.setDividerLocation(Integer.parseInt(userParam.getParam("DETAILS_HEIGHT_VALUE")));
        refreshProductThread = new RefreshProductThread(1000 * listPeriod);
        refreshRssiThread = new RefreshAssociationThread(1000 * rssiPeriod, this.productModel, connectPanel);
        refreshProductThread.setName("refreshProductThread");
        refreshRssiThread.setName("refreshRssiThread");
        refreshProductThread.start();
        refreshRssiThread.start();
    }

    private void initTableColumn(TableColumnModel model) {
        UserParameters user = UserParameters.getInstance();
        model.getColumn(5).setCellRenderer(new TableCellIpRenderer(this.productModel));
        model.getColumn(4).setCellRenderer(new TableCellMacRenderer(this.productModel));
        int display = 0;
        int i = 0;
        while (i < model.getColumnCount()) {
            model.getColumn(i).setPreferredWidth(Integer.parseInt(user.getParam("COLUMN_WIDTH_" + i)));
            ++i;
        }
        TableColumn[] tabColumn = new TableColumn[model.getColumnCount()];
        ArrayList<TableColumn> hideTabColumn = new ArrayList<TableColumn>();
        int i2 = 0;
        while (i2 < model.getColumnCount()) {
            if (1 == Integer.parseInt(user.getParam("COLUMN_VISIBLE_" + i2))) {
                tabColumn[Integer.parseInt((String)user.getParam((String)new StringBuilder((String)"COLUMN_POSITION_").append((int)i2).toString()))] = model.getColumn(i2);
                ++display;
            } else {
                hideTabColumn.add(model.getColumn(i2));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < model.getColumnCount()) {
            model.removeColumn(tabColumn[i2]);
            if (tabColumn[i2] != null) {
                model.addColumn(tabColumn[i2]);
            }
            ++i2;
        }
        for (TableColumn tableColumn : hideTabColumn) {
            model.removeColumn(tableColumn);
        }
    }

    private static void setDividerColor(JSplitPane splitPane, Color newDividerColor) {
        SplitPaneUI splitUI = splitPane.getUI();
        if (splitUI instanceof BasicSplitPaneUI) {
            int divSize = splitPane.getDividerSize();
            BasicSplitPaneDivider div = ((BasicSplitPaneUI)splitUI).getDivider();
            assert (div != null);
            Border divBorder = div.getBorder();
            AbstractBorder newBorder = null;
            MatteBorder colorBorder = null;
            int insetsh = 0;
            int insetsv = 0;
            if (divBorder != null) {
                Insets i = divBorder.getBorderInsets(div);
                insetsh = i.left + i.right;
                insetsv = i.top + i.bottom;
            }
            colorBorder = BorderFactory.createMatteBorder(divSize - insetsv, divSize - insetsh, 0, 0, newDividerColor);
            newBorder = divBorder == null ? colorBorder : BorderFactory.createCompoundBorder(divBorder, colorBorder);
            div.setBorder(newBorder);
        }
    }

    private ActionListener onNewProduct(final int i) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                new MenuNewProductDialog(i).setVisible(true);
            }
        };
    }

    private ActionListener onVacuum() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NdmDb.Vacuum();
            }
        };
    }

    private ActionListener onAffiche(JFrame frame) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new NetList(null).setVisible(true);
            }
        };
    }

    private ActionListener onArpVacuum() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Main.isWindows()) {
                    Main.exec("arp -d", null);
                } else {
                    Main.exec("sh -c 'for i in `arp -n|sed -n \"/^[0-9]/s/ .*//p\"`; do arp -d $i; done'", null);
                }
            }
        };
    }

    private ActionListener onMultiEdit() {
        final MainFrame owner = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Oid.getOidByOidString("");
                ProfileDialog j = new ProfileDialog(owner);
                j.setVisible(true);
            }
        };
    }

    private ActionListener onShowDeads() {
        final MainFrame owner = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem mi = owner.showdeads;
                if (mi.getText().equals(TranslateEnum.MENU_SHOWDEADS.get())) {
                    ProductManager.getInstance().setShowDeads(true);
                    mi.setText(TranslateEnum.MENU_HIDEDEADS.get());
                } else {
                    ProductManager.getInstance().setShowDeads(false);
                    mi.setText(TranslateEnum.MENU_SHOWDEADS.get());
                }
            }
        };
    }

    private static ActionListener onRefreshButton(JFrame frame, final JButton button, final JLabel LoadLabel) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserParameters userParam = UserParameters.getInstance();
                long timestemp_tmp = System.currentTimeMillis();
                final long snmptimeout = Integer.parseInt(userParam.getParam("SNMP_TIMEOUT_VALUE"));
                MainFrame.connectPanel.tree.setSelectionPath(new TreePath(MainFrame.connectPanel.root));
                if (timestemp_tmp - timestemp > snmptimeout * 2L) {
                    ProductManager.getInstance().rediscoverProductListInGUIThread();
                    button.setEnabled(false);
                    LoadLabel.setVisible(true);
                    timestemp = timestemp_tmp;
                    new Thread(){

                        @Override
                        public void run() {
                            try {
                                timestemp = System.currentTimeMillis();
                                Thread.sleep((int)snmptimeout * 2);
                                button.setEnabled(true);
                                LoadLabel.setVisible(false);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        };
    }

    private static ActionListener onUpgradeButton(final JFrame frame, final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedList = MainFrame.getSelectedItem(frame, table);
                if (selectedList == null) {
                    return;
                }
                ProductManager prodManager = ProductManager.getInstance();
                for (Product prod : selectedList) {
                    if (!prodManager.hasConflictingIp(prod)) continue;
                    MessageFormat form = new MessageFormat(TranslateEnum.IP_CONFLICT.get());
                    Object[] args = new Object[]{(String)prod.getParam(Oid.IP_ADDRESS).getValue()};
                    JOptionPane.showMessageDialog(null, form.format(args), TranslateEnum.ERROR.get(), 0);
                    return;
                }
                UpgradeDialog upgradeFrame = new UpgradeDialog((Frame)frame, selectedList);
                upgradeFrame.setVisible(true);
            }
        };
    }

    private static ActionListener onConfigButton(final JFrame frame, final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List selectedList = MainFrame.getSelectedItem(frame, table);
                if (selectedList == null) {
                    return;
                }
                ((Product)selectedList.get(0)).getbaseconfig(frame, selectedList);
            }
        };
    }

    private static ActionListener onTraceJButton(final JFrame frame, final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Product> selectedList = new ArrayList<Product>();
                ArrayList<Product> modelProductList = ((TableProductModel)table.getModel()).getProductList();
                int[] nArray = table.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int viewRow = nArray[n2];
                    Product Spro = modelProductList.get(table.convertRowIndexToModel(viewRow));
                    selectedList.add(Spro);
                    if (Spro.getCurrentWirelessRole() != 2) {
                        JOptionPane.showMessageDialog(frame, TranslateEnum.SELECT_CLIENT.get(), TranslateEnum.INFORMATION.get(), 1);
                        return;
                    }
                    ++n2;
                }
                if (selectedList.size() == 0) {
                    JOptionPane.showMessageDialog(frame, TranslateEnum.SELECT_0_CLIENT.get(), TranslateEnum.INFORMATION.get(), 1);
                    return;
                }
                if (traceopend) {
                    JOptionPane.showMessageDialog(frame, TranslateEnum.MULTI_RSSI.get(), TranslateEnum.ERROR.get(), 0);
                } else {
                    TraceDialog traceJ = new TraceDialog(frame, selectedList);
                    traceJ.setVisible(true);
                }
            }
        };
    }

    private static void runBrowser(JFrame frame, JTable table) {
        List<Product> selectedList = MainFrame.getSelectedItem(frame, table);
        if (selectedList == null) {
            return;
        }
        if (!Desktop.isDesktopSupported()) {
            JOptionPane.showMessageDialog(frame, TranslateEnum.MAINFRAME_NO_BROWSER.get(), TranslateEnum.ERROR.get(), 0);
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            for (Product prod : selectedList) {
                if (prod.canWebInterface) {
                    desktop.browse(new URI("http://" + prod.getIpString()));
                    continue;
                }
                JOptionPane.showMessageDialog(frame, TranslateEnum.MAINFRAME_NO_HTTP.get(), TranslateEnum.ERROR.get(), 0);
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (URISyntaxException e1) {
            e1.printStackTrace();
        }
    }

    private void displayDetails() {
        ArrayList<Product> modelProductList = ((TableProductModel)this.table.getModel()).getProductList();
        int viewRow = this.table.getSelectedRow();
        if (viewRow >= 0) {
            ProductManager.setProductInDetailsPane(modelProductList.get(this.table.convertRowIndexToModel(viewRow)));
        } else {
            ProductManager.resetProductInDetailsPane(null);
        }
    }

    private static ActionListener onWebButton(final JFrame frame, final JTable table) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainFrame.runBrowser(frame, table);
            }
        };
    }

    private MouseListener onClickButton(final JFrame frame, final JTable table) {
        return new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                switch (e.getClickCount()) {
                    case 1: {
                        ((MainFrame)frame).displayDetails();
                        break;
                    }
                    case 2: {
                        MainFrame.runBrowser(frame, table);
                        break;
                    }
                    case 3: {
                        List selectedList = MainFrame.getSelectedItem(frame, table);
                        if (selectedList == null) {
                            ProductManager.getInstance().dump();
                            break;
                        }
                        for (Product prod : selectedList) {
                            prod.dump();
                        }
                        break;
                    }
                }
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }
        };
    }

    private ListSelectionListener onReselect(final JFrame frame, JTable table) {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent arg0) {
                ((MainFrame)frame).displayDetails();
            }
        };
    }

    private static ActionListener onHideBoxButton(final JFrame frame, final JTable table, final JCheckBox hideSelectionBox, final TableProductModel productModel, final ConnectionPanel connectPanel) {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (hideSelectionBox.isSelected()) {
                    List prodList = MainFrame.getSelectedItem(frame, table);
                    if (prodList == null) {
                        hideSelectionBox.setSelected(false);
                        hideSelectionBox.setText(TranslateEnum.HIDE_SELECTION.get());
                        return;
                    }
                    for (Product prod : prodList) {
                        prod.setUserHideState(true);
                        productModel.refreshRemove(prod);
                    }
                    hideSelectionBox.setText(TranslateEnum.HIDDEN_ITEMS.get());
                } else {
                    ProductManager.getInstance().unsetUserHidden();
                    connectPanel.updateTreeView();
                    hideSelectionBox.setText(TranslateEnum.HIDE_SELECTION.get());
                }
            }
        };
    }

    private static List<Product> getSelectedItem(JFrame frame, JTable table) {
        ArrayList<Product> selectedList = new ArrayList<Product>();
        ArrayList<Product> modelProductList = ((TableProductModel)table.getModel()).getProductList();
        int[] nArray = table.getSelectedRows();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int viewRow = nArray[n2];
            selectedList.add(modelProductList.get(table.convertRowIndexToModel(viewRow)));
            ++n2;
        }
        if (selectedList.size() == 0) {
            JOptionPane.showMessageDialog(frame, TranslateEnum.SELECT_ITEM.get(), TranslateEnum.INFORMATION.get(), 1);
            return null;
        }
        return selectedList;
    }

    private void closeMainWindow() {
        String[] param;
        ArrayList<String[]> paramList = new ArrayList<String[]>();
        TableColumnModel model = this.table.getColumnModel();
        UserParameters userParam = UserParameters.getInstance();
        userParam.setParam("FRAME_X_VALUE", new Integer(this.getX()).toString());
        userParam.setParam("FRAME_Y_VALUE", new Integer(this.getY()).toString());
        userParam.setParam("FRAME_WIDTH_VALUE", new Integer(this.getWidth()).toString());
        userParam.setParam("FRAME_HEIGHT_VALUE", new Integer(this.getHeight()).toString());
        userParam.setParam("DETAILS_HEIGHT_VALUE", new Integer(this.splitRightSize.getDividerLocation()).toString());
        int i = 0;
        while (i < 11) {
            param = new String[]{"COLUMN_VISIBLE_" + i, "0"};
            paramList.add(param);
            ++i;
        }
        userParam.setListParam(paramList);
        paramList.clear();
        i = 0;
        while (i < model.getColumnCount()) {
            int index = -1;
            TableColumn column = model.getColumn(i);
            if (column.getHeaderValue().equals(TranslateEnum.PRODUCT.get())) {
                index = 0;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_MODEL.get())) {
                index = 1;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_FUNCTION.get())) {
                index = 2;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_SYSLOCATION.get())) {
                index = 3;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_MAC_ADDRESS.get())) {
                index = 4;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_IP_ADDRESS.get())) {
                index = 5;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_ASSOCIATE.get())) {
                index = 6;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_FIRMWARE.get())) {
                index = 7;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_SECURITY.get())) {
                index = 8;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_SSID.get())) {
                index = 9;
            }
            if (column.getHeaderValue().equals(TranslateEnum.COLUMN_CHANNEL.get())) {
                index = 10;
            }
            param = new String[]{"COLUMN_POSITION_" + index, new Integer(i).toString()};
            paramList.add(param);
            param = new String[]{"COLUMN_WIDTH_" + index, new Integer(column.getWidth()).toString()};
            paramList.add(param);
            param = new String[]{"COLUMN_VISIBLE_" + index, new Integer(1).toString()};
            paramList.add(param);
            ++i;
        }
        userParam.setListParam(paramList);
        Main.unlock();
    }

    private WindowListener onMainWindow() {
        final MainFrame frame = this;
        return new WindowListener(){

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                if (!UserParameters.getBooleanUserParam("TRAY_CHOICE")) {
                    RememberExitDialog remember = new RememberExitDialog();
                    remember.setVisible(true);
                }
                if (!UserParameters.getBooleanUserParam("TRAY_ICON_PROG")) {
                    Main.snmpmanager.closesnmp();
                    frame.dispose();
                    frame.closeMainWindow();
                    if (SystemTray.isSupported()) {
                        SystemTray sys = SystemTray.getSystemTray();
                        sys.remove(MainFrame.this.systrayTooltip);
                    }
                    System.exit(0);
                } else {
                    frame.setExtendedState(1);
                    frame.setVisible(false);
                }
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowOpened(WindowEvent e) {
            }
        };
    }

    public ActionListener getQuitListener() {
        final MainFrame frame = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UserParameters userParam = UserParameters.getInstance();
                userParam.setParam("FRAME_X_VALUE", new Integer(frame.getX()).toString());
                userParam.setParam("FRAME_Y_VALUE", new Integer(frame.getY()).toString());
                Main.snmpmanager.closesnmp();
                frame.dispose();
                frame.closeMainWindow();
                if (SystemTray.isSupported()) {
                    SystemTray sys = SystemTray.getSystemTray();
                    sys.remove(MainFrame.this.systrayTooltip);
                }
                System.exit(0);
            }
        };
    }

    private static JMenuItem getJavaHelp() {
        JMenuItem mi = null;
        try {
            URL url = ClassLoader.getSystemResource("fr/acksys/help/help.hs");
            HelpSet hs = new HelpSet(null, url);
            HelpBroker hb = hs.createHelpBroker();
            mi = new JMenuItem(TranslateEnum.MENU_HELP.get());
            mi.addActionListener(new CSH.DisplayHelpFromSource(hb));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mi;
    }

    public static void main(String[] args) {
        ImageManager.initMapImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JHelp helpViewer = null;
                try {
                    URL url = ClassLoader.getSystemResource("fr/acksys/help/help.hs");
                    helpViewer = new JHelp(new HelpSet(null, url));
                }
                catch (Exception e) {
                    System.err.println("API Help Set not found" + e.getMessage());
                }
                JFrame frame = new JFrame();
                frame.getContentPane().add(helpViewer);
                frame.setDefaultCloseOperation(2);
                frame.setVisible(true);
            }
        });
    }
}

