/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.discover.DatabaseDiscoverMethod;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.InputFieldIp;
import fr.acksys.ndm.ig.InputFieldMediumText;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.product.OpenWrtProduct;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.ProductModel;
import fr.acksys.ndm.product.WlgProduct;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class MenuNewProductDialog
extends JDialog {
    private static final long serialVersionUID = 3443988896785412951L;
    private final JPanel paneFiller = new JPanel();
    private final JComboBox selectMac = new JComboBox();
    private static String firstMacComboChoice;
    private final JLabel labelMac1 = new JLabel(TranslateEnum.NEWP_MAC.get());
    private final JLabel labelMac2 = new JLabel(TranslateEnum.NEWP_MAC.get());
    private final JLabel labelIp = new JLabel(TranslateEnum.NEWP_IP.get());
    private final JLabel labelSnmpRead = new JLabel(TranslateEnum.NEWP_SNMPREAD.get());
    private static final String defaultCommunity;
    private final JPanel paneFiller2 = new JPanel();
    private final JLabel labelSnmpWrite = new JLabel(TranslateEnum.NEWP_SNMPWRITE.get());
    private final JLabel displayMac = new JLabel();
    private final JTextField inputIp = new InputFieldIp();
    private final JTextField inputSnmpRead = new InputFieldMediumText(10);
    private final JTextField inputSnmpWrite = new InputFieldMediumText(10);
    private final JButton btnFind = new JButton(TranslateEnum.NEWP_BTNFIND.get());
    private final JPanel paneSaveCancel = new JPanel();
    private final JButton btnSave = new JButton(TranslateEnum.NEWP_BTNSAVE.get());
    private final JButton btnDelete = new JButton(TranslateEnum.NEWP_BTNDELETE.get());
    private final JButton btnCancel = new JButton(TranslateEnum.NEWP_BTNCANCEL.get());
    private final JButton btnClearAll = new JButton(TranslateEnum.NEWP_CLEARALL.get());
    private final boolean isRemoteNotLocalListType;

    static {
        defaultCommunity = TranslateEnum.NEWP_DFL_COMMUNITY_CHOICE.get();
    }

    MenuNewProductDialog(int i) {
        this.isRemoteNotLocalListType = i == 1;
        this.paneSaveCancel.add(this.btnSave);
        this.btnSave.addActionListener(this.onSave());
        this.paneSaveCancel.add(this.btnDelete);
        this.btnDelete.addActionListener(this.onDelete());
        this.paneSaveCancel.add(this.btnCancel);
        this.btnCancel.addActionListener(this.onWindowCancel());
        this.paneSaveCancel.add(this.btnClearAll);
        this.btnClearAll.addActionListener(this.onClearAll());
        JPanel all = new JPanel(new GridBagLayout());
        GridBagConstraints cLabels = new GridBagConstraints();
        GridBagConstraints cInputs = new GridBagConstraints();
        GridBagConstraints cInputMore = new GridBagConstraints();
        GridBagConstraints cButtons = new GridBagConstraints();
        cLabels.gridx = 0;
        cLabels.gridy = -1;
        cLabels.weightx = 0.5;
        cLabels.anchor = 22;
        cLabels.insets = new Insets(3, 5, 0, 5);
        cInputs.gridx = 1;
        cInputs.gridy = -1;
        cInputs.weightx = 0.5;
        cInputs.anchor = 21;
        cInputs.insets = new Insets(3, 5, 0, 5);
        cButtons.gridx = 0;
        cButtons.gridwidth = 0;
        cButtons.insets = new Insets(5, 0, 5, 0);
        cInputMore.gridx = 2;
        cInputMore.gridy = 3;
        cInputMore.weightx = 0.5;
        cInputMore.anchor = 21;
        cInputMore.insets = new Insets(3, 5, 0, 5);
        all.add((Component)this.labelMac1, cLabels);
        all.add((Component)this.selectMac, cInputs);
        all.add((Component)this.paneFiller, cButtons);
        all.add((Component)this.labelIp, cLabels);
        all.add((Component)this.inputIp, cInputs);
        all.add((Component)this.labelSnmpRead, cLabels);
        all.add((Component)this.inputSnmpRead, cInputs);
        if (this.isRemoteNotLocalListType) {
            all.add((Component)this.btnFind, cInputMore);
            this.btnFind.addActionListener(this.onFind());
        }
        all.add((Component)this.paneFiller2, cButtons);
        all.add((Component)this.labelMac2, cLabels);
        all.add((Component)this.displayMac, cInputs);
        all.add((Component)this.labelSnmpWrite, cLabels);
        all.add((Component)this.inputSnmpWrite, cInputs);
        all.add((Component)this.paneSaveCancel, cButtons);
        all.setOpaque(false);
        this.paneFiller.setOpaque(false);
        this.paneFiller2.setOpaque(false);
        this.paneSaveCancel.setOpaque(false);
        this.add(all);
        this.setModal(true);
        IgUtils.SetIconImage(this);
        if (this.isRemoteNotLocalListType) {
            this.setTitle(TranslateEnum.NEWP_TITLE.get());
            firstMacComboChoice = TranslateEnum.NEWP_NEWLABEL.get();
        } else {
            this.setTitle(TranslateEnum.NEWP_UDAPTITLE.get());
            firstMacComboChoice = TranslateEnum.NEWP_EMPTYLABEL.get();
        }
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        Dimension dim = this.getPreferredSize();
        this.setSize((int)((double)dim.width * 1.5), dim.height);
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
        this.addWindowListener(this.onClose());
        this.reloadList(this.selectMac, null);
    }

    private void doInitState(String choix) {
        if (choix == null) {
            this.inputIp.setText("");
            this.inputSnmpRead.setText(defaultCommunity);
            this.inputSnmpWrite.setText(defaultCommunity);
            this.displayMac.setText(firstMacComboChoice);
            this.btnFind.setEnabled(this.isRemoteNotLocalListType);
            this.btnSave.setEnabled(false);
            this.btnDelete.setEnabled(false);
        } else {
            Product p = ProductManager.getInstance().getProductByMacInGUIThread(choix);
            this.inputIp.setText(p.parameters.getStringValue(Oid.IP_ADDRESS));
            this.inputSnmpRead.setText(p.isDefaultCommunityRead() ? defaultCommunity : p.getCommunityRead());
            this.inputSnmpWrite.setText(p.isDefaultCommunityWrite() ? defaultCommunity : p.getCommunityWrite());
            this.displayMac.setText(choix);
            this.btnFind.setEnabled(false);
            this.btnSave.setEnabled(true);
            this.btnDelete.setEnabled(true);
        }
        this.btnClearAll.setEnabled(true);
        this.inputIp.setEnabled(this.isRemoteNotLocalListType);
    }

    public void reloadList(JComboBox combo, String current) {
        ActionListener[] actionListenerArray = combo.getActionListeners();
        int n = actionListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ActionListener ll = actionListenerArray[n2];
            combo.removeActionListener(ll);
            ++n2;
        }
        combo.removeAllItems();
        String selectable = firstMacComboChoice;
        combo.addItem(selectable);
        for (String s : NdmDb.getProductsMacList(this.isRemoteNotLocalListType ? "S" : "U")) {
            Product p = ProductManager.getInstance().getProductByMacInGUIThread(s);
            if (p == null) continue;
            String itemString = String.valueOf(s) + " / " + p.getIpString();
            combo.addItem(itemString);
            if (!s.equals(current)) continue;
            selectable = itemString;
        }
        combo.addActionListener(this.onMacSelect());
        combo.setSelectedItem(selectable);
    }

    private void closeChecks() {
        this.dispose();
    }

    private WindowListener onClose() {
        final MenuNewProductDialog owner = this;
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                owner.closeChecks();
            }
        };
    }

    private ActionListener onWindowCancel() {
        final MenuNewProductDialog owner = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                owner.closeChecks();
            }
        };
    }

    private ActionListener onFind() {
        final MenuNewProductDialog owner = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ip = owner.inputIp.getText();
                if (ip == null) {
                    JOptionPane.showMessageDialog(owner, TranslateEnum.NEWP_BADIP.get(), TranslateEnum.ERROR.get(), 2);
                    return;
                }
                String databaseSnmpRead = MenuNewProductDialog.this.retrieveCommunity(MenuNewProductDialog.this.inputSnmpRead);
                String databaseSnmpWrite = MenuNewProductDialog.this.retrieveCommunity(MenuNewProductDialog.this.inputSnmpWrite);
                ArrayList<Oid> oidList = new ArrayList<Oid>();
                oidList.add(Oid.SYSDESCR);
                oidList.add(Oid.PRODUCT_CODE);
                String snmpMac = null;
                int productCode = -1;
                String sysDescr = null;
                Product prod = new OpenWrtProduct("U3", ProductModel.WLNABOARD, "AC");
                prod.setParam(new Parameter(Oid.IP_ADDRESS, ip));
                prod.setCommunityRead(databaseSnmpRead);
                prod.setCommunityWrite(databaseSnmpWrite);
                if (Main.snmpmanager.getSnmpString(prod, oidList)) {
                    snmpMac = prod.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
                    productCode = prod.parameters.getPositiveValue(Oid.PRODUCT_CODE);
                    sysDescr = prod.parameters.getStringValue(Oid.SYSDESCR);
                }
                if (snmpMac == null || sysDescr == null || productCode < 0) {
                    prod = new WlgProduct("UT3", ProductModel.WLNABOARD);
                    prod.setParam(new Parameter(Oid.IP_ADDRESS, ip));
                    prod.setCommunityRead(databaseSnmpRead);
                    prod.setCommunityWrite(databaseSnmpWrite);
                    snmpMac = null;
                    productCode = -1;
                    sysDescr = null;
                    if (Main.snmpmanager.getSnmpString(prod, oidList)) {
                        snmpMac = prod.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
                        productCode = prod.parameters.getPositiveValue(Oid.PRODUCT_CODE);
                        sysDescr = prod.parameters.getStringValue(Oid.SYSDESCR);
                    }
                    if (snmpMac == null || sysDescr == null || productCode < 0) {
                        JOptionPane.showMessageDialog(owner, TranslateEnum.NEWP_NOTFOUND.get(), TranslateEnum.ERROR.get(), 2);
                        return;
                    }
                }
                if (owner.knownAddress(ip, snmpMac)) {
                    JOptionPane.showMessageDialog(owner, TranslateEnum.NEWP_KNOWN.get(), TranslateEnum.ERROR.get(), 2);
                    return;
                }
                DatabaseDiscoverMethod.getInstance().createProduct(snmpMac, productCode, sysDescr, ip, databaseSnmpRead, databaseSnmpWrite, true);
                MenuNewProductDialog.this.reloadList(MenuNewProductDialog.this.selectMac, snmpMac);
            }
        };
    }

    private String retrieveCommunity(JTextField inputField) {
        String databaseString = inputField.getText().trim();
        if (databaseString.equals(defaultCommunity)) {
            databaseString = "";
        }
        return databaseString;
    }

    private ActionListener onDelete() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String mac = MenuNewProductDialog.this.selectMac.getSelectedItem().toString().substring(0, 17);
                DatabaseDiscoverMethod.getInstance().deleteProduct(mac);
                MenuNewProductDialog.this.reloadList(MenuNewProductDialog.this.selectMac, null);
            }
        };
    }

    private ActionListener onClearAll() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (String mac : NdmDb.getProductsMacList(MenuNewProductDialog.this.isRemoteNotLocalListType ? "S" : "U")) {
                    DatabaseDiscoverMethod.getInstance().deleteProduct(mac);
                }
                NdmDb.Vacuum();
                MenuNewProductDialog.this.reloadList(MenuNewProductDialog.this.selectMac, null);
            }
        };
    }

    private ActionListener onMacSelect() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selection = MenuNewProductDialog.this.selectMac.getSelectedItem();
                if (selection == null) {
                    System.out.println("Remote Product Mac selection is null");
                }
                if (selection == firstMacComboChoice) {
                    MenuNewProductDialog.this.doInitState(null);
                } else {
                    MenuNewProductDialog.this.doInitState(selection.toString().substring(0, 17));
                }
            }
        };
    }

    private ActionListener onSave() {
        final MenuNewProductDialog owner = this;
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String ip = owner.inputIp.getText();
                if (ip == null) {
                    JOptionPane.showMessageDialog(owner, TranslateEnum.NEWP_BADIP.get(), TranslateEnum.ERROR.get(), 2);
                    return;
                }
                String databaseSnmpRead = MenuNewProductDialog.this.retrieveCommunity(MenuNewProductDialog.this.inputSnmpRead);
                String databaseSnmpWrite = MenuNewProductDialog.this.retrieveCommunity(MenuNewProductDialog.this.inputSnmpWrite);
                String mac = MenuNewProductDialog.this.selectMac.getSelectedItem().toString().substring(0, 17);
                NdmDb.getInstance().executeSynchronizedSqlChange(String.format("update products set p_ip='%s',p_snmp_r='%s',p_snmp_w='%s' where p_mac='%s';", ip, databaseSnmpRead, databaseSnmpWrite, mac));
                Product prod = ProductManager.getInstance().getProductByMacInGUIThread(mac);
                prod.setCommunityRead(databaseSnmpRead);
                prod.setCommunityWrite(databaseSnmpWrite);
                prod.setParam(new Parameter(Oid.IP_ADDRESS, ip));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean knownAddress(String ip, String mac) {
        if (ProductManager.getInstance().getProductByMacInGUIThread(mac) != null) {
            return true;
        }
        NdmDb db = NdmDb.getInstance();
        boolean inDb = false;
        try {
            NdmDb ndmDb = db;
            synchronized (ndmDb) {
                ResultSet query = db.st.executeQuery("select p_mac from products where p_mac='" + mac + "';");
                inDb = query.next();
                query.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return inDb;
    }

    public static void main(String[] args) {
        ImageManager.initMapImage();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new MenuNewProductDialog(0).setVisible(true);
                new MenuNewProductDialog(1).setVisible(true);
            }
        });
    }
}

