/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class ParamTableModel
extends AbstractTableModel
implements RefreshableInterface {
    private static final long serialVersionUID = 3202952159844875778L;
    public static final int MAC_ADDRESS = 0;
    public static final int SYSLOCATION = 1;
    public static final int IP_ADDRESS = 2;
    public static final int IDEN_SINGAL = 3;
    private List<Product> productList = new ArrayList<Product>();

    public ParamTableModel(List<Product> productList) {
        this.productList = productList;
    }

    public void changeProductsList(List<Product> newList) {
        int oldsize = this.productList.size();
        if (oldsize > 0) {
            this.fireTableRowsDeleted(0, oldsize - 1);
        }
        this.productList.clear();
        for (Product p : newList) {
            this.productList.add(p);
        }
        int newsize = this.productList.size();
        if (newsize > 0) {
            this.fireTableRowsInserted(0, newsize - 1);
        }
    }

    public void removeProduct(Product p) {
        int index = this.productList.indexOf(p);
        this.productList.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    public List<Product> getListproduct() {
        return this.productList;
    }

    @Override
    public int getRowCount() {
        return this.productList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.productList.get(rowIndex).getUniqueIdString();
            }
            case 1: {
                return this.productList.get(rowIndex).getParam(Oid.SYSLOCATION).getValue();
            }
            case 2: {
                return this.productList.get(rowIndex).getParam(Oid.IP_ADDRESS).getValue();
            }
            case 3: {
                switch (this.productList.get((int)rowIndex).iden_status) {
                    case 0: {
                        return TranslateEnum.NOT_SUPPORTED.get();
                    }
                    case 1: {
                        return TranslateEnum.IDLE.get();
                    }
                    case 2: {
                        return TranslateEnum.IDENTIFY.get();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return TranslateEnum.COLUMN_MAC_ADDRESS.get();
            }
            case 1: {
                return TranslateEnum.COLUMN_SYSLOCATION.get();
            }
            case 2: {
                return TranslateEnum.COLUMN_IP_ADDRESS.get();
            }
            case 3: {
                return TranslateEnum.IDENT_PRODUCT.get();
            }
        }
        return "";
    }

    @Override
    public void refreshAdd(Product product) {
        int index = this.productList.indexOf(product);
        if (index != -1) {
            this.productList.set(index, product);
            this.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void refreshClearList() {
    }

    @Override
    public void refreshProduct(Product product) {
        int index = this.productList.indexOf(product);
        if (index != -1) {
            this.fireTableRowsUpdated(index, index);
        }
    }

    @Override
    public void refreshRemove(Product product) {
    }
}

