/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.Main;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.RefreshAssociationThread;
import fr.acksys.ndm.RefreshProductThread;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.utils.JSwitchBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 173427871876807812L;
    public static Integer listValue;
    public static Integer rssiValue;
    public static Integer maxTrace;
    final JSpinner listSpin = new JSpinner();
    final JSpinner rssiSpin = new JSpinner();
    final JSpinner snmpRetrySpin = new JSpinner();
    final JSpinner snmpTimeoutSpin = new JSpinner();
    final JLabel warningLab = new JLabel("<html><i>" + TranslateEnum.NOT_REFRESH.get() + "</i></html>");
    final JLabel warningLab2 = new JLabel("<html><i>" + TranslateEnum.EXP_REFRESH.get() + "</i></html>");
    final JTextField snmpCommunityRead = new JTextField();
    final JTextField snmpCommunityWrite = new JTextField();
    final JCheckBox closeCb = new JCheckBox(TranslateEnum.PREF_ASK_ICONIFY.get());
    final JCheckBox iconifyCb = new JCheckBox(TranslateEnum.PREF_ICONIFY.get());
    final JCheckBox snmpEnableWarningCb = new JCheckBox(TranslateEnum.PREF_ASK_SNMPDISABLED.get());
    final JCheckBox databaseWriteCb = new JCheckBox(TranslateEnum.PREF_DBSAVE.get());
    SpinnerNumberModel model = new SpinnerNumberModel(5, 1, 100, 1);
    final JSpinner maxTraceSpin = new JSpinner(this.model);
    JLabel NDM_lange = new JLabel(TranslateEnum.LANGUAGE.get());
    String[] langue = new String[]{TranslateEnum.LANGUAGE_AUTO.get(), TranslateEnum.FRENCH.get(), TranslateEnum.ENGLISH.get()};
    JComboBox choix_langue = new JComboBox<String>(this.langue);
    JSwitchBox choix_unite = new JSwitchBox("%", "dBm");
    private ActionListener onOk = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            UserParameters userParam = UserParameters.getInstance();
            listValue = (Integer)PreferencesDialog.this.listSpin.getValue();
            rssiValue = (Integer)PreferencesDialog.this.rssiSpin.getValue();
            Integer retryValue = (Integer)PreferencesDialog.this.snmpRetrySpin.getValue();
            Integer timeoutValue = (Integer)PreferencesDialog.this.snmpTimeoutSpin.getValue();
            maxTrace = (Integer)PreferencesDialog.this.maxTraceSpin.getValue();
            int val = (int)Math.floor((double)(timeoutValue * retryValue) * 0.002);
            String lang = "00";
            if (listValue == 0 || rssiValue == 0) {
                PreferencesDialog.this.warningLab.setForeground(Color.RED);
            } else {
                PreferencesDialog.this.warningLab.setForeground(Color.BLACK);
            }
            if (listValue > 0 && listValue < val || rssiValue > 0 && rssiValue < val) {
                PreferencesDialog.this.warningLab2.setVisible(true);
                if (listValue < val) {
                    PreferencesDialog.this.listSpin.setValue(val);
                }
                if (rssiValue < val) {
                    PreferencesDialog.this.rssiSpin.setValue(val);
                }
            } else {
                switch (PreferencesDialog.this.choix_langue.getSelectedIndex()) {
                    case 0: {
                        lang = "00";
                        break;
                    }
                    case 1: {
                        lang = "FR";
                        break;
                    }
                    case 2: {
                        lang = "EN";
                        break;
                    }
                    default: {
                        lang = userParam.getParam("LANGUAGE_VALUE");
                    }
                }
                userParam.setParam("LIST_REFRESH_PERIOD", listValue.toString());
                userParam.setParam("RSSI_REFRESH_PERIOD", rssiValue.toString());
                userParam.setParam("SNMP_RETRY_VALUE", retryValue.toString());
                userParam.setParam("SNMP_TIMEOUT_VALUE", timeoutValue.toString());
                userParam.setParam("SNMP_COMMUNITY_READ", PreferencesDialog.this.snmpCommunityRead.getText());
                userParam.setParam("SNMP_COMMUNITY_WRITE", PreferencesDialog.this.snmpCommunityWrite.getText());
                userParam.setParam("RSSI_MAX_NOM", maxTrace.toString());
                userParam.setParam("LANGUAGE_VALUE", lang);
                RefreshProductThread refreshProductThread = MainFrame.getRefreshProductThread();
                RefreshAssociationThread refreshRssiThread = MainFrame.getRefreshRssiThread();
                if (refreshProductThread != null) {
                    refreshProductThread.setDelay(1000 * listValue);
                }
                if (refreshRssiThread != null) {
                    refreshRssiThread.setDelay(1000 * rssiValue);
                }
                userParam.setParam("TRAY_CHOICE", PreferencesDialog.this.closeCb.isSelected() ? "0" : "1");
                userParam.setParam("TRAY_ICON_PROG", PreferencesDialog.this.iconifyCb.isSelected() ? "1" : "0");
                userParam.setParam("SNMP_DISABLED_WARNING", PreferencesDialog.this.snmpEnableWarningCb.isSelected() ? "0" : "1");
                userParam.setParam("DB_SAVE_DETECTED", PreferencesDialog.this.databaseWriteCb.isSelected() ? "1" : "0");
                userParam.setParam("RSSI_UNITE", PreferencesDialog.this.choix_unite.isSelected() ? "0" : "1");
                ProductManager.getInstance().rediscoverProductListInGUIThread();
                PreferencesDialog.this.dispose();
            }
        }
    };

    static {
        maxTrace = 5;
    }

    public PreferencesDialog(Frame owner) {
        UserParameters userParam = UserParameters.getInstance();
        if (userParam.getParam("RSSI_UNITE").equals("1")) {
            this.choix_unite.setSelected(false);
        } else {
            this.choix_unite.setSelected(true);
        }
        if (userParam.getParam("LANGUAGE_VALUE").equals("00")) {
            this.choix_langue.setSelectedIndex(0);
        } else if (userParam.getParam("LANGUAGE_VALUE").equals("FR")) {
            this.choix_langue.setSelectedIndex(1);
        } else if (userParam.getParam("LANGUAGE_VALUE").equals("EN")) {
            this.choix_langue.setSelectedIndex(2);
        }
        UIManager.put("TabbedPane.contentAreaColor", Company.BACK_COLOR);
        JTabbedPane tabs = new JTabbedPane();
        tabs.add((Component)this.makeScanDialog(), TranslateEnum.PREF_TAB_PARAMS.get());
        tabs.add((Component)this.makeMesgDialog(), TranslateEnum.PREF_TAB_OPTIONS.get());
        tabs.setBackground(Company.BACK_COLOR.darker());
        this.setModal(true);
        IgUtils.SetIconImage(this);
        this.setTitle(TranslateEnum.MENU_PREFERENCES.get());
        tabs.setOpaque(false);
        this.add(tabs);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        if (Main.os_name.equals("Linux")) {
            if (Main.language.equals("fr")) {
                this.setSize(500, 370);
                this.setMinimumSize(new Dimension(480, 330));
            } else {
                this.setSize(460, 370);
                this.setMinimumSize(new Dimension(450, 330));
            }
        } else if (Main.language.equals("fr")) {
            this.setSize(400, 370);
            this.setMinimumSize(new Dimension(400, 320));
        } else {
            this.setSize(350, 370);
            this.setMinimumSize(new Dimension(340, 320));
        }
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    private JPanel makeScanDialog() {
        JPanel pane = new JPanel();
        if (Main.os_name.equals("Linux")) {
            this.listSpin.setPreferredSize(new Dimension(70, 20));
            this.rssiSpin.setPreferredSize(new Dimension(70, 20));
            this.snmpRetrySpin.setPreferredSize(new Dimension(70, 20));
            this.snmpTimeoutSpin.setPreferredSize(new Dimension(70, 20));
        } else {
            this.listSpin.setPreferredSize(new Dimension(50, 20));
            this.rssiSpin.setPreferredSize(new Dimension(50, 20));
            this.snmpRetrySpin.setPreferredSize(new Dimension(50, 20));
            this.snmpTimeoutSpin.setPreferredSize(new Dimension(50, 20));
        }
        if (Main.language.equals("fr")) {
            this.maxTraceSpin.setPreferredSize(new Dimension(50, 20));
        } else {
            this.maxTraceSpin.setPreferredSize(new Dimension(40, 20));
        }
        JLabel snmpRetryLabel = new JLabel(TranslateEnum.SNMP_RETRY.get());
        JLabel snmpTimeoutLabel = new JLabel(TranslateEnum.SNMP_TIMEOUT.get());
        JLabel snmpTimeoutUnit = new JLabel(TranslateEnum.TIME_UNIT_MS.get());
        JLabel snmpCommunityReadLabel = new JLabel(TranslateEnum.SNMP_COMMUNITY_READ.get());
        JLabel snmpCommunityWriteLabel = new JLabel(TranslateEnum.SNMP_COMMUNITY_WRITE.get());
        JLabel listScanLabel = new JLabel(TranslateEnum.LIST_SCAN.get());
        JLabel listScanUnit = new JLabel(TranslateEnum.TIME_UNIT_S.get());
        JLabel rssiRefreshLabel = new JLabel(TranslateEnum.RSSI_REFRESH.get());
        JLabel rssiRefreshUnit = new JLabel(TranslateEnum.TIME_UNIT_S.get());
        JLabel MaxTraceLabel = new JLabel(TranslateEnum.MAX_RSSI.get());
        JLabel RSSI_unite = new JLabel(TranslateEnum.UNITE_RSSI.get());
        pane.add(this.warningLab);
        pane.add(this.warningLab2);
        pane.add(listScanLabel);
        pane.add(this.listSpin);
        pane.add(listScanUnit);
        pane.add(rssiRefreshLabel);
        pane.add(this.rssiSpin);
        pane.add(rssiRefreshUnit);
        pane.add(snmpRetryLabel);
        pane.add(this.snmpRetrySpin);
        pane.add(snmpTimeoutLabel);
        pane.add(this.snmpTimeoutSpin);
        pane.add(snmpTimeoutUnit);
        pane.add(this.snmpCommunityRead);
        pane.add(snmpCommunityReadLabel);
        pane.add(this.snmpCommunityWrite);
        pane.add(snmpCommunityWriteLabel);
        pane.add(MaxTraceLabel);
        pane.add(this.maxTraceSpin);
        pane.add(RSSI_unite);
        pane.add(this.choix_unite);
        UserParameters userParam = UserParameters.getInstance();
        int val_snmptimeout = Integer.parseInt(userParam.getParam("SNMP_TIMEOUT_VALUE"));
        int val_snmpretry = Integer.parseInt(userParam.getParam("SNMP_RETRY_VALUE"));
        int val_refreshlist = Integer.parseInt(userParam.getParam("LIST_REFRESH_PERIOD"));
        int val_refreshrssi = Integer.parseInt(userParam.getParam("RSSI_REFRESH_PERIOD"));
        double val = (double)(val_snmptimeout * val_snmpretry) * 0.002;
        this.snmpRetrySpin.setValue(val_snmpretry);
        this.snmpTimeoutSpin.setValue(val_snmptimeout);
        SpinnerNumberModel numModel_scan = new SpinnerNumberModel(5, 0, 900, 1);
        SpinnerNumberModel numModel_scan2 = new SpinnerNumberModel(2, 0, 900, 1);
        this.listSpin.setModel(numModel_scan);
        this.rssiSpin.setModel(numModel_scan2);
        if (val_refreshlist > 0 && (double)val_refreshlist < val) {
            val_refreshlist = (int)Math.floor(val);
            userParam.setParam("LIST_REFRESH_PERIOD", Integer.valueOf(val_refreshlist).toString());
        }
        if (val_refreshrssi > 0 && (double)val_refreshrssi < val) {
            val_refreshrssi = (int)Math.floor(val);
            userParam.setParam("RSSI_REFRESH_PERIOD", Integer.valueOf(val_refreshrssi).toString());
        }
        this.listSpin.setValue(val_refreshlist);
        this.rssiSpin.setValue(val_refreshrssi);
        if (val_refreshlist == 0 || val_refreshrssi == 0) {
            this.warningLab.setForeground(Color.RED);
        } else {
            this.warningLab.setForeground(Color.BLACK);
        }
        this.warningLab2.setForeground(Color.RED);
        this.warningLab2.setVisible(false);
        this.snmpCommunityRead.setText(userParam.getParam("SNMP_COMMUNITY_READ"));
        this.snmpCommunityWrite.setText(userParam.getParam("SNMP_COMMUNITY_WRITE"));
        this.maxTraceSpin.setValue(Integer.parseInt(userParam.getParam("RSSI_MAX_NOM")));
        this.listSpin.addChangeListener(ListenerFactory.getPreferencesSpinnerPeriodListener(this.listSpin, this.rssiSpin, this.warningLab));
        this.rssiSpin.addChangeListener(ListenerFactory.getPreferencesSpinnerPeriodListener(this.rssiSpin, this.listSpin, this.warningLab));
        this.snmpRetrySpin.addChangeListener(ListenerFactory.getPreferencesSpinnerListener(this.snmpRetrySpin));
        this.snmpTimeoutSpin.addChangeListener(ListenerFactory.getPreferencesSpinnerListener(this.snmpTimeoutSpin));
        this.maxTraceSpin.addChangeListener(ListenerFactory.getMAXTraceListener(this.maxTraceSpin));
        JPanel buttonPanel = this.makeOkCancel();
        pane.add(buttonPanel);
        SpringLayout layout = new SpringLayout();
        pane.setLayout(layout);
        layout.putConstraint("North", (Component)this.warningLab, 5, "North", (Component)pane);
        layout.putConstraint("HorizontalCenter", (Component)this.warningLab, 0, "HorizontalCenter", (Component)pane);
        layout.putConstraint("HorizontalCenter", (Component)this.warningLab2, 0, "HorizontalCenter", (Component)pane);
        layout.putConstraint("North", (Component)this.listSpin, 5, "South", (Component)this.warningLab);
        layout.putConstraint("North", (Component)listScanLabel, 0, "North", (Component)this.listSpin);
        layout.putConstraint("West", (Component)listScanLabel, 5, "West", (Component)pane);
        layout.putConstraint("East", (Component)this.listSpin, -30, "East", (Component)pane);
        layout.putConstraint("West", (Component)listScanUnit, 5, "East", (Component)this.listSpin);
        layout.putConstraint("North", (Component)listScanUnit, 0, "North", (Component)this.listSpin);
        layout.putConstraint("North", (Component)rssiRefreshLabel, 0, "North", (Component)this.rssiSpin);
        layout.putConstraint("West", (Component)rssiRefreshLabel, 5, "West", (Component)pane);
        layout.putConstraint("North", (Component)this.rssiSpin, 5, "South", (Component)this.listSpin);
        layout.putConstraint("East", (Component)this.rssiSpin, -30, "East", (Component)pane);
        layout.putConstraint("West", (Component)rssiRefreshUnit, 5, "East", (Component)this.rssiSpin);
        layout.putConstraint("North", (Component)rssiRefreshUnit, 0, "North", (Component)this.rssiSpin);
        layout.putConstraint("North", (Component)snmpRetryLabel, 0, "North", (Component)this.snmpRetrySpin);
        layout.putConstraint("West", (Component)snmpRetryLabel, 5, "West", (Component)pane);
        layout.putConstraint("North", (Component)this.snmpRetrySpin, 5, "South", (Component)this.rssiSpin);
        layout.putConstraint("East", (Component)this.snmpRetrySpin, -30, "East", (Component)pane);
        layout.putConstraint("North", (Component)snmpTimeoutLabel, 0, "North", (Component)this.snmpTimeoutSpin);
        layout.putConstraint("West", (Component)snmpTimeoutLabel, 5, "West", (Component)pane);
        layout.putConstraint("North", (Component)this.snmpCommunityRead, 5, "South", (Component)this.snmpTimeoutSpin);
        layout.putConstraint("North", (Component)this.snmpCommunityWrite, 5, "South", (Component)this.snmpCommunityRead);
        layout.putConstraint("North", (Component)snmpCommunityReadLabel, 0, "North", (Component)this.snmpCommunityRead);
        layout.putConstraint("North", (Component)snmpCommunityWriteLabel, 0, "North", (Component)this.snmpCommunityWrite);
        layout.putConstraint("West", (Component)snmpCommunityReadLabel, 5, "West", (Component)pane);
        layout.putConstraint("West", (Component)snmpCommunityWriteLabel, 5, "West", (Component)pane);
        layout.putConstraint("West", (Component)MaxTraceLabel, 0, "West", (Component)snmpCommunityWriteLabel);
        layout.putConstraint("West", (Component)RSSI_unite, 0, "West", (Component)MaxTraceLabel);
        layout.putConstraint("East", (Component)this.snmpCommunityRead, -30, "East", (Component)pane);
        layout.putConstraint("East", (Component)this.snmpCommunityWrite, -30, "East", (Component)pane);
        layout.putConstraint("East", (Component)this.maxTraceSpin, 0, "East", (Component)this.snmpCommunityWrite);
        layout.putConstraint("East", (Component)this.choix_unite, 0, "East", (Component)this.maxTraceSpin);
        layout.putConstraint("North", (Component)this.warningLab2, 25, "North", (Component)this.choix_unite);
        FontMetrics fm = this.getFontMetrics(snmpCommunityReadLabel.getFont());
        int align = 20;
        align = fm.stringWidth(snmpCommunityReadLabel.getText()) > fm.stringWidth(snmpCommunityWriteLabel.getText()) ? (align += fm.stringWidth(snmpCommunityReadLabel.getText())) : (align += fm.stringWidth(snmpCommunityWriteLabel.getText()));
        layout.putConstraint("West", (Component)this.snmpCommunityRead, align, "West", (Component)snmpCommunityReadLabel);
        layout.putConstraint("West", (Component)this.snmpCommunityWrite, align, "West", (Component)snmpCommunityWriteLabel);
        layout.putConstraint("North", (Component)this.snmpTimeoutSpin, 5, "South", (Component)this.snmpRetrySpin);
        layout.putConstraint("East", (Component)this.snmpTimeoutSpin, -30, "East", (Component)pane);
        layout.putConstraint("West", (Component)snmpTimeoutUnit, 5, "East", (Component)this.snmpTimeoutSpin);
        layout.putConstraint("North", (Component)snmpTimeoutUnit, 0, "North", (Component)this.snmpTimeoutSpin);
        layout.putConstraint("North", (Component)this.maxTraceSpin, 5, "South", (Component)this.snmpCommunityWrite);
        layout.putConstraint("North", (Component)MaxTraceLabel, 0, "North", (Component)this.maxTraceSpin);
        layout.putConstraint("North", (Component)this.choix_unite, 5, "South", (Component)this.maxTraceSpin);
        layout.putConstraint("North", (Component)RSSI_unite, 0, "North", (Component)this.choix_unite);
        layout.putConstraint("South", (Component)buttonPanel, -5, "South", (Component)pane);
        layout.putConstraint("HorizontalCenter", (Component)buttonPanel, 0, "HorizontalCenter", (Component)pane);
        pane.setOpaque(true);
        pane.setBackground(Company.BACK_COLOR);
        return pane;
    }

    private JPanel makeMesgDialog() {
        JPanel pane = new JPanel(new GridBagLayout());
        this.closeCb.setOpaque(false);
        this.closeCb.setSelected(UserParameters.getInstance().getParam("TRAY_CHOICE").equals("0"));
        this.iconifyCb.setOpaque(false);
        this.iconifyCb.setSelected(!UserParameters.getInstance().getParam("TRAY_ICON_PROG").equals("0"));
        this.snmpEnableWarningCb.setOpaque(false);
        this.snmpEnableWarningCb.setSelected(UserParameters.getInstance().getParam("SNMP_DISABLED_WARNING").equals("0"));
        this.databaseWriteCb.setOpaque(false);
        this.databaseWriteCb.setSelected(UserParameters.getInstance().getParam("DB_SAVE_DETECTED").equals("1"));
        GridBagConstraints cLabels = new GridBagConstraints();
        GridBagConstraints Labels_choixlange = new GridBagConstraints();
        GridBagConstraints Label_lange = new GridBagConstraints();
        GridBagConstraints cButtons = new GridBagConstraints();
        GridBagConstraints Labels_buttonunite = new GridBagConstraints();
        GridBagConstraints Labels_unite = new GridBagConstraints();
        cLabels.gridx = 0;
        cLabels.gridy = -1;
        cLabels.weightx = 0.5;
        cLabels.anchor = 21;
        cLabels.insets = new Insets(3, 5, 0, 5);
        Labels_choixlange.gridx = 0;
        Labels_choixlange.gridy = 0;
        Labels_choixlange.weightx = 0.5;
        Labels_choixlange.anchor = 21;
        Labels_choixlange.insets = Main.os_name.equals("Linux") ? (Main.language.equals("en") ? new Insets(0, 110, 0, 0) : new Insets(0, 130, 0, 0)) : (Main.language.equals("en") ? new Insets(0, 100, 0, 0) : new Insets(0, 120, 0, 0));
        Label_lange.gridx = 0;
        Label_lange.gridy = -1;
        Label_lange.weightx = 0.5;
        Label_lange.anchor = 21;
        Label_lange.insets = new Insets(0, 10, 0, 0);
        cButtons.gridx = 0;
        cButtons.gridwidth = 0;
        cButtons.insets = new Insets(5, 0, 5, 0);
        JPanel buttonPanel = this.makeOkCancel();
        pane.add((Component)this.choix_langue, Label_lange);
        pane.add((Component)this.NDM_lange, Labels_choixlange);
        pane.add((Component)this.closeCb, cLabels);
        pane.add((Component)this.iconifyCb, cLabels);
        pane.add((Component)this.snmpEnableWarningCb, cLabels);
        pane.add((Component)this.databaseWriteCb, cLabels);
        pane.add((Component)buttonPanel, cButtons);
        pane.setOpaque(true);
        pane.setBackground(Company.BACK_COLOR);
        return pane;
    }

    private JPanel makeOkCancel() {
        JButton okButton = new JButton(TranslateEnum.OK.get());
        JButton cancelButton = new JButton(TranslateEnum.CANCEL.get());
        cancelButton.addActionListener(ListenerFactory.getCancelDialoglListener(this));
        okButton.addActionListener(this.onOk);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(okButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setOpaque(false);
        return buttonPanel;
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferencesDialog j = new PreferencesDialog(null);
                j.setVisible(true);
            }
        });
    }
}

