/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.ig.ImageManager;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class ProductTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private static final long serialVersionUID = -6300976241777106986L;
    private static final Font leafFont = new Font("leaf", 0, 12);
    private static final Font nodeFont = new Font("node", 1, 12);

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            this.setBackground(Company.TREE_SELECTION_COLOR);
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
        if (leaf) {
            this.setIcon(ImageManager.TREE_LEAF.getImageIcon());
            this.setFont(leafFont);
            this.setText(value.toString());
        } else {
            this.setFont(nodeFont);
            if (expanded) {
                this.setIcon(ImageManager.TREE_NODE2.getImageIcon());
            } else {
                this.setIcon(ImageManager.TREE_NODE.getImageIcon());
            }
            try {
                this.setText(String.valueOf(value.toString()) + " (" + ((DefaultMutableTreeNode)value).getLeafCount() + ")");
            }
            catch (Error e) {
                this.setText(String.valueOf(value.toString()) + " (0)");
            }
        }
        return this;
    }
}

