/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.translation.TranslateEnum;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class RememberableDialog
extends JDialog {
    private static final long serialVersionUID = 7250274755967351420L;

    public RememberableDialog(String parameter, String message) {
        this.buildDialog(parameter, message, TranslateEnum.WARNING);
    }

    public RememberableDialog(String message, TranslateEnum caption) {
        this.buildDialog(null, message, caption);
    }

    private void buildDialog(String parameter, String message, TranslateEnum caption) {
        this.setModal(true);
        IgUtils.SetIconImage(this);
        this.setTitle(caption.get());
        JLabel msgLab = new JLabel(message);
        JButton okButton = new JButton(TranslateEnum.OK.get());
        JCheckBox rememberBox = new JCheckBox(TranslateEnum.REMEMBERCHOICE.get());
        okButton.addActionListener(ListenerFactory.getRememberOkListener(this, rememberBox, parameter));
        rememberBox.setOpaque(false);
        if (parameter == null) {
            rememberBox.setVisible(false);
        }
        this.add(msgLab);
        this.add(rememberBox);
        this.add(okButton);
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("North", (Component)msgLab, 5, "North", (Component)this.getContentPane());
        layout.putConstraint("North", (Component)rememberBox, 5, "South", (Component)msgLab);
        layout.putConstraint("North", (Component)okButton, 5, "South", (Component)rememberBox);
        layout.putConstraint("HorizontalCenter", (Component)msgLab, 0, "HorizontalCenter", (Component)this.getContentPane());
        layout.putConstraint("HorizontalCenter", (Component)rememberBox, 0, "HorizontalCenter", (Component)this.getContentPane());
        layout.putConstraint("HorizontalCenter", (Component)okButton, 0, "HorizontalCenter", (Component)this.getContentPane());
        FontMetrics fm = this.getFontMetrics(msgLab.getFont());
        int msgLength = fm.stringWidth(message);
        int boxWidth = this.getFontMetrics(rememberBox.getFont()).stringWidth(TranslateEnum.REMEMBERCHOICE.get());
        if (msgLength < boxWidth) {
            msgLength = boxWidth;
        }
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.setSize(msgLength + 50, 120);
        this.setMinimumSize(new Dimension(msgLength + 50, 120));
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RememberableDialog("test_user_param_name", "message1").setVisible(true);
                new RememberableDialog(null, "message2").setVisible(true);
                new RememberableDialog(null, new MessageFormat("args{0}").format(null)).setVisible(true);
                new RememberableDialog("warning info", TranslateEnum.PFVAL_DEL).setVisible(true);
            }
        });
    }
}

