/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.translation.TranslateEnum;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

public class StatusBar
extends JPanel
implements RefreshableInterface {
    private static final long serialVersionUID = 2511201839286453590L;
    private String text = String.valueOf(ProductManager.getInstance().sizeProduct()) + " " + TranslateEnum.PRODUCTS.get();
    private int productCount = 0;

    private void changeText() {
        this.text = String.valueOf(this.productCount) + " " + TranslateEnum.PRODUCTS.get();
        super.repaint();
    }

    @Override
    public void refreshAdd(Product product) {
        ++this.productCount;
        this.changeText();
    }

    @Override
    public void refreshClearList() {
        this.productCount = 0;
        this.changeText();
    }

    @Override
    public void refreshProduct(Product product) {
        this.changeText();
    }

    @Override
    public void refreshRemove(Product product) {
        --this.productCount;
        this.changeText();
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int red1 = Company.STATUS_BAR_COLOR1.getRed();
        int green1 = Company.STATUS_BAR_COLOR1.getGreen();
        int blue1 = Company.STATUS_BAR_COLOR1.getBlue();
        int red2 = Company.STATUS_BAR_COLOR2.getRed();
        int green2 = Company.STATUS_BAR_COLOR2.getGreen();
        int blue2 = Company.STATUS_BAR_COLOR2.getBlue();
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < height) {
            g.setColor(new Color((red1 * (height - i) + red2 * i) / height, (green1 * (height - i) + green2 * i) / height, (blue1 * (height - i) + blue2 * i) / height));
            g.drawLine(x, y + i, x + width, y + i);
            ++i;
        }
        g.setColor(Color.WHITE);
        g.drawLine(0, 1, width, 1);
        g.setColor(Color.BLACK);
        g.drawString(this.text, 20, 15);
    }
}

