/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.TableProductModel;
import fr.acksys.ndm.product.Product;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableCellIpRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = -462288313096339147L;
    public static final Font stdFont = new Font("normal", 0, 12);
    private ArrayList<Product> productList;

    TableCellIpRenderer(TableProductModel model) {
        this.productList = model.getProductList();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int viewRow, int viewColumn) {
        int modelRow = table.convertRowIndexToModel(viewRow);
        Product product = this.productList.get(modelRow);
        this.setOpaque(true);
        if (ProductManager.getInstance().hasConflictingIp(product)) {
            this.setFont(UserParameters.ipConflictFont);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(UserParameters.ipConflictSelectedFgColor);
            } else {
                this.setBackground(UserParameters.ipConflictUnselectedBgColor);
                this.setForeground(UserParameters.ipConflictUnselectedFgColor);
            }
        } else {
            this.setFont(stdFont);
            this.setForeground(Color.BLACK);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(Color.WHITE);
            }
        }
        this.setText((String)table.getValueAt(viewRow, viewColumn));
        this.setHorizontalAlignment(0);
        return this;
    }
}

