/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.ig.TableProductModel;
import fr.acksys.ndm.product.Product;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class TableCellMacRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    private static final Font stdFont = new Font("normal", 0, 12);
    private ArrayList<Product> productList;

    TableCellMacRenderer(TableProductModel model) {
        this.productList = model.getProductList();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int viewRow, int viewColumn) {
        int modelRow = table.convertRowIndexToModel(viewRow);
        Product product = this.productList.get(modelRow);
        this.setOpaque(true);
        if (product.getTTL() > 0) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(Color.WHITE);
            }
        } else if (isSelected) {
            this.setBackground(Color.GRAY);
        } else {
            this.setBackground(Color.LIGHT_GRAY);
        }
        this.setFont(stdFont);
        this.setText((String)table.getValueAt(viewRow, viewColumn));
        this.setHorizontalAlignment(0);
        return this;
    }
}

