/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.table.JTableHeader;

public class TableProductHeader
extends JTableHeader {
    private static final long serialVersionUID = -2144755500343357089L;
    private String text;
    private boolean sortIndex;
    private boolean alreadySort;

    public TableProductHeader(String text, boolean sortIndex, boolean alreadySort) {
        this.text = text;
        this.sortIndex = sortIndex;
        this.alreadySort = alreadySort;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int red1 = Company.COLUMN_TITLE_COLOR1.getRed();
        int green1 = Company.COLUMN_TITLE_COLOR1.getGreen();
        int blue1 = Company.COLUMN_TITLE_COLOR1.getBlue();
        int red2 = Company.COLUMN_TITLE_COLOR2.getRed();
        int green2 = Company.COLUMN_TITLE_COLOR2.getGreen();
        int blue2 = Company.COLUMN_TITLE_COLOR2.getBlue();
        int x = 0;
        int y = 0;
        Font headerFont = new Font("table header", 1, 12);
        FontMetrics fm = this.getFontMetrics(headerFont);
        int i = 0;
        while (i < height) {
            g.setColor(new Color((red1 * (height - i) + red2 * i) / height, (green1 * (height - i) + green2 * i) / height, (blue1 * (height - i) + blue2 * i) / height));
            g.drawLine(x, y + i, x + width, y + i);
            ++i;
        }
        g.setColor(Color.BLACK);
        g.drawLine(width - 1, 0, width - 1, height);
        g.drawLine(0, height - 1, width, height - 1);
        g.setFont(headerFont);
        int customWidth = width;
        if (this.sortIndex) {
            customWidth -= 30;
        }
        int textWidth = fm.stringWidth(this.text);
        int textHeight = fm.getHeight() / 2;
        StringBuilder sb = new StringBuilder();
        if (textWidth > customWidth) {
            int length = fm.stringWidth("...");
            int i2 = 0;
            while (i2 < this.text.length()) {
                if (length + fm.charWidth(this.text.charAt(i2)) >= customWidth) break;
                length += fm.charWidth(this.text.charAt(i2));
                sb.append(this.text.charAt(i2));
                ++i2;
            }
            sb.append("...");
            if (this.sortIndex) {
                g.drawString(sb.toString(), (customWidth + 15 - fm.stringWidth(sb.toString())) / 2, (height + textHeight) / 2);
            } else {
                g.drawString(sb.toString(), (width - fm.stringWidth(sb.toString())) / 2, (height + textHeight) / 2);
            }
        } else {
            g.drawString(this.text, (width - textWidth) / 2, (height + textHeight) / 2);
        }
        if (this.sortIndex) {
            if (this.alreadySort) {
                this.drawTriangleUp(g, width - 12, height / 2);
            } else {
                this.drawTriangleDown(g, width - 12, height / 2);
            }
        }
    }

    private void drawTriangleDown(Graphics g, int x1, int y1) {
        int x = x1 - 2;
        int y = y1 - 2;
        g.drawLine(0 + x, 0 + y, 10 + x, 0 + y);
        g.drawLine(0 + x, 0 + y, 5 + x, 5 + y);
        g.drawLine(5 + x, 5 + y, 10 + x, 0 + y);
    }

    private void drawTriangleUp(Graphics g, int x1, int y1) {
        int x = x1 - 3;
        int y = y1 - 3;
        g.drawLine(0 + x, 5 + y, 10 + x, 5 + y);
        g.drawLine(0 + x, 5 + y, 5 + x, 0 + y);
        g.drawLine(5 + x, 0 + y, 10 + x, 5 + y);
    }
}

