/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.Product;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import sun.awt.Mutex;

public class TableProductModel
extends AbstractTableModel
implements RefreshableInterface {
    private static final long serialVersionUID = -6853845705156628632L;
    public static final int TYPE = 0;
    public static final int MODEL = 1;
    public static final int FUNCTION = 2;
    public static final int NAME = 3;
    public static final int MAC_ADDRESS = 4;
    public static final int IP_ADDRESS = 5;
    public static final int BINDINGS = 6;
    public static final int FIRMWARE = 7;
    public static final int SECURITY = 8;
    public static final int SSID = 9;
    public static final int CHANNEL = 10;
    private final Mutex refreshLock = new Mutex();
    private final Mutex getValueLock = new Mutex();
    private ArrayList<Product> productList = new ArrayList();

    @Override
    public void setValueAt(Object value, int row, int col) {
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public int getRowCount() {
        return this.productList.size();
    }

    @Override
    public Object getValueAt(int modelRow, int modelColumn) {
        Object value = null;
        this.getValueLock.lock();
        if (modelRow >= this.productList.size()) {
            this.getValueLock.unlock();
            return null;
        }
        Product selectedProduct = this.productList.get(modelRow);
        switch (modelColumn) {
            case 0: {
                value = selectedProduct.getImageProduct();
                break;
            }
            case 1: {
                value = selectedProduct.getModel();
                break;
            }
            case 2: {
                value = selectedProduct.getFirmwareFunctionString();
                break;
            }
            case 3: {
                value = selectedProduct.parameters.getStringValue(Oid.SYSLOCATION);
                break;
            }
            case 4: {
                value = selectedProduct.getUniqueIdString();
                break;
            }
            case 5: {
                value = selectedProduct.getIpString();
                break;
            }
            case 6: {
                JLabel assocLab = new JLabel(TranslateEnum.COLVAL_NA.get(), 0);
                assocLab.setHorizontalTextPosition(0);
                assocLab.setVerticalTextPosition(3);
                assocLab.setIconTextGap(0);
                assocLab.setBorder(null);
                selectedProduct.getAssocDescription(assocLab);
                value = assocLab;
                break;
            }
            case 7: {
                value = selectedProduct.getFirmwareVersionString();
                if (selectedProduct.parameters.getPositiveValue(Oid.PRODUCT_CODE) != 0) break;
                value = "emg/" + value;
                break;
            }
            case 8: {
                value = selectedProduct.getSecurityDescription();
                break;
            }
            case 9: {
                value = selectedProduct.getSsidDescription();
                break;
            }
            case 10: {
                value = selectedProduct.getChannelDescription();
            }
        }
        this.getValueLock.unlock();
        if (value != null && value.equals("")) {
            return TranslateEnum.COLVAL_NA.get();
        }
        return value;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return TranslateEnum.PRODUCT.get();
            }
            case 1: {
                return TranslateEnum.COLUMN_MODEL.get();
            }
            case 2: {
                return TranslateEnum.COLUMN_FUNCTION.get();
            }
            case 3: {
                return TranslateEnum.COLUMN_SYSLOCATION.get();
            }
            case 4: {
                return TranslateEnum.COLUMN_MAC_ADDRESS.get();
            }
            case 5: {
                return TranslateEnum.COLUMN_IP_ADDRESS.get();
            }
            case 6: {
                return TranslateEnum.COLUMN_ASSOCIATE.get();
            }
            case 7: {
                return TranslateEnum.COLUMN_FIRMWARE.get();
            }
            case 8: {
                return TranslateEnum.COLUMN_SECURITY.get();
            }
            case 9: {
                return TranslateEnum.COLUMN_SSID.get();
            }
            case 10: {
                return TranslateEnum.COLUMN_CHANNEL.get();
            }
        }
        return "";
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return ImageIcon.class;
        }
        if (columnIndex == 6) {
            return JLabel.class;
        }
        return Object.class;
    }

    @Override
    public void refreshRemove(final Product product) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableProductModel.this.refreshLock.lock();
                int index = TableProductModel.this.productList.indexOf(product);
                if (index != -1) {
                    TableProductModel.this.productList.remove(index);
                    TableProductModel.this.fireTableRowsDeleted(index, index);
                }
                TableProductModel.this.refreshLock.unlock();
            }
        });
    }

    @Override
    public void refreshAdd(Product product) {
        this.refreshProduct(product);
    }

    @Override
    public void refreshProduct(final Product product) {
        Runnable refreshRunable = new Runnable(){

            @Override
            public void run() {
                if (product == null) {
                    System.out.println();
                    System.out.println("NULL product in refreshProduct()");
                    System.out.println();
                    Thread.dumpStack();
                }
                TableProductModel.this.refreshLock.lock();
                int index = TableProductModel.this.productList.indexOf(product);
                if (product.requiresDisplay() && product.isSelectedInTree()) {
                    if (index != -1) {
                        TableProductModel.this.fireTableRowsUpdated(index, index);
                    } else {
                        TableProductModel.this.productList.add(product);
                        index = TableProductModel.this.productList.size() - 1;
                        TableProductModel.this.fireTableRowsInserted(index, index);
                    }
                } else if (index != -1) {
                    TableProductModel.this.productList.remove(index);
                    TableProductModel.this.fireTableRowsDeleted(index, index);
                }
                TableProductModel.this.refreshLock.unlock();
            }
        };
        SwingUtilities.invokeLater(refreshRunable);
    }

    @Override
    public void refreshClearList() {
        Runnable clearRunable = new Runnable(){

            @Override
            public void run() {
                TableProductModel.this.refreshLock.lock();
                int index = TableProductModel.this.productList.size() - 1;
                if (index >= 0) {
                    TableProductModel.this.productList.clear();
                    TableProductModel.this.fireTableRowsDeleted(0, index);
                }
                TableProductModel.this.refreshLock.unlock();
            }
        };
        SwingUtilities.invokeLater(clearRunable);
    }

    public void dumpList(final String s) {
        Runnable clearRunable = new Runnable(){

            @Override
            public void run() {
                System.out.println("dumplist " + s);
                TableProductModel.this.refreshLock.lock();
                int i = 0;
                while (i < TableProductModel.this.productList.size()) {
                    Product product = (Product)TableProductModel.this.productList.get(i);
                    System.out.println("  " + product.getIpString());
                    ++i;
                }
                TableProductModel.this.refreshLock.unlock();
            }
        };
        SwingUtilities.invokeLater(clearRunable);
    }

    public void refreshRssiProductList() {
        this.refreshLock.lock();
        int i = 0;
        while (i < this.productList.size()) {
            Product product = this.productList.get(i);
            switch (product.getCurrentWirelessRole()) {
                case 0: {
                    product.refreshState(Arrays.asList(Oid.WIFI_BRIDGE_RSSI, Oid.WIFI_BRIDGE_RSSI_dBm));
                    ProductManager.updateProductDetails(product);
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
                case 1: {
                    if (product.canMultifunction && product.firmspec == "CA") {
                        product.refreshState(Arrays.asList(Oid.ASS_STA_TABLE_MAC));
                    }
                    product.refreshState(Arrays.asList(Oid.WIFI_AP_CLIENTS));
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
                case 3: {
                    product.refreshState(Arrays.asList(Oid.WIFI_BRIDGE_RSSI, Oid.WIFI_BRIDGE_RSSI_dBm));
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
                case 2: 
                case 7: {
                    ArrayList<Oid> paramsList = new ArrayList();
                    paramsList = Arrays.asList(Oid.WIFI_BRIDGE_RSSI, Oid.WIFI_BRIDGE_RSSI_dBm, Oid.WIFI_BRIDGE_STATUS, Oid.WIFI_AP_CHANNEL, Oid.WIFI_BRIDGE_MAC_AP);
                    product.refreshState(paramsList);
                    if (product.canMultifunction && product.firmspec == "CA") {
                        product.refreshState(Arrays.asList(Oid.ASS_STA_TABLE_MAC));
                    }
                    this.fireTableRowsUpdated(i, i);
                    break;
                }
            }
            ++i;
        }
        this.refreshLock.unlock();
    }

    public Product getProductByMac(String mac) {
        for (Product prod : this.productList) {
            if (!prod.getUniqueIdString().equalsIgnoreCase(mac)) continue;
            return prod;
        }
        return null;
    }

    public ArrayList<Product> getProductList() {
        return this.productList;
    }
}

