/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.ig;

import fr.acksys.custom.Company;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.CenterRenderer;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.ndm.ig.ListenerFactory;
import fr.acksys.ndm.ig.MainFrame;
import fr.acksys.ndm.ig.ParamTableModel;
import fr.acksys.ndm.product.Product;
import fr.acksys.translation.TranslateEnum;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.border.BevelBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class UpgradeDialog
extends JDialog {
    private static final long serialVersionUID = -693003284232081048L;
    private boolean isClosed = false;
    private JProgressBar progress = new JProgressBar();
    private JButton closeButton = new JButton(TranslateEnum.CLOSE.get());
    private JButton upgradeButton = new JButton(TranslateEnum.UPGRADE.get());
    private JButton upgradeAllButton = new JButton(TranslateEnum.UPGRADE_ALL.get());
    private ParamTableModel paramModel;
    private JTable table;
    private JTextField fileName = new JTextField(20);
    private JPasswordField passwordField = new JPasswordField(10);
    private String path;
    private JTextArea logArea = new JTextArea();

    public UpgradeDialog(Frame owner, List<Product> selectedList) {
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setTitle(TranslateEnum.UPGRADE_TITRE.get());
        IgUtils.SetIconImage(this);
        this.paramModel = new ParamTableModel(selectedList);
        for (Product p : selectedList) {
            p.registerRefreshIg(this.paramModel);
        }
        this.addWindowListener(this.onClose());
        this.table = new JTable(this.paramModel);
        TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.table.getModel());
        sorter.setComparator(2, new IpComparator());
        this.table.setRowSorter(sorter);
        this.table.setDefaultRenderer(Object.class, new CenterRenderer());
        this.table.selectAll();
        this.table.getSelectionModel().addListSelectionListener(ListenerFactory.getUpgradeTableListener(selectedList, this.table, this.upgradeButton, this.upgradeAllButton));
        if (this.table.getRowCount() > 1) {
            this.upgradeButton.setEnabled(false);
        } else {
            this.upgradeAllButton.setEnabled(false);
        }
        JScrollPane tableScrollPanel = new JScrollPane(this.table);
        BevelBorder border2 = new BevelBorder(1);
        tableScrollPanel.setBorder(border2);
        this.add(tableScrollPanel);
        JPanel upgradePanel = new JPanel(null);
        upgradePanel.setLayout(new BoxLayout(upgradePanel, 1));
        TitledBorder border = new TitledBorder(TranslateEnum.UPGRADE_PARAMETERS.get());
        upgradePanel.setBorder(border);
        Box firmwareLine = new Box(0);
        firmwareLine.add(new JLabel(String.valueOf(TranslateEnum.UPGRADE_FILENAME.get()) + " "));
        this.fileName.setPreferredSize(new Dimension(100, 20));
        UserParameters userParam = UserParameters.getInstance();
        this.path = userParam.getParam("FIRMWARE_PATH_VALUE");
        this.fileName.setText(this.path);
        firmwareLine.add(this.fileName);
        JButton browse = new JButton("...");
        browse.addActionListener(ListenerFactory.getUpgradeBrowseListener(this.fileName, this, this.path));
        firmwareLine.add(browse);
        Box passwordLine = new Box(0);
        passwordLine.add(new JLabel(String.valueOf(TranslateEnum.PASSWORD.get()) + " "));
        this.passwordField.setPreferredSize(new Dimension(100, 20));
        this.passwordField.setText("");
        passwordLine.add(this.passwordField);
        upgradePanel.add(firmwareLine);
        upgradePanel.add(passwordLine);
        this.upgradeButton.addActionListener(ListenerFactory.getUpgradeApplyAllListener(this.table, this.fileName, this.passwordField, this.progress, this.upgradeButton, this.closeButton, this.fileName, browse, this.logArea, selectedList));
        this.upgradeAllButton.addActionListener(ListenerFactory.getUpgradeApplyAllListener(this.table, this.fileName, this.passwordField, this.progress, this.upgradeAllButton, this.closeButton, this.fileName, browse, this.logArea, selectedList));
        this.closeButton.addActionListener(ListenerFactory.getCancelDialoglListener(this));
        this.add(upgradePanel);
        TitledBorder border3 = new TitledBorder(TranslateEnum.UPGRADE_STATUS.get());
        JPanel progressPanel = new JPanel(new BorderLayout());
        progressPanel.setBorder(border3);
        progressPanel.add((Component)this.progress, "Center");
        progressPanel.setPreferredSize(new Dimension(300, 50));
        this.add(progressPanel);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.upgradeButton);
        buttonPanel.add(this.upgradeAllButton);
        buttonPanel.add(this.closeButton);
        this.add(buttonPanel);
        this.logArea.setEditable(false);
        JScrollPane scrollLog = new JScrollPane(this.logArea);
        this.add(scrollLog);
        tableScrollPanel.setPreferredSize(new Dimension(350, 100));
        upgradePanel.setPreferredSize(new Dimension(300, 80));
        buttonPanel.setPreferredSize(new Dimension(300, 40));
        scrollLog.setPreferredSize(new Dimension(340, 100));
        this.setMinimumSize(new Dimension(420, 370));
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        layout.putConstraint("North", (Component)tableScrollPanel, 5, "North", (Component)this.getContentPane());
        layout.putConstraint("South", (Component)tableScrollPanel, -5, "North", (Component)upgradePanel);
        layout.putConstraint("South", (Component)upgradePanel, -5, "North", (Component)progressPanel);
        layout.putConstraint("South", (Component)progressPanel, -5, "North", (Component)scrollLog);
        layout.putConstraint("South", (Component)scrollLog, -5, "North", (Component)buttonPanel);
        layout.putConstraint("South", (Component)buttonPanel, -5, "South", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)tableScrollPanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)tableScrollPanel, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)progressPanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)progressPanel, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)upgradePanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)upgradePanel, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)buttonPanel, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)buttonPanel, -5, "East", (Component)this.getContentPane());
        layout.putConstraint("West", (Component)scrollLog, 5, "West", (Component)this.getContentPane());
        layout.putConstraint("East", (Component)scrollLog, -5, "East", (Component)this.getContentPane());
        buttonPanel.setOpaque(false);
        upgradePanel.setOpaque(false);
        progressPanel.setOpaque(false);
        this.getContentPane().setBackground(Company.BACK_COLOR);
        this.pack();
        this.setSize(350, 400);
        this.setLocation((MainFrame.screen.width - this.getWidth()) / 2, (MainFrame.screen.height - this.getHeight()) / 2);
    }

    public WindowListener onClose() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (!UpgradeDialog.this.closeButton.isEnabled()) {
                    JOptionPane.showMessageDialog(null, TranslateEnum.NO_CLOSE.get(), TranslateEnum.WARNING.get(), 2);
                    return;
                }
                UpgradeDialog.this.dispose();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                if (!UpgradeDialog.this.isClosed) {
                    UpgradeDialog.this.isClosed = true;
                }
            }
        };
    }
}

