/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.ndm.MibParser;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.ConfigDialog2;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.ProductModel;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.ndm.product.config.OpenWrtConfig;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.awt.Frame;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;

public class OpenWrtProduct
extends Product {
    private static final int assoclistMacIndex = Oid.ASS_STA_TABLE.getColumnIndex(Oid.ASS_STA_TABLE_MAC);
    private static final int assoclistBSSIDIndex = Oid.ASS_STA_TABLE.getColumnIndex(Oid.ASS_STA_TABLE_BSSID);
    private static final int assoclistRSSIIndex = Oid.ASS_STA_TABLE.getColumnIndex(Oid.ASS_STA_TABLE_RSSI);
    private static final int assocRoleIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_ROLE);
    private static final int assocNPeersIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_NPEERS);
    private static final int assocQualityIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_QUALITY);
    private static final int assocChannelIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_CHANNEL);
    private static final int assocBssidIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BSSID);
    private static final int assocStateIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_STATE);
    private static final int assocBeaconSigIndex = Oid.ASSOC_TABLE.getColumnIndex(Oid.WLAN_TABLE_BEACON_SIGNAL);
    private static final int radioIndex = Oid.RADIO_TABLE.getColumnIndex(Oid.RADIO_TABLE_INDEX);
    private static final int radioNameIndex = Oid.RADIO_TABLE.getColumnIndex(Oid.RADIO_TABLE_NAME);
    private static final int radioEnableIndex = Oid.RADIO_TABLE.getColumnIndex(Oid.RADIO_TABLE_ENABLE);
    private static final int radiophyMacIndex = Oid.RADIO_TABLE.getColumnIndex(Oid.RADIO_PHY_TABLE_MAC);
    private static final int wlanPhyIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_PHYINDEX);
    private static final int wlanChannelIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_CHANNEL);
    private static final int wlanBandIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_BAND);
    private static final int wlanSsidIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_SSID);
    private static final int wlanRoleIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_ROLE);
    private static final int wlanBssidIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_BSSID);
    private static final int wlanSecurityIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_SECURITY);
    private static final int wlanWpaVersionIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_WPA);
    private static final int wlanStateIndex = Oid.WLAN_TABLE.getColumnIndex(Oid.WLAN_TABLE_STATE);
    private static final String radioTableHeader = "<tr bgcolor=#a0d2ff><th>Radio<th>" + TranslateEnum.COLUMN_SSID.get() + "<th>" + TranslateEnum.COLUMN_FUNCTION.get() + "<th>" + TranslateEnum.COLUMN_SECURITY.get() + "<th>" + TranslateEnum.COLUMN_CHANNEL.get() + "<th>" + TranslateEnum.COLUMN_ASSOCIATE.get() + "<th>" + TranslateEnum.RSSI.get() + "</tr>";
    private final ConfigInterface myConfigInterface = new OpenWrtConfig(this);

    public OpenWrtProduct(String flag, ProductModel brand, String specfirm) {
        this.initFlags(flag, brand.id);
        this.canMultiSnmpConfig = true;
        this.canWebInterface = brand.canWebInterface;
        this.canMultifunction = brand.canMultifunction;
        this.firmspec = specfirm;
    }

    @Override
    public ConfigInterface getConfigMethod() {
        return this.myConfigInterface;
    }

    @Override
    public int getTftpStyle() {
        return 1;
    }

    @Override
    public Oid getUniqueIdOid() {
        return Oid.UNIQUE_ID;
    }

    @Override
    public String getSsidDescription() {
        Parameter wlanssid = this.parameters.get(Oid.WLAN_TABLE).getParameterValue(wlanSsidIndex);
        Object ssid = wlanssid.getOneValue(-1);
        if (ssid == Parameter.MULTIPLE) {
            return TranslateEnum.COLVAL_MULTIPLE.get();
        }
        if (ssid == Parameter.UNAVAILABLE) {
            return "";
        }
        return ssid.toString();
    }

    @Override
    public synchronized void getAssocDescription(JLabel assocLab) {
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        Parameter assocstate = assoc.getParameterValue(assocStateIndex);
        Parameter assocrssi = assoc.getParameterValue(assocQualityIndex);
        Parameter assocbssid = assoc.getParameterValue(assocBssidIndex);
        Parameter assocbeaconsig = assoc.getParameterValue(assocBeaconSigIndex);
        Parameter assoclist = this.parameters.get(Oid.ASS_STA_TABLE);
        Parameter assoclistmac = assoclist.getParameterValue(assoclistMacIndex);
        int maxWlans = assocrole.rowCount();
        block0 : switch (maxWlans) {
            case 0: {
                assocLab.setText(TranslateEnum.UNAVAILABLE.get());
                break;
            }
            case 1: {
                switch (MibParser.getIntValue(assocrole, 0)) {
                    case 1: {
                        String clients = this.firmspec == "CA" ? String.valueOf(assoclistmac.rowCount()) : this.parameters.getStringValue(Oid.WIFI_AP_CLIENTS);
                        if (clients != null) {
                            assocLab.setText(String.valueOf(clients) + " " + TranslateEnum.CLIENTS.get());
                            return;
                        }
                    }
                    default: {
                        assocLab.setText(TranslateEnum.UNAVAILABLE.get());
                        break block0;
                    }
                    case 6: {
                        assocLab.setText(TranslateEnum.MESH_DESCRIPTION.get());
                        break block0;
                    }
                    case 3: {
                        if ((Integer)assocstate.getValue(0) >= 9) {
                            assocLab.setText("<html><center>IBSS ID:<br>" + (String)assocbssid.getValue(0) + "</center></html>");
                            break block0;
                        }
                        assocLab.setText(TranslateEnum.DETAILS_NOT_CONNECTED.get());
                    }
                    case 2: 
                    case 7: 
                }
                if ((Integer)assocstate.getValue(0) >= 9) {
                    int rssiValue = (Integer)assocrssi.getValue(0);
                    int sigValue = (Integer)assocbeaconsig.getValue(0);
                    if (UserParameters.getBooleanUserParam("RSSI_UNITE")) {
                        assocLab.setText(String.valueOf(TranslateEnum.RSSI.get()) + " " + sigValue + " dBm");
                    } else {
                        assocLab.setText(String.valueOf(TranslateEnum.RSSI.get()) + " " + rssiValue + "%");
                    }
                    assocLab.setIcon(ImageManager.getRssiImageIcon(rssiValue));
                    break;
                }
                assocLab.setText(TranslateEnum.DETAILS_NOT_CONNECTED.get());
                break;
            }
            default: {
                int i = 0;
                while (i < maxWlans) {
                    if (MibParser.getIntValue(assocrole, i) != 1) {
                        assocLab.setText(TranslateEnum.COLVAL_MULTIPLE.get());
                        return;
                    }
                    ++i;
                }
                String clients = this.firmspec == "CA" ? String.valueOf(assoclistmac.rowCount()) : this.parameters.getStringValue(Oid.WIFI_AP_CLIENTS);
                if (clients != null) {
                    assocLab.setText(String.valueOf(TranslateEnum.CLIENTS.get()) + ": " + clients);
                    break;
                }
                assocLab.setText(TranslateEnum.COLVAL_MULTIPLE.get());
            }
        }
    }

    @Override
    public String getChannelDescription() {
        Parameter wlans = this.parameters.get(Oid.WLAN_TABLE);
        Parameter wlanband = wlans.getParameterValue(wlanBandIndex);
        Parameter wlanchans = wlans.getParameterValue(wlanChannelIndex);
        Object chans = wlanchans.getOneValue(-1);
        Object band = wlanchans.getOneValue(-1);
        if (chans == Parameter.MULTIPLE || band == Parameter.MULTIPLE) {
            return TranslateEnum.COLVAL_MULTIPLE.get();
        }
        if (chans == Parameter.UNAVAILABLE) {
            if (band == Parameter.UNAVAILABLE) {
                return TranslateEnum.UNAVAILABLE.get();
            }
            return MibParser.getValue(wlanband, -1);
        }
        if (band == Parameter.UNAVAILABLE) {
            return chans.toString();
        }
        return String.valueOf(chans.toString()) + "/" + MibParser.getValue(wlanband, -1);
    }

    @Override
    public String getSecurityDescription() {
        Parameter wlans = this.parameters.get(Oid.WLAN_TABLE);
        Parameter wlansecurity = wlans.getParameterValue(wlanSecurityIndex);
        Parameter wlanwpa = wlans.getParameterValue(wlanWpaVersionIndex);
        return this.getSecurityDescription(wlansecurity, wlanwpa, -1);
    }

    private String getSecurityDescription(Parameter securityParamArray, Parameter wpaParamArray, int index) {
        if (securityParamArray == null) {
            return "";
        }
        switch (MibParser.getIntValue(securityParamArray, index)) {
            case 3: {
                return MibParser.getValue(wpaParamArray, index);
            }
            case 2: {
                return String.valueOf(MibParser.getValue(wpaParamArray, index)) + " " + TranslateEnum.PSK.get();
            }
        }
        return MibParser.getValue(securityParamArray, index);
    }

    public void setDefaultBridgeStatus() {
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        Parameter assocstate = assoc.getParameterValue(assocStateIndex);
        Parameter assocbssid = assoc.getParameterValue(assocBssidIndex);
        int maxWlans = assocrole.rowCount();
        int i = 0;
        while (i < maxWlans) {
            if (MibParser.getIntValue(assocrole, i) == 2) {
                if (MibParser.getIntValue(assocstate, i) == 9) {
                    this.setParam(new Parameter(Oid.WIFI_BRIDGE_STATUS, 1));
                    this.setParam(new Parameter(Oid.WIFI_BRIDGE_MAC_AP, (String)assocbssid.getValue(i)));
                } else {
                    this.setParam(new Parameter(Oid.WIFI_BRIDGE_STATUS, 2));
                    this.setParam(new Parameter(Oid.WIFI_BRIDGE_MAC_AP, ""));
                }
                return;
            }
            ++i;
        }
    }

    @Override
    public synchronized int getCurrentWirelessRole() {
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        int maxWlans = assocrole.rowCount();
        if (maxWlans > 0) {
            int i = 0;
            while (i < maxWlans) {
                if (MibParser.getIntValue(assocrole, i) == 2) {
                    return 2;
                }
                ++i;
            }
            return MibParser.getIntValue(assocrole, 0);
        }
        return 0;
    }

    @Override
    public int getClientCount() {
        int count_client = 0;
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        int maxWlans = assocrole.rowCount();
        if (maxWlans > 0) {
            int i = 0;
            while (i < maxWlans) {
                if (MibParser.getIntValue(assocrole, i) == 2) {
                    ++count_client;
                }
                ++i;
            }
        }
        return count_client;
    }

    @Override
    public int getmaxWlans() {
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        int maxWlans = assocrole.rowCount();
        return maxWlans;
    }

    @Override
    public boolean[] getClientFlag() {
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocrole = assoc.getParameterValue(assocRoleIndex);
        int maxWlans = assocrole.rowCount();
        boolean[] flag_wln = new boolean[maxWlans];
        if (maxWlans > 0) {
            int i = 0;
            while (i < maxWlans) {
                flag_wln[i] = MibParser.getIntValue(assocrole, i) == 2;
                ++i;
            }
        }
        return flag_wln;
    }

    @Override
    public boolean getProductByRadioMac(String mac) {
        Parameter radiosphy = this.parameters.get(Oid.RADIO_TABLE);
        Parameter radiophymac = radiosphy.getParameterValue(radiophyMacIndex);
        int radionum = radiophymac.rowCount();
        int i = 0;
        while (i < radionum) {
            if (((String)radiophymac.getValue(i)).substring(2).equals(mac.substring(2))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public synchronized String getHtmlDetails() {
        int i;
        MessageFormat form = new MessageFormat(TranslateEnum.DETAILS_GENERAL1.get());
        Object[] args = new Object[]{this.parameters.getStringValue(Oid.SYSLOCATION), this.getModel(), this.getUniqueIdString(), this.getFirmwareVersionString(), this.parameters.getStringValue(Oid.FIRMWARE_ID)};
        String s = form.format(args);
        s = String.valueOf(s) + "<br><br>";
        s = String.valueOf(s) + "<u>" + TranslateEnum.COLUMN_IP_ADDRESS.get() + "</u>: " + this.getIpString();
        if (!this.canUdap()) {
            s = String.valueOf(s) + ", " + TranslateEnum.DETAILS_UDAP_NAME.get() + ": " + TranslateEnum.UNAVAILABLE.get() + "<br>";
        }
        if (this.cannotMultiSnmpWarning) {
            s = String.valueOf(s) + ", " + TranslateEnum.DETAILS_SNMP_NAME.get() + ": " + TranslateEnum.UNAVAILABLE.get() + "<br>";
            s = String.valueOf(s) + "<br><br>";
            return s;
        }
        s = String.valueOf(s) + "<br><br>";
        Parameter radios = this.parameters.get(Oid.RADIO_TABLE);
        Parameter radiodevs = radios.getParameterValue(radioIndex);
        Parameter radioenable = radios.getParameterValue(radioEnableIndex);
        Parameter radioname = radios.getParameterValue(radioNameIndex);
        int maxRadios = radiodevs.rowCount();
        Parameter wlans = this.parameters.get(Oid.WLAN_TABLE);
        Parameter wlanphy = wlans.getParameterValue(wlanPhyIndex);
        Parameter wlanssid = wlans.getParameterValue(wlanSsidIndex);
        Parameter wlanband = wlans.getParameterValue(wlanBandIndex);
        Parameter wlanchans = wlans.getParameterValue(wlanChannelIndex);
        Parameter wlanrole = wlans.getParameterValue(wlanRoleIndex);
        Parameter wlanbssid = wlans.getParameterValue(wlanBssidIndex);
        Parameter wlansecurity = wlans.getParameterValue(wlanSecurityIndex);
        Parameter wlanwpa = wlans.getParameterValue(wlanWpaVersionIndex);
        Parameter wlanstate = wlans.getParameterValue(wlanStateIndex);
        int maxWlans = wlanrole.rowCount();
        Parameter assoc = this.parameters.get(Oid.ASSOC_TABLE);
        Parameter assocstate = assoc.getParameterValue(assocStateIndex);
        Parameter assocrssi = assoc.getParameterValue(assocQualityIndex);
        Parameter assocbssid = assoc.getParameterValue(assocBssidIndex);
        Parameter assocchannel = assoc.getParameterValue(assocChannelIndex);
        Parameter assocnpeers = assoc.getParameterValue(assocNPeersIndex);
        Parameter assocbeaconsig = assoc.getParameterValue(assocBeaconSigIndex);
        Parameter assoclist = this.parameters.get(Oid.ASS_STA_TABLE);
        Parameter assoclistmac = assoclist.getParameterValue(assoclistMacIndex);
        Parameter assoclistbssid = assoclist.getParameterValue(assoclistBSSIDIndex);
        Parameter assoclistrssi = assoclist.getParameterValue(assoclistRSSIIndex);
        int maxAssocs = assoclistmac.rowCount();
        int[] radiowlancount = new int[maxRadios];
        int[] radioassoccount = new int[maxRadios];
        int[][] radiowlan = null;
        ArrayList assocwlan = new ArrayList();
        String table = "";
        if (maxRadios != 0) {
            radiowlan = new int[maxRadios][maxWlans];
            i = 0;
            while (i < maxWlans) {
                int thisradio;
                int n = thisradio = (Integer)wlanphy.getValue(i) - 1;
                radiowlancount[n] = radiowlancount[n] + 1;
                radiowlan[thisradio][count] = i;
                int n2 = thisradio;
                radioassoccount[n2] = radioassoccount[n2] + 1;
                if ((Integer)assocnpeers.getValue(i) > 0) {
                    int n3 = thisradio;
                    radioassoccount[n3] = radioassoccount[n3] + ((Integer)assocnpeers.getValue(i) - 1);
                }
                ++i;
            }
        }
        int[] sortedRadio = new int[maxRadios];
        String[] sortedRadioName = new String[maxRadios];
        String prev = null;
        if (maxRadios > 0) {
            sortedRadio[0] = 0;
            sortedRadioName[0] = (String)radioname.getValue(0);
            prev = sortedRadioName[0];
        }
        i = 1;
        while (i < maxRadios) {
            String rname = (String)radioname.getValue(i);
            if (rname.compareToIgnoreCase(prev) < 0) {
                sortedRadio[i] = sortedRadio[i - 1];
                sortedRadioName[i] = prev;
                sortedRadio[i - 1] = i;
                sortedRadioName[i - 1] = rname;
            } else {
                sortedRadio[i] = i;
                sortedRadioName[i] = rname;
                prev = rname;
            }
            ++i;
        }
        table = String.valueOf(table) + "<center><table border=1>" + radioTableHeader;
        int i_unsorted = 0;
        while (i_unsorted < maxRadios) {
            i = sortedRadio[i_unsorted];
            String radioHdr = String.valueOf(sortedRadioName[i]) + "<br>";
            int wmax = radiowlancount[i];
            if (wmax == 0) {
                radioHdr = String.valueOf(radioHdr) + TranslateEnum.COLVAL_DISABLE.get();
                table = String.valueOf(table) + "<tr><td>" + radioHdr + "<td colspan=7></tr>";
            } else {
                radioHdr = String.valueOf(radioHdr) + MibParser.getEnable12String(radioenable, i);
                int w = 0;
                while (w < wmax) {
                    int wlanIndex = radiowlan[i][w];
                    int asscount = 0;
                    ArrayList alist = null;
                    if (assocwlan.size() > 0 && assocwlan.get(wlanIndex) != null) {
                        alist = (ArrayList)assocwlan.get(wlanIndex);
                        asscount = alist.size();
                    }
                    table = String.valueOf(table) + "<tr>";
                    if (w == 0) {
                        table = String.valueOf(table) + "<td rowspan=" + wmax + ">" + radioHdr;
                    }
                    String assocStr = null;
                    String rssiStr = null;
                    String[] assocStr_AP = new String[]{};
                    String[] rssiStr_AP = new String[]{};
                    String chanStr = "" + wlanchans.getValue(wlanIndex);
                    switch (MibParser.getIntValue(wlanrole, wlanIndex)) {
                        default: {
                            assocStr = "";
                            rssiStr = "";
                            break;
                        }
                        case 1: {
                            try {
                                assocStr = String.valueOf(TranslateEnum.CLIENTS.get()) + ": " + assocnpeers.getValue(wlanIndex).toString();
                                rssiStr = "/";
                            }
                            catch (Exception e) {
                                assocStr = "";
                                rssiStr = "";
                            }
                            break;
                        }
                        case 6: {
                            assocStr = TranslateEnum.MESH_DESCRIPTION.get();
                            rssiStr = TranslateEnum.UNAVAILABLE.get();
                            break;
                        }
                        case 3: {
                            if (assoc.rowCount() > 0 && assoc.rowCount() > wlanIndex && (Integer)assocstate.getValue(wlanIndex) >= 9) {
                                assocStr = "IBSS ID:<br>" + (String)assocbssid.getValue(wlanIndex);
                                rssiStr = "";
                                break;
                            }
                            assocStr = TranslateEnum.DETAILS_NOT_CONNECTED.get();
                            rssiStr = TranslateEnum.UNAVAILABLE.get();
                            break;
                        }
                        case 2: 
                        case 7: {
                            if (assoc.rowCount() > 0 && assoc.rowCount() > wlanIndex) {
                                if ((Integer)assocstate.getValue(wlanIndex) >= 9) {
                                    int rssiValue = (Integer)assocrssi.getValue(wlanIndex);
                                    int sigValue = (Integer)assocbeaconsig.getValue(wlanIndex);
                                    assocStr = (String)assocbssid.getValue(wlanIndex);
                                    Product p = ProductManager.getInstance().getProductByMacInGUIThread(assocStr);
                                    assocStr = p != null ? String.valueOf(p.toDisplayMac()) + "<br>( " + assocStr + " )" : assocStr;
                                    rssiStr = "<img src=\"" + ImageManager.getRssiUrlString(rssiValue) + "\" >" + "<br>" + TranslateEnum.RSSI.get() + " ";
                                    rssiStr = UserParameters.getBooleanUserParam("RSSI_UNITE") ? String.valueOf(rssiStr) + (sigValue != -9999 ? String.valueOf(sigValue) + " dBm" : TranslateEnum.UNAVAILABLE.get()) : String.valueOf(rssiStr) + rssiValue + "%";
                                }
                            } else {
                                assocStr = TranslateEnum.DETAILS_NOT_CONNECTED.get();
                                rssiStr = TranslateEnum.UNAVAILABLE.get();
                            }
                            if (!(chanStr = "" + (assoc.rowCount() > 0 ? assocchannel.getValue(wlanIndex) : wlanchans.getValue(wlanIndex))).equals("0") && !chanStr.equals("-1")) break;
                            assocStr = TranslateEnum.DETAILS_NOT_CONNECTED.get();
                            rssiStr = TranslateEnum.UNAVAILABLE.get();
                            chanStr = TranslateEnum.DETAILS_CHAN_SCANNING.get();
                        }
                    }
                    asscount = 0;
                    table = String.valueOf(table) + "<td align=\"center\" rowspan=" + (asscount > 0 ? asscount : 1) + ">" + wlanssid.getValue(wlanIndex) + "<td align=\"center\" rowspan=" + (asscount > 0 ? asscount : 1) + ">" + MibParser.getValue(wlanrole, wlanIndex) + "<td align=\"center\" rowspan=" + (asscount > 0 ? asscount : 1) + ">" + this.getSecurityDescription(wlansecurity, wlanwpa, wlanIndex) + "<td align=\"center\" rowspan=" + (asscount > 0 ? asscount : 1) + ">" + chanStr + "/" + MibParser.getValue(wlanband, wlanIndex);
                    if (assocStr_AP.length != 0 && rssiStr_AP.length != 0) {
                        table = String.valueOf(table) + "<td align=\"center\" >" + assocStr_AP[0] + "<td align=\"center\" >" + rssiStr_AP[0] + "</tr>";
                        int h = 1;
                        while (h < asscount) {
                            table = String.valueOf(table) + "<tr><td align=\"center\" >" + assocStr_AP[h] + "<td align=\"center\" >" + rssiStr_AP[h] + "</tr>";
                            ++h;
                        }
                    } else {
                        table = String.valueOf(table) + "<td align=\"center\" >" + assocStr + "<td align=\"center\" >" + rssiStr + "</tr>";
                    }
                    ++w;
                }
            }
            ++i_unsorted;
        }
        table = String.valueOf(table) + "</table></center>";
        s = String.valueOf(s) + table;
        return s;
    }

    @Override
    public void getbaseconfig(Frame frame, List<Product> selectedList) {
        selectedList.size();
        ConfigDialog2 conf = new ConfigDialog2(frame, selectedList);
        conf.setVisible(true);
    }
}

