/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ig.IpComparator;
import fr.acksys.snmp.Oid;
import java.util.HashMap;
import java.util.Map;

public class ParametersDB {
    protected Map<Oid, Parameter> parametersMap = new HashMap<Oid, Parameter>(32);

    public void put(Parameter param) {
        this.parametersMap.put(param.getId(), param);
    }

    public void put(Oid oid, int value) {
        this.parametersMap.put(oid, new Parameter(oid, value));
    }

    public void put(Oid oid, String value) {
        this.parametersMap.put(oid, new Parameter(oid, value));
    }

    public Parameter get(Oid key) {
        return this.parametersMap.get((Object)key);
    }

    public String getStringValue(Oid oid) {
        Parameter param = this.parametersMap.get((Object)oid);
        if (param == null) {
            return null;
        }
        switch (oid.getType()) {
            case INTEGER: 
            case GAUGE32: 
            case TIMETICKS: {
                return param.getValue().toString();
            }
        }
        return param.getValue().toString();
    }

    public int getIntegerValue(Oid oid) throws NumberFormatException {
        Parameter param = this.parametersMap.get((Object)oid);
        if (param == null) {
            return 0;
        }
        switch (oid.getType()) {
            case INTEGER: 
            case GAUGE32: {
                return (Integer)param.getValue();
            }
            case IP_ADDRESS: {
                return param == null ? 0 : IpComparator.toInteger((String)param.getValue());
            }
            case TIMETICKS: {
                return (int)((Long)param.getValue()).longValue();
            }
        }
        return Integer.parseInt((String)param.getValue());
    }

    public int getPositiveValue(Oid oid) {
        Parameter param = this.parametersMap.get((Object)oid);
        if (param != null) {
            switch (oid.getType()) {
                case INTEGER: 
                case GAUGE32: {
                    return (Integer)param.getValue();
                }
                case TIMETICKS: {
                    return (int)((Long)param.getValue()).longValue();
                }
            }
            try {
                int i = Integer.parseInt((String)param.getValue());
                return i >= 0 ? i : -1;
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public void iterate(NdmCallback code) {
        for (Oid key : this.parametersMap.keySet()) {
            code.callback(this.parametersMap.get((Object)key));
        }
    }

    public Object getMap() {
        return this.parametersMap;
    }
}

