/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.ndm.NdmCallback;
import fr.acksys.ndm.NdmDb;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.ProductManager;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.ConfigDialog2;
import fr.acksys.ndm.ig.IgUtils;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.ig.RefreshableInterface;
import fr.acksys.ndm.product.ParametersDB;
import fr.acksys.ndm.product.ProductModel;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.ndm.product.config.UnknownConfig;
import fr.acksys.ndm.product.upgrade.TftpUpgrade;
import fr.acksys.ndm.product.upgrade.UnknownUpgrade;
import fr.acksys.ndm.product.upgrade.UpgradeInterface;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.udap.Udap;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public abstract class Product {
    public static final int WL_ROLE_NONE = 0;
    public static final int WL_ROLE_AP = 1;
    public static final int WL_ROLE_CLIENT = 2;
    public static final int WL_ROLE_ADHOC = 3;
    public static final int WL_ROLE_VLANAP = 4;
    public static final int WL_ROLE_WDS = 5;
    public static final int WL_ROLE_MESH = 6;
    public static final int WL_ROLE_REPEATER = 7;
    public static final int WL_SECURITY_NONE = 0;
    public static final int WL_SECURITY_WEP = 1;
    public static final int WL_SECURITY_WPAPSK = 2;
    public static final int WL_SECURITY_WPA = 3;
    public static final int WL_SECURITY_UNKNOWN = 4;
    protected String communityRead;
    protected String communityWrite;
    private boolean isDefaultCommunityRead;
    private boolean isDefaultCommunityWrite;
    protected ConfigInterface config;
    protected UpgradeInterface upgrade;
    private List<RefreshableInterface> refreshList = new ArrayList<RefreshableInterface>();
    public ParametersDB parameters = new ParametersDB();
    public String firmspec = "AC";
    protected String model;
    public int snmpVersion = 0;
    public boolean iden_sign = false;
    protected String iconModel;
    protected int timeToLive;
    private int maxTimeToLive;
    private int distance;
    private boolean selectedInTree;
    private boolean hiddenByUser;
    private boolean isDeleted;
    private boolean displayed;
    private Boolean canUdap;
    public boolean canMultiSnmpConfig;
    public boolean cannotMultiSnmpWarning;
    public boolean canWebInterface;
    public boolean canMultifunction;
    public int tftpActivationMethod;
    public boolean hasAnyStaticParameterChanged;
    public boolean hasAnyStatusParameterChanged;
    public boolean hasWifiPeerChanged;
    private NdmCallback setParamCallback;
    public static final int IDEN_STATUS_NON = 0;
    public static final int IDEN_STATUS_STOP = 1;
    public static final int IDEN_STATUS_START = 2;
    public int iden_status;
    public boolean is_respond;
    public boolean thread_isstoped;
    public boolean is_snmprespond;
    public boolean rolechange;
    public boolean locationchange;

    public Product() {
        this.iconModel = ProductModel.UNKNOWN.id;
        this.timeToLive = 0;
        this.maxTimeToLive = 0;
        this.distance = 0;
        this.selectedInTree = false;
        this.canMultifunction = false;
        this.hasAnyStaticParameterChanged = false;
        this.hasAnyStatusParameterChanged = false;
        this.hasWifiPeerChanged = false;
        this.setParamCallback = null;
        this.iden_status = 0;
        this.is_respond = false;
        this.thread_isstoped = true;
        this.is_snmprespond = false;
        this.rolechange = false;
        this.locationchange = false;
        this.setCommunityRead("");
        this.setCommunityWrite("");
        this.setMaxTTL(4);
        this.isDeleted = true;
        this.displayed = false;
        this.canUdap = false;
        this.canMultiSnmpConfig = false;
        this.cannotMultiSnmpWarning = false;
        this.canWebInterface = false;
        this.tftpActivationMethod = 0;
        this.setParam(new Parameter(Oid.WIFI_MODE, -1));
        this.setParam(new Parameter(Oid.WIFI_BRIDGE_MODE, -1));
        this.parameters.put(new Parameter(Oid.RADIO_TABLE));
        this.parameters.put(new Parameter(Oid.WLAN_TABLE));
        this.parameters.put(new Parameter(Oid.ASSOC_TABLE));
        this.parameters.put(new Parameter(Oid.ASS_STA_TABLE));
    }

    public String toDisplayMac() {
        String syslocation = this.parameters.getStringValue(Oid.SYSLOCATION);
        if (syslocation.equalsIgnoreCase("ACKSYS Device") || syslocation.equals("User-definable")) {
            return this.getIpString();
        }
        return syslocation;
    }

    protected void initFlags(String flag, String submodel) {
        if (flag.indexOf("U") != -1) {
            this.setCanUdap(true);
            this.config = this.getConfigMethod();
        } else {
            this.config = new UnknownConfig(this);
        }
        this.tftpActivationMethod = this.getTftpStyle();
        this.upgrade = flag.indexOf("T") != -1 ? new TftpUpgrade() : new UnknownUpgrade();
        this.snmpVersion = flag.indexOf("1") != -1 ? 1 : (flag.indexOf("2") != -1 ? 2 : (flag.indexOf("3") != -1 ? 3 : 0));
        if (flag.indexOf("L") != -1) {
            this.iden_sign = true;
            this.iden_status = 1;
        } else {
            this.iden_sign = false;
            this.iden_status = 0;
        }
        if (submodel != null) {
            this.iconModel = submodel;
        }
    }

    public void cleanup() {
        final Product p = this;
        final boolean wasDisplayed = this.displayed;
        this.isDeleted = true;
        this.displayed = false;
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                for (RefreshableInterface refreshItem : Product.this.refreshList) {
                    if (!wasDisplayed) continue;
                    refreshItem.refreshRemove(p);
                }
            }
        });
    }

    public String getCommunityRead() {
        return this.communityRead;
    }

    public int getClientCount() {
        return 0;
    }

    public int getmaxWlans() {
        return 0;
    }

    public boolean[] getClientFlag() {
        return null;
    }

    public void setCommunityRead(String communityRead) {
        if (communityRead.equals("")) {
            this.communityRead = UserParameters.getInstance().getParam("SNMP_COMMUNITY_READ");
            this.isDefaultCommunityRead = true;
        } else {
            this.communityRead = communityRead;
            this.isDefaultCommunityRead = false;
        }
    }

    public String getCommunityWrite() {
        return this.communityWrite;
    }

    public boolean isDefaultCommunityRead() {
        return this.isDefaultCommunityRead;
    }

    public boolean isDefaultCommunityWrite() {
        return this.isDefaultCommunityWrite;
    }

    public void setCommunityWrite(String communityWrite) {
        if (communityWrite.equals("")) {
            this.communityWrite = UserParameters.getInstance().getParam("SNMP_COMMUNITY_WRITE");
            this.isDefaultCommunityWrite = true;
        } else {
            this.communityWrite = communityWrite;
            this.isDefaultCommunityWrite = false;
        }
    }

    public int configure(char[] password) {
        final ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        this.parameters.iterate(new NdmCallback(){

            @Override
            public void callback(Object ob) {
                if (((Parameter)ob).isChanged()) {
                    paramList.add((Parameter)ob);
                }
            }
        });
        int configOk = this.config.setConfig(paramList, password);
        if (configOk == 0) {
            this.configApplied(paramList);
        }
        return configOk;
    }

    public void identify_Product(int timeout) {
        this.config.idenUdapProduct(timeout);
    }

    public int getConfigurationTime() {
        return this.config.getConfigurationTime();
    }

    public void configApplied(List<Parameter> paramList) {
        boolean needDbUpdate = false;
        for (Parameter param : paramList) {
            Oid oid = param.getId();
            if (oid == Oid.IP_ADDRESS) {
                needDbUpdate = true;
            }
            if (oid == Oid.RESET) {
                param.setNewValue(0);
            }
            this.hasAnyStatusParameterChanged = true;
            this.hasAnyStaticParameterChanged = true;
            param.applyNewValue();
        }
        if (needDbUpdate) {
            NdmDb.getInstance().executeSynchronizedSqlChange(String.format("update products set p_ip='%s' where p_mac='%s';", this.getIpString(), this.getUniqueIdString()));
        }
        this.checkForDisplayChanges();
    }

    public void setParam(Parameter parameter) {
        Oid id = parameter.getId();
        Parameter old = this.parameters.get(id);
        if (old == null || !parameter.equals(old)) {
            if (id == Oid.SYSUPTIME || id == Oid.WIFI_BRIDGE_RSSI || id == Oid.WIFI_BRIDGE_RSSI_dBm || id == Oid.WIFI_AP_CLIENTS) {
                this.hasAnyStatusParameterChanged = true;
            } else if (id == Oid.WIFI_BRIDGE_MAC_AP) {
                this.hasWifiPeerChanged = true;
            } else {
                this.hasAnyStaticParameterChanged = true;
            }
            this.parameters.put(parameter);
            if (old != null && this.setParamCallback != null) {
                this.setParamCallback.callback(Arrays.asList(this, parameter));
            }
            if (id == Oid.SYSDESCR) {
                String[] splitDescr;
                String capabilities = this.parameters.getStringValue(Oid.FIRMWARE_DESCRIPTION);
                capabilities = capabilities != null ? ((splitDescr = capabilities.split("_", 3)).length < 2 ? "A" : splitDescr[2]) : "B";
                String sysdescr = (String)parameter.getValue();
                splitDescr = sysdescr.split("_", 4);
                if (splitDescr.length < 2) {
                    splitDescr = (String.valueOf(sysdescr) + "_" + TranslateEnum.VERSION_OLD.get()).split("_", 4);
                } else if (splitDescr.length < 3) {
                    splitDescr = (String.valueOf(sysdescr) + "_" + TranslateEnum.VERSION_OLD.get().substring(6)).split("_", 4);
                } else if (splitDescr.length < 4) {
                    splitDescr = (String.valueOf(sysdescr) + "_U3").split("_", 4);
                }
                this.setDeviceType(splitDescr[0]);
                ProductModel brand = ProductModel.getModelFromProductAndFirmwareCodes(splitDescr[1], this.parameters.getPositiveValue(Oid.PRODUCT_CODE));
                if (brand != ProductModel.WLG_NEW) {
                    this.iconModel = brand.id;
                }
                this.parameters.put(Oid.FIRMWARE_DESCRIPTION, String.valueOf(splitDescr[1]) + "_" + splitDescr[2] + "_" + splitDescr[3]);
                this.parameters.put(Oid.FIRMWARE_ID, splitDescr[1]);
                this.parameters.put(Oid.FIRMWARE_VERSION, splitDescr[2]);
                if (capabilities != splitDescr[3]) {
                    this.initFlags(splitDescr[3], null);
                }
            } else if (id == Oid.PRODUCT_CODE) {
                ProductModel brand;
                if (old != null && (brand = ProductModel.getModelFromProductAndFirmwareCodes(this.parameters.getStringValue(Oid.FIRMWARE_ID), (Integer)parameter.getValue())) != ProductModel.WLG_NEW) {
                    this.iconModel = brand.id;
                }
            } else if (id == Oid.IP_ADDRESS) {
                try {
                    Integer netmask = this.parameters.getIntegerValue(Oid.SUBNET_MASK);
                    Integer gateway = this.parameters.getIntegerValue(Oid.GATEWAY);
                    if (gateway != 0 && (this.parameters.getIntegerValue(Oid.IP_ADDRESS) & netmask) != (gateway & netmask)) {
                        this.updateConfig();
                    }
                }
                catch (NumberFormatException e) {
                    this.updateConfig();
                }
            } else if (id == Oid.WIFI_MODE) {
                if ((Integer)parameter.getValue() == 2 || this.parameters.get(Oid.WIFI_BRIDGE_MODE) == null) {
                    this.parameters.put(Oid.WIFI_BRIDGE_MODE, 1);
                }
            } else if (id == Oid.SYSUPTIME && old != null && (Long)parameter.getValue() < (Long)old.getValue()) {
                this.updateConfig();
            }
        }
    }

    public void changeStatusParamArray(Parameter oldTable, Parameter[] newTable, int newSize) {
        int oldRole = this.getCurrentWirelessRole();
        if (newSize != ((Parameter)oldTable.getValue(0)).rowCount()) {
            int i = 0;
            while (i < newTable.length) {
                oldTable.setValue(i, newTable[i]);
                ++i;
            }
            this.hasAnyStatusParameterChanged = true;
        } else {
            int j = 0;
            while (j < newTable.length) {
                Parameter newParam = newTable[j];
                Parameter oldParam = (Parameter)oldTable.getValue(j);
                int newMax = newParam.rowCount();
                int i = 0;
                while (i < newMax) {
                    if (oldParam.testAndSetValue(i, newParam.getValue(i))) {
                        this.hasAnyStatusParameterChanged = true;
                    }
                    ++i;
                }
                ++j;
            }
        }
        if (oldRole != this.getCurrentWirelessRole()) {
            this.hasAnyStaticParameterChanged = true;
        }
    }

    public boolean updateParam(Oid id, Object newValue) {
        Parameter param = this.parameters.get(id);
        if (param == null) {
            param = new Parameter(id);
            this.setParam(param);
        }
        param.setNewValue(newValue);
        return true;
    }

    public Parameter getParam(Oid id) {
        Parameter param = this.parameters.get(id);
        if (param == null) {
            switch (id.getType()) {
                case INTEGER: 
                case GAUGE32: {
                    return new Parameter(id, -1);
                }
                case TIMETICKS: {
                    return new Parameter(id, -1);
                }
            }
            return new Parameter(id, "");
        }
        return param;
    }

    public String getIpString() {
        Parameter param = this.parameters.get(Oid.IP_ADDRESS);
        return param == null ? "" : (String)param.getValue();
    }

    public void refreshState(List<Oid> paramsList) {
        this.config.getConfig(paramsList);
    }

    public void upgrade(String file, char[] pwd, JProgressBar progress, JTextArea logArea) {
        this.upgrade.upgrade(file, pwd, this, progress, logArea);
        this.updateIg();
    }

    public ImageIcon getImageProduct() {
        ImageIcon img = ImageManager.getImageIcon(this.iconModel);
        if (img == null) {
            img = ImageManager.getImageIcon(ProductModel.UNKNOWN.id);
        }
        return img;
    }

    public String getModel() {
        return this.model;
    }

    public void updateConfig() {
        this.config.updateConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canUdap() {
        Boolean bl = this.canUdap;
        synchronized (bl) {
            return this.canUdap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCanUdap(boolean b) {
        Boolean bl = this.canUdap;
        synchronized (bl) {
            this.canUdap = b;
        }
    }

    public boolean equals(Object obj) {
        int phase;
        block13: {
            Product other;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            other = null;
                            phase = 0;
                            try {
                                if (this != obj) break block9;
                                return true;
                            }
                            catch (NullPointerException e) {
                                e.printStackTrace();
                                System.out.println("Product.equals.NullPointerException:phase " + phase);
                                System.out.println("   :obj =" + obj.getClass().getName() + '@' + Integer.toHexString(obj.hashCode()));
                                System.out.println("   :this=" + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()));
                                if (other != null) {
                                    System.out.println("   :obj.pm =" + other.parameters);
                                    System.out.println("   :this.pm=" + this.parameters);
                                    System.out.println("   :obj.pm.get =" + other.getUniqueIdString());
                                    System.out.println("   :this.pm.get=" + this.getUniqueIdString());
                                    System.out.println("   :obj.pm.get =" + other.getUniqueIdString());
                                    System.out.println("   :this.pm.get=" + this.getUniqueIdString());
                                }
                                return false;
                            }
                        }
                        phase = 1;
                        if (obj != null) break block10;
                        return false;
                    }
                    phase = 2;
                    if (this.getClass() == obj.getClass()) break block11;
                    return false;
                }
                phase = 3;
                other = (Product)obj;
                phase = 4;
                if (this.parameters.getMap() != null) break block12;
                phase = 5;
                if (other.parameters.getMap() != null) {
                    return false;
                }
                break block13;
            }
            phase = 6;
            if (this.getUniqueIdString().equals(other.getUniqueIdString())) break block13;
            return false;
        }
        phase = 7;
        return true;
    }

    public void registerRefreshIg(final RefreshableInterface refreshItem) {
        final Product p = this;
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (!Product.this.refreshList.contains(refreshItem)) {
                    Product.this.refreshList.add(refreshItem);
                    if (Product.this.displayed) {
                        refreshItem.refreshAdd(p);
                    }
                }
            }
        });
    }

    public void unRegisterRefreshIg(final RefreshableInterface refreshItem) {
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                Product.this.refreshList.remove(refreshItem);
            }
        });
    }

    public void setDistance(int distance) {
        this.distance = distance;
    }

    public int getDistance() {
        return this.distance;
    }

    public void decrementTTL() {
        if (this.timeToLive > 0 && --this.timeToLive == 0) {
            this.toggleDisplayRemoveIfConditionsAreMet();
            ProductManager.checkIpConflictsForIg(this, false);
        }
    }

    public void clearTTL() {
        if (this.timeToLive > 0) {
            this.timeToLive = 1;
            this.decrementTTL();
        }
    }

    public void resetTTL() {
        int oldTtl = this.timeToLive;
        this.timeToLive = this.maxTimeToLive;
        if (oldTtl == 0) {
            this.toggleDisplayRemoveIfConditionsAreMet();
            ProductManager.checkIpConflictsForIg(this, true);
        }
    }

    public int getTTL() {
        return this.timeToLive;
    }

    private void setMaxTTL(int max) {
        this.maxTimeToLive = max;
    }

    public void setSelectedInTreeState(boolean show) {
        this.selectedInTree = show;
    }

    public boolean isSelectedInTree() {
        return this.selectedInTree;
    }

    public void setUserHideState(boolean hide) {
        this.hiddenByUser = hide;
        this.toggleDisplayRemoveIfConditionsAreMet();
    }

    public boolean isHiddenByUser() {
        return this.hiddenByUser;
    }

    public void toggleDisplayRemoveIfConditionsAreMet() {
        final Product p = this;
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (!(Product.this.isDeleted || Product.this.hiddenByUser || Product.this.timeToLive <= 0 && !ProductManager.showDead)) {
                    if (!Product.this.displayed) {
                        Product.this.displayed = true;
                        for (RefreshableInterface refreshItem : Product.this.refreshList) {
                            refreshItem.refreshAdd(p);
                        }
                    } else {
                        Product.this.updateIg();
                    }
                } else if (Product.this.displayed) {
                    Product.this.displayed = false;
                    for (RefreshableInterface refreshItem : Product.this.refreshList) {
                        refreshItem.refreshRemove(p);
                    }
                    ProductManager.resetProductInDetailsPane(p);
                }
            }
        });
    }

    public boolean requiresDisplay() {
        return this.displayed;
    }

    public void initDisplayableFlag() {
        this.isDeleted = false;
        this.displayed = !this.isDeleted && !this.hiddenByUser && (this.timeToLive > 0 || ProductManager.showDead);
    }

    public String dumpDisplayFlags() {
        return "treeSel=" + this.selectedInTree + " deleted=" + this.isDeleted + " (TTL=" + this.timeToLive + " || showdead=" + ProductManager.showDead + ") userHid=" + this.hiddenByUser;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " " + this.getIpString() + " " + this.getUniqueIdString();
    }

    public void updateIg() {
        final Product p = this;
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (Product.this.displayed) {
                    for (RefreshableInterface refreshItem : Product.this.refreshList) {
                        refreshItem.refreshProduct(p);
                    }
                    ProductManager.updateProductDetails(p);
                }
            }
        });
    }

    public void updateDynamicIg() {
        final Product p = this;
        IgUtils.ExecuteOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (Product.this.displayed) {
                    for (RefreshableInterface refreshItem : ProductManager.dynamicStatusList) {
                        refreshItem.refreshProduct(p);
                    }
                    ProductManager.updateProductDetails(p);
                }
            }
        });
    }

    public void setDeviceType(String model) {
        this.model = model;
    }

    public void dump() {
        System.out.println("==============================================");
        System.out.println(String.valueOf(this.getIpString()) + " udap=" + this.canUdap + ", ttl=" + this.getTTL() + " role=" + this.parameters.getPositiveValue(Oid.WIFI_MODE) + "," + this.parameters.getPositiveValue(Oid.WIFI_BRIDGE_MODE) + "," + this.getCurrentWirelessRole());
        this.parameters.iterate(new NdmCallback(){

            @Override
            public void callback(Object ob) {
                ((Parameter)ob).print("Product:dump");
            }
        });
    }

    public synchronized void checkForDisplayChanges() {
        if (this.hasAnyStaticParameterChanged) {
            this.hasAnyStaticParameterChanged = false;
            this.updateIg();
        } else if (this.hasAnyStatusParameterChanged) {
            this.hasAnyStatusParameterChanged = false;
            this.updateDynamicIg();
        }
    }

    public String getFirmwareVersionString() {
        return this.parameters.getStringValue(Oid.FIRMWARE_VERSION);
    }

    public String getFirmwareFunctionString() {
        String str = this.parameters.getStringValue(Oid.FIRMWARE_ID);
        switch (this.getCurrentWirelessRole()) {
            default: {
                return "";
            }
            case 1: {
                if (str != null && str.startsWith("E2124")) {
                    return this.parameters.getPositiveValue(Oid.WIFI_AP_WDS_MODE) == 2 ? TranslateEnum.COLVAL_ROLE_AP_SERIAL_WDS.get() : TranslateEnum.COLVAL_ROLE_AP_SERIAL.get();
                }
                return this.parameters.getPositiveValue(Oid.WIFI_AP_WDS_MODE) == 2 ? TranslateEnum.COLVAL_ROLE_WDS_REPEATER.get() : TranslateEnum.COLVAL_ROLE_AP.get();
            }
            case 3: {
                if (str != null && str.startsWith("E2124")) {
                    return TranslateEnum.COLVAL_ROLE_BRIDGE_ADHOC_SERIAL.get();
                }
                return TranslateEnum.COLVAL_ROLE_BRIDGE_ADHOC.get();
            }
            case 6: {
                return TranslateEnum.COLVAL_WROLE_MESH.get();
            }
            case 2: 
            case 7: 
        }
        if (str != null && str.startsWith("E2124")) {
            return TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_SERIAL.get();
        }
        return TranslateEnum.COLVAL_ROLE_BRIDGE_WIFI_ETH.get();
    }

    public void setSetParamCallback(NdmCallback cb) {
        this.setParamCallback = cb;
    }

    public abstract Oid getUniqueIdOid();

    public String getUniqueIdString() {
        return this.parameters.getStringValue(Oid.GENERIC_PRODUCT_ID);
    }

    public void setUniqueIdString(String uniqueId) {
        this.setParam(new Parameter(Oid.GENERIC_PRODUCT_ID, uniqueId));
    }

    public String getHtmlDetails() {
        String s = "No extended information available for this product category";
        return s;
    }

    public String getSecurityDescription() {
        return TranslateEnum.COLVAL_NA.get();
    }

    public String getSsidDescription() {
        String value = this.parameters.getStringValue(Oid.WIFI_SSID);
        if (value == null) {
            return "";
        }
        return value;
    }

    public String getChannelDescription() {
        return TranslateEnum.COLVAL_NA.get();
    }

    public abstract void getAssocDescription(JLabel var1);

    public abstract ConfigInterface getConfigMethod();

    public abstract int getTftpStyle();

    public abstract int getCurrentWirelessRole();

    public boolean peerHasChangedAutoReset() {
        boolean b = this.hasWifiPeerChanged;
        this.hasWifiPeerChanged = false;
        return b;
    }

    public void getbaseconfig(Frame frame, List<Product> selectedList) {
        ConfigDialog2 conf = new ConfigDialog2(frame, selectedList);
        conf.setVisible(true);
    }

    public void unicastRetry() {
        final Product p = this;
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                    if (p.getTTL() == 2) {
                        p.decrementTTL();
                        Udap.updateConfig(p, true);
                        Thread.sleep(200L);
                        if (p.getTTL() == 1) {
                            p.decrementTTL();
                        }
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    public boolean getProductByRadioMac(String mac) {
        return false;
    }
}

