/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.custom.Company;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.ProductModel;
import fr.acksys.udap.DiscoverResponse;

public class ProductFactory {
    private static final String CS_SPECIFIC = "CSL Wifi a/b/g/h product";
    private static final String IN_SPECIFIC = "QUEST Wifi a/b/g/h product";
    private static final String SL_SPECIFIC = "Snaplink Radio";
    private static final String TH_SPECIFIC = "Ubicom, Inc. Wifi a/b/g/h product";
    private static final String FORCE_HIDE = "";
    private static final String FORCE_SHOW = "AC";

    public static Product createProduct(DiscoverResponse response) {
        String specific;
        Product prod;
        String sysDescr = response.getSysDescr();
        if (response.getFirmwareId().equals(FORCE_HIDE)) {
            if (sysDescr.equalsIgnoreCase("ACKSYS ACCESS POINT / BRIDGE")) {
                prod = ProductModel.createOldWlgProduct(ProductModel.WLB, response, "U");
                specific = FORCE_SHOW;
            } else if (sysDescr.equalsIgnoreCase("ACKSYS Wifi a/b/g/h product")) {
                prod = ProductModel.createOldWlgProduct(ProductModel.WLG_OLD, response, "UT");
                specific = FORCE_SHOW;
            } else if (sysDescr.equalsIgnoreCase("ACKSYS Ethernet AIR-PACK unit")) {
                prod = ProductModel.createOldWlgProduct(ProductModel.AIRPACKV0, response, "UT");
                specific = FORCE_SHOW;
            } else if (sysDescr.equalsIgnoreCase("Ubicom ISP/ISD Dongle")) {
                prod = ProductModel.createSonde(response);
                specific = "UB";
            } else if (sysDescr.equalsIgnoreCase(CS_SPECIFIC)) {
                prod = ProductModel.createWlgProduct(ProductModel.CS_WLGLINK, response, "UT");
                specific = "CS";
            } else if (sysDescr.equalsIgnoreCase(IN_SPECIFIC) || sysDescr.equalsIgnoreCase(SL_SPECIFIC) || sysDescr.equalsIgnoreCase(TH_SPECIFIC)) {
                prod = ProductModel.createOldWlgProduct(ProductModel.SPECIFIC, response, "UT");
                specific = FORCE_HIDE;
            } else {
                prod = ProductModel.createWlgProduct(ProductModel.UNKNOWN, response, FORCE_HIDE);
                specific = FORCE_SHOW;
            }
        } else {
            String[] firmdesc = response.getFirmwareId().split("_");
            if (firmdesc.length != 3) {
                prod = ProductModel.createWlgProduct(ProductModel.UNKNOWN, response, FORCE_HIDE);
                specific = FORCE_SHOW;
            } else if (Company.afficherAussiNdmStandard && response.isStandardNdm()) {
                prod = ProductModel.createFromProductAndFirmwareCodes(firmdesc[0], response.getProductCode(), response, firmdesc[2]);
                specific = FORCE_SHOW;
            } else {
                prod = ProductModel.createFromProductAndFirmwareCodes(firmdesc[0], response.getProductCode(), response, firmdesc[2]);
                String[] firmId = firmdesc[0].split("\\.");
                String string = specific = firmId.length < 2 ? FORCE_HIDE : firmId[1];
            }
        }
        if (!specific.equals(FORCE_SHOW) && UserParameters.getInstance().getParam("SHOW_ALL").equals("0")) {
            return null;
        }
        return prod;
    }
}

