/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.product.CATWlgProduct;
import fr.acksys.ndm.product.OpenWrtProduct;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.Sonde;
import fr.acksys.ndm.product.WlgProduct;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import fr.acksys.udap.DiscoverResponse;

public enum ProductModel {
    UNKNOWN(1, true, false, TranslateEnum.UNKNOWN.get(), "unknown.png"),
    WLG_OLD(1, true, false, "ACKSYS Wifi a/b/g/h product", "wlg-old.png"),
    WLB(1, true, false, "ACKSYS ACCESS POINT / BRIDGE", "wlb-old.png"),
    WLG_NEW(1, true, false, "New product", "new.png"),
    SONDE(1, true, false, "Ubicom ISP/ISD Dongle", "sonde.png"),
    SPECIFIC(1, true, false, "SPECIFIC", "wlg-specific.png"),
    AIRPACKV0(1, true, false, "ACKSYS Ethernet AIR-PACK unit", "airpack.png"),
    WLGEMERGENCY(1, true, false, "E2131.AC.0.000", "emergency.png"),
    WLGLINK(1, true, false, "E2080.AC.1.001", "wlg-link.png"),
    AIRPACKV1(1, true, false, "E2080.AC.2.001", "airpack.png"),
    TH_WLGLINK(1, true, false, "E2080.TH.1.001", "wlg-link.png"),
    CS_WLGLINK(1, true, false, "E2080.CS.1.001", "wlg-csl.png"),
    CA_WLGABOARDNV3(1, true, false, "E2080.CA.1.019", "wlg-CAT.png"),
    CA_WLGABOARDNV3_US(1, true, false, "E2080.CA.2.019", "wlg-CAT.png"),
    WLGABOARDN(1, true, false, "E2080.AC.1.002", "wlg-aboard-n.png"),
    HYPERLAN(1, true, false, "E2080.AC.2.002", "hyperlan.png"),
    WLGACCESSATEX(1, true, false, "E2080.AC.3.002", "wlg-access-atex.png"),
    WLGLINKV2(1, true, false, "E2080.AC.1.003", "wlg-link.png"),
    AIRPACKV2(1, true, false, "E2080.AC.2.003", "airpack.png"),
    CS_WLGLINKV2(1, true, false, "E2080.CS.1.003", "wlg-csl.png"),
    CE_WLGLINKV2(1, true, false, "E2080.CE.1.003", "wlg-link-oem.png"),
    KO_WLGLINKV2(1, true, false, "E2080.KO.1.003", "wlg-link-oem.png"),
    WLGABOARDNV2(1, true, false, "E2080.AC.1.004", "wlg-aboard-n.png"),
    HYPERLANV2(1, true, false, "E2080.AC.2.004", "hyperlan.png"),
    WLGACCESSATEXV2(1, true, false, "E2080.AC.3.004", "wlg-access-atex.png"),
    WLGSWITCH(1, true, false, "E2080.AC.1.005", "wlg-switch.png"),
    WLGDONGLEOEM(1, true, false, "E2124.AC.1.006", "wlg-dongle-oem-ttl.png"),
    WLGDONGLEMECA(1, true, false, "E2124.AC.1.007", "wlg-dongle.png"),
    MSWABOARD(1, true, false, "Exxxx.AC.1.008", "new.png"),
    WLGXROADN(1, true, false, "E2080.AC.1.009", "wlg-xroad-n.png"),
    IO1_WLGXROADN(1, true, false, "E2080.IO.1.009", "wlg-xroad-n.png"),
    IO2_WLGXROADN(1, true, false, "E2080.IO.2.009", "wlg-xroad-n.png"),
    WLGXROADS(1, true, false, "E2124.AC.1.010", "wlg-xroad-s.png"),
    WLGIDAN(1, true, false, "E2080.AC.1.011", "wlg-ida-n.png"),
    WLGIDAS(1, true, false, "E2124.AC.1.012", "wlg-ida-s.png"),
    WLGXROADNP(1, true, false, "E2080.AC.1.013", "wlg-xroad-np.png"),
    IO1_WLGXROADNP(1, true, false, "E2080.IO.1.013", "wlg-xroad-np.png"),
    IO2_WLGXROADNP(1, true, false, "E2080.IO.2.013", "wlg-xroad-np.png"),
    WLGIDANP(1, true, false, "E2080.AC.1.014", "wlg-ida-np.png"),
    WLXR900N(1, true, false, "E2080.AC.1.015", "wl-xr900-np.png"),
    WLXR900NP(1, true, false, "E2080.AC.1.016", "wl-xr900-np.png"),
    WLXR900S(1, true, false, "E2124.AC.1.017", "wl-xr900-s.png"),
    M340_WC(1, true, false, "E2080.AC.1.018", "m340-wc.png"),
    WLGABOARDNV3(1, true, false, "E2080.AC.1.019", "wlg-aboard-n.png"),
    HYPERLANV3(1, true, false, "E2080.AC.2.019", "hyperlan.png"),
    WLGACCESSATEXV3(1, true, false, "E2080.AC.3.019", "wlg-access-atex.png"),
    WLGLINKV3(1, true, false, "E2080.AC.1.032", "wlg-link-V3.png"),
    AIRPACKV3(1, true, false, "E2080.AC.2.032", "airpack.png"),
    WLG4LAN(1, true, false, "E2080.AC.1.033", "wlg-4lan.png"),
    AIRTRACKS4(1, true, false, "E2080.AC.1.034", "airtrack-s4.png"),
    CA_AIRTRACKS4(1, true, false, "E2080.CA.1.034", "airtrack-s4.png"),
    CA_AIRTRACKS4_US(1, true, false, "E2080.CA.2.034", "airtrack-s4.png"),
    WLGABOARD_4N(1, true, false, "E2080.AC.1.039", "airtrack-s4.png"),
    WLNEMERGENCYV10(2, false, false, "E2148.AC.0.000", "emergency.png"),
    WLNEMERGENCYV12(2, false, false, "E2158.AC.0.000", "emergency.png"),
    WLNABOARD(2, true, true, "E2148.AC.1.022", "wln-aboard-ni.png"),
    WLNABOARDN(2, true, true, "E2148.AC.1.023", "wln-aboard-ni.png"),
    WLNABOARD24(2, true, true, "E2148.AC.1.024", "wln-aboard-ni.png"),
    WLNABOARD48(2, true, true, "E2148.AC.1.025", "wln-aboard-ni.png"),
    WLNABOARD72(2, true, true, "E2148.AC.1.026", "wln-aboard-ni.png"),
    WLNABOARD110(2, true, true, "E2148.AC.1.027", "wln-aboard-ni.png"),
    WLNLINKOEMRJ(2, true, true, "E2148.AC.1.028", "wln-link-oem-rj.png"),
    WLNLINKOEMTTL(2, true, true, "E2148.AC.1.029", "wln-link-oem-ttl.png"),
    WLNXROAD(2, true, true, "E2148.AC.1.030", "wln-xroad.png"),
    WLNXROAD_MPCIE(2, true, true, "E2148.AC.1.031", "wln-xroad.png"),
    WLNRAILBOX1(2, true, true, "E2148.AC.1.035", "wln-railbox.png"),
    WLNRAILBOX1P(2, true, true, "E2148.AC.1.036", "wln-railbox.png"),
    WLNRAILBOX2(2, true, true, "E2148.AC.1.037", "wln-railbox.png"),
    WLNRAILBOX2P(2, true, true, "E2148.AC.1.038", "wln-railbox.png"),
    WLNRAILBOX3(2, true, true, "E2148.AC.1.040", "wln-railbox.png"),
    WLNRAILBOX3P(2, true, true, "E2148.AC.1.041", "wln-railbox.png"),
    WLNXROADM12_4_V2(2, true, true, "E2148.AC.1.042", "wln-xroad.png"),
    WLNXROAD_IC1_V2(2, true, true, "E2148.AC.1.043", "wln-xroad.png"),
    WLNLINKOEMRJ_V2(2, true, true, "E2148.AC.1.044", "wln-link-oem-rj.png"),
    WLNLINKOEMTTL_V2(2, true, true, "E2148.AC.1.045", "wln-link-oem-ttl.png"),
    WLNRAILBOX1_IC2(2, true, true, "E2148.AC.1.046", "wln-railbox.png"),
    WLNRAILBOX2_IC2(2, true, true, "E2148.AC.1.047", "wln-railbox.png"),
    RAILBOX22A0(2, true, true, "E2148.AC.1.048", "railbox.png"),
    RAILBOX20A0(2, true, true, "E2148.AC.1.049", "railbox.png"),
    RAILBOX11A0(2, true, true, "E2148.AC.1.050", "railbox.png"),
    RAILBOX10A0(2, true, true, "E2148.AC.1.051", "railbox.png"),
    RAILBOX22AY(2, true, true, "E2148.AC.1.052", "railbox.png"),
    RAILBOX20AY(2, true, true, "E2148.AC.1.053", "railbox.png"),
    RAILBOX11AY(2, true, true, "E2148.AC.1.054", "railbox.png"),
    RAILBOX10AY(2, true, true, "E2148.AC.1.055", "railbox.png"),
    RAILBOX22P0(2, true, true, "E2148.AC.1.056", "railbox.png"),
    RAILBOX20P0(2, true, true, "E2148.AC.1.057", "railbox.png"),
    RAILBOX11P0(2, true, true, "E2148.AC.1.058", "railbox.png"),
    RAILBOX10P0(2, true, true, "E2148.AC.1.059", "railbox.png"),
    RAILBOX21A0(2, true, true, "E2148.AC.1.060", "railbox.png"),
    RAILBOX21AY(2, true, true, "E2148.AC.1.061", "railbox.png"),
    RAILBOX10B0(2, true, true, "E2148.AC.1.062", "railbox.png"),
    RAILBOX11B0(2, true, true, "E2148.AC.1.063", "railbox.png"),
    RAILBOX20B0(2, true, true, "E2148.AC.1.064", "railbox.png"),
    RAILBOX22B0(2, true, true, "E2148.AC.1.065", "railbox.png"),
    RAILBOX21P0(2, true, true, "E2148.AC.1.066", "railbox.png"),
    RAILBOX21B0(2, true, true, "E2148.AC.1.067", "railbox.png"),
    RAILTRACK333A0(2, true, true, "E2148.AC.1.068", "railtrack.png"),
    RAILBOX11BY(2, true, true, "E2148.AC.1.069", "railbox.png"),
    RAILTRACK333AY(2, true, true, "E2148.AC.1.070", "railtrack.png"),
    RAILTRACK333AP(2, true, true, "E2148.AC.1.071", "railtrack.png"),
    RAILBOX_B_22AY(2, true, true, "E2148.AC.1.072", "railbox.png"),
    RAILBOX_B_22B0(2, true, true, "E2148.AC.1.073", "railbox.png"),
    RAILBOX_B_22P0(2, true, true, "E2148.AC.1.074", "railbox.png"),
    RAILBOX50A0(2, true, true, "E2148.AC.1.075", "railbox.png"),
    RAILBOX_B_50A0(2, true, true, "E2148.AC.1.076", "railbox.png"),
    RAILBOX_55A0(2, true, true, "E2148.AC.1.077", "railbox.png"),
    RAILBOX55AY(2, true, true, "E2148.AC.1.078", "railbox.png"),
    RAILBOX_B_22A0(2, true, true, "E2148.AC.1.079", "railbox.png"),
    RAILBOX_B_11A0(2, true, true, "E2148.AC.1.080", "railbox.png"),
    RAILBOX_B_21A0(2, true, true, "E2148.AC.1.081", "railbox.png"),
    RAILBOX_B_20P0(2, true, true, "E2148.AC.1.082", "railbox.png"),
    RAILBOX_B_20A0(2, true, true, "E2148.AC.1.083", "railbox.png"),
    RAILBOX_B_20AY(2, true, true, "E2148.AC.1.084", "railbox.png"),
    WLNXROADSE1(2, true, true, "E2148.AC.1.085", "wln-xroad.png"),
    RAILTRACK222AP(2, true, true, "E2148.AC.1.086", "railtrack.png"),
    RAILTRACK555AP(2, true, true, "E2148.AC.1.087", "railtrack.png"),
    RAILBOX_B_55A0(2, true, true, "E2148.AC.1.088", "railbox.png"),
    RAILBOX_B_10A0(2, true, true, "E2148.AC.1.089", "railbox.png"),
    RAILBOX_B_10P0(2, true, true, "E2148.AC.1.090", "railbox.png"),
    EMBEDAIR100_R(2, true, true, "E2148.AC.1.100", "embedair100.png"),
    EMBEDAIR100_K(2, true, true, "E2148.AC.1.101", "embedair100.png"),
    EMBEDAIR100_T(2, true, true, "E2148.AC.1.102", "embedair100.png"),
    EMBEDAIR1000_R2(2, true, true, "E2148.AC.1.103", "embedair1000.png"),
    EMBEDAIR1000_T2(2, true, true, "E2148.AC.1.104", "embedair1000.png"),
    AIRLINK(2, true, true, "E2148.AC.1.105", "airlink.png"),
    CAT490_8925(2, true, true, "E2148.CA.1.000", "490-8925.png");

    public static final int CODE_UNKNOWN = 21;
    public static final int CODE_SONDE = 20;
    public int genericType;
    public boolean canWebInterface;
    public boolean canMultifunction;
    public String id;
    public String iconFileName;

    private ProductModel(int genericType, boolean argWeb, boolean argMulti, String argId, String argIcon) {
        this.genericType = genericType;
        this.canWebInterface = argWeb;
        this.canMultifunction = argMulti;
        this.id = argId;
        this.iconFileName = argIcon;
    }

    public static ProductModel getModelFromProductAndFirmwareCodes(String firmwareId, int productCode) {
        if (productCode != 21) {
            String id = String.format("%s.%03d", firmwareId, productCode);
            String wln_id = String.format("E2148.AC.1.%03d", productCode);
            String wlg_id = String.format("E2080.AC.1.%03d", productCode);
            ProductModel defaultmodel = null;
            ProductModel[] productModelArray = ProductModel.values();
            int n = productModelArray.length;
            int n2 = 0;
            while (n2 < n) {
                ProductModel brand = productModelArray[n2];
                if (brand.id.equals(id)) {
                    return brand;
                }
                if (brand.id.equals(wln_id)) {
                    defaultmodel = brand;
                    if (firmwareId.contains(".CA.")) {
                        defaultmodel = CAT490_8925;
                    }
                } else if (brand.id.equals(wlg_id)) {
                    defaultmodel = brand;
                }
                ++n2;
            }
            if (defaultmodel != null) {
                return defaultmodel;
            }
            if (productCode != -1) {
                System.out.println("Info: id " + id + " not found for productCode " + productCode);
                if (productCode >= 22) {
                    System.out.println("ERROR: check SNMP SYSDESCR for above productCode");
                }
            }
        }
        return WLG_NEW;
    }

    public static Product createWlgProduct(ProductModel brand, DiscoverResponse response, String flags) {
        WlgProduct product = brand.id.contains(".CA.") ? new CATWlgProduct(flags, brand) : new WlgProduct(flags, brand);
        response.setProductDiscoverParams(product);
        return product;
    }

    public static Product createOpenWrtProduct(ProductModel brand, DiscoverResponse response, String flags, String specfirm) {
        OpenWrtProduct product = new OpenWrtProduct(flags, brand, specfirm);
        response.setProductDiscoverParams(product);
        return product;
    }

    public static Product createOldWlgProduct(ProductModel brand, DiscoverResponse response, String flags) {
        WlgProduct product = new WlgProduct(flags, brand);
        response.setProductDiscoverParams(product);
        product.setParam(new Parameter(Oid.FIRMWARE_DESCRIPTION, TranslateEnum.VERSION_OLD.get()));
        product.checkForDisplayChanges();
        return product;
    }

    public static Product createSonde(DiscoverResponse response) {
        response.SetProductCode(20);
        Sonde product = new Sonde();
        response.setProductDiscoverParams(product);
        product.setParam(new Parameter(Oid.FIRMWARE_VERSION, TranslateEnum.UNAVAILABLE.get()));
        return product;
    }

    public static Product createFromProductAndFirmwareCodes(String firmClass, int productCode, DiscoverResponse response, String firmwareCapabilities) {
        String specfirm = "AC";
        ProductModel brand = ProductModel.getModelFromProductAndFirmwareCodes(firmClass, productCode);
        switch (brand.genericType) {
            default: {
                return ProductModel.createWlgProduct(brand, response, firmwareCapabilities);
            }
            case 2: 
        }
        if (firmClass.contains("CA")) {
            specfirm = "CA";
        }
        return ProductModel.createOpenWrtProduct(brand, response, firmwareCapabilities, specfirm);
    }
}

