/*
 * Decompiled with CFR 0.152.
 */
package fr.acksys.ndm.product;

import fr.acksys.ndm.MibParser;
import fr.acksys.ndm.Parameter;
import fr.acksys.ndm.UserParameters;
import fr.acksys.ndm.ig.ImageManager;
import fr.acksys.ndm.product.Product;
import fr.acksys.ndm.product.ProductModel;
import fr.acksys.ndm.product.config.ConfigInterface;
import fr.acksys.ndm.product.config.WlgConfig;
import fr.acksys.snmp.Oid;
import fr.acksys.translation.TranslateEnum;
import java.text.MessageFormat;
import javax.swing.JLabel;

public class WlgProduct
extends Product {
    private final ConfigInterface myConfigInterface = new WlgConfig(this);
    private Oid validMacOid;

    public WlgProduct(String flag, ProductModel brand) {
        this.initFlags(flag, brand.id);
        this.validMacOid = brand.id.startsWith("E2124") ? Oid.MAC_ADDRESS_S : Oid.MAC_ADDRESS;
        this.canWebInterface = brand.canWebInterface;
    }

    @Override
    public ConfigInterface getConfigMethod() {
        return this.myConfigInterface;
    }

    @Override
    public int getTftpStyle() {
        return 1;
    }

    @Override
    public Oid getUniqueIdOid() {
        return this.validMacOid;
    }

    @Override
    public void getAssocDescription(JLabel assocLab) {
        switch (this.getCurrentWirelessRole()) {
            default: {
                assocLab.setText(TranslateEnum.UNAVAILABLE.get());
                break;
            }
            case 1: {
                String clients = this.parameters.getStringValue(Oid.WIFI_AP_CLIENTS);
                if (clients == null || clients.equals(TranslateEnum.UNAVAILABLE.get())) {
                    assocLab.setText(TranslateEnum.UNAVAILABLE.get());
                    break;
                }
                assocLab.setText(String.valueOf(clients) + " " + TranslateEnum.CLIENTS.get());
                break;
            }
            case 3: {
                assocLab.setText("<html><center>(I)BSSID:<br>" + this.parameters.getStringValue(Oid.WIFI_SSID) + "</center></html>");
                break;
            }
            case 2: 
            case 7: {
                int rssiValue = this.parameters.getPositiveValue(Oid.WIFI_BRIDGE_RSSI);
                int rssidB = this.parameters.getIntegerValue(Oid.WIFI_BRIDGE_RSSI_dBm);
                assocLab.setIcon(ImageManager.getRssiImageIcon(rssiValue));
                if (UserParameters.getBooleanUserParam("RSSI_UNITE")) {
                    assocLab.setText(String.valueOf(TranslateEnum.RSSI.get()) + " " + rssidB + " dBm");
                    break;
                }
                assocLab.setText(String.valueOf(TranslateEnum.RSSI.get()) + " " + rssiValue + "%");
            }
        }
    }

    @Override
    public String getChannelDescription() {
        switch (this.getCurrentWirelessRole()) {
            default: {
                String channel = this.parameters.getStringValue(Oid.WIFI_AP_CHANNEL);
                String wifi = MibParser.getValue(this.getParam(Oid.WIFI_802), -1);
                StringBuilder sb = new StringBuilder();
                if (channel != null) {
                    sb.append(String.valueOf(channel) + " ");
                }
                if (wifi != null) {
                    sb.append(wifi);
                }
                if (sb.toString().equals(String.valueOf(TranslateEnum.UNAVAILABLE.get()) + " " + TranslateEnum.UNAVAILABLE.get())) {
                    return TranslateEnum.UNAVAILABLE.get();
                }
                return sb.toString();
            }
            case 0: 
        }
        return TranslateEnum.COLVAL_NA.get();
    }

    @Override
    public String getSecurityDescription() {
        Parameter securityParam = this.getParam(Oid.WIFI_SECURITY);
        if (securityParam == null) {
            return "";
        }
        String mode = MibParser.getValue(securityParam, -1);
        if (mode.equals(TranslateEnum.WPA.get())) {
            return MibParser.getValue(this.getParam(Oid.WPA_VERSION), -1);
        }
        if (mode.equals(TranslateEnum.WPAPSK.get())) {
            return String.valueOf(MibParser.getValue(this.getParam(Oid.WPA_VERSION), -1)) + " " + TranslateEnum.PSK.get();
        }
        return mode;
    }

    @Override
    public int getCurrentWirelessRole() {
        try {
            switch (this.parameters.getPositiveValue(Oid.WIFI_MODE)) {
                case 1: {
                    switch (this.parameters.getPositiveValue(Oid.WIFI_BRIDGE_MODE)) {
                        case 1: {
                            return 2;
                        }
                        case 2: {
                            return 3;
                        }
                    }
                    return 0;
                }
                case 2: {
                    return 1;
                }
            }
            return 0;
        }
        catch (NumberFormatException ex) {
            return 0;
        }
    }

    @Override
    public String getHtmlDetails() {
        String assoc;
        switch (this.getCurrentWirelessRole()) {
            default: {
                assoc = "";
                break;
            }
            case 1: {
                String clients = this.parameters.getStringValue(Oid.WIFI_AP_CLIENTS);
                if (clients == null || clients.equals(TranslateEnum.UNAVAILABLE.get())) {
                    assoc = TranslateEnum.UNAVAILABLE.get();
                    break;
                }
                assoc = String.valueOf(clients) + " " + TranslateEnum.CLIENTS.get();
                break;
            }
            case 3: {
                assoc = "(I)BSSID:<br>" + this.parameters.getStringValue(Oid.WIFI_SSID);
                break;
            }
            case 2: 
            case 7: {
                int rssiValue = this.parameters.getPositiveValue(Oid.WIFI_BRIDGE_RSSI);
                int rssidB = this.parameters.getIntegerValue(Oid.WIFI_BRIDGE_RSSI_dBm);
                assoc = "<img src=\"" + ImageManager.getRssiUrlString(rssiValue) + "\" >" + "<br>" + TranslateEnum.RSSI.get() + " ";
                assoc = UserParameters.getBooleanUserParam("RSSI_UNITE") ? String.valueOf(assoc) + rssidB + " dBm" : String.valueOf(assoc) + rssiValue + "%";
            }
        }
        MessageFormat form = new MessageFormat(TranslateEnum.DETAILS_GENERAL1.get());
        Object[] args = new Object[]{this.parameters.getStringValue(Oid.SYSLOCATION), this.getModel(), this.getUniqueIdString(), this.getFirmwareVersionString(), this.parameters.getStringValue(Oid.FIRMWARE_ID)};
        String s = form.format(args);
        s = String.valueOf(s) + "<br><br>";
        s = String.valueOf(s) + "<u>" + TranslateEnum.COLUMN_IP_ADDRESS.get() + "</u>: " + this.getIpString();
        s = String.valueOf(s) + "<br><br>";
        s = String.valueOf(s) + "<center><table border=1><tr bgcolor=#a0d2ff><th>Radio<th>" + TranslateEnum.COLUMN_CHANNEL.get() + "<th>" + TranslateEnum.COLUMN_SSID.get() + "<th>" + TranslateEnum.COLUMN_FUNCTION.get() + "<th>" + TranslateEnum.COLUMN_SECURITY.get() + "<th>" + TranslateEnum.COLUMN_ASSOCIATE.get() + "</tr>";
        s = String.valueOf(s) + "<tr><td align=center>#0<td align=center>" + this.parameters.getStringValue(Oid.WIFI_AP_CHANNEL) + "/" + MibParser.getValue(this.getParam(Oid.WIFI_802), -1) + "<td align=center>" + this.parameters.getStringValue(Oid.WIFI_SSID) + "<td align=center>" + this.getFirmwareFunctionString() + "<td align=center>" + this.getSecurityDescription() + "<td align=center>" + assoc;
        s = String.valueOf(s) + "</tr></table></center>";
        return s;
    }
}

